package ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TabPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import pviScreen.PVIScreenControlData;
import pviScreen.ParameterChoices;
import pviScreen.RawInput;
import pviScreen.RawInputLine;
import util.FileLogger;
import util.FileModifier;
import util.NameConstants;
import util.Stripper;

public class HandlerPrepareForRun implements EventHandler
{
	private Stage stage;
	private Button b;
	private Label lTopLabel;
	private Repository repository;
	private HandlerEdit he;
	private boolean bInputFileSet;
	private String sInputFile;
	private String sInputFileAndPath;
	private String sCurrentDirectory;
	private String sInitialDirectory;
	private String sActiveDirectory;
	private PVIScreenControlData pvisControlData;
	private ParameterChoices pc;
	private ObservableList<Button> olButton;
	private NameConstants nc;
	private Stripper s;

	public HandlerPrepareForRun(Stage stage)
	{
		this.stage = stage;
	}




	//open dialog for saving/discarding changes to input file
	public void handle(Event arg0) 
	{
		System.out.println("Handling");

		bInputFileSet = repository.getInputFileFlagSet(); 	
		boolean bInputChanged = repository.getEditControlChanged();

		olButton = repository.getButtonList();
		nc = new NameConstants();
		s = new Stripper();	 
		pvisControlData = repository.getPVIScreenControlData();
		pc = pvisControlData.getParameterChoices(); 

		lTopLabel.setText("Press " + nc.s_ButtonRun + " to run " + repository.getInputFileAndPath());

		//allow for saving the data if they've changed
		if (bInputChanged)
		{	
			//look for file directory read from 05ParameterChoices.csv, if an alternative directory has not be set
			this.sActiveDirectory = repository.getDirectory();


			//fc = repository.getFileChooser();
			final FileChooser fc = new FileChooser();

			//show dialog:
			fc.setTitle("Save Changes To Input Data?");
			fc.setInitialFileName(repository.getInputFile());
			String sInputExtension = "*." + nc.s_Extension_Input;
			fc.getExtensionFilters().add(new FileChooser.ExtensionFilter("PVIScreen ",sInputExtension));


			//if an active directory has been set (through the selection of an input file)
			//use the active directory for writing results
			if (this.sActiveDirectory=="")
			{	
				sInitialDirectory = "projects";
				try
				{
					ArrayList<String> alInitialDirectory = pc.getValue("Project Directory", 1);
					sInitialDirectory = alInitialDirectory.get(0);
				}
				catch(Exception e){}

				try
				{
					this.sCurrentDirectory = new java.io.File(".").getCanonicalPath();

					this.sCurrentDirectory = this.sCurrentDirectory + "//" + sInitialDirectory;
				}
				catch (Exception e){}
			}
			else
			{
				//use active directory
				this.sCurrentDirectory = this.sActiveDirectory;
			}
			System.out.println("Found Path " + this.sCurrentDirectory);
			fc.setInitialDirectory(new File(this.sCurrentDirectory));


			//launch the file chooser
			File fInputFile=null;
			fInputFile = fc.showSaveDialog(stage);
			if (fInputFile!=null)
			{	  
				//get choices--file name and path
				sInputFile = fInputFile.getName();
				sInputFileAndPath = fInputFile.getPath();
				sActiveDirectory = fInputFile.getParent();
				repository.setDirectory(sActiveDirectory);

			}
			else
			{
				//no input file selected from fileChooser
				//exit the handler
				return;
			}	 

		}
		else
		{
			//unchanged Input
			sInputFile = repository.getInputFile();
			sInputFileAndPath = repository.getInputFileAndPath();
			sActiveDirectory = repository.getDirectory();
		}


		//fix the file:  make sure the extension is present
		FileModifier fm = new FileModifier();
		sInputFile = fm.getOutputFileAndPathName(sInputFile, nc.i_Extension_Input_Dots, nc.s_Extension_Input, false);
		sInputFileAndPath = fm.getOutputFileAndPathName(sInputFileAndPath, nc.i_Extension_Input_Dots, nc.s_Extension_Input,  false);

		
		
		

		ArrayList<RawInputLine>alRawOutputLine = new ArrayList<RawInputLine>();
		TabPane tp = he.getTabPane();
		alRawOutputLine = he.getAllInputs(tp);




		//update PVIScreen Control Data with possibly revised inputs (JWW 1-19-2016)
		//these are for use inside the interface
		//this is necessary to get changes made to the risk and hazard levels
		//incorporated into the cumulative frequency plots.

		String sGroup, sParameter;
		String sInput;
		String[] lineArray;
		pvisControlData.clearRiskLevels();




		//risk levels no longer used, 2-16-2018
        /*
		for (RawInputLine ril:  alRawOutputLine)
		{	  
			sGroup = ril.getGroupName();
			sParameter = ril.getParameterName();

			//find the risk level and hazard quotient raw output lines
			//and load the values into the pcisControlData data container
			if (s.areTheyEqual(sGroup,"Control") && s.areTheyEqual(sParameter,"Risk Level")) 
			{
				lineArray = ril.getOutputLine().split(",",0);
				double dRiskLevel = Double.parseDouble(lineArray[2]);
				pvisControlData.addRiskLevel(dRiskLevel);
			}
			if (s.areTheyEqual(sGroup,"Control") && s.areTheyEqual(sParameter,"Hazard Quotient"))
			{
				lineArray = ril.getOutputLine().split(",",0);
				double dHazardQuotient = Double.parseDouble(lineArray[2]);
				pvisControlData.addHazardQuotient(dHazardQuotient);
			}  
		}
		*/

		//check data

		pvisControlData.checkData();
		if (pvisControlData.getCanRunModel())
		{

			//overwrite existing file contents
			FileLogger fl = new FileLogger(sInputFileAndPath);
			fl.openOverWriteFile();
			he.writeDataFile(fl, alRawOutputLine);
			fl.closeOverWriteFile();
			
			

			//save the new names so they go to the pviscreen runner.
			repository.setInputFile(sInputFile);
			repository.setInputFileAndPath(sInputFileAndPath); 

			//reread the input data so they are availble for the report writer and for redisplaying the inputs
			PVIScreenUIInputData pvisUIInputData = repository.getPCIScreenUIInputData();
			pvisUIInputData.setFileAndPathName(sInputFileAndPath);
			
			//read the input data to make available to the interface, through the repository
			try {
				pvisUIInputData.readInputData();
				repository.clearPreviousPVIScreenControlData();
				repository.setPVIScreenControlData(pvisUIInputData.getPVIScreenControlData());
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			//redisplay the data in the interface
			he.redisplayData();
			
			//change the file name in the banner
		    this.lTopLabel.setText(sInputFileAndPath);
			
			
			//proceed to run.
			olButton = repository.getButtonList();
			s = new Stripper();
			for (Button button: olButton)
			{
				String sButton = button.getText();
				if (s.areTheyEqual(nc.s_ButtonSchematic,sButton)){button.fire();button.requestFocus();}
				if (s.areTheyEqual(nc.s_ButtonRun,sButton)){button.setDisable(false);button.setStyle(nc.s_StyleEnable);}
			}	  		          
		}
		else
		{
			//display error messages  

		}





	}  



	//sets
	public void setButton(Button b){this.b = b;}
	public void setHandlerRepository(Repository repository){this.repository = repository;}
	public void setHandlerEdit(HandlerEdit he){this.he = he;}
	public void setTopLabel(Label lTopLabel){this.lTopLabel = lTopLabel;}
	//gets

}
