package ui;


import java.awt.*;
import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/*
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.ColorModel;
import com.teamdev.jxbrowser.chromium.DuplexMode;
import com.teamdev.jxbrowser.chromium.PageRange;
import com.teamdev.jxbrowser.chromium.PaperSize;
import com.teamdev.jxbrowser.chromium.PrintHandler;
import com.teamdev.jxbrowser.chromium.PrintJob;
import com.teamdev.jxbrowser.chromium.PrintSettings;
import com.teamdev.jxbrowser.chromium.PrintStatus;
import com.teamdev.jxbrowser.chromium.events.PrintJobEvent;
import com.teamdev.jxbrowser.chromium.events.PrintJobListener;
import com.teamdev.jxbrowser.chromium.swing.BrowserView;
*/


import pviScreen.PVIScreenControlData;
import pviScreen.ParameterChoices;


import util.FileLogger;
import util.NameConstants;
import util.Stripper;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
//import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class HandlerReport implements EventHandler
{
	private Stage stage;
	private FileLogger flReport;
	private Repository repository;
	private WebEngine we;
	private WebView wv;
	private BorderPane bp;
	private String sURL;
	private Label lTopLabel;
	private ReportWriter reportWriter;
	private boolean bInputFileSet,bInputTypeSetFlag;
	private String sOutputFileAndPath,sInputFileAndPath; 
	private Task pviScreenReportWriter;
	private NameConstants nc;
	private Stripper s;
	private PVIScreenControlData pvisCD;
	private ParameterChoices pc;
	private HandlerSitePlot hSitePlot;

	public HandlerReport(Stage stage)
	{
		this.stage = stage;
		this.sURL = "";  
		reportWriter = new ReportWriter();
		nc = new NameConstants();
		s = new Stripper();

	}

	public void handle(Event e)
	{



		pviScreenReportWriter = writePVIScreenReport();

		//HandlerMainLabel hml = new HandlerMainLabel(stage);
		//lTopLabel.addEventHandler(ActionEvent.ACTION, hml);


		lTopLabel.setText(" ");
		//bInputFileSet = repository.getInputFileFlagSet();
		//if (this.bInputFileSet)
		//{	
		pviScreenReportWriter.messageProperty().addListener
		(
				new ChangeListener<String>()
				{
					public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue)
					{
						lTopLabel.setText("Writing Report");
					}
				}
				);
		new Thread(pviScreenReportWriter).start();

		//}
		//else{ }





	}


	public  Task writePVIScreenReport()
	{
		 
		return new Task(){


			protected Object call() throws Exception 
			{
				String sStatus = "Starting to Write Report";
				updateMessage(sStatus);

				reportWriter = new ReportWriter();
				reportWriter.setHandlerSitePlot(hSitePlot);

				reportWriter.setInputFileAndPath(sInputFileAndPath);
				reportWriter.setOutputFileAndPath(sOutputFileAndPath);
				reportWriter.setHandlerRepository(repository);
				reportWriter.prepareGraphics();

				sInputFileAndPath = repository.getInputFileAndPath();
				sOutputFileAndPath = repository.getFilePathAndNameResults();

				System.out.println(sOutputFileAndPath);



				String sTemp = reportWriter.getReportFileName(sOutputFileAndPath);
				repository.setFilePathAndNameHTML(sTemp);
				System.out.println("output file name " + sTemp);
				flReport = new FileLogger(sTemp);
				flReport.openOverWriteFile();
				System.out.println("File created");

				reportWriter.setFileLogger(flReport);
				reportWriter.startWritingReport();
				reportWriter.writeReportHeadings();
				reportWriter.writePVIScreenParagraph();
				reportWriter.writeRunIdentification();
				reportWriter.writeIOInformation();
				reportWriter.writeSiteSchmatic();
				//reportWriter.writeProbabilityCurves();
				reportWriter.writeSourceDefinition();
				//reportWriter.writeRiskResults();
				reportWriter.writeScreeningLevelTable();
				//reportWriter.writeRiskTable();


				reportWriter.writeInputData();
				reportWriter.writeChemicalInput();

				reportWriter.writeChemicalData();
				reportWriter.writeRiskData();

				reportWriter.endReport();
				flReport.closeOverWriteFile();

				sStatus = "PVIScreen Report Completed";
				updateMessage(sStatus);
				
				
				//1) internal javafx browser--not working as of 3/27/2017
				//JavaFXBrowser jfxb = new JavaFXBrowser();
		        //jfxb.startIt(stage);

				
				//2) Browser name and location from input -- may create a difficult problem as the user must specify the location
				//of the Browser
				
				try 
				{ 

					pvisCD = repository.getPVIScreenControlData();
					pc = pvisCD.getParameterChoices();
					String sFileAndPath = repository.getFilePathAndNameHTML();
					String sBrowser = pvisCD.getBrowserName();


					ArrayList<String>alBrowser = pc.getValue(nc.s_BROWSER, 1);
					ArrayList<String>alBrowserCommand = pc.getValue(nc.s_BROWSER,2);

					String sBrowserCommand = "";
					sBrowserCommand = "\\Program Files (x86)\\Internet Explorer\\iexplore.exe";


					int iSize = alBrowser.size();
					for (int i=0;i<iSize;i++)
					{

						if (s.areTheyEqual(sBrowser,alBrowser.get(i)))
						{
							sBrowserCommand = alBrowserCommand.get(i);
							break;
						}
					}



					//Process p = null;


					Process p=Runtime.getRuntime().exec(sBrowserCommand  + " " + sFileAndPath);
					//Process p=Runtime.getRuntime().exec(sFileAndPath);
					p.waitFor(); 




				} 
				catch(IOException e1) 
				{
					BorderPane border = repository.getBorder();
					double dCanvasWidth = 1000;
					double dCanvasHeight = 400;
					Canvas c = new Canvas(dCanvasWidth,dCanvasHeight);
					GraphicsContext gc = c.getGraphicsContext2D();

					//water table thickness
					gc.setStroke(Color.BLACK);
					gc.setFill(Color.BLACK);

					gc.setFont(Font.font("Arial", FontWeight.BOLD, 14));
					gc.fillText("PVIScreen cannot display your report in a browser.", 5, 20);
					gc.fillText("Your report can be found at:", 5, 40);
					gc.fillText(repository.getFilePathAndNameHTML(), 5, 60);


					gc.fillText("Include the browser path and name in file PVISCreen\\ui\\systemData\\05Preferences.csv", 5, 100);

					border.setCenter(c);
					stage.show();

				} 
				catch(InterruptedException e2) 
				{

				} 	
               


				//3) internal browser (JxBrowser)  (no operating system knowledge required)
				try{
					/*10-6-2017
					final Browser browser = new Browser();
					BrowserView view = new BrowserView(browser);
                    */
					/*
					browser.setPrintHandler(new PrintHandler() {
						// @Override
						public PrintStatus onPrint(PrintJob printJob) {
							PrintSettings settings = printJob.getPrintSettings();
							settings.setPrintToPDF(true);
							settings.setPDFFilePath("web_page.pdf");
							settings.setPrintBackgrounds(true);
							return PrintStatus.CONTINUE;
						}
					});

				 */
					


					
					/* 10-6-2017
					//original sample code from JXBrowser
					final JButton print = new JButton("Print PVIScreen Report");
					print.addActionListener(new ActionListener() {
						@Override
						public void actionPerformed(ActionEvent e) {
							browser.print();
						}
					});

					JFrame frame = new JFrame();
					frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
					frame.add(print, BorderLayout.NORTH);
					frame.add(view, BorderLayout.CENTER);
					frame.setSize(700, 500);
					frame.setLocationRelativeTo(null);
					frame.setVisible(true);
					*/
					
				
					/*
					
					 browser.setPrintHandler(new PrintHandler() {
				            @Override
				            public PrintStatus onPrint(PrintJob printJob) {
				                PrintSettings printSettings = printJob.getPrintSettings();
				                printSettings.setPrinterName("PDF Maker");
				                printSettings.setLandscape(false);
				                printSettings.setPrintBackgrounds(false);
				                printSettings.setColorModel(ColorModel.COLOR);
				                printSettings.setDuplexMode(DuplexMode.SIMPLEX);
				                printSettings.setDisplayHeaderFooter(true);
				                printSettings.setCopies(1);
				            
				                

				                List<PageRange> ranges = new ArrayList<PageRange>();
				                ranges.add(new PageRange(0, 3));
				                printSettings.setPageRanges(ranges);

				                printJob.addPrintJobListener(new PrintJobListener() {
				                    @Override
				                    public void onPrintingDone(PrintJobEvent event) {
				                        System.out.println("Printing is finished successfully: " +
				                                event.isSuccess());
				                    }
				                });
				                return PrintStatus.CONTINUE;
				            }
				        });
					*/
					
					
                    /* 10-6-2017
					//browser.loadURL("http://google.com");
					browser.loadURL(repository.getFilePathAndNameHTML());
					*/
					
					openFile();
					
					
					
					
				}
				catch(Exception eeee){}
				 
				
				
			

				return true;
			}

			
			
			
			
		};

       


	}

	
	private void openFile() throws IOException
	{
		String sInitialDirectory="";
		FileChooser fc = repository.getFileChooser();
		fc = new FileChooser();
		//FileChooser fc = new FileChooser();
		pvisCD = repository.getPVIScreenControlData();
		pc = pvisCD.getParameterChoices();
	 
		 
		
	 
		
		 
		//look for file directory read from 05ParameterChoices.csv
		try
		{
			ArrayList<String> alInitialDirectory = pc.getValue("Project Directory", 1);
			sInitialDirectory = alInitialDirectory.get(0);
		}
		catch(Exception e){}
		 
		
		String sCurrentDirectory;
		String sActiveDirectory;
		
		fc.setTitle("PVIScreen File Input");
		try
		{
			sCurrentDirectory = new java.io.File(".").getCanonicalPath();
		    sActiveDirectory = repository.getDirectory();
			if (sActiveDirectory!="")
			{
				sCurrentDirectory=sActiveDirectory;
			}
			else
			{	
				
			  //this.sCurrentDirectory = this.sCurrentDirectory + "//" + sInitialDirectory;
			  sCurrentDirectory = sCurrentDirectory + "\\" + sInitialDirectory;
			}
			System.out.println("Found Path " + sCurrentDirectory);
			fc.setInitialDirectory(new File(sCurrentDirectory));
			
		}
		catch(Exception e){}
		fc.setTitle("PVIScreen HTML Output");
		
		
		
		
		
		//filters to select special files
		fc.getExtensionFilters().add(new FileChooser.ExtensionFilter("HTML Results   ","*." + nc.s_Extension_HTML));	
				
		
		//show dialog:
	
		File fInputFile = fc.showOpenDialog(stage);
		
	
		
		
		 
		
	
	}
	
	
	//sets
	public void setHandlerRepository(Repository repository){this.repository = repository;}
	public void setURL(String sURL){this.sURL = sURL;}
	public void setTopLabel(Label lTopLabel){this.lTopLabel = lTopLabel;}
	public void setInputFileAndPath(String sInputFileAndPath){this.sInputFileAndPath = sInputFileAndPath;}
	public void setOutputFileAndPath(String sOutputFileAndPath){this.sOutputFileAndPath = sOutputFileAndPath;}
	public void setHandlerSitePlot(HandlerSitePlot hSitePlot){this.hSitePlot = hSitePlot;}



}
