package ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;



import javafx.beans.value.ObservableValue;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

import pviScreen.PVIScreen;
import pviScreen.RawInputLine;
import util.FileLogger;
import util.FileModifier;
import util.NameConstants;
import util.Stripper;

public class HandlerRun implements EventHandler
{
   private Stage stage;
   //two results from
   private String sFilePathAndNameResults;
   private String sFilePathAndNameStatistics;
   private String sStatus;
   //input file
   private String sInputFile;
   //input path
   private String sInputFileAndPath;
   private boolean bInputFileSet;
   private PVIScreen pvis;
   private Repository repository;
   private Label lTopLabel;    
   private NameConstants nc;
   private Stripper s;
   private ObservableList<Button> olButton;

	
   public HandlerRun(Stage stage)
   {
	   this.stage = stage;
	   this.bInputFileSet = false;
	   nc = new NameConstants();
	   s = new Stripper();	   
   }
   
   public void handle(Event event)
   {
 
	//pviScreenRunner = runPVIScreen();
	 
	HandlerMainLabel hml = new HandlerMainLabel(stage);
	lTopLabel.addEventHandler(ActionEvent.ACTION, hml);
	//updateMessage("Running File "+ sInputFileAndPath);
	sStatus = "Running File " + sInputFileAndPath;
	lTopLabel.setText(sStatus);
	
	 
	bInputFileSet = repository.getInputFileFlagSet();
	
	try
	{
		BorderPane border = repository.getBorder();
		ScrollPane sp = (ScrollPane)border.getCenter();
		Canvas canvas = (Canvas)sp.getContent();
		GraphicsContext gc = canvas.getGraphicsContext2D();
		gc.setFill(Color.WHITE);
		gc.fillRect(0, 0, nc.canvas_width,nc.canvas_height);
		gc.setStroke(Color.ORANGE);
		gc.strokeLine(0, 0, nc.canvas_width, nc.canvas_height);
		border.setCenter(sp);
		stage.show();
		 
	}
	catch(Exception e)
	{
		System.out.println("Exception on HandlerRun clear of canvas");
	}
	
	try
	{
		BorderPane border = repository.getBorder(); 
		TabPane tp = (TabPane)border.getCenter();
		tp.getTabs().clear(); 
	}	 
	catch(Exception e)
	{
		System.out.println("Exception on HandlerRun clear of tabpane");
	}
	
	  
	olButton = repository.getButtonList();
	
	
	 

	
	if (this.bInputFileSet)
	{	
			
		 sStatus = "Running PVIScreen....";
         //updateMessage(sStatus);
		 sInputFile = repository.getInputFile();
		 sInputFileAndPath = repository.getInputFileAndPath();
		 		 
		 try 
		 {
			pvis.runOneInputSetFromGUI(sInputFileAndPath);
			//two main results files
			sStatus = "PVIScreen simulation completed";
			System.out.println(sStatus);
			lTopLabel.setText(sStatus);
			//updateMessage(sStatus);
			sFilePathAndNameResults = pvis.getOutputFileName();
		    sFilePathAndNameStatistics = pvis.getOutputFileNameStatistics();
		    repository.setFilePathAndNameResults(sFilePathAndNameResults);
		    repository.setFilePathAndNameStatistics(sFilePathAndNameStatistics);
		    repository.setFileResultsNameFlagSet(true);
		    System.out.println("File Updateing completed");	
			
			
			
			//enable buttons
			olButton = repository.getButtonList();
		    for (Button button: olButton)
		    {	 
			   	String sButton = button.getText();
			   	if (s.areTheyEqual(nc.s_ButtonResults,sButton))
			   	{
			   		button.setDisable(false);
			   		button.setStyle(nc.s_StyleEnable);
			   		button.fire();
			   		button.requestFocus();
			   	}
		    }				    
			
			
		 } 
		 catch (IOException e){}
		 
	    	
	}
	else{ }
	
	stage.show();
   }
  
    	
    
    
    //sets
    public void setPVIScreenModel(PVIScreen pvis){this.pvis = pvis;}
    public void setInputDataSetFlag(boolean b){this.bInputFileSet = b;}
    public void setInputFile(String sInputFile){this.sInputFile = sInputFile;}
    public void setInputFileAndPath(String s){this.sInputFileAndPath = s;}
    public void setHandlerRepository(Repository repository){this.repository = repository;}
    public void setTopLabel(Label lTopLabel){this.lTopLabel = lTopLabel;}
    
     
}
