package ui;

import java.util.List;

import pviScreen.Building;
import pviScreen.OilLens;
import pviScreen.PVIScreenControlData;
import pviScreen.VadoseZone;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

//import com.sun.javafx.scene.layout.region.Border;
 

import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

/**
 * event handler to draw site diagram schematic
 * @author Jim Weaver
 * 9-17-2013
 *
 */
public class HandlerSitePlot implements EventHandler
{
   private Stage stage;
   private Repository repository;
   private Canvas canvas;
   private Scene scene;
   private BorderPane border;
   private ScrollPane sp;
   private Label lTopLabel;
   private PVIScreenControlData pvisCD;
   private UnitConverter uc;
   private String sOutputLengthUnit;
   private double dUCF;
   
   private double dStageHeight,dStageWidth;
   private double dCanvasHeight,dCanvasWidth;
   
   private Stripper s;
   private NameConstants nc;
   private ObservableList<Button> olButton;
   
   public HandlerSitePlot(Stage stage)
   {
	   this.stage = stage;
	   nc = new NameConstants();   
   }
   
   public void handle(Event e)
   {
	 drawSchematic(true);
   }
   
   public void drawSchematic(boolean bShow)
   {
		 //get the repository data  
		 pvisCD = repository.getPVIScreenControlData(); 
		 border = repository.getBorder();
		 
		 dCanvasWidth = nc.canvas_width;
		 dCanvasHeight = nc.canvas_height;
		 
		 canvas = new Canvas(dCanvasWidth,dCanvasHeight);
	 	 GraphicsContext gc = canvas.getGraphicsContext2D();
	 	 
	  
	 	 
	 	 dCanvasHeight = canvas.getHeight();
	 	 dCanvasWidth = canvas.getWidth();
	 	 
		 //set height of drawing
		 dStageHeight = stage.getHeight();
		 dStageWidth = stage.getWidth();
		 
		 //set up geometic relationships
		 this.adjustGeometry(dCanvasHeight,dCanvasWidth);
		 
		 //draw the schematic
		 this.drawSchematic(gc);
		 
		 //add labels and arrows
		 this.addArrowsAndLabels(gc);
		 
		 //add water table mark
		 this.addWaterTableMark(gc,dWaterTableY,10,1.1*dLandX0,10);

		 //add bottom of aquifer hatching
		 if (dAquifer>0.0){this.addAquiferBottomHatching(gc);}
		 
		 WritableImage snapshot2 = (canvas).snapshot(new SnapshotParameters(), null);
		 repository.setSiteSchematic(snapshot2);
		 
		 
		 sp = new ScrollPane();
		
		 sp.setContent(canvas);
		 
		 stage.setHeight(dStageHeight);
		 border.setCenter(sp);
		
		 if (bShow){stage.show();}
		
			   
   }
   
//match the geometry of the screen drawing to the geometry of the input data set   
private double dTotalHeight,dTotalWidth;
private double dSky, dHouse, dVadose, dVadoseMax, dAquifer, dUnderworld;
private double dDepthOfFoundation;
private double dSample;
private double dLensTop, dLensBottom;
private double dWidth,dLensWidth;
private double dLength, dLensLength;
private VadoseZone vz;
private Building bldg;
private OilLens ol;
//declare the scale factors:	
private double dSFY,dSFX;
private void adjustGeometry(double dStageHeight, double dStageWidth)
{
   
   //sizes from input data set
   try
   {
	 //get data from the pviScreenControlData object
	 vz = pvisCD.getVadoseZone();
	 bldg = pvisCD.getBuilding();
	 ol = pvisCD.getOilLens();
	 dSample = vz.getDepthToSample();
	 dVadose = vz.getDepthToWaterTable();
     dVadoseMax = vz.getDepthToHistoricWaterTable();
     dAquifer = vz.getDepthToBottom();
     dLensTop = ol.getSurfaceElevation() - ol.getOilZoneTopElevation();
     dLensBottom = ol.getSurfaceElevation() - ol.getMobileOilZoneBottomElevation();
     dLensWidth = ol.getLensWidth();
     dLensLength = ol.getLensLength();
     dHouse = bldg.getMixingZoneHeight();
     dWidth = bldg.getWidth();
     dLength = bldg.getLength();
     dDepthOfFoundation = bldg.getFoundationDepthBelowGrade();
     //unit converter for output unit
     uc = pvisCD.getUnitConverter();
     sOutputLengthUnit = uc.getOutputNameFromType("Length");
     dUCF = uc.getOutputUCFFromType("Length");
   }
   catch (Exception e)
   {
	 //set generic values
	 dVadose = 25;
	 dVadoseMax = 29;
	 dLensTop = dVadose-1;
	 dLensBottom = dVadoseMax;
	 dLensWidth = 15;
	 dLensLength = 9;
	 dSample = 10;
	 dAquifer = 35;
	 dHouse = 8;
	 dWidth = 10;
	 dLength = 10;
	 dDepthOfFoundation = 4;
	 sOutputLengthUnit = "ft";
	 dUCF = 1.0;
   }
   //add the padding
   //(Math.PI/6.0 = 30 degrees = slope of roof)
   dSky = 1.2*( 0.5*dWidth*Math.tan(Math.PI/6.0));
   dUnderworld = dSky;
   
   //total height of drawing
   dTotalHeight = dSky + dHouse + dVadose + dAquifer + dUnderworld; 
   dTotalWidth = 7.0*dWidth;
   
   //screen coordinates
   
   //scale factors
   dSFY = dCanvasHeight/dTotalHeight;
   //correct the vertical exaggeration
   //dSFY = dSFY*dCanvasWidth/dCanvasHeight;
   
   dSFX = dCanvasWidth/dTotalWidth;
   
}

double dMarginX,dMarginY;
double dLandY;
double dLandX0, dLandX1, dLandX2, dLandX3, dLandX4;
double dLand2p5;
double dWaterTableY, dWaterTableMaxY, dAquiferBottomY;
double dBuildingY0,dBuildingY1,dBuildingY2;
double dLensTopPlot, dLensBottomPlot;
double dSampleY0, dSampleY1;
double dSampleX;
//draw the PVIScreen Schematic
private void drawSchematic(GraphicsContext gc) 
{
	dMarginX = 10;
	dMarginY = 10;
	//draw a line representing the land
	 
	//the land is located at a height (y-coordinate) of dSky + dBuilding
	//the land runs from the margin to the building wall and then opposite building wall to the next margin
	//the length of the land is the same as with width of the building, but with a minimum
	gc.setStroke(Color.BROWN);
	gc.setLineWidth(5);
	dLandY = dMarginY  + dSFY*(dSky + dHouse);
	dLandX0 = dMarginX + dSFX*dWidth;
	dLandX1 = dLandX0 + dSFX*dWidth;
	dLandX2 = dLandX1 + dSFX*dWidth;
	dLandX3 = dLandX2 + dSFX*dWidth;
	dLandX4 = dLandX3 + dSFX*dWidth;
	
	//the 0.88 allows room for the sample and NAPL scale bars in addArrowsAndLabels
	gc.strokeLine(dLandX0, dLandY, 0.88*dLandX1, dLandY);
	if (dDepthOfFoundation>0.075*(dAquifer+dVadose))
	{	
	  gc.strokeLine(1.06*dLandX2, dLandY, dLandX3, dLandY);
	}
	gc.strokeLine(1.04*dLandX3, dLandY, dLandX4, dLandY);
	
	//requirement for LensWidth to be More than zero added 2-16-2018
	if (dLensTop>0.0  && dLensWidth>0)
	{	
	  gc.setStroke(Color.ORANGE);
	
	  //contamination
	  dLensTopPlot = dLandY + dSFY*(dLensTop);
	  dLensBottomPlot = dLandY + dSFY*(dLensBottom);
	  double dLW = dSFX*(dLensWidth-dWidth);
	  double d1, d2;
	  d1 = dLandX1-0.5*dLW;
	  d2 = d1 + dSFX*dLensWidth;
	  gc.strokeLine(d1,dLensTopPlot,d2,dLensTopPlot);
	  gc.strokeLine(d1,dLensBottomPlot,d2,dLensBottomPlot);
	  gc.strokeLine(d1,dLensTopPlot,d1, dLensBottomPlot);
	  gc.strokeLine(d2,dLensTopPlot,d2, dLensBottomPlot);
	}	
	
	 gc.setStroke(Color.GREEN);
	 
	
	 //draw building accounting for the depth of the foundation
	
	 //starting point in Y
	 dBuildingY0 = dMarginY + dSFY*(dSky + dDepthOfFoundation);
	 //deepest point in ground:
	 dBuildingY1 = dBuildingY0 + dSFY*(dHouse);
	 //peak of roof:
	 dBuildingY2 = dBuildingY0 - dSFY*(0.4*dHouse);
	 
	 //starting point in x is dLandX1
	 //mid point of building
	 dLand2p5 = dLandX1 + dSFX*0.5*dWidth;
	 //left wall
	 gc.strokeLine(dLandX1, dBuildingY0, dLandX1, dBuildingY1);
	 //floor
	 gc.strokeLine(dLandX1, dBuildingY1, dLandX2, dBuildingY1);
	 //right wall
	 gc.strokeLine(dLandX2, dBuildingY1, dLandX2, dBuildingY0);
	 //right wall to peak of roof!
	 gc.strokeLine(dLandX2, dBuildingY0, dLand2p5, dBuildingY2);
	 //peak of roof to left wall!
	 gc.strokeLine(dLand2p5, dBuildingY2, dLandX1, dBuildingY0);
	 
	 gc.setStroke(Color.CHARTREUSE);
	 //depth of sample
	 if (dSample>0)  //default sample depth is -1 (1 unit above land surface)
	 {
		//starting point in Y is the land surface
		double dSampleY0 = dMarginY + dSFY*(dSky+dHouse);
		double dSampleY1 = dMarginY + dSFY*(dSky + dHouse + dSample);
		//starting point in X is the left edge of the building
		double dSampleX0 = dLandX1;
		gc.strokeRect(0.94*dLandX1, 0.99*dSampleY1, 0.02*dLandX1, 0.01*dSampleY1);
	 }
	
	 
	 //water table depth
	 gc.setStroke(Color.BLUE);
	 gc.setLineWidth(2);
	 
	 //depth of vadose zone is depth to water
	
	 dWaterTableY = dLandY + dSFY*(dVadose);
	 dWaterTableMaxY = dLandY + dSFY*(dVadoseMax);
	 dAquiferBottomY = dLandY + dSFY*(dAquifer);
	 
	 //water table
	 gc.strokeLine(1.00*dLandX0, dWaterTableY, 1.01*dLandX2, dWaterTableY);
	 gc.strokeLine(1.05*dLandX2, dWaterTableY, 1.00*dLandX3, dWaterTableY);
	 gc.strokeLine(1.04*dLandX3, dWaterTableY, 1.00*dLandX4, dWaterTableY);
	 
	 /*
	 //max depth of water table
	 gc.strokeLine(1.50*dLandX0, dWaterTableMaxY, 1.01*dLandX2, dWaterTableMaxY);
	 gc.strokeLine(1.05*dLandX2, dWaterTableMaxY, dLandX2 + 0.65*(dLandX3-dLandX2), dWaterTableMaxY);
	 //gc.strokeLine(1.04*dLandX3, dWaterTableMaxY, dLandX4, dWaterTableMaxY);
	 */
	 
	 if (dAquifer>0.0)
	 {	 
	   //bottom of aquifer
	   gc.setStroke(Color.BLACK);
	   gc.setLineWidth(5);
	   gc.strokeLine(dLandX0, dAquiferBottomY, dLandX3, dAquiferBottomY);
	   gc.strokeLine(1.04*dLandX3, dAquiferBottomY, dLandX4, dAquiferBottomY);
	 }  
	 
	 }
   
   //add an open triangular mark to indicate the location of the water table.
   public void addWaterTableMark(GraphicsContext gc, double dYValue, double dY, double dLandX, double dX)
   {
     //water table depth
	 gc.setStroke(Color.BLUE);
	 gc.setLineWidth(2);
	 
	 gc.strokeLine(dLandX-dX, dYValue-dY, dLandX, dYValue);
	 gc.strokeLine(dLandX, dYValue, dLandX+dX, dYValue-dY);
	 
	 //add some straight lines
	 gc.strokeLine(dLandX-dX, 1.02*dYValue, dLandX+dX, 1.02*dYValue);
	 gc.strokeLine(dLandX-(1.0-0.15)*dX, 1.04*dYValue, dLandX+(1.0-0.15)*dX, 1.04*dYValue);
	 gc.strokeLine(dLandX-(1.0-0.25)*dX, 1.06*dYValue, dLandX+(1.0-0.25)*dX, 1.06*dYValue);
   }
   
   //add hatching to indicate the bottom of the aquifer
   public void addAquiferBottomHatching(GraphicsContext gc)
   {
	 //bottom of aquifer
	 gc.setStroke(Color.BLACK);
	 gc.setLineWidth(2);
	 //gc.strokeLine(dLandX0, dAquiferBottomY, dLandX3, dAquiferBottomY);
	 
	 double dStart, dEnd;
	 dStart = 1.0;
	 dEnd = 1.05;
	 while (dEnd*dLandX0 < dLandX3)
	 {	 
	   gc.strokeLine(dStart*dLandX0, 1.05*dAquiferBottomY, dEnd*dLandX0, dAquiferBottomY);
	   dStart = dEnd;
	   dEnd = dEnd + 0.05;
	 } 	 
	 
	 gc.setStroke(Color.BLACK);
	 dStart = 3.95;
	 dEnd = 4.00;
	 while (dEnd*dLandX0 <= 0.99*dLandX4)
	 {	 
	   gc.strokeLine(dStart*dLandX0, 1.05*dAquiferBottomY, dEnd*dLandX0, dAquiferBottomY);
	   dStart = dEnd;
	   dEnd = dEnd + 0.05;
	 } 	 
	 
	 
	 
   }
   
   //add dimensions and dimension lines to plot
   public void addArrowsAndLabels(GraphicsContext gc)
   {
	   OutputDigits od = new OutputDigits();
	   gc.setStroke(Color.BLACK);
	   gc.setLineWidth(2);
	   
	   
	   //land to bottom of foundation
	   gc.strokeLine(1.03*dLandX2,dLandY,1.03*dLandX2,dBuildingY1);
	   //crossing lines
	   gc.strokeLine(1.02*dLandX2,dLandY,1.04*dLandX2,dLandY);
	   gc.strokeLine(1.02*dLandX2,dBuildingY1,1.04*dLandX2,dBuildingY1);
	   
	   //bottom of foundation to water table
	   gc.strokeLine(1.03*dLandX2,dBuildingY1, 1.03*dLandX2,dWaterTableY);
	   //crossing line
	   gc.strokeLine(1.02*dLandX2,dWaterTableY,1.04*dLandX2,dWaterTableY);
	   
	   //current water table to historic water table
	   /*
	   gc.strokeLine(1.03*dLandX2,dWaterTableY,1.03*dLandX2,dWaterTableMaxY);
	   gc.strokeLine(1.02*dLandX2,dWaterTableMaxY,1.04*dLandX2,dWaterTableMaxY);
	   */
	   
	   
	   //land to top of current water table
	   gc.strokeLine(1.02*dLandX3,dLandY,1.02*dLandX3,dWaterTableY);
	   gc.strokeLine(1.01*dLandX3,dLandY,1.03*dLandX3,dLandY);
	   gc.strokeLine(1.01*dLandX3,dWaterTableY,1.03*dLandX3,dWaterTableY);
	   
	   if (dAquifer>0.0)
	   {	   
	     //max water table to aquifer bottom
	     gc.strokeLine(1.02*dLandX3,dWaterTableY,1.02*dLandX3,dAquiferBottomY);
	     gc.strokeLine(1.01*dLandX3,dAquiferBottomY,1.03*dLandX3,dAquiferBottomY);
	   }
	   
	   if (dLensTop>0.0)
	   {	   
	     //foundation to top of oil zone
	     //gc.strokeLine(0.97*dLandX1, dBuildingY1, 0.97*dLandX1, dLensTopPlot);
		 //hashes
		 //gc.strokeLine(0.96*dLandX1, dBuildingY1, 0.98*dLandX1, dBuildingY1);
		 //gc.strokeLine(0.96*dLandX1, dLensTopPlot, 0.98*dLandX1, dLensTopPlot); 
	   }
	   
	   if (dSample>0)
	   {	   
		   //land to sample depth
		   //starting point in Y is the land surface
		   double dSampleY0 = dMarginY + dSFY*(dSky+dHouse);
		   double dSampleY1 = dMarginY + dSFY*(dSky + dHouse + dSample);
		   //starting point in X is the left edge of the building
		   double dSampleX0 = dLandX1;
			
		   //code for the sample:
		   //gc.strokeRect(0.94*dLandX1, 0.99*dSampleY1, 0.02*dLandX1, 0.01*dSampleY1);
		 		  
		   gc.strokeLine(0.90*dLandX1, dSampleY0, 0.92*dLandX1, dSampleY0);
		   gc.strokeLine(0.91*dLandX1, dSampleY0, 0.91*dLandX1, dSampleY1);
		   gc.strokeLine(0.90*dLandX1, dSampleY1, 0.92*dLandX1, dSampleY1);
	   }
		   
	   
	  
	   
	   
	   //text
	   
	   //water table thickness
	   gc.setStroke(Color.BLACK);
	   gc.setFill(Color.BLACK);
	   gc.setLineWidth(1);
	   double dDepth1 = 0.5*(dLandY + dWaterTableY);
	   String sOut1 = od.num2String(this.dVadose*this.dUCF) + " (" + sOutputLengthUnit + ")";
	   gc.setFont(Font.font("Arial", FontWeight.BOLD, 14));
	   //gc.setFont(Font.font("System Regular",FontWeight.NORMAL,20));
	   gc.fillText(sOut1, 1.05*dLandX3,dDepth1);
	   
	   /*
	   //historic and current water table differences
	   gc.setStroke(Color.BLACK);
	   double dDepth2 = dWaterTableY + 0.75*(dWaterTableMaxY - dWaterTableY);
	   String sOut2 = od.num2String((this.dVadoseMax - this.dVadose)*this.dUCF) + " (" + sOutputLengthUnit + ")";
	   gc.fillText(sOut2, 1.05*dLandX2,dDepth2);
	   */
	   
	   //aquifer thickness
	   if (dAquifer>0.0)
	   {	   
	     gc.setStroke(Color.BLACK);
	     double dDepth3 = 0.5*(dWaterTableY + dAquiferBottomY);
	     String sOut3 = od.num2String((this.dAquifer - this.dVadose)*this.dUCF) + " (" + sOutputLengthUnit + ")";
	     gc.fillText(sOut3, 1.05*dLandX3,dDepth3);
	   }
	   
	   //foundation thickness
	   double dDepth4 = dLandY + 0.75*dSFY*dDepthOfFoundation;
	   String sOut4 = od.num2String(this.dDepthOfFoundation*this.dUCF) + " (" + sOutputLengthUnit + ")";
	   gc.fillText(sOut4, 1.05*dLandX2,dDepth4);
	   
	   //foundation to water table
	   double dDepth5 = dLandY + dSFY*dDepthOfFoundation + 0.75*dSFY*(dVadose-dDepthOfFoundation);
	   String sOut5 = od.num2String((this.dVadose - this.dDepthOfFoundation)*this.dUCF) + " (" + sOutputLengthUnit + ")";
	   gc.fillText(sOut5, 1.05*dLandX2,dDepth5);
	   
	   
	   //foundation to top of contamination
	   /*
	   double dDepth6 = dLandY + dSFY*dDepthOfFoundation + 0.75*dSFY*(dLensTop - dDepthOfFoundation);
	   String sOut6 = od.num2String((dLensTop - dDepthOfFoundation)*this.dUCF) + " ("  + sOutputLengthUnit + ")";
	   gc.fillText(sOut6, 1.02*dLandX1,dDepth6);
	   */
	   
	   //depth of sample
	   if (dSample>0)
	   {	   
	     double dDepth7 = dLandY + dSFY*dDepthOfFoundation + 0.50*dSFY*(dSample - dDepthOfFoundation);
	     String sOut7 = od.num2String((dSample - dDepthOfFoundation)*this.dUCF) + " ("  + sOutputLengthUnit + ")";
	     sOut7 = od.num2String(dSample*this.dUCF) + " ("  + sOutputLengthUnit + ")";
	     gc.fillText(sOut7, 0.65*dLandX1,dDepth7);
	   }
	   
   }

   //sets
   public void setHandlerRepository(Repository r){this.repository = r;}
   public void setTopLabel(Label lTopLabel){this.lTopLabel = lTopLabel;}
  
}
