package ui;



import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Set;


import javax.imageio.ImageIO;


import pviScreen.Chemical;
import pviScreen.ChemicalRisk;
import pviScreen.PVIScreenControlData;
import pviScreen.ParameterChoices;

import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.scene.chart.LineChart;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.util.Duration;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;


import statistics.Histogram;
import statistics.Interval;
import statistics.RiskContainer;
import util.NameConstants;
import util.OutputDigits;
import util.OutputFormatter;
import util.Stripper;

public class HandlerStatisticsPlot implements EventHandler
{
	private Stage stage;
	private TabPane tp;
	private Tab tab;

	private ScrollPane sp;
	private Repository repository;
	private PVIScreenControlData pvisControlData;
	private RiskContainer rc;
	private ParameterChoices pc;
	private BorderPane border;
	private boolean bInputFileSet;
	private boolean bInputTypeSetFlag;
	private boolean bChosenChemicalSetFlag;

	private String sInputType;
	private String sInputFile;
	private String sInputPath;
	private String sFilePathAndNameStatistics;
	private String sChosenChemical;
	private Label lTopLabel;
	private LegendThatWorks ltw;
	private NameConstants nc;
	private Stripper s;
	private ObservableList<Button> olButton;
	private ChartAnnotationOverlay cao;
	private OutputFormatter ou;
    private String sOutputUnit;
	
	static final private String FILE_STATISTICS = "Statistics";     
	static final private String C_EXTENSION = " Indoor Air Concentration"; 
	


	public HandlerStatisticsPlot(Stage stage)
	{
		this.stage = stage;
		this.bInputFileSet = false;
		s = new Stripper();
		ou = new OutputFormatter();
	}

	public void handle(Event event)
	{
		String sName;
		int iLegendPosition;
		pvisControlData = repository.getPVIScreenControlData();
		pc = pvisControlData.getParameterChoices();

		border = repository.getBorder();


		//create the container panes
		sp = new ScrollPane();
		tp = new TabPane();


		//change combo box chemical choice buttons
		ArrayList<Chemical> alChemical = pvisControlData.getChemicals();

		//go through all the chemicals
		//put each active chemical on a tab
		for (Chemical chemical: alChemical)
		{
			if(chemical.getIsChemicalUsed())
			{
				//create new tab
				Tab tab = new Tab();


				StackPane sp = new StackPane();
				GridPane gp = new GridPane();

				ColumnConstraints column1 = new ColumnConstraints(600);
				column1.setHgrow(Priority.ALWAYS);
				ColumnConstraints column2 = new ColumnConstraints(300);
				gp.getColumnConstraints().addAll(column1, column2); // first column gets any extra width

				sName = chemical.getName();
				tab.setText(sName);

				//create a linechart and generate the legend items
				//these two are plotted separately; this.drawStatistics must be used to generate the legend
				LineChart<Number,Number> lcStatistics = this.drawStatistics(chemical, sName, true, true, true);

				iLegendPosition = 0;
				//draw chart if possible
				if (lcStatistics!=null)
				{	
					lcStatistics.setAnimated(false);
					lcStatistics.setMaxHeight(0.75*stage.getHeight());
					lcStatistics.setMaxWidth(0.67*stage.getWidth());

					//gp.add(lcStatistics, 0, 0);
					sp.getChildren().addAll(lcStatistics,cao);
					gp.add(sp, 0, 0);
					iLegendPosition = 1;
				}   

				//get and draw the legend
				Canvas cLegend = this.getLegendCanvas(); 
				gp.add(cLegend,iLegendPosition,0);
				tab.setContent(gp);


				//save tab name as final to get into internal class:
				final Tab tabWrite = tab;
				//attempt writing out of the chart
				Task task = new Task<Void>() {
					@Override
					public Void call() {

						Platform.runLater(
								new Runnable() {
									public void run() {
										try {
											//only write one output graphic, becuase the rest  WON'T write
											if (s.areTheyEqual(tabWrite.getText(),"Benzene"))
											{
												WritableImage snapshot = tabWrite.getContent().snapshot(new SnapshotParameters(), null);
												String sFileName = repository.getFilePathAndNameResults();
												String sFilePNG = sFileName + "." + tabWrite.getText() + ".png";
												File outFile = new File(sFilePNG);
												try 
												{
													ImageIO.write(SwingFXUtils.fromFXImage(snapshot, null),"png", outFile);
												} 
												catch (IOException ex) 
												{
													//System.out.println(ex.getMessage());
													System.out.println("Exception on writing image");
												}
												repository.addOutputImage(snapshot);
												System.out.println("graphic for: " + tabWrite.getText());
												repository.addOutputImageName(tabWrite.getText());
											}



										} catch (Exception s) {}

										System.out.println("finished");

									}
								});

						return null;
					}

				};
				//set off the drawing threed for the snapshot
				Thread th = new Thread(task);
				th.start();


				//add the tab to the tabpane
				tab.setClosable(false);
				tp.getTabs().add(tab);

			}
		}  //get next chemical

		//set the tabpane as the center of the border layout
		border.setCenter(tp);
		repository.setStatisticsTabPane(tp);

		stage.show();


		//adjust button enablement
		olButton = repository.getButtonList();
		s = new Stripper();
		nc = new NameConstants();
		for (Button button: olButton)
		{
			String sButton = button.getText();
			if (s.equals(nc.s_ButtonReport,sButton))
			{
				button.setDisable(false);
				button.setStyle(nc.s_StyleEnable);	
			}
		}

	}





	public LineChart<Number,Number> drawStatistics(Chemical chemical, String sChosenChemical, boolean bDisplayGraphic, boolean bSaveRisk, boolean bSaveGraphic)
	{
		boolean bHistogramExist=false;
		LineChart<Number,Number> lcForReturn;
		lcForReturn = null;


		rc = repository.getRiskContainer();
		sFilePathAndNameStatistics = repository.getFilePathAndNameResults();
		pvisControlData = repository.getPVIScreenControlData();

		try 
		{
			Histogram h = new Histogram();
			String sChemical = sChosenChemical + this.C_EXTENSION ;
			//read histogram results
			h.readHistogram(this.sFilePathAndNameStatistics, sChemical, "Log Intervals");	
			//did histogram exist?
			bHistogramExist = h.doesHistogramExist();
			if (bHistogramExist)
			{	

				//get histogram chemical name
				String sHistogramChemical = getHistogramChemical(h.getHistogramChemical());
				System.out.println("Histogram Chemical " + sHistogramChemical);
				//create the line chart
				lcForReturn = this.createStatisticsOutput(chemical,this.sFilePathAndNameStatistics, sChosenChemical, h, rc, bDisplayGraphic, bSaveRisk, bSaveRisk);
				//update the output Label
				if (bDisplayGraphic){this.lTopLabel.setText("Statistics results plotted for " + repository.getInputFileAndPath());}
			}
		} catch (IOException e1) {}	

		return lcForReturn;
	}


	public LineChart<Number,Number> createStatisticsOutput(Chemical chemical,
			String sFilePathAndName, 
			String sChosenChemical,
			Histogram h, 
			RiskContainer rc,
			boolean bDisplayGraphic,
			boolean bSaveRisk,
			boolean bSaveGraphic) throws IOException
	{
		boolean bAllResultsLessThanCancerRisk = false;
		boolean bAllResultsLessThanNonCancerRisk = false;
		boolean bAllResultsLessThanScreeningLevel = false;
		boolean bDrawChart = false;
		double dPerCentAboveRiskLevel;
		double dRiskLevel;
		double dRiskConcentration;
		double dCancerLevelForSaving=0.0;
		double dHazardLevelForSaving=0.0;
		double dScreeningLevelForSaving=0.0;
		int iColorForSaving=0;
		int iSeriesForSaving=0;
		double dSelectedFrequency;
		String sOutputUnit = null;      	
		String sName;
		int iCountSeries=0;
		//original colors red, yellow, green (pale shades)
		//String[] sConcernColor = {"#FF9999","#FFFF99","#99FF99"};
		//new colors red, black,black
		//String[] sConcernColor = {"#FF3333","#333333","#333333"};
		String[] sConcernColor = {"#333333","#333333","#333333"};
		double dMinXAxis,dMaxXAxis;

		//axis limits
		dMinXAxis = -5.0;
		dMaxXAxis = 2.0;

		//revise default axis limits
		ParameterChoices pc;
		pc = pvisControlData.getParameterChoices();
		try
		{
			ArrayList<String>	alParameterChoices;
			alParameterChoices = new ArrayList<String>();
			alParameterChoices = pc.getValue("MinimumXAxis",1);
			dMinXAxis = Double.parseDouble(alParameterChoices.get(0));

			alParameterChoices = new ArrayList<String>();
			alParameterChoices = pc.getValue("MaximumXAxis",1);
			dMaxXAxis = Double.parseDouble(alParameterChoices.get(0));   	  
		}
		catch (Exception e)
		{
			//use default axes
			dMinXAxis = -5.0;
			dMaxXAxis = 2.0;
		}

		//check to see if the cumulative probability plot will fall within the range of the axes
		//if not the plot will not be created
		bDrawChart = false;
		for (Interval interval: h.getHistogramIntervals())
		{
			double dConc = interval.getMidPointValue();
			if (dMinXAxis<=dConc && dConc <= dMaxXAxis)
			{	  
				bDrawChart = true;
			}
		}    	    	


		sName = h.getHistogramChemical();
		ScrollPane sp = new ScrollPane();


		//concentration or x value
		double dConc;
		//cumulative frequency or y value
		double dCF;
		//instantaneous frequency (density) or value
		double dIF;


		//start new LegendThatWorks to contain the characteristics of the legend
		//since the JavaFX chart legend is unusable.
		ltw = new LegendThatWorks();


		//create an array list for the histogram intervals
		ArrayList<Interval> alInterval = new ArrayList<Interval>(); 
		XYChart.Series xyDataRiskLevel = new XYChart.Series();
		XYChart.Series xyScreeningLevel = new XYChart.Series();

		NumberAxis xAxis = new NumberAxis();
		NumberAxis yAxis = new NumberAxis();
		xAxis.setLabel("Log Indoor Air Concentration (Log10 " + h.getOutputUnit() + ")");
		yAxis.setLabel("Frequency");
		//yAxis.setAutoRanging(false);
		//yAxis.setUpperBound(1.0);
		yAxis.setTickUnit(0.1);


		final LineChart<Number,Number> statisticsChart = new LineChart<Number,Number>(xAxis,yAxis);
		statisticsChart.setLegendVisible(false);
		statisticsChart.setCreateSymbols(false);
		statisticsChart.setTitle("PVIScreen Result for " + h.getHistogramTitle());	
		ltw.setName(h.getHistogramChemical());
		//create the annotations container


		XYChart.Series[] xyCumulative;
		xyCumulative = new XYChart.Series[3];
		xyCumulative[0] = new XYChart.Series();
		//xyCumulative[0].setName("High model probability of exceedence");
		xyCumulative[0].setName("");
		xyCumulative[1] = new XYChart.Series();
		//xyCumulative[1].setName("Low or moderate model probability of exceedence");
		xyCumulative[1].setName("");
		xyCumulative[2] = new XYChart.Series();
		xyCumulative[2].setName("");

		XYChart.Series xyDataDensity = new XYChart.Series();

		xyDataDensity.setName("Probability Density");

		//set legend annotations
		ltw.addTextAnnotation(h.getHistogramChemical() + " risks/hazards", 0);
		//ltw.addTextAnnotation("Probability", 5);
		//ltw.addTextAnnotation("Probability That Chosen Risk Level(s) Are Exceeded", 4);


		//load the data
		//default color limits, these can be changed in the systemData/05ParameterChoices.csv file
		//(if the middle value (0.60 below) is set to "Highest Probability" the color break will occur
		//at the point of maximum probability -- probably don't really want to do this.)
		//double[] dColorLow  = {0.00,0.60,0.95};
		//double[] dColorHigh = {0.60,0.95,1.00};

		//override the color choices:

		//plot the curve in red for concentrations above:
		//cancer risk
		//non-cancer hazard risk
		//screening level
		//otherwise the curve is black
		double dHistogramColorChangeLevel=1e308;
		double dCancerRiskLevel;


		/*
    	//cancer risk
    	if (chemical.getRiskLevelSet() && chemical.getRiskConcentration()>0)
    	{	
    	  ArrayList<Double> alRiskLevel2 = pvisControlData.getRiskLevels();
    	  dCancerRiskLevel = h.getLevelOfConcern()*alRiskLevel2.get(0);
    	  if (dCancerRiskLevel<dHistogramColorChangeLevel){dHistogramColorChangeLevel = dCancerRiskLevel;}
    	}

    	//non-cancer risk
    	if (chemical.getReferenceConcentrationSet())
    	{	
    	  double dRFc = h.getRfC()   ;
    	  ArrayList<Double>alHazardQuotient2 = pvisControlData.getHazardQuotients();
    	  double dHazardLevel = dRFc*alHazardQuotient2.get(0);
    	  if (dHazardLevel<dHistogramColorChangeLevel){dHistogramColorChangeLevel = dHazardLevel;}
    	}
    	//external screening level
    	//overrides other choices
    	if (chemical.getScreeningLevelSet())
    	{
    		dHistogramColorChangeLevel = chemical.getScreeningLevel();
    	}    	
		 */


		double dCumulativeProbability = h.getCumulativeProbability(dHistogramColorChangeLevel,true);		
		//revise the color choices (only the first and second choices are really used now)
		//red, yellow, green
		double[] dColorLow  = {dCumulativeProbability,0.00,0.00};
		double[] dColorHigh = {1.00,dCumulativeProbability,0.00};
		int iSize = alInterval.size();
		/*

  	  //
      //probability density plot
  	  //   	
      //histogram for the probability density	
      alInterval = h.getHistogramIntervals();

  	  for (int ii=0;ii<iSize;ii++)
  	  {
  		Interval interval = alInterval.get(ii);
  	    dConc = interval.getMidPointValue();
  	    if (dMinXAxis<=dConc && dConc <= dMaxXAxis)
  	    {	  
  	      dIF = interval.getFrequency();
		  xyDataDensity.getData().add(new XYChart.Data<Double, Double>(dConc,dIF));	 
  	    }
  	  }    
      statisticsChart.getData().addAll(xyDataDensity);   
      //set color
      setColor(statisticsChart,iCountSeries,"#CCCCCC");
      iCountSeries++;   	  
  	  ltw.addLegendItem(true,xyDataDensity.getName(),"#CCCCCC",6);

		 */



		//get the point of highest probability density
		//eliminated  8-27-2018 jww
		/*
  	  double dLogMax = h.getIntervalWithHighestProbabilityDensity();
  	  double dMax = Math.pow(10,dLogMax);
  	  double dMaxDensity = h.getHighestProbabilityDensity();

  	  h.determineCumulativeProbabilityOfTheLevelOfConcern(dMax);
   	  double dMaxFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
      dPerCentAboveRiskLevel = (1.0 - dMaxFrequency)*100.0;
	  if (dPerCentAboveRiskLevel<0.0001){dPerCentAboveRiskLevel=0.0;}
  	  XYChart.Series xyDataHighProbability = new XYChart.Series();
  	  xyDataHighProbability.setName("Most Probable Individual Result: " + ou.getFormattedString(dMax) + " " + h.getOutputUnit());


	    if (dMaxFrequency>0.0)
	    {	

	      //modifyColorLimits(pc,dColorLow,dColorHigh,true,1-dMaxFrequency);
	      boolean bDrawLine = false;
          if (dMinXAxis < dLogMax && dLogMax < dMaxXAxis)
          { 	  
		      xyDataHighProbability.getData().add(new XYChart.Data(dLogMax,dMaxDensity-0.02));
		      xyDataHighProbability.getData().add(new XYChart.Data<Double, Double>(dLogMax,dMaxDensity));
	          xyDataHighProbability.getData().add(new XYChart.Data(dLogMax,dMaxDensity+0.02));
	          statisticsChart.getData().addAll(xyDataHighProbability);
	          //set color
	  	      setColor(statisticsChart,iCountSeries,"#3333CC");
	  	      iCountSeries++;
	  	      bDrawLine = true; 
	  	      addMForMaximumProbabilityResult(statisticsChart,iCountSeries,"#000000",dLogMax,dMaxDensity+0.1,true);

          }    
	  	      else
  	      {
  	    	  bDrawLine = false;
  	      }
  	      ltw.addLegendItem(bDrawLine,xyDataHighProbability.getName(),"#3333CC",5);
  	      ltw.addLegendItem(false,"  (which is exceeded by "+ ou.getFormattedString(dPerCentAboveRiskLevel) + " % of simulations)","#999999",5);
          //addMForMaximumProbabilityResult(statisticsChart,iCountSeries,"#000000",dLogMax,dMaxDensity+0.1,true);

  	      iCountSeries++;   
	    }  	
	    else
	    {
	    	  //modifyColorLimits(pc,dColorLow,dColorHigh,false,1-dMaxFrequency);
	    }
		 */

		//save the color limit choices for use later (especially the report writer)
		repository.setColorLow(dColorLow);
		repository.setColorHigh(dColorHigh);



		//
		//cumulative probability plot
		//
		//add the color-coded cumulative probability curve to the chart
		double dCFMax = -1;
		alInterval = h.getHistogramIntervals();
		for (int j=0;j<dColorHigh.length;j++)
		{	
			iSize = alInterval.size();

			//initial point
			dConc = h.getValueForCumulativeFrequency(dColorLow[j]);
			if (dMinXAxis<=dConc && dConc <=dMaxXAxis){xyCumulative[j].getData().add(new XYChart.Data<Double,Double>(dConc,dColorLow[j]));}

			//all other intervals
			for (int ii=0;ii<iSize;ii++)
			{
				Interval interval = alInterval.get(ii);
				dConc = interval.getMidPointValue();
				if (dMinXAxis<= dConc && dConc <= dMaxXAxis)
				{	  
					dCF = interval.getCumulativeFrequency();
					if (dColorLow[j]<dCF && dCF<=dColorHigh[j])
					{
						//save the color for the highest cumulative probability
						if (dCF>dCFMax){dCFMax = dCF;iColorForSaving=j;}
						//add the datapoint
						xyCumulative[j].getData().add(new XYChart.Data<Double, Double>(dConc,dCF));  
					}  
				}
			}

			//final point
			dConc = h.getValueForCumulativeFrequency(dColorHigh[j]);
			if (dMinXAxis<dConc && dConc<=dMaxXAxis)
			{
				xyCumulative[j].getData().add(new XYChart.Data<Double,Double>(dConc,dColorHigh[j]));
			}

			//add to the chart
			statisticsChart.getData().addAll(xyCumulative[j]);
			//set color
			setColor(statisticsChart,iCountSeries,sConcernColor[j]);
			if (xyCumulative[j].getName()!=""){ltw.addLegendItem(true, xyCumulative[j].getName(), sConcernColor[j],4);}
			iCountSeries++;
		}



		//create annotations for the cancer, non-cancer, screening, average result and most probable results
		cao = new ChartAnnotationOverlay(statisticsChart);
		//
		//
		//Cancer risk
		//if this histogram is a chemical, a risk level can be added
		//add a risk level --- a vertical line at a specified concentration
		int iRiskCount = 0;
		//boolean for putting the "C" for cancer in the legend
		boolean bAddC = true;

		//determine cancer risk levels for all values in input set
		ArrayList<Double> alRiskLevel = pvisControlData.getRiskLevels();

		//dRiskLevel = h.getRiskLevel();

		if (chemical.getRiskConcentration()>0.0)
		{	   
			dRiskConcentration = h.getLevelOfConcern();
			for (Double dRisk: alRiskLevel)
			{   
				try
				{
					//dConcentrationToCheck = dRiskConcentration*(dOutputRiskLevel[i]/dRiskLevel);
					dCancerLevelForSaving = dRiskConcentration*dRisk;
					//determine the cumulative probability of the Level Of Concern
					h.determineCumulativeProbabilityOfTheLevelOfConcern(dCancerLevelForSaving);
					sOutputUnit = h.getOutputUnit();
					dSelectedFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
					dPerCentAboveRiskLevel = (1.0 - dSelectedFrequency)*100.0;
					if (dPerCentAboveRiskLevel<0.0001){dPerCentAboveRiskLevel=0.0;}

					//save risk information
					if (bSaveRisk){rc.addCancerRisk(sName, true, dRisk, dCancerLevelForSaving, dPerCentAboveRiskLevel);}

					xyDataRiskLevel = new XYChart.Series();
					xyDataRiskLevel.setName( ou.getFormattedString(dPerCentAboveRiskLevel) + "% Above Risk " + dRisk + " Level (" + ou.getFormattedString(dCancerLevelForSaving) + " " + sOutputUnit +  ")");

					double dLogConcentration = Math.log10(dCancerLevelForSaving);
					if(dMinXAxis <= dLogConcentration && dLogConcentration <= dMaxXAxis)
					{		    	     
						xyDataRiskLevel.getData().add(new XYChart.Data(Math.log10(dCancerLevelForSaving),dSelectedFrequency+0.04));
						xyDataRiskLevel.getData().add(new XYChart.Data<Double, Double>(Math.log10(dCancerLevelForSaving),dSelectedFrequency));
						xyDataRiskLevel.getData().add(new XYChart.Data(Math.log10(dCancerLevelForSaving),dSelectedFrequency-0.04));
						statisticsChart.getData().addAll(xyDataRiskLevel);
						iRiskCount++;
						//set color
						/*
		             for (int j=0;j<dColorHigh.length;j++)
		             {	 
		               if (dColorLow[j]<=dSelectedFrequency && dSelectedFrequency<=dColorHigh[j])
		               {
		            	   setColor(statisticsChart,iCountSeries,sConcernColor[j]);
		            	   ltw.addLegendItem(false, xyDataRiskLevel.getName(), sConcernColor[j],0);  
		            	   break;
		               }
		             }  
						 */
						//make hash mark black
						setColor(statisticsChart,iCountSeries,"#333333");
						ltw.addLegendItem(false,xyDataRiskLevel.getName(),"#333333",2);

						iCountSeries++;  
						//add a "C" to indicate the cancer risk level
						//routine increments number of series


						iCountSeries = addCForCancer(statisticsChart,iCountSeries,"#000000",Math.log10(dCancerLevelForSaving),dSelectedFrequency-0.06,bAddC);
						//only one legend entry for "C for Cancer"
						cao.addAnnotation(false, dLogConcentration, dSelectedFrequency, "C");
						bAddC=false;
					}
				}
				catch (Exception e){}
			}   
		}

		else if (iRiskCount<=0)
		{
			//no cancer risks calculated
			if (bSaveRisk){rc.addCancerRisk(sName,false);}
		}

		//
		//non-cancer risk
		boolean bAddH=true;
		double dRfC;
		//get the reference concentration from the histogram
		dRfC = h.getRfC();

		if (dRfC>0.0)
		{
			ArrayList<Double> alHazardQuotient = pvisControlData.getHazardQuotients();
			//for (int i=0;i<dOutputHQ.length;i++)
			for (Double dHazardQuotient: alHazardQuotient)
			{ 
				try
				{
					dHazardLevelForSaving = dRfC*dHazardQuotient;
					h.determineCumulativeProbabilityOfTheLevelOfConcern(dHazardLevelForSaving);
					sOutputUnit = h.getOutputUnit();
					dSelectedFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
					dPerCentAboveRiskLevel = (1.0 - dSelectedFrequency)*100.0;
					if (dPerCentAboveRiskLevel<0.0001){dPerCentAboveRiskLevel=0.0;}

					//save results for writing to output
					if(bSaveRisk){rc.addHazard(sName, true, dHazardQuotient, dHazardLevelForSaving, dPerCentAboveRiskLevel);}

					xyDataRiskLevel = new XYChart.Series();
					xyDataRiskLevel.setName( ou.getFormattedString(dPerCentAboveRiskLevel) + "% Above Hazard Quotient of " + dHazardQuotient +   " (" + ou.getFormattedString(dHazardLevelForSaving) + " " + sOutputUnit +  ")");

					int iColor=0;
					//only add the mark if the concentration is within the axis limits
					double dLogConcentration = Math.log10(dHazardLevelForSaving);

					if(dMinXAxis <= dLogConcentration && dLogConcentration <= dMaxXAxis)
					{	  
						xyDataRiskLevel.getData().add(new XYChart.Data(dLogConcentration,dSelectedFrequency-0.04));
						xyDataRiskLevel.getData().add(new XYChart.Data<Double, Double>(dLogConcentration,dSelectedFrequency));
						xyDataRiskLevel.getData().add(new XYChart.Data(dLogConcentration,dSelectedFrequency+0.04));
						statisticsChart.getData().addAll(xyDataRiskLevel);

						//set color
						/*
		            for (int j=0;j<dColorHigh.length;j++)
		            {	 
		              if (dColorLow[j]<=dSelectedFrequency && dSelectedFrequency<=dColorHigh[j])
		              {
		            	setColor(statisticsChart,iCountSeries,sConcernColor[j]);
		            	iColor = j;
		            	break;
		              }
		            }
						 */
						//make hash mark black
						setColor(statisticsChart,iCountSeries,"#333333");
					}

					//(color is only used if concentration is within range of axis limits)
					//(color included, however, in function call)
					ltw.addLegendItem(false,xyDataRiskLevel.getName(),sConcernColor[iColor],2);

					iCountSeries++;
					iCountSeries = addHForHazard(statisticsChart,iCountSeries,"#000000",dLogConcentration,dSelectedFrequency+0.12,bAddH);
					cao.addAnnotation(false, dLogConcentration, dSelectedFrequency, "H");
					bAddH=false;
				}
				catch(Exception e){}
			}  

		}
		else
		{
			//add to RiskContainer as a "no-hazard" chemical
			if (bSaveRisk){rc.addHazard(sName,false);}
		}


		//screening levels, if used
		if (chemical.getScreeningLevelSet())
		{


			try
			{
				dScreeningLevelForSaving = chemical.getScreeningLevel();
				h.determineCumulativeProbabilityOfTheLevelOfConcern(dScreeningLevelForSaving);
				sOutputUnit = h.getOutputUnit();
				dSelectedFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
				dPerCentAboveRiskLevel = (1.0 - dSelectedFrequency)*100.0;
				if (dPerCentAboveRiskLevel<0.0001){dPerCentAboveRiskLevel=0.0;}

				//save results for writing to output
				if(bSaveRisk){rc.addScreeningRisk(sName, true, dScreeningLevelForSaving, dPerCentAboveRiskLevel);}

				xyScreeningLevel = new XYChart.Series();
				//xyScreeningLevel.setName( ou.getFormattedString(dPerCentAboveRiskLevel) + "% Exceed the Screening Level of " + dScreeningLevelForSaving +   " (" + ou.getFormattedString(dScreeningLevelForSaving) + " " + sOutputUnit +  ")");
				xyScreeningLevel.setName( ou.getFormattedString(dPerCentAboveRiskLevel) + "% Exceed the Screening Level of " + ou.getFormattedString(dScreeningLevelForSaving) + " " + sOutputUnit);

				int iColor=0;
				//only add the mark if the concentration is within the axis limits
				if(dMinXAxis <= Math.log10(dScreeningLevelForSaving) && Math.log10(dScreeningLevelForSaving) <= dMaxXAxis)
				{	  
					xyScreeningLevel.getData().add(new XYChart.Data(Math.log10(dScreeningLevelForSaving),dSelectedFrequency-0.04));
					xyScreeningLevel.getData().add(new XYChart.Data<Double, Double>(Math.log10(dScreeningLevelForSaving),dSelectedFrequency));
					xyScreeningLevel.getData().add(new XYChart.Data(Math.log10(dScreeningLevelForSaving),dSelectedFrequency+0.04));
					statisticsChart.getData().addAll(xyScreeningLevel);

					//set color
					for (int j=0;j<dColorHigh.length;j++)
					{	 
						if (dColorLow[j]<=dSelectedFrequency && dSelectedFrequency<=dColorHigh[j])
						{
							setColor(statisticsChart,iCountSeries,sConcernColor[j]);
							iColor = j;
							break;
						}
					}  
				}

				//(color is only used if concentration is within range of axis limits)
				//(color included, however, in function call)
				ltw.addLegendItem(false,xyScreeningLevel.getName(),sConcernColor[iColor],2);

				iCountSeries++;
				iCountSeries = addSForScreening(statisticsChart,iCountSeries,"#000000",Math.log10(dScreeningLevelForSaving),dSelectedFrequency+0.12,bAddH);
				bAddH=false;
			}
			catch(Exception e){}	     



		}

		//add a point to the cumulative probability curve, if one of the screening levels are higher than the
		//concentration of cumulative probability equal to one.
		int iLength = alInterval.size();
		//determine the maximum screening concentration
		double[] dScreening = {dScreeningLevelForSaving,dCancerLevelForSaving,dHazardLevelForSaving};
		//find maximum of screening concentrations
		double dMaxLevel = -1;
		for (int i=0;i<dScreening.length;i++)
		{
			if (dMaxLevel<dScreening[i]){dMaxLevel=dScreening[i];}
		}
		//is the maximum screening level above the top of the curve? and within the range of the axes?
		double dIntervalLevel=alInterval.get(iLength-1).getMidPointValue();
		if(dMinXAxis <= Math.log10(dMaxLevel) && Math.log10(dMaxLevel) <= dMaxXAxis)
		{	
			if (dIntervalLevel<Math.log10(dMaxLevel))
			{	
				XYChart.Series xyAdditional = new XYChart.Series();

				//add the maximum screening level to the curve
				xyAdditional.getData().add(new XYChart.Data<Double,Double>(dIntervalLevel,1.0));
				xyAdditional.getData().add(new XYChart.Data<Double,Double>(Math.log10(dMaxLevel),1.0));
				statisticsChart.getData().addAll(xyAdditional);
				setColor(statisticsChart,iCountSeries,sConcernColor[iColorForSaving]);
				iCountSeries++;
			}
		}
		
		//adding the mim, max etc of the results, jww, 9-3-2018
		//String[] sOutputStatistics = {"Maximum","95th Percentile","Third Quartile","Median","First Quartile","5th Percentile","Minimum"};
		String[] sOutputStatistics = {"Minimum","5th Percentile","First Quartile","Median","Third Quartile","95th Percentile","Maximum"};
		double[] dOutputStatistics = new double[sOutputStatistics.length];
		//get the results for the maximum calculated concentration
		dOutputStatistics = getOutputStatistics(sChosenChemical,sFilePathAndName,sOutputStatistics);

		//add the results to the legend, jww, 9-3-2018
		for (int k=0;k<sOutputStatistics.length;k++)
		{
		  int kk = sOutputStatistics.length-1 - k;
		  ltw.addLegendItem(false, sOutputStatistics[kk] + " " + ou.getFormattedString(dOutputStatistics[kk]) + " " + sOutputUnit, "#999999", 5);	
		  //ltw.addLegendItem(false, sOutputStatistics[k] + " " + dOutputStatistics[k] + " " + sOutputUnit, "#999999", 5);
		}

		//get the results for the averaged-parameter run.  These are found in the main results file
		double dAveragedParameterResult = getSingleParameterResult(sChosenChemical,"AveragedParameterResult",sFilePathAndName);
		double dLogAPR = Math.log10(dAveragedParameterResult);
		h.determineCumulativeProbabilityOfTheLevelOfConcern(dAveragedParameterResult);
		double dAveragedCumulativeFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
		double dPerCentAboveAveragedParameterSolution = (1.0 - dAveragedCumulativeFrequency)*100.0;
		if (dPerCentAboveAveragedParameterSolution<0.0001){dPerCentAboveAveragedParameterSolution = 0.0;}

		ltw.addLegendItem(false,"Averaged-Parameter Result: " + ou.getFormattedString(dAveragedParameterResult) + " " + h.getOutputUnit(),"#770077",5);	
		ltw.addLegendItem(false,"  (which is exceeded by "+ ou.getFormattedString(dPerCentAboveAveragedParameterSolution) + " % of simulations)","#999999",5);         		  	

		//get the results for the median-parameter run.  These are found in the main results file
		//JWW  3-28-2020
		double dMedianParameterResult = getSingleParameterResult(sChosenChemical,"MedianParameterResult",sFilePathAndName);
		double dLogMPR = Math.log10(dMedianParameterResult);
		h.determineCumulativeProbabilityOfTheLevelOfConcern(dMedianParameterResult);
		double dMedianCumulativeFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
		double dPerCentAboveMedianParameterSolution = (1.0 - dMedianCumulativeFrequency)*100.0;
		if (dPerCentAboveMedianParameterSolution<0.0001){dPerCentAboveMedianParameterSolution = 0.0;}

		ltw.addLegendItem(false,"Median-Parameter Result: " + ou.getFormattedString(dMedianParameterResult) + " " + h.getOutputUnit(),"#770077",5);	
		ltw.addLegendItem(false,"  (which is exceeded by "+ ou.getFormattedString(dPerCentAboveMedianParameterSolution) + " % of simulations)","#999999",5);         		  	
	
	
		//"animation" must be turned off to get complete snapshot of chart
		statisticsChart.setAnimated(false);

		if (bSaveGraphic)
		{	
			WritableImage snapshot = statisticsChart.snapshot(new SnapshotParameters(), null);
			repository.addOutputImage(snapshot);
		}

		//update the annotations overlay
		cao.update();

		//don't make a graphic if all results are less than risk levels
		if (!bDrawChart){return null;}
		else {return statisticsChart;}
	}
	private double[] getOutputStatistics(String sChosenChemical,String sFilePathAndName, String[] sOutputStatistics) throws IOException
	{
		double[] dValue = new double[sOutputStatistics.length];
		Stripper s = new Stripper();
		int iCount = 0;
		int iColumn = 0;


		FileReader fr = new FileReader(sFilePathAndName);
		BufferedReader br = new BufferedReader(fr);


		String currentLine;
		String[] lineArray = {""};

		while ((currentLine = br.readLine()) != null) 
		{
			lineArray = currentLine.split(",",0);

			if (iCount ==0 
					&& s.areTheyEqual(lineArray[0],"Results") 
					&& s.areTheyEqual(lineArray[1],"Heading"))
			{

				//find result column index
				for (int i=0;i<lineArray.length;i++)
				{
					if (s.areTheyEqual(lineArray[i],sChosenChemical + "IndoorAirConcentration")) 
					{
						//column found
						iColumn = i;
					}
				}
				iCount=1;


			}

			if (iCount == 3)
			{ 
				for (int k=0;k<sOutputStatistics.length;k++)  
				{ 
					// line of the averaged parameter result are the values
					if (s.areTheyEqual(lineArray[0],sOutputStatistics[k]))
					{
						//one more check is the second column an integer?

						//int iColumnOne = Integer.parseInt(lineArray[1]);
						//data row found
						dValue[k] = Double.parseDouble(lineArray[iColumn]);

						System.out.println("Statistics graph output " + sOutputStatistics[k] + " " + dValue[k]);
                        
						if (k==sOutputStatistics.length-1){iCount=4;}
						break;
					}

				}
			} 


			//second line of the averaged parameter results is the units
			if	(iCount == 1 
					&& s.areTheyEqual(lineArray[0], "Results",' ')
					&& s.areTheyEqual(lineArray[1], "Unit/Count")) 
			{
				this.sOutputUnit = lineArray[iColumn];
				iCount=2;
			}
			
			if (iCount==2
			&& s.areTheyEqual(lineArray[0], "Resistant Statistical Measures",' '))
			{
				iCount = 3;
			}
		}

		return dValue;
	}
	private double getSingleParameterResult(String sChosenChemical, String sResultType, String sFilePathAndName) throws IOException
	{
		double dValue=0.0;
		Stripper s = new Stripper();
		boolean bValid = false;
		int iCount = 0;
		int iColumn = 0;

		FileReader fr = new FileReader(sFilePathAndName);
		BufferedReader br = new BufferedReader(fr);

		String currentLine;
		String[] lineArray = {""};

		while ((currentLine = br.readLine()) != null) 
		{
			lineArray = currentLine.split(",",0);

			if (s.areTheyEqual(lineArray[0],"Control") && s.areTheyEqual(lineArray[1],"Results"))
			{
				//valid results file found 
				bValid = true;
			}

			if (bValid)
			{

				//third (and last) line of the averaged parameter result are the values
				if (s.areTheyEqual(lineArray[0],sResultType) && iCount == 2)
				{
					//one more check is the second column an integer?
					try
					{
						int iColumnOne = Integer.parseInt(lineArray[1]);
						//data row found
						dValue = Double.parseDouble(lineArray[iColumn]);
						iCount = 3;
						break;
					}
					catch(Exception e)
					{
						return dValue;
					}
				}

				//second line of the averaged parameter results is the units
				if	(s.areTheyEqual(lineArray[0], sResultType) && s.areTheyEqual(lineArray[1], "Unit/Count")){iCount=2;}


				//first line of averaged parameter results is the headings
				if (s.areTheyEqual(lineArray[0],sResultType) && s.areTheyEqual(lineArray[1],"Heading")) 
				{
					//find result column index
					for (int i=0;i<lineArray.length;i++)
					{
						if (s.areTheyEqual(lineArray[i],sChosenChemical + "IndoorAirConcentration")) 
						{
							//column found
							iColumn = i;
							break;
						}
					}
					iCount=1;
				}

			}




		}   	


		return dValue;
	}

	//routine to simplify color setting
	private void setColor(LineChart lc, int iCountSeries, String sColor)
	{
		final LineChart lc2 = lc;
		final int iCountSeries2 = iCountSeries;
		final String sColor2 = sColor;
		Set<Node> nodes = lc.lookupAll(".series" + iCountSeries);	
		for(Node n: nodes)
		{
			StringBuilder style = new StringBuilder();
			style.append("-fx-stroke: " + sColor + "; -fx-background-color: " + sColor + ", " + sColor +"; ");
			n.setStyle(style.toString());
		} 


	}


	//add a "C" for cancer
	private int addCForCancer(LineChart lc, int iCountSeries, String sColor, double dXCenter, double dYTop, boolean bAdd)
	{

		//put "c" on in parts -- change needed for java 8
		XYChart.Series xyCForCancer = new XYChart.Series();

		xyCForCancer = new XYChart.Series();
		xyCForCancer.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop));
		xyCForCancer.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop-0.05));


		lc.getData().addAll(xyCForCancer);
		setColor(lc,iCountSeries,sColor);
		iCountSeries++;


		xyCForCancer = new XYChart.Series();
		xyCForCancer.getData().add(new XYChart.Data(dXCenter + 0.09,dYTop));
		xyCForCancer.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop));


		lc.getData().addAll(xyCForCancer);
		setColor(lc,iCountSeries,sColor);
		iCountSeries++;


		xyCForCancer = new XYChart.Series();
		xyCForCancer.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop-0.05));
		xyCForCancer.getData().add(new XYChart.Data(dXCenter + 0.09,dYTop-0.05));
		//xyCForCancer.getData().add(new XYChart.Data(dXCenter + 0.09,dYTop-0.04));


		lc.getData().addAll(xyCForCancer);
		setColor(lc,iCountSeries,sColor);
		iCountSeries++;

		xyCForCancer.setName("\"C\" indicates specified cancer risk level");
		if (bAdd){ltw.addLegendItem(false, xyCForCancer.getName(), sColor,1);}

		return iCountSeries;
	}




	//add a "H" for NonCancer Risk
	private int addHForHazard(LineChart lc, int iCountSeries, String sColor, double dXCenter, double dYTop, boolean bAdd)
	{
		XYChart.Series xyHForHazard = new XYChart.Series();
		//xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter + 0.15,dYTop));
		//xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter + 0.15,dYTop-0.05));
		//xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter       ,dYTop-0.03));
		//xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter - 0.15,dYTop-0.05));
		//xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter - 0.15,dYTop));
		//change needed after switch to java 8
		//add three data series to make H (reliably)
		//first upright
		xyHForHazard.getData().add(new XYChart.Data(dXCenter + 0.09,dYTop-0.06));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter + 0.09,dYTop));
		//to center

		xyHForHazard.getData().add(new XYChart.Data(dXCenter + 0.08,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter + 0.07,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter + 0.06,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter + 0.05,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter + 0.04,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter + 0.03,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter + 0.02,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter + 0.01,dYTop-0.03));   	



		//middle point
		xyHForHazard.getData().add(new XYChart.Data(dXCenter       ,dYTop-0.03));
		//to 2nd up right
		xyHForHazard.getData().add(new XYChart.Data(dXCenter - 0.01,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter - 0.02,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter - 0.03,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter - 0.04,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter - 0.05,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter - 0.06,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter - 0.07,dYTop-0.03));
		xyHForHazard.getData().add(new XYChart.Data(dXCenter - 0.08,dYTop-0.03));   	


		//to the top
		xyHForHazard.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop));
		//to the bottom
		xyHForHazard.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop-0.06));
		xyHForHazard.setName("\"H\" indicates specified hazard quotient");


		//xyHForHazard.setName("\"M\" indicates maximum probability result");
		lc.getData().addAll(xyHForHazard);
		setColor(lc,iCountSeries,sColor);   	
		iCountSeries++;



		if (bAdd){ltw.addLegendItem(false, xyHForHazard.getName(), sColor,3);}

		return iCountSeries;
	}
	//add a "H" for NonCancer Risk
	private int addSForScreening(LineChart lc, int iCountSeries, String sColor, double dXCenter, double dYTop, boolean bAdd)
	{
		XYChart.Series xySForScreening = new XYChart.Series();

		//top
		xySForScreening.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop));
		xySForScreening.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop));

		//bottpm
		xySForScreening.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop-0.06));
		xySForScreening.getData().add(new XYChart.Data(dXCenter + 0.09,dYTop-0.06));

		xySForScreening.setName("\"L\" indicates screening level");

		lc.getData().addAll(xySForScreening);
		setColor(lc,iCountSeries,sColor);   	
		iCountSeries++;



		if (bAdd){ltw.addLegendItem(false, xySForScreening.getName(), sColor,3);}

		return iCountSeries;
	}   
	//add a "A" for the Averaged Parameter Solution
	private int addAForAveragedParameterSolution(LineChart lc, int iCountSeries, String sColor, double dXCenter, double dYTop, boolean bAdd)
	{
		XYChart.Series xyAForAveragedParameterSolution = new XYChart.Series();
		xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop));
		xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter       ,dYTop-0.06));
		xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter + 0.09,dYTop));



		//change needed after switch to java 8
		//add four data series to make A (reliably)
		//first upright

		/*

     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter       ,dYTop));
    	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter + 0.09,dYTop-0.06));

    	//2nd upright 
    	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter - 0.09,dYTop-0.06));
    	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter       ,dYTop));    	

    	//middle crossing


     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter + 0.05,dYTop-0.03));   	
     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter + 0.04,dYTop-0.03));    	
     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter + 0.03,dYTop-0.03)); 
     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter + 0.02,dYTop-0.03));   	
     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter + 0.01,dYTop-0.03));

     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter       ,dYTop-0.03));   	    	

      	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter - 0.01,dYTop-0.03));   	
     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter - 0.02,dYTop-0.03));    	
     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter - 0.03,dYTop-0.03));   	
     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter - 0.04,dYTop-0.03));   	
     	xyAForAveragedParameterSolution.getData().add(new XYChart.Data(dXCenter - 0.05,dYTop-0.03));    	
		 */




		lc.getData().addAll(xyAForAveragedParameterSolution);
		setColor(lc,iCountSeries,sColor);
		iCountSeries++; 
		xyAForAveragedParameterSolution.setName("\"V\" indicates averaged-parameter solution");
		//xyAForAveragedParameterSolution.setName("\"A\" indicates averaged-parameter solution");

		Text text = new Text(dXCenter, dYTop, "D");
		text.setFont(new Font(20));



		if (bAdd){ltw.addLegendItem(false, xyAForAveragedParameterSolution.getName(), sColor,5);}

		return iCountSeries;
	}    
	//add a "M" for Maximum Probability Result
	private int addMForMaximumProbabilityResult(LineChart lc, int iCountSeries, String sColor, double dXCenter, double dYTop, boolean bAdd)
	{
		XYChart.Series xyMForMaximumProbabilityResult = new XYChart.Series();
		//xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter + 0.15,dYTop-0.05));
		//xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter + 0.15,dYTop));
		//xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter       ,dYTop-0.03));
		//xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter - 0.15,dYTop));
		//xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter - 0.15,dYTop-0.05));
		//correction needed after switch to java 8
		xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter + 0.15,dYTop));
		xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter + 0.15,dYTop-0.05));
		xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter       ,dYTop-0.03));
		xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter - 0.15,dYTop-0.05));
		xyMForMaximumProbabilityResult.getData().add(new XYChart.Data(dXCenter - 0.15,dYTop));

		xyMForMaximumProbabilityResult.setName("\"M\" indicates maximum probability result");

		lc.getData().addAll(xyMForMaximumProbabilityResult);
		setColor(lc,iCountSeries,sColor);
		if (bAdd){ltw.addLegendItem(false, xyMForMaximumProbabilityResult.getName(), sColor,5);}
		iCountSeries++;
		return iCountSeries;
	}   



	//find the first word in the string of the histogram title
	//this is "supposed" to be the chemical name
	//if it isn't it won't match the name of a chemical in the model
	private String getHistogramChemical(String sTitleString)
	{
		Stripper s = new Stripper();
		String sChemical = "";
		int iEnd = 0;


		//cycle through each character in the title string
		for (int i=0;i<sTitleString.length();i++)
		{
			if (sTitleString.charAt(i)==' ')
			{
				if (i>1)
				{
					//discount the first character if it is blank
					iEnd = i;
					break;
				}
			}
		}

		//no ending blank character found
		//set the ending c
		if (iEnd == 0){iEnd = sTitleString.length();}

		//store up the characters from the beginning to the character discovered above
		for (int i=0;i<iEnd;i++)
		{
			sChemical = sChemical + sTitleString.charAt(i);
		}

		//eliminate any blanks -- should only be the first character
		sChemical = s.removeCharacter(' ', sChemical);

		return sChemical;	
	}


	//create a legend for a LineChart
	private Canvas getLegendCanvas()
	{
		int iItems;

		double dCanvasWidth = 0.50*stage.getWidth();
		double dCanvasHeight = 0.75*stage.getHeight();
		Canvas cReturn = new Canvas(dCanvasWidth,dCanvasHeight);
		//Canvas cReturn = new Canvas();
		GraphicsContext gc = cReturn.getGraphicsContext2D();
		gc.setLineWidth(5);

		double dY = 25;
		double dX = 20;
		double dXHalf = 5;
		double dYHalf = 5;
		double dYStart = 20;
		double dXBar = 300;
		double dXLoc;
		double dYLoc;
		double dNoneMoreOpaque = 1.0;
		dXLoc = 100;
		dYLoc = dYStart;


		iItems = ltw.getCount();
		for (int j=0;j<ltw.getLevelMax() + 1;j++)
		{	 

			//write out annotation
			String sOut1 = ltw.getTextAnnotation(j);
			if(!sOut1.equalsIgnoreCase(""))
			{	   
				gc.setStroke(new Color(0.0,0.0,0.0,dNoneMoreOpaque));
				gc.setLineWidth(1);
				gc.setFont(Font.font("SanSerif", FontWeight.BLACK, 14));
				gc.fillText(sOut1, dXLoc + dX + dXHalf, dYLoc + dYHalf );

				dYLoc = dYLoc + 2*dYHalf;
				gc.strokeLine(dXLoc, dYLoc, dXLoc + dXBar,dYLoc);

				dYLoc = dYLoc + dY;	 
			}
			for (int i=0;i<iItems;i++)
			{


				//write out by the specified "iLevel"
				if (ltw.getLevel(i)==j)
				{
					String sColor = ltw.getColor(i);

					dNoneMoreOpaque = 1.0;
					String sColorRed = sColor.substring(1,3);
					String sColorGreen = sColor.substring(3,5);
					String sColorBlue = sColor.substring(5,7);
					int iColorRed = Integer.parseInt(sColorRed, 16);
					int iColorGreen = Integer.parseInt(sColorGreen,16);
					int iColorBlue = Integer.parseInt(sColorBlue,16);

					Color color = new Color(iColorRed/255.0,iColorGreen/255.0,iColorBlue/255.0,dNoneMoreOpaque);

					if (ltw.getDrawLine(i))
					{		 
						gc.setStroke(color);
						gc.setLineWidth(5);
						gc.strokeLine(dXLoc, dYLoc, dXLoc+dX, dYLoc);
					}

					String sOut2 = ltw.getText(i);

					gc.setStroke(new Color(.25,.25,.25,dNoneMoreOpaque));
					gc.setLineWidth(1);
					//gc.setFont(Font.font("System Regular",FontWeight.NORMAL,10));
					gc.setFont(Font.font("SanSerif", 12));
					gc.fillText(sOut2, dXLoc + dX + dXHalf, dYLoc + dYHalf );

					dYLoc = dYLoc + dY;
				}  
			}
		}


		return cReturn;
	}

	//sFile = file (+ path name if included)
	//sTypeToCheck = "input", "statistics" or "results"
	//returns true if the sTypeToCheck matches 2nd entry on first line of file ("First entry is "Control")
	private boolean checkFileType(String sFile, String sTypeToCheck) throws IOException
	{
		boolean bMatch = false;
		String currentLine;
		String[] lineArray = {""};


		//check the input file
		//is it really a statistics file?
		//the first line of the statistics file is "control, statistics"

		//open the file
		FileReader fr = new FileReader(sFile);
		BufferedReader br = new BufferedReader(fr);


		//read the first line of the input file.
		currentLine = br.readLine();
		lineArray = currentLine.split(",",0);
		if (lineArray[0].equalsIgnoreCase("Control"))
		{
			//file is a possible match
			if (lineArray[1].equalsIgnoreCase(sTypeToCheck))
			{
				bMatch = true;
			}

		}


		return bMatch;
	}

	//reset the transitions between color codes based on input in the parameter choices file
	//users can change the transition cumulative frequency between red and yellow, and between yellow and green
	//if "Highest Probability" is input the transition point is the point of highest probability density
	//(the highest probability is not injected here, but directly after the highest probability has been determined
	private void modifyColorLimits(ParameterChoices pc, double[] dColorLow, double[] dColorHigh, boolean bUseHighestProbability, double dHighestProbability)
	{
		ArrayList<String> alTypes = pc.getValue("ColorCoding",1);
		ArrayList<String> alChoices = pc.getValue("ColorCoding",2);

		//first color choice red to yellow
		//could be a specific value or it could be the max probability
		int iSize = alTypes.size();
		String sString = "";
		for (int i=0;i<iSize;i++)
		{
			sString = alTypes.get(i);
			if (s.areTheyEqual("Red-Yellow", sString))
			{
				if (s.areTheyEqual("Highest Probability", alChoices.get(i)))
				{
					if (bUseHighestProbability)
					{	
						dColorLow[1] = dHighestProbability;
						dColorHigh[0] = dHighestProbability;
					}  
				}	
				else
				{
					try
					{
						double dNew = Double.parseDouble(alChoices.get(i));
						dColorLow[1] = dNew;
						dColorHigh[0] = dNew;
					}
					catch(Exception e){}
				}
			}

			else if (s.areTheyEqual("Yellow-Green", sString))
			{

				if (s.areTheyEqual("Highest Probability", alChoices.get(i)))
				{
					//no changes are needed	
					if (bUseHighestProbability)
					{	
						dColorLow[2] = dHighestProbability;
						dColorHigh[1] = dHighestProbability;
					}  						
				}
				else
				{
					try
					{
						double dNew = Double.parseDouble(alChoices.get(i));
						dColorLow[2] = dNew;
						dColorHigh[1] = dNew;
					}
					catch(Exception e){}	
				}
			}

		}
	}



	//sets
	public void setFileAndPathNameStatistics(String s){this.sFilePathAndNameStatistics = s;}
	public void setChemical(String s){this.sChosenChemical = s;}
	public void setHandlerRepository(Repository repository){this.repository = repository;}
	public void setTopLabel(Label lTopLabel){this.lTopLabel = lTopLabel;}


}
