package ui;

import java.util.ArrayList;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import pviScreen.Chemical;
import pviScreen.PVIScreenControlData;
import pviScreen.RawInputLine;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

public class InputControlHeading extends InputControl
{
   
	private String sTabName;
    private String sDataGroup;
    private String sVariableName;
    private String sVariableName2;
    private String sUnitType;
	private int iIndex;
    private String sQualifier;
    private double dValue;
    private String sValueString;
    private String sUnitSelected;
    //sStatus is along for the ride:  either variable or constant
    private String sDistributionType;
    private double dFrequency;
    private String sComment;
    //iHeight is height value to use in all controls
    private int iHeight;
    //sInputType is the type of input control (
    private String sInputType;
    private String sChangeToCome;
    private RawInputLine ril;
	private HBox hbox;
	private ArrayList<String> alUnitNames;
	private OutputDigits od;
	private HandlerChemicalAdder hca;
    private HandlerEditControl hec,hec2,hec3;
    private HandlerChemicalChoice hcc;
    private String[] sHeadingText;
    private int[] iHeadingLength;
    
    
	private HandlerEdit he;
	private Tab tab;
	private TabPane tp;
	private boolean bValueString;
	private Repository repository;
	private PVIScreenControlData pvisCD;
	private UnitConverter uc;
	private NameConstants nc;
	 
	
	public InputControlHeading()
	{
		nc = new NameConstants();
	}
	
	//code to prepare for making a blank control
	private void blankEmAll()
    {
    	sDataGroup = "";
		sVariableName = "";
		sVariableName2 = "";
		dValue = 0;
		iIndex = 0;
		iHeight = nc.int_HEIGHT;
		sInputType = "";  
		sUnitType = "";
		sChangeToCome = "keep";
    }
	private TextField tfValue, tfFrequency, tfComment;
	private ObservableList<String> options;	
	private ArrayList<Chemical> alChemicals;
	private ArrayList<String> alChemicalNames;
	private ObservableList<Node> olNodes;
	private final ComboBox comboBox = new ComboBox();
	


	public void makeInputControlForAll()
	{
		//has a control been placed previously with the same data group and parameter name 
		//(this choice prevents two combo boxes for a single data group/parameter name
		// which is needed because only one choice is needed for the number of controls for a single data group/parameter name)
		boolean bPriorControl;
		//is the text field value a string?
		boolean bValueString=false;
		//is the second parameter name visible?
		boolean bParameterNameVisible2=false;
		String sRawInputType;
		Stripper s = new Stripper();
		pvisCD = repository.getPVIScreenControlData();
		iHeight = nc.int_HEIGHT;
		 
		
		hbox = new HBox();
		hbox.getStyleClass().add("hbox");
		//create a collection to add controls to for future display	
		olNodes = FXCollections.observableArrayList();
		sRawInputType = nc.s_CONTROLHEADING;
		
		
		
	    sDataGroup = "Heading";
	    sVariableName = "Heading for " + sTabName + iIndex;
	    sVariableName2 = sVariableName + "2";
	     
		
		
		
		

		
		//first the invisible labels which are used to manage the input lines:
 		//invisible label giving the tab name
		Label lTabName = new Label(sTabName);
		lTabName.setVisible(false);
		lTabName.setPrefSize(0,0);
		
		//invisible label describing type of data
		Label lDataGroup = new Label(nc.s_CONTROLHEADING);
		lDataGroup.setVisible(false);
		lDataGroup.setPrefSize(0,0);
		
	    //invisible counter
	    Label lCount = new Label();
	    //force String type by concatenation to ""
	    lCount.setText("" + iIndex);
	    lCount.setVisible(false);
	    lCount.setPrefSize(0,iHeight);	
	    
	    //input line type
	    Label lInputType = new Label();
	    lInputType.setText(nc.s_CONTROLHEADING);
	    lInputType.setVisible(false);
	    lInputType.setPrefSize(0, iHeight);
	    
	    
	    //the input type is always first
	    //the count is always second	    
	    olNodes.add(lInputType); 
	    olNodes.add(lCount);

	    //input line type
	    for (int i=0;i<sHeadingText.length;i++)
	    {
	    	Label lHeadingText = new Label();
	    	lHeadingText.setText(sHeadingText[i]);
	    	lHeadingText.setVisible(true);
	    	lHeadingText.setPrefSize(iHeadingLength[i],iHeight);
	    	lHeadingText.setFont(Font.font("Verdana", FontWeight.BOLD, FontPosture.ITALIC, 12));
	    	olNodes.add(lHeadingText);
	    }
	    
	    //add remaining required controls  
	    olNodes.add(lTabName);
	    olNodes.add(lDataGroup);
	 
	    
	     
	    //(hidden labels come last, because, though even hidden and "0" length they take up some space :-(  )
	    hbox.getChildren().addAll(olNodes);
	    //addStackPane(hbox);
	    
	    //add this control to repository set of controls made
	    repository.addPriorControl(sDataGroup,sVariableName,sVariableName2);
	}

	
	/*
	 * Uses a stack pane to create a help icon and adds it to the right side of an HBox
	 * 
	 * @param hb HBox to add the stack to
	 */
    private void addStackPane(HBox hb) 
    {
        hb.getChildren().add(addStackPane("?"));
        //javafx.scene.layout.HBox.setHgrow(stack, Priority.ALWAYS);           
    }	
    
    public StackPane addStackPane(String sText)
    {
    	 StackPane stack = new StackPane();
         Rectangle helpIcon = new Rectangle(20.0, 20.0);
         helpIcon.setFill(new LinearGradient(0,0,0,1, true, CycleMethod.NO_CYCLE,
             new Stop[]{
             new Stop(0,Color.web("#4977A3")),
             new Stop(0.5, Color.web("#B0C6DA")),
             new Stop(1,Color.web("#9CB6CF")),}));
         helpIcon.setStroke(Color.web("#D0E6FA"));
         helpIcon.setArcHeight(1.5);
         helpIcon.setArcWidth(3.5);
         
         Text helpText = new Text(sText);
         helpText.setFont(Font.font("Verdana", FontWeight.BOLD, 16));
         helpText.setFill(Color.WHITE);
         helpText.setStroke(Color.web("#7080A0")); 
         
         stack.getChildren().addAll(helpIcon, helpText);
         stack.setAlignment(Pos.CENTER_RIGHT);
         // Add offset to right for question mark to compensate for RIGHT 
         // alignment of all nodes
         StackPane.setMargin(helpText, new Insets(0, 5, 0, 0));
         return stack;
    }
    
  
	
	//sets
    public void setTabName(String sTabName){this.sTabName = sTabName;}
	public void setName(String sName){this.sDataGroup = sName;}
	public void setLabel(String sVariableName){this.sVariableName = sVariableName;}
	public void setDistributionType(String s){this.sDistributionType = s;}
	public void setQualifier(String sQualifier){this.sQualifier = sQualifier;}
	public void setInputType(String sInputType){this.sInputType = sInputType;}
	public void setUseStringValue(boolean b){this.bValueString = b;}
	public void setValue(double dValue){this.dValue = dValue;}
	public void setValueString(String sValueString){this.sValueString = sValueString;}
	public void setUnitSelected(String sUnitSelected){this.sUnitSelected = sUnitSelected;}
	public void setUnitType(String sUnitType){this.sUnitType = sUnitType;}
	public void setFrequency(double dFrequency){this.dFrequency = dFrequency;}
	public void setComment(String sComment){this.sComment = sComment;}
	public void setUnitChoices(ArrayList<String> alUnitNames){this.alUnitNames = alUnitNames;}
	public void setHandlerRepository(Repository repository){this.repository = repository;}
	public void setIndex(int iIndex){this.iIndex = iIndex;}	
	public void setHeight(int iHeight){this.iHeight = iHeight;}
	public void setHandlerEdit(HandlerEdit he){this.he = he;}
	public void setTabPane(TabPane tp){this.tp = tp;}
	public void setTab(Tab tab){this.tab = tab;}
	public void setChangeToCome(String sChangeToCome){this.sChangeToCome = sChangeToCome;}
	public void setRawInputLine(RawInputLine ril){this.ril = ril;}
	public void setUnitConverter(UnitConverter uc){this.uc = uc;}
	public void setHandlerChemical(HandlerChemicalChoice hcc){this.hcc = hcc;}
	public void setHeadingText(String[] sHeadingText){this.sHeadingText = sHeadingText;}
	public void setHeadingLength(int[] iHeadingLength){this.iHeadingLength = iHeadingLength;}
	
	
	
	
	//simple gets
	public String getTabName(){return this.sTabName;}
	public String getName(){return this.sDataGroup;}
	public String getLabel(){return this.sVariableName;}
	public String getDistributionType(){return this.sDistributionType;}
	public String getQualifier(){return this.sQualifier;}
	public String getInputType(){return this.sInputType;}
	public HBox getInputControl(){return hbox;}
	public double getValue(){return this.dValue;}
	public String getUnitSelected(){return this.sUnitSelected;}
	public String getUnitType(){return this.sUnitType;}
	public double getFrequency(){return this.dFrequency;}
	public String getComment(){return this.sComment;}
	public int getIndex(){return this.iIndex;}
	public int getHeight(){return this.iHeight;}
    public HandlerEdit getHandlerEdit(){return this.he;}
    public Tab getTab(){return this.tab;}	
	
		
	
	
	
}
