package ui;

import java.util.ArrayList;


//import com.sun.javafx.sg.PGNode;

import pviScreen.RawInputLine;
import util.NameConstants;
import util.OutputDigits;
import util.Stripper;
import util.UnitConverter;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;


/**
 * serves as a control to input a line of input
 * @author Jim Weaver
 *
 */
public class InputControlValue extends InputControl
{
	private String sTabName;
	private String sDataGroup;
	private String sVariableName;
	private String sVariableName2;
	private String sUnitType;
	private int iIndex;
	private String sQualifier;
	private double dValue;
	private String sValueString;
	private String sUnitSelected;
	//sStatus is along for the ride:  either variable or constant
	private String sDistributionType;
	private double dFrequency;
	private String sComment;
	//iHeight is height value to use in all controls
	private int iHeight;
	//sInputType is the type of input control (
	private String sInputType;
	private String sChangeToCome;
	private RawInputLine ril;
	private HBox hbox;
	private ArrayList<String> alUnitNames;
	private OutputDigits od;
	private HandlerEditControl hec,hec2,hec3,hec4,hec5;
	private HandlerEditNumber hen;
	private HandlerEditComboBox hecb;
	private Repository repository;
	private HandlerEdit he;
	private Tab tab;
	private TabPane tp;
	private boolean bValueString;
	private UnitConverter uc;


	private NameConstants nc;



	public InputControlValue()
	{
		nc = new NameConstants();
		blankEmAll();

	}

	//code to prepare for making a blank control
	private void blankEmAll()
	{
		sDataGroup = "";
		sVariableName = "";
		sVariableName2 = "";
		sQualifier = "";
		sDistributionType = "";
		dValue = 0;
		dFrequency = 0;
		iIndex = 0;
		iHeight = nc.int_HEIGHT;
		sInputType = "";  
		sUnitType = "";
		sChangeToCome = "keep";
	}



	private TextField tfValue, tfFrequency, tfComment;
	private ObservableList<String> options;	
	private ObservableList<Node> olNodes;
	private final ComboBox comboBox = new ComboBox();



	public void makeInputControlForAll()
	{
		//has a control been placed previously with the same data group and parameter name 
		//(this choice prevents two combo boxes for a single data group/parameter name
		// which is needed because only one choice is needed for the number of controls for a single data group/parameter name)
		boolean bPriorControl;
		//is the text field value a string?
		boolean bValueString=false;
		//is the second parameter name visible?
		boolean bParameterNameVisible2=false;
		String sRawInputType;
		Stripper s = new Stripper();

		hbox = new HBox();
		hbox.getStyleClass().add("hbox");
		//create a collection to add controls to for future display	
		olNodes = FXCollections.observableArrayList();
		sRawInputType = ril.getRawInputType();


		sDistributionType = ril.getDistributionType();
		bValueString = false;
		bParameterNameVisible2 = false;
		sUnitType = "none";

		if (s.areTheyEqual(this.nc.s_CONTROL2STRING,sRawInputType))
		{
			//control input with two strings (2nd string is changeable, i.e., set in a text box)
			bValueString = true;
			//no units for this one
			sUnitType = "none";
		}
		else if (s.areTheyEqual(nc.s_CONTROLSTRINGVALUE,sRawInputType))
		{
			//control input with a string and a value (value is a number and changeable, i.e., 
			//         set in a text box with a number error handler of type HandlerEditNumber)
			sUnitType = "none";
		}	    
		else if (s.areTheyEqual(nc.s_CONTROL2STRINGVALUE,sRawInputType))
		{
			//control input with a string and a value (value is a number and changeable, i.e., 
			//         set in a text box with a number error handler of type HandlerEditNumber)
			bParameterNameVisible2 = true;
			sUnitType = "none";
		}
		else if (s.areTheyEqual(nc.s_CONTROL3STRING, sRawInputType))
		{
			//control with three strings, the last is changeable, but not a number
			bValueString = true;
			bParameterNameVisible2 = true;
			sUnitType = "none";
		}
		else if (s.areTheyEqual(nc.s_VALUEINPUT,sRawInputType))
		{	
			//value input including distribution, qualifier, description, value, unit
			bValueString = false;
			sUnitType = ril.getUnitType(ril.getParameterName(),uc);
			dFrequency = ril.getFrequency();
			sUnitSelected = ril.getUnit(); 
			alUnitNames = uc.getAllUnitNamesForAType(sUnitType);
		}
		else if (s.areTheyEqual(nc.s_CHEMICALINPUT,sRawInputType))
		{
			//chemical input string
			bValueString = false;
			bParameterNameVisible2 = true;
			sUnitType = ril.getUnitType(ril.getParameterName2(),uc);
			dFrequency = ril.getFrequency();
			sUnitSelected = ril.getUnit();
			alUnitNames = uc.getAllUnitNamesForAType(sUnitType);
		}
		else if (s.areTheyEqual(nc.s_CONTROLSTRINGCHOICE, sRawInputType))
		{
			//input of a dropdown box choice only
			sUnitType = "other";
		}
		else if (s.areTheyEqual(nc.s_CONTROLSCREENINGLEVELINPUT,sRawInputType))
		{
			sUnitType = ril.getUnitType(ril.getGroupName(),uc);
			sUnitSelected = ril.getUnit();
			alUnitNames = uc.getAllUnitNamesForAType(sUnitType);
			dFrequency = ril.getFrequency();
		}



		//first the invisible labels which are used to manage the input lines:

		//frequency
		Label lFrequency = new Label();
		lFrequency.setVisible(false);
		lFrequency.setPrefSize(0,iHeight);
		//(""+dFrequency) forces type cast to String
		lFrequency.setText((String)""+dFrequency);

		//invisible label giving the tab name
		Label lTabName = new Label(sTabName);
		lTabName.setVisible(false);
		lTabName.setPrefSize(0,0);

		//invisible label describing type of data
		Label lDataGroup = new Label(sDataGroup);
		lDataGroup.setVisible(false);
		lDataGroup.setPrefSize(0,0);

		//invisible counter
		Label lCount = new Label();
		//force String type by concatenation to ""
		lCount.setText("" + iIndex);
		lCount.setVisible(false);
		lCount.setPrefSize(0,iHeight);	

		//input line type
		Label lInputType = new Label();
		lInputType.setText(sRawInputType);
		lInputType.setVisible(false);
		lInputType.setPrefSize(0, iHeight);

		//invisible label of the previous statistical distribution
		Label lPreviousDistribution = new Label();
		lPreviousDistribution.setVisible(false);
		//lPreviousDistribution.setPrefSize(100,iHeight);
		lPreviousDistribution.setPrefSize(0,iHeight);
		//value set below to match current distribution

		//invisible label of the change to come (either keep or delete)
		Label lChangeToCome = new Label();
		lChangeToCome.setVisible(false);
		lChangeToCome.setPrefSize(0,iHeight);
		lChangeToCome.setText(sChangeToCome);

		//hidden label for unit type
		Label lUnitType = new Label();
		lUnitType.setVisible(false);
		lUnitType.setPrefSize(0,iHeight);
		lUnitType.setText(sUnitType);	    


		//the input type is always first
		//the count is always second
		olNodes.add(lInputType);  
		olNodes.add(lCount);

		if (!this.sDistributionType.equalsIgnoreCase("none"))
		{	
			sDataGroup = ril.getGroupName();
			sVariableName = ril.getParameterName();
			sVariableName2 = ril.getParameterName2();
			//ComboBox for type of input distribution (single value, minimum, maximum, median, etc.)
			ObservableList<String> opt = FXCollections.observableArrayList(nc.dist_CONSTANT,nc.dist_UNIFORM);	
			final ComboBox<String> cbDistribution = new ComboBox<String>(opt);	 	
			cbDistribution.setId("DistributionComboBox");
			cbDistribution.setPrefSize(100,iHeight);
			if (s.areTheyEqual(nc.s_CHEMICALINPUT,sRawInputType)){ bPriorControl = repository.checkForPreviousControl(sDataGroup,sVariableName2,sVariableName);}
			else {bPriorControl = repository.checkForPreviousControl(sDataGroup, sVariableName,sVariableName2);}
			if (bPriorControl)
			{
				//do not display the combobox if there is a previous control with same datagroup and variable name
				System.out.println("Setting combo box distribution type invisible");
				cbDistribution.setVisible(false);
			}
			else {cbDistribution.setVisible(true);}
			hecb = new HandlerEditComboBox();
			hecb.setNames(sTabName,sDataGroup);
			hecb.setHandlerRepository(repository);
			hecb.setComboBox(cbDistribution);
			hecb.setTabPane(tp);
			hecb.setTab(tab);


			cbDistribution.setPrefWidth(105);
			if (sDistributionType.equalsIgnoreCase(nc.dist_DISTRIBUTION))
			{
				sQualifier = "file";
				cbDistribution.setValue(nc.dist_DISTRIBUTION);
				lPreviousDistribution.setText(nc.dist_DISTRIBUTION);
			}
			else if (sDistributionType.equalsIgnoreCase(nc.dist_CONSTANT))
			{
				sQualifier = nc.qual_OneValue;
				cbDistribution.setValue(nc.dist_CONSTANT);
				lPreviousDistribution.setText(nc.dist_CONSTANT);
			}
			else if (sDistributionType.equalsIgnoreCase(nc.dist_VARIABLE) || sDistributionType.equalsIgnoreCase(nc.dist_UNIFORM))
			{
				if (dFrequency == 0.0){sQualifier = nc.qual_min;}
				else {sQualifier = nc.qual_max;}
				cbDistribution.setValue(nc.dist_UNIFORM);
				lPreviousDistribution.setText(nc.dist_UNIFORM);
			}

			cbDistribution.addEventHandler(ActionEvent.ACTION, hecb);
			olNodes.add(cbDistribution);

			Label lQualifier = new Label(sQualifier);
			lQualifier.setPrefSize(100,iHeight);
			lQualifier.setVisible(true);

			olNodes.add(lQualifier);

		}



		//label describing value
		sVariableName = ril.getParameterName();
		Label lDescription = new Label(sVariableName);
		lDescription.setPrefSize(250,iHeight);
		lDescription.setVisible(true);
		olNodes.add(lDescription);


		//second description label
		//(the second label is used always, but only visible for special parameters)
		Label lDescription2 = new Label(ril.getParameterName2());
		lDescription2.setPrefSize(0,iHeight);
		lDescription2.setVisible(false);
		if (bParameterNameVisible2)
		{	
			lDescription2.setPrefSize(200,iHeight);
			lDescription2.setVisible(bParameterNameVisible2);
		}
		olNodes.add(lDescription2);


		//the input value
		TextField tfValue = new TextField("");
		tfValue.setPrefSize(100,iHeight);
		tfValue.setVisible(true);

		if (bValueString)
		{
			tfValue.setText(ril.getValueString());
			hec = new HandlerEditControl();
			tfValue.addEventHandler(ActionEvent.ACTION, hec);
		}
		else
		{	
			od = new OutputDigits();
			dValue = ril.getValue();
			if (dValue >= 0.0){tfValue.setText(od.num2String(dValue));}
			else {tfValue.setText("");}
			//add handler to force the input to be a number
			//event handler added after initial setting of value, so as not to immediately trigger event. 
			hen = new HandlerEditNumber();
			hen.setHandlerRepository(repository);
			hen.setTextField(tfValue);
			tfValue.setOnAction(hen);	
			tfValue.setOnMouseExited(hen);
			tfValue.addEventHandler(ActionEvent.ACTION,hen);
		}
		olNodes.add(tfValue);


		if (!this.sUnitType.equalsIgnoreCase("none"))
		{
			int iUnitIndex = 0;
			System.out.println("sUnitType "+ this.sUnitType + " name " + this.getName() + " selected unit " + this.sUnitSelected);
			for (String sUnit: alUnitNames)
			{
				if (s.areTheyEqual(this.sUnitSelected,sUnit))
				{
					iUnitIndex = alUnitNames.indexOf(sUnit);
				}
			}
			//input value unit choices
			options = FXCollections.observableArrayList(alUnitNames);
			final ComboBox<String> cbUnit = new ComboBox<String>(options);
			cbUnit.setValue(alUnitNames.get(iUnitIndex));
			cbUnit.setPrefSize(100, iHeight);
			cbUnit.setVisible(true);
			//event handler added after initial setting of value, so as not to immediately trigger event. 
			hec2 = new HandlerEditControl();
			hec2.setHandlerRepository(repository);
			cbUnit.addEventHandler(ActionEvent.ACTION, hec2);	 
			olNodes.add(cbUnit);
		}
		else if (s.areTheyEqual(sUnitType, "other"))
		{
			//use the unit choice box for some "other" purpose
			if (s.areTheyEqual("DirtFloor", sVariableName)){}
			else if (s.areTheyEqual("OilDistribution",sVariableName)){}
		}


		//comment associated with input value
		tfComment = new TextField();
		tfComment.setPrefSize(300,iHeight);
		tfComment.setVisible(true);
		tfComment.setText(sComment);
		//add event handler after setting initial value
		hec5 = new HandlerEditControl();
		hec5.setHandlerRepository(repository);
		tfComment.addEventHandler(ActionEvent.ACTION, hec5);

		//add remaining required controls
		//olNodes.add(tfComment);
		olNodes.add(lFrequency);
		olNodes.add(lTabName);
		olNodes.add(lDataGroup);
		olNodes.add(lPreviousDistribution);
		olNodes.add(lChangeToCome);
		olNodes.add(lUnitType);
		
		//indicator for output destination for new file
		Label lOutputDestination = new Label();
		lOutputDestination.setText(ril.getOutputDestination());
		lOutputDestination.setVisible(false);
		olNodes.add(lOutputDestination);

		//(hidden labels come last, because, though even hidden and "0" length they take up some space :-(  )
		hbox.getChildren().addAll(olNodes);
		//addStackPane(hbox);

		//add this control to repository set of controls made
		repository.addPriorControl(sDataGroup, sVariableName,sVariableName2);

	}


	/*
	 * Uses a stack pane to create a help icon and adds it to the right side of an HBox
	 * 
	 * @param hb HBox to add the stack to
	 */
	private void addStackPane(HBox hb) 
	{
		hb.getChildren().add(addStackPane("?"));
		//javafx.scene.layout.HBox.setHgrow(stack, Priority.ALWAYS);           
	}	

	public StackPane addStackPane(String sText)
	{
		StackPane stack = new StackPane();
		Rectangle helpIcon = new Rectangle(20.0, 20.0);
		helpIcon.setFill(new LinearGradient(0,0,0,1, true, CycleMethod.NO_CYCLE,
				new Stop[]{
						new Stop(0,Color.web("#4977A3")),
						new Stop(0.5, Color.web("#B0C6DA")),
						new Stop(1,Color.web("#9CB6CF")),}));
		helpIcon.setStroke(Color.web("#D0E6FA"));
		helpIcon.setArcHeight(1.5);
		helpIcon.setArcWidth(3.5);

		Text helpText = new Text(sText);
		helpText.setFont(Font.font("Verdana", FontWeight.BOLD, 16));
		helpText.setFill(Color.WHITE);
		helpText.setStroke(Color.web("#7080A0")); 

		stack.getChildren().addAll(helpIcon, helpText);
		stack.setAlignment(Pos.CENTER_RIGHT);
		// Add offset to right for question mark to compensate for RIGHT 
		// alignment of all nodes
		StackPane.setMargin(helpText, new Insets(0, 5, 0, 0));
		return stack;
	}



	//sets
	public void setTabName(String sTabName){this.sTabName = sTabName;}
	public void setName(String sName){this.sDataGroup = sName;}
	public void setLabel(String sVariableName){this.sVariableName = sVariableName;}
	public void setDistributionType(String s){this.sDistributionType = s;}
	public void setQualifier(String sQualifier){this.sQualifier = sQualifier;}
	public void setInputType(String sInputType){this.sInputType = sInputType;}
	public void setUseStringValue(boolean b){this.bValueString = b;}
	public void setValue(double dValue){this.dValue = dValue;}
	public void setValueString(String sValueString){this.sValueString = sValueString;}
	public void setUnitSelected(String sUnitSelected){this.sUnitSelected = sUnitSelected;}
	public void setUnitType(String sUnitType){this.sUnitType = sUnitType;}
	public void setFrequency(double dFrequency){this.dFrequency = dFrequency;}
	public void setComment(String sComment){this.sComment = sComment;}
	public void setUnitChoices(ArrayList<String> alUnitNames){this.alUnitNames = alUnitNames;}
	public void setHandlerRepository(Repository repository){this.repository = repository;}
	public void setIndex(int iIndex){this.iIndex = iIndex;}	
	public void setHeight(int iHeight){this.iHeight = iHeight;}
	public void setHandlerEdit(HandlerEdit he){this.he = he;}
	public void setTabPane(TabPane tp){this.tp = tp;}
	public void setTab(Tab tab){this.tab = tab;}
	public void setChangeToCome(String sChangeToCome){this.sChangeToCome = sChangeToCome;}
	public void setRawInputLine(RawInputLine ril){this.ril = ril;}
	public void setUnitConverter(UnitConverter uc){this.uc = uc;}

	//gets
	public RawInputLine getRawInputLine()
	{
		String sValue="";
		String sFrequency="";
		RawInputLine ril = new RawInputLine();
		//fill in the contents of the raw input line

		dValue = Double.parseDouble(tfValue.getText());
		sValue = tfValue.getText();
		dFrequency = Double.parseDouble(tfFrequency.getText());
		sFrequency = tfFrequency.getText();
		sComment = tfComment.getText();
		String sUnitOutput = (String) comboBox.getValue();
		String[] sRawInput = {sDataGroup,sVariableName,sDistributionType,sValue,sUnitOutput,sFrequency,sComment};
		ril.setRawInputLine(nc.s_VALUEINPUT, sRawInput);

		return ril;

	}

	//simple gets
	public String getTabName(){return this.sTabName;}
	public String getName(){return this.sDataGroup;}
	public String getLabel(){return this.sVariableName;}
	public String getDistributionType(){return this.sDistributionType;}
	public String getQualifier(){return this.sQualifier;}
	public String getInputType(){return this.sInputType;}
	public HBox getInputControl(){return hbox;}
	public double getValue(){return this.dValue;}
	public String getUnitSelected(){return this.sUnitSelected;}
	public String getUnitType(){return this.sUnitType;}
	public double getFrequency(){return this.dFrequency;}
	public String getComment(){return this.sComment;}
	public int getIndex(){return this.iIndex;}
	public int getHeight(){return this.iHeight;}
	public HandlerEdit getHandlerEdit(){return this.he;}
	public Tab getTab(){return this.tab;}






}
