package ui;

//container for legend information
//and the drawing for the legend
public class LegendThatWorks 
{
   //legend name	
   private String sName;
   //item color
   private String[] sColor;
   //item text
   private String[] sText;
   //item draw line in legend?
   private boolean[] bLine;
   //item drawing order level
   private int[] iLevel;
   //limits of the iLevels
   private int iLevelMin =1000000;
   private int iLevelMax =0;
   //legend text annotations
   //these appear in legend before (if desired) each level of legend items are written
   private String[] sTextAnnotation;
   private int[] iTextAnnotationLevel;
   private int nDim;
   private int nPts;
	
   public LegendThatWorks()
   {
	 nDim = 100;
	 sColor = new String[nDim];
	 sText = new String[nDim];
	 bLine = new boolean[nDim];
	 iLevel = new int[nDim];
	 sTextAnnotation = new String[nDim];
	 for (int i=0;i<nDim;i++){sTextAnnotation[i]="";}
	 nPts = 0;
   }
   
   
   
   //adds
   public void addLegendItem(boolean bLine, String sText, String sColor, int iLevel)
   { 
	  //only add if adequate space exists 
	  if (nPts<nDim-1 && (0<= iLevel && iLevel <= nDim))
	  {	  
	    this.bLine[nPts] = bLine;
	    this.sText[nPts] = sText;
	    this.sColor[nPts] = sColor;
	    this.iLevel[nPts] = iLevel;
	    if (iLevelMin>iLevel){iLevelMin = iLevel;}
	    if (iLevelMax<iLevel){iLevelMax = iLevel;}
	    nPts++;
	  }  
   }
   
   //addText Annotation
   public void addTextAnnotation(String sText, int iLevel)
   {
	   if (0<= iLevel && iLevel <= nDim)
	   {	   
	     this.sTextAnnotation[iLevel] = sText;
	   }  
   }
   
   //sets
   public void setName(String sName){this.sName = sName;}
   
   //gets
   public String getName(){return this.sName;}
   public int getCount(){return this.nPts;}
   public String getColor(int iIndex){return this.sColor[iIndex];}
   public String getText(int iIndex){return this.sText[iIndex];}
   public boolean getDrawLine(int iIndex){return this.bLine[iIndex];}
   public int getLevel(int iIndex){return this.iLevel[iIndex];}
   public int getLevelMin(){return this.iLevelMin;}
   public int getLevelMax(){return this.iLevelMax;}
   public String getTextAnnotation(int iIndex){return this.sTextAnnotation[iIndex];}
}
