package ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import pviScreen.Chemical;
import pviScreen.PVIScreenControlData;
import pviScreen.ParameterChoices;
import util.NameConstants;
import util.Stripper;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.stage.Stage;
import javafx.stage.FileChooser;

public class PVIFileChooser 
{
	private String sCurrentDirectory;
	private String sInputFile;
	private String sInputFileAndPath;
	private String sInitialDirectory;
	private String sActiveDirectory;
    private Stage stage;
    private FileChooser fc;
    private ComboBox cbChemical;
    private PVIScreenUIInputData pvisUIInputData;
    private PVIScreenControlData pvisControlData;
    private Repository repository;
    private ObservableList<Button> olButton;
    private NameConstants nc;
    private Stripper s;
    private ParameterChoices pc;
 
	
    public PVIFileChooser(){}
	public PVIFileChooser(Stage stage)
	{
	  this.stage = stage;
	  nc = new NameConstants();
	  s = new Stripper();
	}

	public void openFile() throws IOException
	{
		fc = new FileChooser();
		
		sInitialDirectory = "projects";
		
		//look for file directory read from 05ParameterChoices.csv
		try
		{
			ArrayList<String> alInitialDirectory = pc.getValue("Project Directory", 1);
			sInitialDirectory = alInitialDirectory.get(0);
		}
		catch(Exception e){}
		 
		
		fc.setTitle("PVIScreen File Input");
		try
		{
			this.sCurrentDirectory = new java.io.File(".").getCanonicalPath();
			this.sActiveDirectory = repository.getDirectory();
			if (this.sActiveDirectory!="")
			{
				this.sCurrentDirectory=sActiveDirectory;
			}
			else
			{	
				
			  //this.sCurrentDirectory = this.sCurrentDirectory + "//" + sInitialDirectory;
			  this.sCurrentDirectory = this.sCurrentDirectory + "\\" + sInitialDirectory;
			}
			System.out.println("Found Path " + this.sCurrentDirectory);
			fc.setInitialDirectory(new File(this.sCurrentDirectory));
			
		}
		catch(Exception e){}
		
		
		//filters to select special files
		if (repository.getInputType().equalsIgnoreCase(nc.s_Radio_ExistingInput))
		{	
			fc.getExtensionFilters().add(new FileChooser.ExtensionFilter("PVIScreen ","*." + nc.s_Extension_Input));
		}
		else if (repository.getInputType().equalsIgnoreCase(nc.s_Radio_Results))
		{
			fc.getExtensionFilters().add(new FileChooser.ExtensionFilter("Results   ","*." + nc.s_Extension_Results));	
		}		
		
		//add file chooser to the repository
		repository.setFileChooser(fc);
		
		
		//show dialog:
		File fInputFile = fc.showOpenDialog(stage);
		//get choices--file name and path
		
		if (fInputFile!=null)
		{	
			sInputFile = fInputFile.getName();
			sInputFileAndPath = fInputFile.getPath();
			String sDirectory = fInputFile.getParent();
			repository.setDirectory(sDirectory);
			 
			if (repository.getInputType().equalsIgnoreCase(nc.s_Radio_ExistingInput))
			{	
			  pvisUIInputData = new PVIScreenUIInputData();
			  pvisUIInputData.setFileAndPathName(this.sInputFileAndPath);
			  pvisUIInputData.setResultsFileAndPathName(this.sInputFileAndPath,nc.s_Extension_Results,nc.i_Extension_Results_Dots);
			  pvisUIInputData.readInputData();
			  repository.setPVIScreenUIInputData(pvisUIInputData);
              pvisControlData = pvisUIInputData.getPVIScreenControlData();
			  repository.setPVIScreenControlData(pvisControlData);
			}
			else if (repository.getInputType().equalsIgnoreCase(nc.s_Radio_Results))
			{
		      HandlerEdit he = repository.getHandlerEdit();
		      he.removeTabs();
			  pvisUIInputData = new PVIScreenUIInputData();
			  //extract input file name from results file:
			  pvisUIInputData.extractInputFileNameFromOutputFile(sInputFile,sInputFileAndPath);
			  pvisUIInputData.readInputData();
			  repository.setPVIScreenUIInputData(pvisUIInputData);
	          pvisControlData = pvisUIInputData.getPVIScreenControlData();
	          repository.setFilePathAndNameResults(sInputFileAndPath);
			  repository.setPVIScreenControlData(pvisControlData);				
			}		
		 }
		else
		{
			  //allow for editing and running the model
			  olButton = repository.getButtonList();
			  for (Button button: olButton)
			  {
				String sButton = button.getText();
				//disable running buttons
				if (s.equals(nc.s_ButtonEdit,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonRun,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				//disable results buttons
				else if (s.equals(nc.s_ButtonSchematic,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonResults,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
				else if (s.equals(nc.s_ButtonReport,sButton)){button.setDisable(true);button.setStyle(nc.s_StyleDisable);}
			  }			
		}
	
	}
	
	
	
	
	//sets
	public void setRepository(Repository repository){this.repository = repository;}
	public void setChemicalComboBox(ComboBox cbChemical){this.cbChemical = cbChemical;}
	
	//gets
	public String getInputFile(){return sInputFile;}
	public String getInputFileAndPath(){return sInputFileAndPath;}
	public PVIScreenControlData getPVIScreenControlData(){return pvisControlData;}
 
}
