/*

 */

package ui;




import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

import pviScreen.PVIScreen;
import statistics.RiskContainer;
import util.CalendarClock;
import util.NameConstants;
import util.UnitConverter;

import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;

/**

 */
public class PVIScreenUI extends Application 
{
	PVIScreen pvis;  
	UnitConverter uc;

	/**
	 * @param args the command line arguments
	 */
	public static void main(String[] args) 
	{
		launch(PVIScreenUI.class, args);
	}

	BorderPane border;
	ScrollPane sp;
	Label lTopLabel;
	HandlerMainLabel hml;
	@SuppressWarnings("deprecation")
	public void start(Stage stage) throws IOException
	{

		//create the model itself
		pvis = new PVIScreen();
		//unit converter
		uc = new UnitConverter();
		try {uc.readUnits("src/systemData/01PVIScreenUnitConversion.csv");}
		catch (IOException e) {e.printStackTrace();}


		//start the interface
		// Use a border pane as the root for scene
		border = new BorderPane();       

		// Create HBox for use here and with stack pane
		HBox hbox2 = new HBox();
		hbox2.getStyleClass().add("hbox");       
		lTopLabel = new Label();
		lTopLabel.setFont(new Font("Arial",15));
		lTopLabel.setText("Welcome to PVIScreen:  Select an input file to begin");
		//lTopLabel TopLabel omitted from ui (JWW 1-19-2016)
		hbox2.getChildren().add(lTopLabel);  //added back jww 4-12-2016



		HBox hbox = addHBox(stage);
		hbox.prefWidthProperty().bind(stage.widthProperty());

		GridPane gpTop = new GridPane();
		gpTop.add(hbox, 0, 0);
		gpTop.add(hbox2, 0, 1);

		border.setTop(gpTop);


		//image on the center of the layout
		sp = new ScrollPane();

		
        try
        {
          Image imagePVIS = new Image(getClass().getResourceAsStream("src/systemData/PVIScreenSchematic.png"));
          sp.setContent(new ImageView(imagePVIS));
        }
        catch(Exception e){}
		 

		//sp.prefWidthProperty().bind(stage.widthProperty());
		//sp.setPrefHeight(600);

		sp.setPrefSize(nc.pref_WIDTH,nc.pref_HEIGHT);
		border.setCenter(sp);

		Scene scene = new Scene(border);
		// Add a style sheet to the scene        
		scene.getStylesheets().add("ui/layoutstyles.css");
		stage.setScene(scene);
		stage.setTitle("EPA PVIScreen");
		stage.centerOnScreen();
		Date date = new Date();
		CalendarClock cc = new CalendarClock();
		int iYear = cc.getYear();
		int iMonth = cc.getMonth();
		int iDay = cc.getDay();


		//refresh input template files
		//these files are needed in case an input file gets corrupted
		//regenerate each time the model is executed
		String sTemplateDirectory = new java.io.File(".").getCanonicalPath() + "\\projects\\templates";
		WriteTemplateFile wtf = new WriteTemplateFile();
		wtf.writeGroundWaterExample(sTemplateDirectory);
		wtf.writeGroundWaterExampleResidential(sTemplateDirectory);
		wtf.writeSoilGasExample(sTemplateDirectory);
        wtf.writeSoilGasExampleResidential(sTemplateDirectory);

		
		{
			stage.show();
		}
	}

	/*
	 * Creates an HBox with two buttons for the top region
	 */
	String sInputFile;
	Button bEditInputFile;
	Button bSelectInputFile;
	Button bRunPVIScreenModel;
	Button bSaveInputFile;
	Button bDisplayStatisticalResults;
	Button bDisplaySchematic;
	Button bWriteReport;
	Button bAbout;
	Button bExit;

	ObservableList<Button> olButton;

	Repository repository;
	HandlerRun hr;
	//HandlerRunTest hr;
	HandlerChemicalChoice hcc;
	HandlerStatisticsPlot hsp;
	HandlerInputChoice hic;
	HandlerEdit he;
	HandlerPrepareForRun hsi;
	HandlerSitePlot hSitePlot;
	HandlerReport hReport;
	HandlerAbout hAbout;
	private NameConstants nc;
	private HBox addHBox(final Stage stage) 
	{
		repository = new Repository();
		repository.setBorder(border);
		//make constants available to method
		nc = new NameConstants();
		olButton =  FXCollections.observableArrayList();

		RiskContainer rc = new RiskContainer();
		repository.setRiskContainer(rc);

		HBox hbox = new HBox(); 
		hbox.getStyleClass().add("hbox");

		final ToggleGroup group = new ToggleGroup();
		RadioButton rb0 = new RadioButton(nc.s_Radio_ExistingInput);
		rb0.setSelected(true);
		rb0.setToggleGroup(group);
		RadioButton rb1 = new RadioButton(nc.s_Radio_Results);
		rb1.setSelected(false);
		rb1.setToggleGroup(group);




		//set a default input type in the repository
		repository.setInputType(rb0.getText());
		repository.setInputTypeFlagSet(true);

		hic = new HandlerInputChoice(stage);
		hic.setInputGroup(group);
		hic.setHandlerRepository(repository);
		rb0.addEventHandler(ActionEvent.ACTION, hic);
		rb1.addEventHandler(ActionEvent.ACTION, hic);

		//rb4.addEventHandler(ActionEvent.ACTION, hic);
		VBox vb = new VBox();
		vb.getChildren().addAll(rb0);
		vb.getChildren().addAll(rb1);

		bSelectInputFile = new Button(nc.s_ButtonInput);
		bSelectInputFile.setStyle(nc.s_StyleEnable);
		bSelectInputFile.setDisable(false);
		HandlerInput hi = new HandlerInput(stage);
		hi.setTopLabel(lTopLabel);
		hi.setHandlerRepository(repository);
		bSelectInputFile.addEventHandler(ActionEvent.ACTION, hi); 
		hi.setHandlerRepository(repository);
		olButton.add(bSelectInputFile);

		bEditInputFile = new Button(nc.s_ButtonEdit);
		he = new HandlerEdit(stage);
		he.setButton(bEditInputFile);
		bEditInputFile.addEventHandler(ActionEvent.ACTION, he);
		he.setHandlerRepository(repository);
		he.setTopLabel(this.lTopLabel);
		repository.setHandlerEdit(he);
		bEditInputFile.setDisable(true);
		bEditInputFile.setStyle(nc.s_StyleDisable);
		olButton.add(bEditInputFile);

		bSaveInputFile = new Button(nc.s_ButtonSave);
		hsi = new HandlerPrepareForRun(stage);
		hsi.setButton(bSaveInputFile);
		hsi.setTopLabel(this.lTopLabel);
		bSaveInputFile.addEventHandler(ActionEvent.ACTION, hsi);
		hsi.setHandlerRepository(repository);
		hsi.setHandlerEdit(he);
		bSaveInputFile.setDisable(true);
		bSaveInputFile.setStyle(nc.s_StyleDisable);
		olButton.add(bSaveInputFile);

		bDisplaySchematic = new Button(nc.s_ButtonSchematic);
		hSitePlot = new HandlerSitePlot(stage);
		hSitePlot.setHandlerRepository(repository);
		hSitePlot.setTopLabel(this.lTopLabel);
		bDisplaySchematic.addEventHandler(ActionEvent.ACTION,hSitePlot);
		bDisplaySchematic.setDisable(true);
		bDisplaySchematic.setStyle(nc.s_StyleDisable);
		olButton.add(bDisplaySchematic);     

		bRunPVIScreenModel = new Button(nc.s_ButtonRun);
		hr = new HandlerRun(stage);
		//hr = new HandlerRunTest(stage);
		hr.setPVIScreenModel(pvis);
		hr.setTopLabel(this.lTopLabel);
		bRunPVIScreenModel.addEventHandler(ActionEvent.ACTION,hr);
		hr.setHandlerRepository(repository);
		//hr.setHandlerEdit(he);
		bRunPVIScreenModel.setDisable(true);
		bRunPVIScreenModel.setStyle(nc.s_StyleDisable);
		olButton.add(bRunPVIScreenModel);



		bDisplayStatisticalResults = new Button(nc.s_ButtonResults);
		hsp = new HandlerStatisticsPlot(stage);
		bDisplayStatisticalResults.addEventHandler(ActionEvent.ACTION, hsp);
		hsp.setHandlerRepository(repository);        
		hsp.setTopLabel(this.lTopLabel);
		repository.setHandlerStatisticsPlot(hsp);
		bDisplayStatisticalResults.setDisable(true); 
		bDisplayStatisticalResults.setStyle(nc.s_StyleDisable);
		olButton.add(bDisplayStatisticalResults);

		bWriteReport = new Button(nc.s_ButtonReport);
		hReport = new HandlerReport(stage);
		hReport.setHandlerRepository(repository);
		hReport.setHandlerSitePlot(hSitePlot);
		hReport.setTopLabel(lTopLabel);
		bWriteReport.addEventHandler(ActionEvent.ACTION,hReport);
		bWriteReport.setDisable(true);
		bWriteReport.setStyle(nc.s_StyleDisable);
		olButton.add(bWriteReport);

		bAbout = new Button(nc.s_ButtonAbout);
		bAbout.setDisable(false);
		bAbout.setStyle(nc.s_StyleEnable);
		hAbout = new HandlerAbout(stage);
		bAbout.addEventHandler(ActionEvent.ACTION,hAbout);
		hAbout.setHandlerRepository(repository);   
		olButton.add(bAbout);

		bExit = new Button(nc.s_ButtonExit);
		bExit.setDisable(false);
		bExit.setStyle(nc.s_StyleEnable);
		//event handler for exiting the ui
		HandlerExit he = new HandlerExit(stage);
		bExit.addEventHandler(ActionEvent.ACTION, he);
		olButton.add(bExit);



		repository.setButtonList(olButton);




		hbox.getChildren().addAll(vb, 
				bSelectInputFile, 
				bEditInputFile,
				bDisplaySchematic,  
				bSaveInputFile,
				bRunPVIScreenModel, 
				bDisplayStatisticalResults, 
				bWriteReport,
				bAbout,
				bExit);

		addStackPane(hbox);

		return hbox;
	}


	/*
	 * Uses a stack pane to create a help icon and adds it to the right side of an HBox
	 * 
	 * @param hb HBox to add the stack to
	 */
	private void addStackPane(HBox hb) {

		StackPane stack = new StackPane();
		
		/*
		Rectangle helpIcon = new Rectangle(30.0, 25.0);
		helpIcon.setFill(new LinearGradient(0,0,0,1, true, CycleMethod.NO_CYCLE,
				new Stop[]{
						new Stop(0,Color.web("#4977A3")),
						new Stop(0.5, Color.web("#B0C6DA")),
						new Stop(1,Color.web("#9CB6CF")),}));
		helpIcon.setStroke(Color.web("#D0E6FA"));
		helpIcon.setArcHeight(3.5);
		helpIcon.setArcWidth(3.5);

		Text helpText = new Text("?");
		helpText.setFont(Font.font("Verdana", FontWeight.BOLD, 18));
		helpText.setFill(Color.WHITE);
		helpText.setStroke(Color.web("#7080A0")); 
        
     

		stack.getChildren().addAll(helpIcon, helpText);
		stack.setAlignment(Pos.CENTER_RIGHT);
		// Add offset to right for question mark to compensate for RIGHT 
		// alignment of all nodes
		StackPane.setMargin(helpText, new Insets(0, 10, 0, 0));
        */
		
		
		hb.getChildren().add(stack);
		HBox.setHgrow(stack, Priority.ALWAYS);
	}



	public HBox getNavigationControl()
	{
		HBox hbo = new HBox();
		hbo.getStyleClass().add("hbox");

		Button bPrev = new Button("< Previous");
		bPrev.setPrefSize(100, 20);

		Button bSave = new Button("Save");
		bSave.setPrefSize(100,20);

		Button bNext = new Button("Next >");
		bNext.setPrefSize(100,20);

		hbo.setAlignment(Pos.CENTER);
		hbo.getChildren().addAll(bPrev, bSave, bNext);

		return hbo;
	}



	/*
	 * Creates an anchor pane using the provided grid and an HBox with buttons
	 * 
	 * @param grid Grid to anchor to the top of the anchor pane
	 */
	private AnchorPane addAnchorPane(GridPane grid) {

		AnchorPane anchorpane = new AnchorPane();
		anchorpane.getStyleClass().add("pane");

		Button buttonSave = new Button("Save");
		buttonSave.setId("button-custom");
		Button buttonCancel = new Button("Cancel");
		buttonCancel.setId("button-custom");

		HBox hb = new HBox();
		//        hb.setPadding(new Insets(0, 10, 10, 10));
		//        hb.setSpacing(10);
		// Use style classes to set properties previously set above (with some changes)        
		hb.getStyleClass().add("hbox");
		hb.setId("hbox-custom");
		hb.getChildren().addAll(buttonSave, buttonCancel);

		anchorpane.getChildren().addAll(grid,hb);
		// Anchor buttons to bottom right, anchor grid to top
		AnchorPane.setBottomAnchor(hb, 8.0);
		AnchorPane.setRightAnchor(hb, 5.0);
		AnchorPane.setTopAnchor(grid, 10.0);

		return anchorpane;
	}
}
