package ui;

import java.io.IOException;

import pviScreen.PVIScreenReader;
import pviScreen.PVIScreenControlData;
import util.FileModifier;
import util.UnitConverter;
import util.NameConstants;

/**
 * PVIScreenUIInputData    input file reader for the PVIScreenUI
 *                         uses only the PVIScreen file reader classes
 *                         (no new ones created for the interface)
 * @author Jim Weaver
 * 
 * 9-9-2013
 */
public class PVIScreenUIInputData 
{
   private PVIScreenReader pvisReader;
   private String sFileAndPathName;
   private String sStatisticsFileAndPathName;
   private String sResultsFileAndPathName;
   private String sOutputFileTime;
   private NameConstants nc;
   private PVIScreenControlData pvisControlData;
   private UnitConverter uc;
   private FileModifier fm;
   
   
   
   public PVIScreenUIInputData()
   {
	   fm = new FileModifier();
	   fm.setTimeStamp();
	   nc = new NameConstants();
   }
   
   
   //read the PVIScreen input data with the standard PVIScreen classes
   public void readInputData() throws IOException
   {
	   pvisReader = new PVIScreenReader();
	   pvisReader.initial();
	   pvisReader.setFileModifier(fm);
	   //do not write an output file
	   pvisReader.setWriteFile(false);

	   //read from file
	   pvisReader.readFile(sFileAndPathName);
	
	   //get data container
	   pvisControlData = pvisReader.getPVIScreenControlData();	   
   }

   public void extractInputFileNameFromOutputFile(String sOutputFileName, String sOutputFileAndPathName)
   {
	  //output file names end in .PviScreen.Results.csv
	  //input file names end in .PviScreen.csv
	  //extension names are set in the class NameConstants
	  this.sResultsFileAndPathName = sOutputFileAndPathName; 
	  this.sStatisticsFileAndPathName = sOutputFileAndPathName;
	  this.sFileAndPathName = fm.removeExtensionAndTimeStamp(sOutputFileAndPathName)+'.'+nc.s_Extension_Input;
   }
   
   //sets
   public void setFileAndPathName(String sFileAndPathName){this.sFileAndPathName = sFileAndPathName;}
   public void setResultsFileAndPathName(String sFileAndPathName, String sNewFileType, int iDots)
   {
	   //parse and remove extension, add new extension
	   this.sResultsFileAndPathName = fm.getOutputFileAndPathName(sFileAndPathName, iDots, sNewFileType, true);
   }
   

   //gets
   public PVIScreenControlData getPVIScreenControlData(){return this.pvisControlData;}
   public FileModifier getFileModifier(){return this.fm;}


  
   
}
