package ui;

import java.util.ArrayList;

import pviScreen.PVIScreenControlData;
import statistics.RiskContainer;
import util.Stripper;
import javafx.collections.ObservableList;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;

public class Repository 
{
	private BorderPane border;

	private String sInputFile;
	private String sInputFileAndPath;
	private String sDirectory;
	private boolean bInputFileFlagSet;

	private String sInputChemical;
	private boolean bInputChemicalFlagSet;

	private String sInputType;
	private boolean bInputTypeFlagSet;

	private String sFilePathAndNameResults;
	private String sFilePathAndNameStatistics;
	private String sFilePathAndNameHTML;
	private boolean bFileResultsNameFlagSet;

	private String sTopLabelText;

	private PVIScreenControlData pvisControlData;

	private boolean bEditControlChanged;

	private ArrayList<String[]> alControlMade; 

	private TabPane tpStatistics;
	private WritableImage wiSite;
	private ArrayList<WritableImage> alOutputImages;
	private ArrayList<String> alOutputImageNames;
	private RiskContainer rc;

	private ObservableList<String> olChemical;
	private ArrayList<DefaultNameRange> alAirExchange;

	private HandlerStatisticsPlot hsp;
	private HandlerEdit he;
	private FileChooser fc;
	private ArrayList<HBox> alHbox;
	private ObservableList<Button> olButton;
	private double[] dColorLow;
	private double[] dColorHigh;

	private Tab tabScreening;

	private PVIScreenUIInputData pvisUIInputData;


	Repository()
	{
		this.bInputFileFlagSet = false;
		this.bInputTypeFlagSet = false;
		this.bInputChemicalFlagSet = false;
		this.bEditControlChanged = false;

		alControlMade = new ArrayList<String[]>();
		alOutputImages = new ArrayList<WritableImage>();
		alOutputImageNames = new ArrayList<String>();
		alAirExchange = new ArrayList<DefaultNameRange>();	

		this.sDirectory = "";
	}


	//register each control that is made for later checking
	public void addPriorControl(String sDataGroup, String sDescription, String sDescription2)
	{
		String[] sInput = new String[]{sDataGroup,sDescription,sDescription2};
		alControlMade.add(sInput);
	}

	public void removePriorControl(String sDataGroup, String sDescription, String sDescription2)
	{

		for (String[] string:  alControlMade)
		{
			boolean bReturn;
			Stripper s = new Stripper();
			String s0, s1, s2;
			String s0Input, s1Input, s2Input;

			//assume no prior control made
			bReturn = false;

			s0Input = s.removeCharacter(' ', sDataGroup);
			s1Input = s.removeCharacter(' ', sDescription);
			s2Input = s.removeCharacter(' ', sDescription2);
			s0 = s.removeCharacter(' ', string[0]);
			s1 = s.removeCharacter(' ', string[1]); 
			s2 = s.removeCharacter(' ', string[2]);
			if (s0.equalsIgnoreCase(s0Input)
					&& s1.equalsIgnoreCase(s1Input)		
					&& s2.equalsIgnoreCase(s2Input))
			{
				//prior control made
				alControlMade.remove(string);
				//if a chemical is removed, also remove the associated screening leven
				alControlMade = removeScreeningLevel(string);
				int iCount = 0;
				for (String[] ss: alControlMade)
				{
					System.out.println(iCount + " " + ss[0] + " " + ss[1] + " " + ss[2]);
					iCount++;
				}

				break;
			}
		}
	}


	private ArrayList<String[]> removeScreeningLevel(String[] string)
	{
		ArrayList<String[]>alControlMadeNew = new ArrayList<String[]>();
		Stripper s = new Stripper();
		//remove the screening level (simple code doesn't work:  alControlMade.remove(string);  )
		string[0] = "ScreeningLevel";
		string[2] = "";

		for (String[] ss: alControlMade)
		{
			if (s.areTheyEqual(string[0], ss[0],' ') && s.areTheyEqual(string[1], ss[1],' ') && s.areTheyEqual(string[2], ss[2],' '))
			{
				//do not add to reconstructed control list
			}
			else
			{
				alControlMadeNew.add(ss);
			}
		}
		return alControlMadeNew;
	}

	public void clearPriorControls()
	{
		alControlMade.clear();
	}

	//checks

	//check to see if input control has already been made for the dataGroup and description
	//(only one input control will have active changer for the type of distribution)
	public boolean checkForPreviousControl(String sDataGroup, String sDescription, String sDescription2)
	{
		boolean bReturn;
		Stripper s = new Stripper();
		String s0, s1, s2;
		String s0Input, s1Input, s2Input;

		//assume no prior control made
		bReturn = false;

		s0Input = s.removeCharacter(' ', sDataGroup);
		s1Input = s.removeCharacter(' ', sDescription);
		s2Input = s.removeCharacter(' ', sDescription2);

		for (String[] string: alControlMade)
		{
			s0 = s.removeCharacter(' ', string[0]);
			s1 = s.removeCharacter(' ', string[1]); 
			s2 = s.removeCharacter(' ', string[2]);
			if (s0.equalsIgnoreCase(s0Input)
					&& s1.equalsIgnoreCase(s1Input)		
					&& s2.equalsIgnoreCase(s2Input))
			{
				//prior control made
				bReturn = true;
				break;
			}
		}

		return bReturn;
	}

	
	
	//clear repository of prior data (for use when edited file has changed and been saved)
	public void clearPreviousPVIScreenControlData()
	{
		pvisControlData = new PVIScreenControlData();
	}

	//adds
	public void addOutputImage(WritableImage wi){alOutputImages.add(wi);}
	public void addOutputImageName(String sName){alOutputImageNames.add(sName);}
	public void addAirExchange(String sName, double dMin, double dMax){alAirExchange.add(new DefaultNameRange(sName,dMin,dMax));}

	//clears
	public void clearPreviousControlArrayList(){alControlMade = new ArrayList<String[]>();}
	//clear prior air exchange rates
	public void removeAirExchangeRates(){alAirExchange = new ArrayList<DefaultNameRange>();}
	//clear previous risk results
	public void refreshRiskResults(){rc.initialize();}	


	//sets
	public void setInputFile(String s){this.sInputFile = s;}
	public void setInputFileAndPath(String s){this.sInputFileAndPath = s;}
	public void setInputFileFlagSet(boolean b){this.bInputFileFlagSet = b;}
	public void setDirectory(String s){this.sDirectory = s;}

	public void setInputChemical(String s){this.sInputChemical = s;}
	public void setInputChemicalFlagSet(boolean b){this.bInputChemicalFlagSet = b;}

	public void setInputType(String s){this.sInputType = s;}
	public void setInputTypeFlagSet(boolean b){this.bInputTypeFlagSet = b;}

	public void setBorder(BorderPane border){this.border = border;}

	public void setFilePathAndNameResults(String s){this.sFilePathAndNameResults=s;}
	public void setFilePathAndNameStatistics(String s){this.sFilePathAndNameStatistics=s;} 	
	public void setFilePathAndNameHTML(String s){this.sFilePathAndNameHTML = s;}
	public void setFileResultsNameFlagSet(boolean b){this.bFileResultsNameFlagSet =b;}


	public void setTopLabelText(String s){this.sTopLabelText = s;} 
	public void setPVIScreenControlData(PVIScreenControlData pvisControlData){this.pvisControlData = pvisControlData;}

	public void setEditControlChanged(boolean bEditControlChanged){this.bEditControlChanged = bEditControlChanged;}
	public void setSiteSchematic(WritableImage wiSite){this.wiSite = wiSite;}
	public void setRiskContainer(RiskContainer rc){this.rc = rc;}
	public void setAllChemicalChoices(ObservableList<String> alChemical){this.olChemical = alChemical;}
	public void setHandlerStatisticsPlot(HandlerStatisticsPlot hsp){this.hsp = hsp;}
	public void setHandlerEdit(HandlerEdit he){this.he = he;}
	public void setStatisticsTabPane(TabPane tp){this.tpStatistics = tp;}
	public void setFileChooser(FileChooser fc){this.fc = fc;}
	public void setHboxList(ArrayList<HBox>alHbox){this.alHbox=alHbox;}
	public void setButtonList(ObservableList<Button>olButton){this.olButton = olButton;}

	public void setColorLow(double[] dColorLow){this.dColorLow = dColorLow;}
	public void setColorHigh(double[] dColorHigh){this.dColorHigh = dColorHigh;}

	public void setScreeningTab(Tab tabScreening){this.tabScreening = tabScreening;}
	public void setPVIScreenUIInputData(PVIScreenUIInputData pvis){this.pvisUIInputData = pvis;}


	//gets
	public String getInputFile(){return this.sInputFile;}
	public String getInputFileAndPath(){return this.sInputFileAndPath;}
	public boolean getInputFileFlagSet(){return this.bInputFileFlagSet;}
	public String getDirectory(){return this.sDirectory;}

	public String getInputChemical(){return this.sInputChemical;}
	public boolean getInputChemicalFlagSet(){return this.bInputChemicalFlagSet;}
	public ArrayList<DefaultNameRange> getAirExchange(){return this.alAirExchange;}

	public String getInputType(){return this.sInputType;}
	public boolean getInputTypeFlagSet(){return this.bInputTypeFlagSet;}

	public BorderPane getBorder(){return this.border;}

	//public String getFilePathAndName(){return this.sFilePathAndNameResults;}
	public String getFilePathAndNameStatistics(){return this.sFilePathAndNameStatistics;} 
	public String getFilePathAndNameResults(){return this.sFilePathAndNameResults;}
	public String getFilePathAndNameHTML(){return this.sFilePathAndNameHTML;}
	public boolean getFileResultsNameFlagSet(){return this.bFileResultsNameFlagSet;}

	public String getTopLabelText(){return this.sTopLabelText;}

	public PVIScreenControlData getPVIScreenControlData(){return this.pvisControlData;}
	public boolean getEditControlChanged(){return this.bEditControlChanged;}
	public WritableImage getSiteSchematic(){return this.wiSite;}
	public ArrayList<WritableImage> getOutputImages(){return this.alOutputImages;}
	public ArrayList<String> getOutputImageNames(){return this.alOutputImageNames;}
	public RiskContainer getRiskContainer(){return this.rc;}

	public ObservableList<String> getAllChemicalChoices(){return this.olChemical;}
	public HandlerStatisticsPlot getHandlerStatisticsPlot(){return this.hsp;}
	public HandlerEdit getHandlerEdit(){return this.he;}
	public TabPane getStatisticsTabPane(){return this.tpStatistics;}

	public FileChooser getFileChooser(){return this.fc;}
	public ArrayList<HBox> getHBoxList(){return this.alHbox;}
	public ObservableList<Button> getButtonList(){return this.olButton;}

	public double[] getColorLow(){return this.dColorLow;}
	public double[] getColorHigh(){return this.dColorHigh;}

	public Tab getScreeningTab(){return this.tabScreening;}
	public PVIScreenUIInputData getPCIScreenUIInputData(){return this.pvisUIInputData;}

}
