package ui;

import java.util.ArrayList;

import pviScreen.PVIScreenControlData;

import javafx.geometry.Side;
import javafx.scene.SnapshotParameters;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import statistics.Histogram;
import statistics.Interval;
import statistics.RiskContainer;
import util.OutputDigits;

public class StatisticsOutput 
{
       private OutputDigits od;
       private PVIScreenControlData pvisCD;
       private Repository repository;
       
	   public StatisticsOutput()
	   {
		   od = new OutputDigits();
		   
	   }
	
	   public LineChart<Number,Number> createStatisticsOutput(String sFilePathAndName, 
               Histogram h, 
               RiskContainer rc,
               boolean bDisplayGraphic,
               boolean bSaveRisk,
               boolean bSaveGraphic)
			{
				String sName;
				BorderPane border;
				
				double dMinXAxis;
				dMinXAxis = -4.0;
				sName = h.getHistogramChemical();
				ScrollPane sp = new ScrollPane();
				//truncate output numbers
				//Initializing with an arbitrary number sets defaults
				od = new OutputDigits(0.0,2,-15,15,-3,3);
				
				//create an array list for the histogram intervals
				ArrayList<Interval> alInterval = new ArrayList<Interval>(); 
				XYChart.Series xyDataRiskLevel = new XYChart.Series();
				
				NumberAxis xAxis = new NumberAxis();
				NumberAxis yAxis = new NumberAxis();
				xAxis.setLabel("Log Concentration (Log10 " + h.getOutputUnit() + ")");
				yAxis.setLabel("Frequency");
				//yAxis.setAutoRanging(false);
				//yAxis.setUpperBound(1.0);
				yAxis.setTickUnit(0.1);
				
				
				final LineChart<Number,Number> statisticsChart = new LineChart<Number,Number>(xAxis,yAxis);
				statisticsChart.setCreateSymbols(false);
				statisticsChart.setTitle("PVIScreen Result for " + h.getHistogramChemical());
				
				//create two xy data series:  one for the probability density and one for the cumulative probability
				XYChart.Series xyDataCumulative = new XYChart.Series();
				xyDataCumulative.setName(h.getHistogramTitle() + " Frequency");
				XYChart.Series xyDataDensity = new XYChart.Series();
				xyDataDensity.setName(h.getHistogramTitle() + " Density");
				
				
				
				//load the data
				double dConc;
				double dCF;
				int iCountEm=0;
				alInterval = h.getHistogramIntervals();
				for (Interval i: alInterval)
				{
				dConc = i.getMidPointValue();
				if (dConc>dMinXAxis)
					{	  
						dCF = i.getCumulativeFrequency();
						
						//once the cumulative frequency reaches 1.0, a limited number of values are needed
						//cut it off at 2
						xyDataCumulative.getData().add(new XYChart.Data<Double, Double>(i.getMidPointValue(),i.getCumulativeFrequency()));  
						//the futility of a linear plot is shown by using this instead: 
						//xyDataCumulative.getData().add(new XYChart.Data(Math.pow(10, i.getMidPointValue()),i.getCumulativeFrequency()));
						xyDataDensity.getData().add(new XYChart.Data<Double, Double>(i.getMidPointValue(),i.getFrequency()));
					
					} 
				}
				
				statisticsChart.getData().addAll(xyDataCumulative);
				statisticsChart.getData().addAll(xyDataDensity);
				
				//get the point of highest probability density
				double dLogMax = h.getIntervalWithHighestProbabilityDensity();
				double dMax = Math.pow(dLogMax, 10);
				
			 
				h.determineCumulativeProbabilityOfTheLevelOfConcern(dMax);
				double dMaxFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
				XYChart.Series xyDataHighProbability = new XYChart.Series();
				 
				xyDataHighProbability.setName("Highest Individual Probability Result: " + od.num2String(dMax) + "(" + h.getOutputUnit() + ")");
				
				
				if (dMaxFrequency>0.0)
				{	
					xyDataHighProbability.getData().add(new XYChart.Data(dMax,dMaxFrequency-0.02));
					xyDataHighProbability.getData().add(new XYChart.Data<Double, Double>(dMax,dMaxFrequency));
					xyDataHighProbability.getData().add(new XYChart.Data(dMax,dMaxFrequency+0.02));
					statisticsChart.getData().addAll(xyDataHighProbability);
				}
				
				
				double dPerCentAboveRiskLevel;
				double dRiskLevel;
				double dRiskConcentration;
				double dConcentrationToCheck;
				double dSelectedFrequency;
				String sOutputUnit;
				
				//Cancer risk
				//if this histogram is a chemical, a risk level can be added
				//add a risk level --- a vertical line at a specified concentration
				
				
				int iRiskCount = 0;
				
				//determine cancer risk levels for all values in input set
				ArrayList<Double> alRiskLevel = pvisCD.getRiskLevels();
				
				//dRiskLevel = h.getRiskLevel();
				dRiskConcentration = h.getLevelOfConcern();
				if (dRiskConcentration>0.0)
				{	   
					for (Double dRisk: alRiskLevel)
					{   
					try
						{
						//dConcentrationToCheck = dRiskConcentration*(dOutputRiskLevel[i]/dRiskLevel);
						dConcentrationToCheck = dRiskConcentration*dRisk;
						//determine the cumulative probability of the Level Of Concern
						h.determineCumulativeProbabilityOfTheLevelOfConcern(dConcentrationToCheck);
						sOutputUnit = h.getOutputUnit();
						dSelectedFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
						dPerCentAboveRiskLevel = (1.0 - dSelectedFrequency)*100.0;
						if (dPerCentAboveRiskLevel<0.0001){dPerCentAboveRiskLevel=0.0;}
						
						//save risk information
						if (bSaveRisk){rc.addCancerRisk(sName, true, dRisk, dConcentrationToCheck, dPerCentAboveRiskLevel);}
						
						xyDataRiskLevel = new XYChart.Series();
						xyDataRiskLevel.setName( od.num2String(dPerCentAboveRiskLevel) + "% Above Risk " + dRisk + " Level (" + od.num2String(dConcentrationToCheck) + " " + sOutputUnit +  ")");
						xyDataRiskLevel.getData().add(new XYChart.Data(Math.log10(dConcentrationToCheck),dSelectedFrequency+0.04));
						xyDataRiskLevel.getData().add(new XYChart.Data<Double, Double>(Math.log10(dConcentrationToCheck),dSelectedFrequency));
						xyDataRiskLevel.getData().add(new XYChart.Data(Math.log10(dConcentrationToCheck),dSelectedFrequency-0.04));
						statisticsChart.getData().addAll(xyDataRiskLevel);
						iRiskCount++;
					}
					catch (Exception e){}
					}   
				}
				
				else if (iRiskCount<=0)
				{
					//no cancer risks calculated
					if (bSaveRisk){rc.addCancerRisk(sName,false);}
				}
				
				
				//non-cancer risk
				double dRfC;
				//get the reference concentration from the histogram
				dRfC = h.getRfC();
				ArrayList<Double> alHazardQuotient = pvisCD.getHazardQuotients();
				if (dRfC>0.0)
				{
					//for (int i=0;i<dOutputHQ.length;i++)
					for (Double dHazardQuotient: alHazardQuotient)
					{ 
						try
						{
							dConcentrationToCheck = dRfC*dHazardQuotient;
							h.determineCumulativeProbabilityOfTheLevelOfConcern(dConcentrationToCheck);
							sOutputUnit = h.getOutputUnit();
							dSelectedFrequency = h.getHistogramLevelOfConcernCumulativeFrequency();
							dPerCentAboveRiskLevel = (1.0 - dSelectedFrequency)*100.0;
							if (dPerCentAboveRiskLevel<0.0001){dPerCentAboveRiskLevel=0.0;}
							
							//save results for writing to output
							if(bSaveRisk){rc.addHazard(sName, true, dHazardQuotient, dConcentrationToCheck, dPerCentAboveRiskLevel);}
							
							xyDataRiskLevel = new XYChart.Series();
							xyDataRiskLevel.setName( od.num2String(dPerCentAboveRiskLevel) + "% Above Hazard Quotient of " + dHazardQuotient +   " (" + od.num2String(dConcentrationToCheck) + " " + sOutputUnit +  ")");
							xyDataRiskLevel.getData().add(new XYChart.Data(Math.log10(dConcentrationToCheck),dSelectedFrequency-0.02));
							xyDataRiskLevel.getData().add(new XYChart.Data<Double, Double>(Math.log10(dConcentrationToCheck),dSelectedFrequency));
							xyDataRiskLevel.getData().add(new XYChart.Data(Math.log10(dConcentrationToCheck),dSelectedFrequency+0.02));
							statisticsChart.getData().addAll(xyDataRiskLevel);
						}
						catch(Exception e){}
						}  
						
			    }
				else
				{
						//add to RiskContainer as a "no-hazard" chemical
						if (bSaveRisk){rc.addHazard(sName,false);}
				}
				
				
				
				statisticsChart.setLegendSide(Side.RIGHT);
				//"animation" must be turned off to get complete snapshot of chart
				statisticsChart.setAnimated(false);
				
				 
				
				if (bSaveGraphic)
				{	
				  WritableImage snapshot = statisticsChart.snapshot(new SnapshotParameters(), null);
				  repository.addOutputImage(snapshot);
				}
			 
				return statisticsChart;
			
			}
	
	
	   //sets
	   public void setHandlerRepository(Repository repository){this.repository = repository;}
	
}
