package ui;

import util.FileLogger;

public class WriteTemplateFile 
{

	public WriteTemplateFile(){}
	
	public void writeOilLensExample(String sTemplateDirectory)
	{	
		FileLogger fl = new FileLogger();
		fl.setFileExtension("pvi");
		fl.setShortFileName(sTemplateDirectory+"\\"+"SampleOilLensInput");
		fl.useCalendarInName(false);
		fl.assembleOutputFile();
		fl.openOverWriteFile();
		
		fl.logMessageOverWrite("Control,Begin");
		fl.logMessageOverWrite("Control,Site,");
		fl.logMessageOverWrite("Control,SiteLocation,");
		fl.logMessageOverWrite("Control,City,");
		fl.logMessageOverWrite("Control,State,");
		fl.logMessageOverWrite("Control,Analyst,");
		fl.logMessageOverWrite("Control,Affiliation,");
		fl.logMessageOverWrite("Control,Risk Level,1.00E-06");
		fl.logMessageOverWrite("Control,HazardQuotient,1");
		fl.logMessageOverWrite("Control,Oil Distribution,capillary");
		fl.logMessageOverWrite("Control,End");
		fl.logMessageOverWrite("Building,Begin");
		fl.logMessageOverWrite("Building,dirt floor,no");
		fl.logMessageOverWrite("Building,Width,Constant,10,m,1");
		fl.logMessageOverWrite("Building,Length,Constant,10,m,1");
		fl.logMessageOverWrite("Building,CeilingHeight,Constant,9,ft,1");
		fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,2,m,1");
		fl.logMessageOverWrite("Building,FoundationThickness,Variable,10,cm,0");
		fl.logMessageOverWrite("Building,FoundationThickness,Variable,20,cm,1");
		fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
		fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
		fl.logMessageOverWrite("Building,AirExchangeRate,Variable,0.1,1/hr,0");
		fl.logMessageOverWrite("Building,AirExchangeRate,Variable,1.5,1/hr,1");
		fl.logMessageOverWrite("Building,End");
		fl.logMessageOverWrite("VadoseZone,Begin");
		fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,5.048,m,1");
		fl.logMessageOverWrite("Vadose Zone,Depth To Sample,Constant,5.048,m,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,5.048,m,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,6.048,m,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,10,m,1");
		fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.049,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.2127,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.35,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.35,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,7.50E-04,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.00125,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
		fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
		fl.logMessageOverWrite("Vadose Zone,AirEntryHead,Constant,60,cm,1");
		fl.logMessageOverWrite("Vadose Zone,ResidualWaterSaturation,Variable,0.029,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,ResidualWaterSaturation,Variable,0.049,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,WaterSurfaceTension,Constant,72,dyne/cm,1");
		fl.logMessageOverWrite("Vadose Zone,Lambda,Variable,0.2,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,Lambda,Variable,0.2,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,TrappedAirSaturation,Variable,0.1,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,TrappedAirSaturation,Variable,0.2,dimensionless,1");
		fl.logMessageOverWrite("VadoseZone,End");
		fl.logMessageOverWrite("Aquifer,Begin");
		fl.logMessageOverWrite("Aquifer,HydraulicConductivity,Variable,100,ft/d,0");
		fl.logMessageOverWrite("Aquifer,HydraulicConductivity,Variable,100,ft/d,1");
		fl.logMessageOverWrite("Aquifer,Gradient,Variable,0.001,dimensionless,0");
		fl.logMessageOverWrite("Aquifer,Gradient,Variable,0.001,dimensionless,1");
		fl.logMessageOverWrite("Aquifer,End");
		fl.logMessageOverWrite("OilLens,Begin");
		fl.logMessageOverWrite("Oil Lens,FuelVolume,Variable,500,gal,0");
		fl.logMessageOverWrite("Oil Lens,FuelVolume,Variable,500,gal,1");
		fl.logMessageOverWrite("Oil Lens,LensLength,Variable,20,ft,0");
		fl.logMessageOverWrite("Oil Lens,LensLength,Variable,20,ft,1");
		fl.logMessageOverWrite("Oil Lens,LensWidth,Variable,30,ft,0");
		fl.logMessageOverWrite("Oil Lens,LensWidth,Variable,30,ft,1");
		fl.logMessageOverWrite("Oil Lens,MaxOilSaturation,Variable,0.15,dimensionless,0");
		fl.logMessageOverWrite("Oil Lens,MaxOilSaturation,Variable,0.15,dimensionless,1");
		fl.logMessageOverWrite("Oil Lens,ResidualOilSaturation,Variable,0.01,dimensionless,0");
		fl.logMessageOverWrite("Oil Lens,ResidualOilSaturation,Variable,0.05,dimensionless,1");
		fl.logMessageOverWrite("Oil Lens,OilWaterInterfacialTension,Variable,25,dyne/cm,0");
		fl.logMessageOverWrite("Oil Lens,OilWaterInterfacialTension,Variable,35,dyne/cm,1");
		fl.logMessageOverWrite("Oil Lens,OilDensity,Variable,0.72,g/mL,0");
		fl.logMessageOverWrite("Oil Lens,OilDensity,Variable,0.78,g/mL,1");
		fl.logMessageOverWrite("Oil Lens,OilMolecularWeight,Variable,105,g/mole,0");
		fl.logMessageOverWrite("Oil Lens,OilMolecularWeight,Variable,105,g/mole,1");
		fl.logMessageOverWrite("OilLens,End");
		fl.logMessageOverWrite("Chemical,Begin");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,benzene,6.02E-06,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,toluene,0.01243,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,ethylbenzene,0.009463,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,xylenes,0.04454,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C8ToC9Aromatic,0.003047,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C9ToC10Aromatic,0.06796,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C10toC11Aromatic,0.003607,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C5ToC6Aliphatic,0.2478,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C6ToC7Aliphatic,0.1571,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C7ToC8Aliphatic,0.0933,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,Fuel Phase Concentration By Volume,Constant,C8ToC9Aliphatic,0.07359,cm3/cm3,1");
		fl.logMessageOverWrite("Chemical,End");
		
		fl.closeOverWriteFile();
	}
	
	public void writeSoilGasExample(String sTemplateDirectory)
	{
		FileLogger fl = new FileLogger();
		fl.setFileExtension("pvi");
		fl.setShortFileName(sTemplateDirectory+"\\"+"SampleSoilGasInput-Commercial");
		fl.useCalendarInName(false);
		fl.assembleOutputFile();
		fl.openOverWriteFile();
		
		
		fl.logMessageOverWrite("Control,Begin");
		fl.logMessageOverWrite("Control,Site, ");
		fl.logMessageOverWrite("Control,SiteLocation, ");
		fl.logMessageOverWrite("Control,City, ");
		fl.logMessageOverWrite("Control,State, ");
		fl.logMessageOverWrite("Control,Analyst, ");
		fl.logMessageOverWrite("Control,Affiliation, ");
		fl.logMessageOverWrite("Control,GroundWaterConcentrationFactor,0.1");
		fl.logMessageOverWrite("Control,Oil Distribution,none");
		fl.logMessageOverWrite("Control,End");
		fl.logMessageOverWrite("Building,Begin");
		fl.logMessageOverWrite("Building,dirt floor,no");
		fl.logMessageOverWrite("Building,Width,Constant,60,ft,1");
		fl.logMessageOverWrite("Building,Length,Constant,80,ft,1");
		fl.logMessageOverWrite("Building,CeilingHeight,Constant,9,ft,1");
		fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,6,in,1");
		fl.logMessageOverWrite("Building,FoundationThickness,Variable,10,cm,0");
		fl.logMessageOverWrite("Building,FoundationThickness,Variable,20,cm,1");
		fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
		fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
		fl.logMessageOverWrite("Building,AirExchangeRate,Variable,3,1/hr,0");
		fl.logMessageOverWrite("Building,AirExchangeRate,Variable,10,1/hr,1");
		fl.logMessageOverWrite("Building,End");
		fl.logMessageOverWrite("VadoseZone,Begin");
		fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,3,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,7.5,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,7.5,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,20,ft,1");
		fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.049,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.2127,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.29,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.484,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,7.50E-04,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.00125,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
		fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
		fl.logMessageOverWrite("VadoseZone,End");
		fl.logMessageOverWrite("Aquifer,Begin");
		fl.logMessageOverWrite("Aquifer,End");
		fl.logMessageOverWrite("OilLens,Begin");
		fl.logMessageOverWrite("OilLens,End");
		fl.logMessageOverWrite("Chemical,Begin");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,benzene,1.6,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,toluene,10,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,ethylbenzene,2.2,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,xylenes,41,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,naphthalene,2.85,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,MTBE,1.8,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,TPH-GRO,210,ug/m3,1");
		fl.logMessageOverWrite("Chemical,End");
		fl.logMessageOverWrite("Risk,Begin");
		fl.logMessageOverWrite("Risk,End");
		fl.logMessageOverWrite("ScreeningLevel,Begin");
		fl.logMessageOverWrite("ScreeningLevel,benzene,Constant,0.5,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,toluene,Constant,7310,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,ethylbenzene,Constant,1480,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,xylenes,Constant,148,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,naphthalene,Constant,4.39,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,MTBE,Constant,4380,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,TPH-GRO,Constant,307,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,End");
        
		fl.closeOverWriteFile();
	}
	public void writeSoilGasExampleResidential(String sTemplateDirectory)
	{
		FileLogger fl = new FileLogger();
		fl.setFileExtension("pvi");
		fl.setShortFileName(sTemplateDirectory+"\\"+"SampleSoilGasInput-Residential");
		fl.useCalendarInName(false);
		fl.assembleOutputFile();
		fl.openOverWriteFile();
		

		fl.logMessageOverWrite("Control,Begin");
		fl.logMessageOverWrite("Control,Site, ");
		fl.logMessageOverWrite("Control,SiteLocation, ");
		fl.logMessageOverWrite("Control,City, ");
		fl.logMessageOverWrite("Control,State, ");
		fl.logMessageOverWrite("Control,Analyst, ");
		fl.logMessageOverWrite("Control,Affiliation, ");
		fl.logMessageOverWrite("Control,GroundWaterConcentrationFactor,0.1");
		fl.logMessageOverWrite("Control,Oil Distribution,none");
		fl.logMessageOverWrite("Control,End");
		fl.logMessageOverWrite("Building,Begin");
		fl.logMessageOverWrite("Building,dirt floor,no");
		fl.logMessageOverWrite("Building,Width,Constant,60,ft,1");
		fl.logMessageOverWrite("Building,Length,Constant,80,ft,1");
		fl.logMessageOverWrite("Building,CeilingHeight,Constant,9,ft,1");
		fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,6,in,1");
		fl.logMessageOverWrite("Building,FoundationThickness,Variable,10,cm,0");
		fl.logMessageOverWrite("Building,FoundationThickness,Variable,20,cm,1");
		fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
		fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
		fl.logMessageOverWrite("Building,AirExchangeRate,Variable,0.5,1/hr,0");
		fl.logMessageOverWrite("Building,AirExchangeRate,Variable,1.5,1/hr,1");
		fl.logMessageOverWrite("Building,End");
		fl.logMessageOverWrite("VadoseZone,Begin");
		fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,3,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,7.5,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,7.5,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,20,ft,1");
		fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.049,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.2127,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.29,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.484,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,7.50E-04,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.00125,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
		fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
		fl.logMessageOverWrite("VadoseZone,End");
		fl.logMessageOverWrite("Aquifer,Begin");
		fl.logMessageOverWrite("Aquifer,End");
		fl.logMessageOverWrite("OilLens,Begin");
		fl.logMessageOverWrite("OilLens,End");
		fl.logMessageOverWrite("Chemical,Begin");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,benzene,1.6,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,toluene,10,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,ethylbenzene,2.2,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,xylenes,41,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,naphthalene,2.85,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,MTBE,1.8,ug/m3,1");
		fl.logMessageOverWrite("Chemical,AirPhaseConcentration,Constant,TPH-GRO,210,ug/m3,1");
		fl.logMessageOverWrite("Chemical,End");
		fl.logMessageOverWrite("Risk,Begin");
		fl.logMessageOverWrite("Risk,End");
		fl.logMessageOverWrite("ScreeningLevel,Begin");
		fl.logMessageOverWrite("ScreeningLevel,benzene,Constant,0.5,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,toluene,Constant,7310,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,ethylbenzene,Constant,1480,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,xylenes,Constant,148,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,naphthalene,Constant,4.39,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,MTBE,Constant,4380,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,TPH-GRO,Constant,307,ug/m3");
		fl.logMessageOverWrite("ScreeningLevel,End");
        
		fl.closeOverWriteFile();
	}
	public void writeGroundWaterExample(String sTemplateDirectory)
	{
		FileLogger fl = new FileLogger();
		fl.setFileExtension("pvi");
		fl.setShortFileName(sTemplateDirectory+"\\"+"SampleGroundWaterInput-Commercial");
		fl.useCalendarInName(false);
		fl.assembleOutputFile();
		fl.openOverWriteFile();

		fl.logMessageOverWrite("Control,Begin");
		fl.logMessageOverWrite("Control,Site, ");
		fl.logMessageOverWrite("Control,SiteLocation, ");
		fl.logMessageOverWrite("Control,City, ");
		fl.logMessageOverWrite("Control,State, ");
		fl.logMessageOverWrite("Control,Analyst, ");
		fl.logMessageOverWrite("Control,Affiliation, ");
		fl.logMessageOverWrite("Control,GroundWaterConcentrationFactor,0.1");
		fl.logMessageOverWrite("Control,Oil Distribution,none");
		fl.logMessageOverWrite("Control,End");
		fl.logMessageOverWrite("Building,Begin");
		fl.logMessageOverWrite("Building,dirt floor,no");
		fl.logMessageOverWrite("Building,Width,Constant,60,ft,1");
		fl.logMessageOverWrite("Building,Length,Constant,80,ft,1");
		fl.logMessageOverWrite("Building,CeilingHeight,Constant,9,ft,1");
		fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,6,in,1");
		fl.logMessageOverWrite("Building,FoundationThickness,Variable,6,in,0");
		fl.logMessageOverWrite("Building,FoundationThickness,Variable,6,cm,1");
		fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
		fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
		fl.logMessageOverWrite("Building,AirExchangeRate,Variable,3,1/hr,0");
		fl.logMessageOverWrite("Building,AirExchangeRate,Variable,10,1/hr,1");
		fl.logMessageOverWrite("Building,End");
		fl.logMessageOverWrite("VadoseZone,Begin");
		fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,6.9,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,6.9,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,6.9,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,20,ft,1");
		fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.049,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.2127,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.29,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.484,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,7.50E-04,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.00125,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
		fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
		fl.logMessageOverWrite("VadoseZone,End");
		fl.logMessageOverWrite("Aquifer,Begin");
		fl.logMessageOverWrite("Aquifer,End");
		fl.logMessageOverWrite("OilLens,Begin");
		fl.logMessageOverWrite("OilLens,End");
		fl.logMessageOverWrite("Chemical,Begin");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,benzene,0.033,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,toluene,0.001,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,ethylbenzene,0.001,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,xylenes,0.001,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,naphthalene,0.001,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,MTBE,0.001,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,TPH-GRO,0.14,mg/l,1");
		fl.logMessageOverWrite("Chemical,End");
		fl.logMessageOverWrite("Risk,Begin");
		fl.logMessageOverWrite("Risk,End");
		fl.logMessageOverWrite("ScreeningLevel,Begin");
		fl.logMessageOverWrite("ScreeningLevel,benzene,Constant,0.5,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,toluene,Constant,7310,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,ethylbenzene,Constant,1480,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,xylenes,Constant,148,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,naphthalene,Constant,4.39,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,MTBE,Constant,4380,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,TPH-GRO,Constant,307,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,End");

		fl.closeOverWriteFile();
	}
	public void writeGroundWaterExampleResidential(String sTemplateDirectory)
	{
		FileLogger fl = new FileLogger();
		fl.setFileExtension("pvi");
		fl.setShortFileName(sTemplateDirectory+"\\"+"SampleGroundWaterInput-Residential");
		fl.useCalendarInName(false);
		fl.assembleOutputFile();
		fl.openOverWriteFile();

		fl.logMessageOverWrite("Control,Begin");
		fl.logMessageOverWrite("Control,Site, ");
		fl.logMessageOverWrite("Control,SiteLocation, ");
		fl.logMessageOverWrite("Control,City, ");
		fl.logMessageOverWrite("Control,State, ");
		fl.logMessageOverWrite("Control,Analyst, ");
		fl.logMessageOverWrite("Control,Affiliation, ");
		fl.logMessageOverWrite("Control,GroundWaterConcentrationFactor,0.1");
		fl.logMessageOverWrite("Control,Oil Distribution,none");
		fl.logMessageOverWrite("Control,End");
		fl.logMessageOverWrite("Building,Begin");
		fl.logMessageOverWrite("Building,dirt floor,no");
		fl.logMessageOverWrite("Building,Width,Constant,60,ft,1");
		fl.logMessageOverWrite("Building,Length,Constant,80,ft,1");
		fl.logMessageOverWrite("Building,CeilingHeight,Constant,9,ft,1");
		fl.logMessageOverWrite("Building,FoundationDepthBelowGrade,Constant,6,in,1");
		fl.logMessageOverWrite("Building,FoundationThickness,Variable,6,in,0");
		fl.logMessageOverWrite("Building,FoundationThickness,Variable,6,in,1");
		fl.logMessageOverWrite("Building,CrackWidth,Variable,0.5,mm,0");
		fl.logMessageOverWrite("Building,CrackWidth,Variable,5,mm,1");
		fl.logMessageOverWrite("Building,AirExchangeRate,Variable,0.5,1/hr,0");
		fl.logMessageOverWrite("Building,AirExchangeRate,Variable,1.5,1/hr,1");
		fl.logMessageOverWrite("Building,End");
		fl.logMessageOverWrite("VadoseZone,Begin");
		fl.logMessageOverWrite("Vadose Zone,DepthToSample,Constant,6.9,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToWater,Constant,6.9,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToHistoricWaterTable,Constant,6.9,ft,1");
		fl.logMessageOverWrite("Vadose Zone,DepthToBottom,Constant,20,ft,1");
		fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.049,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,MoistureContent,Variable,0.2127,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.29,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,Porosity,Variable,0.484,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,7.50E-04,dimensionless,0");
		fl.logMessageOverWrite("Vadose Zone,FractionOrganicCarbon,Variable,0.00125,dimensionless,1");
		fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,11.25,C,0");
		fl.logMessageOverWrite("Vadose Zone,SoilTemperature,Variable,18.75,C,1");
		fl.logMessageOverWrite("VadoseZone,End");
		fl.logMessageOverWrite("Aquifer,Begin");
		fl.logMessageOverWrite("Aquifer,End");
		fl.logMessageOverWrite("OilLens,Begin");
		fl.logMessageOverWrite("OilLens,End");
		fl.logMessageOverWrite("Chemical,Begin");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,benzene,0.033,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,toluene,0.001,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,ethylbenzene,0.001,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,xylenes,0.001,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,naphthalene,0.001,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,MTBE,0.001,mg/l,1");
		fl.logMessageOverWrite("Chemical,WaterPhaseConcentration,Constant,TPH-GRO,0.14,mg/l,1");
		fl.logMessageOverWrite("Chemical,End");
		fl.logMessageOverWrite("Risk,Begin");
		fl.logMessageOverWrite("Risk,End");
		fl.logMessageOverWrite("ScreeningLevel,Begin");
		fl.logMessageOverWrite("ScreeningLevel,benzene,Constant,0.5,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,toluene,Constant,7310,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,ethylbenzene,Constant,1480,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,xylenes,Constant,148,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,naphthalene,Constant,4.39,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,MTBE,Constant,4380,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,TPH-GRO,Constant,307,mg/cm3");
		fl.logMessageOverWrite("ScreeningLevel,End");

		fl.closeOverWriteFile();
	}
}
