package uncertaintyAnalysis;

import util.FileLogger;


/**
 * Monte Carlo Simulation with Latin Hypercube Sampling
 * 
 * @author JWEAVER
 * Jim Weaver
 * Research Hydrologist
 * Subsurface Remediation Branch
 * Ground Water and Ecosystems Restoration Division
 * National Risk Management Research Laboratory
 * Office of Research and Development
 * United States Environmental Protection Agency
 * Ada, Oklahoma  74820
 * 580-436-8550
 * 
 * 
 * weaver.jim@epa.gov
 * 
 * 3-25-2012
 *
 *
 */
public class MonteCarloLHS 
{
	private FileLogger fl, flSummary;
	private int nInterval;
	private MonteCarloModel mcm;

	public MonteCarloLHS(){}

	//perform simulation
	public void simulate()
	{

		//run average of all parameters for comparison to MonteCarlo output
		mcm.blankTheOutputString();
		mcm.writeAveragedParameterOutputHeadings();
		mcm.setAveragedParametersForAMonteCarloRun();
		mcm.runModel();
		mcm.writeAveragedParameterResult();

		//run median of all parameters for comparison to MonteCarlo output
		mcm.blankTheOutputString();
		mcm.writeMedianParameterOutputHeadings();
		mcm.setMedianParametersForAMonteCarloRun();
		mcm.runModel();
		mcm.writeMedianParameterResult();

		//set the fixed parameters  
		//--all fixed parameters set from StatisticalDistribution objects
		//--where the values are uniform (i.e.   cumulative distribution of (fixed-value) = 0.0 and cumulative distribution of (fixed-value) = 1.0)
		//run the model    
		mcm.writeOutputHeadings();
		for (int i=0;i<nInterval;i++)
		{
			mcm.blankTheOutputString();
			//recreate the concentration distribution objects
			System.out.println("renewing the concentration distributions");
			mcm.reNewConcentrationDistributions();
			//set fixed and random parameters through one call
			System.out.println("setting parameters");
			mcm.setVariableParametersForAMonteCarloRun(i);
			//run this instance of model
			System.out.println("running model for the " + i + " th time");
			mcm.runModel();
			//recapture results
			mcm.writeResult();
		}
	}

	public void setMonteCarloParameters(int nInterval)
	{
		this.nInterval = nInterval;
		//set the Monte Carlo parameters of the river model
		mcm.setMonteCarloParameters(nInterval);
	}

	public void setParameter(){}








	//simple sets
	public void setFileLoggers(FileLogger fl, FileLogger flSummary){this.fl = fl;this.flSummary = flSummary;}
	public void setNumberOfSimulations(int nInterval){this.nInterval = nInterval;}
	public void setMonteCarloModel(MonteCarloModel mcm){this.mcm = mcm;}



}
