package uncertaintyAnalysis;

public abstract class MonteCarloModel 
{
	//set up an array of combinations for use in setting latin hypercube-derived random values
	//the cumulative probability is divided into iInterval number of intervals between 0 and 1
	//each interval is randomly assigned an integer
	//when the model is run, the run number (1 to iInterval) will be used to pick the input parameters
	//The since the interval numbers were assigned randomly, a given run number combines
	//parameters from various parts of the interval from 0 to 1
	public void setMonteCarloParameters(int iInterval){}
	//write headings for output file
	public void writeOutputHeadings(){}
	public void writeAveragedParameterOutputHeadings(){}
	public void writeMedianParameterOutputHeadings(){}
	//choose values for a specific run (run # interval)
	public void setVariableParametersForAMonteCarloRun(int interval){}
	//choose values for the averaged-parameter MonteCarlo run
	public void setAveragedParametersForAMonteCarloRun(){}
	//choose values for the median-parameter MonteCarlo run
	public void setMedianParametersForAMonteCarloRun(){}
    //eliminate any old outputs before a new monte carlo run
	public void blankTheOutputString(){}
	//eliminate any stored data (if applicable)
	public void reNewConcentrationDistributions(){}
	//run the model for the parameter choices established by:
	//   setting up the problem with setMonteCarloParameters
	//   then choosing a set of parameters with setVariableParameter
	public void runModel(){}
	//write results to a fileLogger (within the monte carlo model)
	public void writeResult(){}
	//write average parameter result
	public void writeAveragedParameterResult(){}
	public void writeMedianParameterResult(){}
	
	
	
	
}
