package util;

//a class to expand the length of arrays
public class ArrayExpander 
{
   //number of places to add to array
   //iIncrement = 1 adds one place, so that there are no extra unfilled places in the array
   //Consequently, sArray.length can be used to get the number of filled places in the array
   //              and sArray.length equals iCount
   //iIncrement > 1 adds more places, count must be kept in iCount; 
   //			  sArray.length is dimensioning not equal to the number of filled places
   private int iIncrement=1;
   private int iCount;
   
   public ArrayExpander(){}
   
   //add a new point to a string array
   public String[] addAPoint(String[] sArray, String sAddedPoint, int iCount)
   {
	 this.iCount = iCount;
	 
	 if (iCount<sArray.length)
	 {
		 //there is sufficient room to add a point
		 sArray[this.iCount] = sAddedPoint;
		 this.iCount++;
	 }
	 else
	 {
		 //increase the size of the array
		 
		 String[] sTemp = sArray;
		 //save the original data
		 for (int i=0;i<this.iCount;i++)
		 {
			sTemp[i] = sArray[i]; 
		 }
		 //create new array
		 sArray = new String[this.iCount + iIncrement];
		 //load the results into the new array
		 for (int i=0;i<this.iCount;i++)
		 {
			 sArray[i] = sTemp[i];
		 }
		 //add the new point
		 sArray[this.iCount] = sAddedPoint;
		 this.iCount++;
	 }
	 return sArray;
   }
   
   
   
   //sets
   public void setIncrement(int iIncrement){this.iIncrement = iIncrement;}
	
   //gets
   public int getNumberOfElements(){return this.iCount;}
}
