package util;

import java.util.Calendar;

public class CalendarClock 
{
	Calendar rT;
	  public CalendarClock()
	  {
	     initial();
	  }
	  void initial()
	  {
	    //generate new calendar
	    rT = Calendar.getInstance();
	  }

	  public CalendarClock(int year, String threeLetterMonth, int day, int hour, int minute, int second)
	  {
	    initial();
	    setAll(year,threeLetterMonth,day,hour,minute,second);
	  }

	  public void setAll(int year, int month, int day, int hour, int minute, int second)
	  {
	    //input month assumed to run from 1 to 12 (subtract 1 for the innane 0 to 11 that is used in the Calendar Class)
	    rT.set(year,month-1,day,hour,minute,second);
	  }

	  public void setAll(int year, String threeLetterMonth, int day, int hour, int minute, int second)
	  {
	    int imonth=-1;

	    //following the rediculous comupter science practice of numbering the first array element
	    //as 0, rather than the sensible 1,  January is month 0, February is month 1, etc
	    if (threeLetterMonth.toUpperCase().equals("JAN")){imonth =0;}
	    else if (threeLetterMonth.toUpperCase().equals("FEB")) {imonth=1;}
	    else if (threeLetterMonth.toUpperCase().equals("MAR")) {imonth=2;}
	    else if (threeLetterMonth.toUpperCase().equals("APR")) {imonth=3;}
	    else if (threeLetterMonth.toUpperCase().equals("MAY")) {imonth=4;}
	    else if (threeLetterMonth.toUpperCase().equals("JUN")) {imonth=5;}
	    else if (threeLetterMonth.toUpperCase().equals("JUL")) {imonth=6;}
	    else if (threeLetterMonth.toUpperCase().equals("AUG")) {imonth=7;}
	    else if (threeLetterMonth.toUpperCase().equals("SEP")) {imonth=8;}
	    else if (threeLetterMonth.toUpperCase().equals("OCT")) {imonth=9;}
	    else if (threeLetterMonth.toUpperCase().equals("NOV")) {imonth=10;}
	    else if (threeLetterMonth.toUpperCase().equals("DEC")) {imonth=11;}

	    //set em.
	    rT.set(year,imonth,day,hour,minute,second);
	  }

	  public void addSeconds(double seconds)
	  {
	    //adding is done in milleseconds to have more precision
	    rT.add(Calendar.MILLISECOND,(int)(seconds*1000));
	  }

	  public void addDays(int iDays) {rT.add(Calendar.DATE,iDays);}
	  public void addMonths(int iMonths) {rT.add(Calendar.MONTH,iMonths);}
	  public void addYears(int iYears) {rT.add(Calendar.YEAR,iYears);}

	  public double timeDifferenceSeconds(CalendarClock cc)
	  {
	    //determine the difference between this date/time and one passed in (cc)
	    //results in seconds
	    long timeCC = cc.getTimeInMilles();
	    long timeThis = this.getTimeInMilles();

	    return (double)(timeCC - timeThis)/1000;
	  }

	  public void removeSeconds(double seconds)
	  {
	    //subtracting is done in milleseconds to have more precision
	    rT.add(Calendar.MILLISECOND,(int)(seconds*(-1000)));
	  }

	  public long getTimeInMilles(){return rT.getTimeInMillis();}
	  public double getSeconds() {return (double)rT.get(Calendar.SECOND);}
	  public int getMinutes() {return rT.get(Calendar.MINUTE);}
	  public int getHours() {return rT.get(Calendar.HOUR_OF_DAY);}
	  public int getDay() {return rT.get(Calendar.DATE);}
	  public int getMonth() {/*one must be added because of ridiculous computer science practice */ return rT.get(Calendar.MONTH) + 1;}
	  public int getYear() {return rT.get(Calendar.YEAR);}

	  public String getThreeLetterMonth()
	  {
	    int imonth = rT.get(Calendar.MONTH);

	    //following the ridiculous comupter science practice of numbering the first array element
	    //as 0, rather than the sensible 1,  January is month 0, February is month 1, etc
	    if (imonth==0){return "Jan";}
	    else if (imonth==1) {return "Feb";}
	    else if (imonth==2) {return "Mar";}
	    else if (imonth==3) {return "Apr";}
	    else if (imonth==4) {return "May";}
	    else if (imonth==5) {return "Jun";}
	    else if (imonth==6) {return "Jul";}
	    else if (imonth==7) {return "Aug";}
	    else if (imonth==8) {return "Sep";}
	    else if (imonth==9) {return "Oct";}
	    else if (imonth==10) {return "Nov";}
	    else if (imonth==11) {return "Dec";}
	    else { return "";}
	  }
	  
	  /**
	   * getDateTimeString   return date and time in a string for use in output files
	   * @return
	   */
	  public String getDateTimeString()
	  {
		  String sOut = "";
		  
		 
          sOut = sOut + this.getYear() + "-"
                  + this.getThreeLetterMonth() + "-"
                  + this.getDay() + " "
                  + this.getHours() + "h-"
                  + this.getMinutes() + "m-"
                  + this.getSeconds() + "s";	
          
          return sOut;
	  }
	  
}
