package util;


import java.io.FileOutputStream;
import java.io.PrintWriter;

public class FileLogger 
{
	 
	  private CalendarClock cc;
	  private String sLogFile;
	  private String sShortFileName;
	  private String sModelName;
	  private String sFileExtension;
	  private boolean bUseCalendarInName;
	  private boolean bFileAssembled;
	  private boolean bWriteFile;

	  
	  public FileLogger()
	  {
		  initial();
	  }
	  
	  //use a simple output file name
	  public FileLogger(String fileName) 
	  {
		  initial();
		  sLogFile = fileName;
		  bFileAssembled = true;
	  }
	  
	  

	  //start with the elements needed to assemble the output file name
	  public FileLogger(String sModelName, String sShortFileName, String sFileExtension, boolean bUseCalendarInName)
	  {
		 initial();
		 //save the components 
		 this.sModelName = sModelName;
		 this.sFileExtension = sFileExtension;
		 this.sShortFileName = sShortFileName;
		 this.bUseCalendarInName = bUseCalendarInName;
		 //put the file together
		 assembleOutputFile();
	  }
	  
	  private void initial()
	  {
		  sLogFile = "";
		  sShortFileName = "";
		  sModelName = "";
		  sFileExtension = "";
		  bUseCalendarInName = false;
		  bFileAssembled = false;
		  bWriteFile = true;
	  }
	  
	  //assemble output file name
	  public void assembleOutputFile()
	  {
		//start with a clean slate  
		sLogFile = "";
		if (sShortFileName!="")
		{
			if (sModelName!=""){sLogFile = sShortFileName + "-" + sModelName;}
			else {sLogFile = sShortFileName + "";}
		}
		else {sLogFile = sModelName;}
			
		if (bUseCalendarInName)
		{
		    //embed the date into the file name
			cc = new CalendarClock();
			sLogFile = sLogFile + " " + cc.getYear() + "-"
					            + cc.getThreeLetterMonth() + "-"
					            + cc.getDay()  + "-"
					            + cc.getHours() + " hours "
					            + cc.getMinutes() + " min "
					            + cc.getSeconds() + " sec";			
		}
		//add the file extension
		
		if (sFileExtension.charAt(0)!='.'){sFileExtension = '.' + sFileExtension;} 
		
		sLogFile = sLogFile + sFileExtension;
		bFileAssembled = true;
	  }
	  
	  
	  int iLogCount = 0;
	  FileOutputStream fileOutputOver;
	  PrintWriter outputStreamOver;
	  /**
	   * logMessageOverWrite   write out a set of messages that completely overwrite existing file contents
	   * @param message        message to write out
	   */
	  public void logMessageOverWrite(String message)
	  {
		  try
		    {
		      //make sure file name is available	
		      if (!bFileAssembled){assembleOutputFile();}
		      if (bWriteFile)
		      {	  
		        //open up the Java apparatus needed to write
		    	if (iLogCount==0)
		    	{	
		          fileOutputOver = new FileOutputStream(sLogFile, true);
		          outputStreamOver = new PrintWriter(fileOutputOver);
		          iLogCount++;
		    	}
		        outputStreamOver.println(message);
		      }  
		    }
		    catch (Exception ex)
		    {
		      System.out.println(ex.getMessage());
		    }
 
	  }
	  
	  /**
	   * openOverWriteFile  open the file to be overwritten
	   */
	  public void openOverWriteFile()
	  {
		  try
		    {
		      //make sure file name is available	
		      if (!bFileAssembled){assembleOutputFile();}
		      if (bWriteFile)
		      {	  
		        //open up the Java apparatus needed to write
		    	if (iLogCount==0)
		    	{	
		          fileOutputOver = new FileOutputStream(sLogFile, false);
		          outputStreamOver = new PrintWriter(fileOutputOver);
		          iLogCount++;
		    	}
		      }  
		    }
		    catch (Exception ex)
		    {
		      System.out.println(ex.getMessage());
		    }		  
	  }
	  
	  /*
	   * closeOverWriteFile  close the file to be overwritten
	   */
	  public void closeOverWriteFile()
	  {
		  try
		    {
		      //make sure file name is available	
		      if (!bFileAssembled){assembleOutputFile();}
		      if (bWriteFile)
		      {	  
		        outputStreamOver.close();
		        fileOutputOver.close();
		      }  
		    }
		    catch (Exception ex)
		    {
		      System.out.println(ex.getMessage());
		    }
	  }
	  
	  
	  
	  /**
	   * file logger for appending to existing file
	   * @param message    message to be written to file
	   */
	  public void logMessage(String message)
	  {
	    try
	    {
	      //make sure file name is available	
	      if (!bFileAssembled){assembleOutputFile();}
	      if (bWriteFile)
	      {	  
	        //open up the Java apparatus needed to write
	        FileOutputStream fileOutput = new FileOutputStream(sLogFile, true);
	        PrintWriter outputStream = new PrintWriter(fileOutput);
	        outputStream.println(message);
	        outputStream.close();
	        fileOutput.close();
	      }  
	    }
	    catch (Exception ex)
	    {
	      System.out.println(ex.getMessage());
	    }

	  }

	  //write out a string array
	  public void logMessage(String[] mArray)
	  {
		 String logMessage = "";
		 for (int i=0;i<mArray.length;i++) {logMessage = logMessage + mArray[i] + ", ";}
		 logMessage(logMessage);
	  }
	  
	 private String arrayToString(String[] lineArray)
	 {
			String sOut="";
			for (int i=0;i<lineArray.length;i++){sOut = sOut + lineArray[i] + ", ";}
			return sOut;
	 }
		
	  public void setModelName(String sModelName){this.sModelName = sModelName;}
	  public void setShortFileName(String sShortFileName){this.sShortFileName = sShortFileName;}
	  public void setFileExtension(String extension){this.sFileExtension = extension;}
	  public void setWriteFile(boolean b){this.bWriteFile = b;}
	  public void useCalendarInName(boolean bUse){this.bUseCalendarInName = bUse;}
	  
}
