package util;

/**
 * utility to modify the extension of a file
 * 
 * @author Jim Weaver
 * 
 * 11-14-2013
 *
 */
public class FileModifier 
{
	private String sOutputFileTime;
	
	public FileModifier()
	{
		sOutputFileTime="";
	}
	
	
	//sFileAndPathName = input file name
	//iNDots = number of dots in file extension fileName.PVIScreen.csv = 2 dots
	//(ex:  PVIScreen.csv is the sFileType and contains one of the dots, the other is attached to the as: fileName.)
	//sNewFileType = new file type to be appended to input file name (sFileAndPathName)
	//bAddDateStamp = boolean to add or not date stamp in output file
	public String getOutputFileAndPathName(String sFileAndPathName, int iNDots, String sFileType, boolean bAddDateStamp)
	{
	       char c;
		   String sNew="";
		   int iIndex;
		   int iCount = 0;
		   
		   //parse and remove extension, add new extension
		   int iLength = sFileAndPathName.length();
		   iIndex = iLength;
		   for (int i=iLength-1;i>0;i--)
		   {	   
			   //remove second dot (PVIScreen uses a double extension:  *.PVIScreen.csv for input)
			   //remove third dot (PVIScreen uses a triple extension for output *.PVIScreen.Result.csv)
			   c=sFileAndPathName.charAt(i);
			   if (c == '.')
			   {
				 //found a dot on the RHS
				 if (iCount==iNDots-1)
				 {	 
				   iIndex = i;
				   break;
				 }
				 iCount++;
			   }
		   }
		   
		   //construct new name
		   for (int i=0;i<iIndex;i++)
		   {
			   sNew = sNew + sFileAndPathName.charAt(i);
		   }
		   
		   //add the date stamp if called for
		   if (bAddDateStamp)
		   {
			   if (sOutputFileTime.equalsIgnoreCase("")){this.setTimeStamp();}
		 	   sNew = sNew + sOutputFileTime;
		   }
		   
		   //add dot
		   sNew = sNew + ".";
		   
		   //add new extension
		   sNew = sNew + sFileType;
		   
		   return sNew;
	 }
	
	 //remove time stamp and all extensions
	 public String removeExtensionAndTimeStamp(String sOutputFileName){return removeTimeStamp(sOutputFileName);}
	 
	 
	 public String removeTimeStamp(String sFileName)
	 {
		int iCount = 0;
		char c;
		
		//find first space working from right to left
		//the first space marks the beginning point of time stamp
		//parse and remove extension, add new extension
		int iLength = sFileName.length();
		int iIndex = iLength;
		for (int i=iLength-1;i>0;i--)
		{	   
		   c=sFileName.charAt(i);
		   if (c == ' ')
		   {
			  iIndex = i;
			   break;
		   }
	    } 
		
		//reconstruct file name without the space or date or extension
		String sBaseName = "";
		for (int i=0;i<iIndex;i++)
		{
			sBaseName = sBaseName + sFileName.charAt(i);
		}
		
		return sBaseName;
		
	 }
	
	 public void setTimeStamp()
	 {
		 //set and save the time and date
	       CalendarClock cc = new CalendarClock();
	 	   sOutputFileTime = " " + cc.getYear() + "-"
	 		                        + cc.getThreeLetterMonth() + "-"
	 		                        + cc.getDay() + "-"
	 		                        + cc.getHours() + "h-"
	 		                        + cc.getMinutes() + "m-"
	 		                        + cc.getSeconds() + "s";
	 }
}
