package util;

public class MergeSort 
{
	 
	    private double[] dArray;
	    private double[] dTemp;
	    private String[] sArray;
	    private String[] sTemp;
	    private double[] dArraySort;
	    private double[] dTempSort;
	    private int iLength;
	 
	    public static void main(String a[])
	    {
	         
	        double[] dInputArr = {45,23,11,89,77,98,4,28,65,43};
	        String[] sInputArr = {"four","two","one","eight","seven","nine","four","two","six","four"};
	        for(int i=0;i<dInputArr.length;i++)
	        {
	            System.out.print(dInputArr[i]);
	            
	            System.out.print(" ");
	        }
	        System.out.println(" ");
	        for(int i=0;i<dInputArr.length;i++)
	        {
	             
	            System.out.print(sInputArr[i]);
	            System.out.print(" ");
	        }
	        System.out.println("");
	        MergeSort ms = new MergeSort();
	        ms.sortWithDependentString(dInputArr,sInputArr);
	        for(int i=0;i<dInputArr.length;i++)
	        {
	            System.out.print(dInputArr[i]);
	            System.out.print(" ");
	        }
	        System.out.println(" ");
	        for(int i=0;i<dInputArr.length;i++)
	        {
	            System.out.print(sInputArr[i]);
	            System.out.print(" ");
	        }
	        
	    }
	     
	    public double[] sort(double[] dArray) 
	    {
	        this.dArray = dArray;
	        this.iLength = dArray.length;
	        this.dTemp = new double[iLength];
	        doMergeSort(0, iLength - 1);
	        return dArray;
	    }
	 
	    private void doMergeSort(int lowerIndex, int higherIndex) 
	    {
	         
	        if (lowerIndex < higherIndex) 
	        {
	            int middle = lowerIndex + (higherIndex - lowerIndex) / 2;
	            // Below step sorts the left side of the array
	            doMergeSort(lowerIndex, middle);
	            // Below step sorts the right side of the array
	            doMergeSort(middle + 1, higherIndex);
	            // Now merge both sides
	            mergeParts(lowerIndex, middle, higherIndex);
	        }
	    }
	 
	    private void mergeParts(int iLow, int iMid, int iHigh) 
	    {
	 
	        for (int i=iLow;i<= iHigh;i++) {dTemp[i] = dArray[i];}
	        int i = iLow;
	        int j = iMid + 1;
	        int k = iLow;
	        while (i <= iMid && j <= iHigh) 
	        {
	            if (dTemp[i] <= dTemp[j]) 
	            {
	                dArray[k] = dTemp[i];
	                i++;
	            } 
	            else 
	            {
	                dArray[k] = dTemp[j];
	                j++;
	            }
	            k++;
	        }
	        while (i <= iMid) 
	        {
	            dArray[k] = dTemp[i];
	            k++;
	            i++;
	        }
	 
	    }
	    
	    
	    
	    
	    
	    //
	    // Merge Sort With Dependent String
	    //
	    
	    //dArray to sort
	    //sArray string array to reorder according to dArray
	    //(sArray is carried along with dArray)
	    public void sortWithDependentString(double[] dArray, String[] sArray) 
	    {
	        this.dArray = dArray;
	        this.sArray = sArray;
	        this.iLength = dArray.length;
	        this.dTemp = new double[iLength];
	        this.sTemp = new String[iLength];
	        doMergeSortWithDependentString(0, iLength - 1);
	    }
	 
	    private void doMergeSortWithDependentString(int lowerIndex, int higherIndex) 
	    {
	         
	        if (lowerIndex < higherIndex) 
	        {
	            int middle = lowerIndex + (higherIndex - lowerIndex) / 2;
	            // Below step sorts the left side of the array
	            doMergeSortWithDependentString(lowerIndex, middle);
	            // Below step sorts the right side of the array
	            doMergeSortWithDependentString(middle + 1, higherIndex);
	            // Now merge both sides
	            mergePartsWithDependentString(lowerIndex, middle, higherIndex);
	        }
	    }
	 
	    private void mergePartsWithDependentString(int iLow, int iMid, int iHigh) 
	    {
	 
	        for (int i=iLow;i<= iHigh;i++) {dTemp[i] = dArray[i]; sTemp[i]=sArray[i];}
	        int i = iLow;
	        int j = iMid + 1;
	        int k = iLow;
	        while (i <= iMid && j <= iHigh) 
	        {
	            if (dTemp[i] <= dTemp[j]) 
	            {
	                dArray[k] = dTemp[i];
	                sArray[k] = sTemp[i];
	                i++;
	            } 
	            else 
	            {
	                dArray[k] = dTemp[j];
	                sArray[k] = sTemp[j];
	                j++;
	            }
	            k++;
	        }
	        while (i <= iMid) 
	        {
	            dArray[k] = dTemp[i];
	            sArray[k] = sTemp[i];
	            k++;
	            i++;
	        }
	 
	    }
	    //
	    // Merge Sort With Dependent double
	    //
	    
	    //dArray to sort
	    //sArray string array to reorder according to dArray
	    //(sArray is carried along with dArray)
	    public void sortWithDependentDouble(double[] dArrayToSortBy, double[] dArrayToSort) 
	    {
	        this.dArray = dArrayToSortBy;
	        this.dArraySort = dArrayToSort;
	        this.iLength = dArrayToSortBy.length;
	        this.dTemp = new double[iLength];
	        this.dTempSort = new double[iLength];
	        doMergeSortWithDependentDouble(0, iLength - 1);
	    }
	 
	    private void doMergeSortWithDependentDouble(int lowerIndex, int higherIndex) 
	    {
	         
	        if (lowerIndex < higherIndex) 
	        {
	            int middle = lowerIndex + (higherIndex - lowerIndex) / 2;
	            // Below step sorts the left side of the array
	            doMergeSortWithDependentDouble(lowerIndex, middle);
	            // Below step sorts the right side of the array
	            doMergeSortWithDependentDouble(middle + 1, higherIndex);
	            // Now merge both sides
	            mergePartsWithDependentDouble(lowerIndex, middle, higherIndex);
	        }
	    }
	 
	    private void mergePartsWithDependentDouble(int iLow, int iMid, int iHigh) 
	    {
	 
	        for (int i=iLow;i<= iHigh;i++) {dTemp[i] = dArray[i]; dTempSort[i]=dArraySort[i];}
	        int i = iLow;
	        int j = iMid + 1;
	        int k = iLow;
	        while (i <= iMid && j <= iHigh) 
	        {
	            if (dTemp[i] <= dTemp[j]) 
	            {
	                dArray[k] = dTemp[i];
	                dArraySort[k] = dTempSort[i];
	                i++;
	            } 
	            else 
	            {
	                dArray[k] = dTemp[j];
	                dArraySort[k] = dTempSort[j];
	                j++;
	            }
	            k++;
	        }
	        while (i <= iMid) 
	        {
	            dArray[k] = dTemp[i];
	            dArraySort[k] = dTempSort[i];
	            k++;
	            i++;
	        }
	 
	    }
 
}
