package util;

/**
 * NameConstants   names for raw input lines
 * @author Jim Weaver
 * 1-1-2014
 */
public class NameConstants 
{

	
	//constants for file extensions
	public final String s_Extension_Input =  "pvi";
	public final String s_Extension_Results = "PVIScreen.Results.csv";
	public final String s_Extension_HTML = "PVIScreen.Results.csv.htm";

	//number of 'dots' in the extension type:   1 plus the number appearing in the extension name
	//(i.e., 3 for PVIScreen.Results.csv has two dots in the name above so add one more
	public final int i_Extension_Input_Dots = 1;
	public final int i_Extension_Results_Dots = 3;
	public final int i_Extension_HTML_Dots = 4;
    
	
	/*
	//choices prior to 3-23-2017, jww
	//constants for file extensions
	public final String s_Extension_Input =  "PVIScreen.csv";
	public final String s_Extension_Results = "PVIScreen.Results.csv";
	public final String s_Extension_HTML = "PVIScreen.Results.csv.htm";

	//number of 'dots' in the extension type:   1 plus the number appearing in the extension name
	//(i.e., 3 for PVIScreen.Results.csv has two dots in the name above so add one more
	public final int i_Extension_Input_Dots = 2;
	public final int i_Extension_Results_Dots = 3;
	public final int i_Extension_HTML_Dots = 4;
	 */


	//constants for the input type names
	public final String s_VALUEINPUT = "ValueInput";
	public final String s_CHEMICALINPUT = "ChemicalInput";
	public final String s_CONTROLSTRING = "ControlString";
	public final String s_CONTROL2STRING = "Control2String";
	public final String s_CONTROL3STRING = "Control3String";    
	public final String s_CONTROLSTRINGVALUE = "ControlStringValue";
	public final String s_CONTROL2STRINGVALUE = "Control2StringValue";
	public final String s_CONTROLSTRINGCHOICE = "ControlStringChoice";
	public final String s_CONTROLCHEMICALMANAGEMENT = "ControlChemicalManagement";
	public final String s_CONTROLRISKINPUT = "Risk";
	public final String s_CONTROLSCREENINGLEVELINPUT = "ScreeningLevel";
	public final String s_CONTROLHEADING = "ControlHeading";

	//constants for the ALL hbox elements (must match the order of addition to the hbox)
	public final   int int_INPUTTYPE = 0;
	public final   int int_COUNT = 1;

	//most containers value, chemical 
	public final   int int_CBDISTRIBUTION = 2;
	public final   int int_QUALIFIER = 3;
	public final   int int_DESCRIPTION = 4;
	public final   int int_DESCRIPTION2 = 5;
	public final   int int_VALUE = 6;
	public final   int int_UNIT = 7;
	public final   int int_FREQUENCY = 8;
	public final   int int_TABNAME = 9;
	public final   int int_DATAGROUP = 10;
	public final   int int_PREVIOUSDISTRIBUTION = 11;
	public final   int int_CHANGETOCOME = 12;
	public final   int int_UNITTYPE = 13;
	public final   int int_OUTPUTDESTINATION = 14;

	//radio button names
	public final String s_Radio_ExistingInput = "Existing Input";
	public final String s_Radio_Results = "Previous Results";

	//risk
	public final int int_RISK_CHEMICAL = 2;
	public final int int_RISK_LEVEL = 3;
	public final int int_RISK_LEVEL_CONC = 4;
	public final int int_RISK_LEVEL_UNIT = 5;
	public final int int_RISK_HQ = 6;
	public final int int_RISK_HQ_CONC = 7;
	public final int int_RISK_HQ_UNIT = 8;

	//constants for controlstringchoice input box
	public final   int int_CHOICEDESCRIPTION = 2;
	public final   int int_CHOICEDESCRIPTION2 = 3;
	public final   int int_CHOICECHOICEBOX = 4;
	public final   int int_CHOICETABNAME = 5;
	public final   int int_CHOICEDATAGROUP = 6;
	public final   int int_CHOICECOUNT = 7;
	public final   int int_CHOICEOUTPUTDESTINATION = 8;

	//constants for controlchemicalmanagement
	public final   int int_CCMAddRemove = 2;
	public final   int int_CMMCHOICE = 3;
	public final   int int_CMMCHECK = 4;

	//constants for the controlscreeninglevel
	public final   int int_CSLChemical = 2;
	public final   int int_CSLType = 0;
	public final   int int_CCLValue = 4;
	public final   int int_CCLUnit = 5;
	public final   int int_CSLOUTPUTDESTINATION = 12;

	//constants for the hbox controls
	public final   int int_HEIGHT = 25;

	//constants for navigation button names
	public final String s_ButtonInput = "Select File";
	public final String s_ButtonEdit = "View/Edit Input";
	public final String s_ButtonRun = "Run PVIScreen";
	public final String s_ButtonSave = "Prepare to Run";
	public final String s_ButtonSchematic = "View Schematic";
	public final String s_ButtonResults = "Results";
	public final String s_ButtonReport = "Write Report";
	public final String s_ButtonAbout = "About";
	public final String s_ButtonExit = "Exit";

	//styles for the disabled/enabled navigation buttons
	public final String s_StyleDisable = "-fx-font: 13 arial; -fx-base: #d3def5;";
	public final String s_StyleEnable = "-fx-font: 13 arial; -fx-base: #ccffcc;";

	//distribution types for input controls
	public final   String dist_DISTRIBUTION = "Distribution";
	public final   String dist_CONSTANT = "Constant";
	public final   String dist_UNIFORM = "Uniform";

	//(to accomodate the string "variable" used in old input files -- same as "Uniform"
	public final   String dist_VARIABLE = "Variable";
	public final   String dist_TRIANGULAR = "Triangular";
	public final   String dist_TNORMAL = "Truncated Normal";

	//Air Exchange default options
	public final   String s_Air_Exchange_Full = "Full";
	public final   String s_Air_Exchange_High = "High (Drafty)";
	public final   String s_Air_Exchange_Mod = "Moderate";
	public final   String s_Air_Exchange_Low = "Low (Tight)";

	//input tab names
	public final   String tab_IdentificationAndOptions = "Identification & Options";
	public final   String tab_BuildingAndFoundation = "Building & Foundation";
	public final   String tab_Chemicals = "Chemicals";
	public final   String tab_Risk = "Risk";
	public final   String tab_VadoseZone = "Vadose Zone";
	public final   String tab_OilZone = "Oil Zone";
	public final   String tab_OilZoneContinuer = "Oil Zone (cont.)";
	public final   String tab_Aquifer = "Aquifer";
	public final   String tab_SuggestedValues = "Suggested Values";
	public final   String tab_AirFlow = "Air Flow and Oxygen";
	public final   String tab_Control = "Model Control";
	public final   String tab_ScreeningLevel = "Screening Levels";
	public final   String tab_InputDataError = "Input Data Error!";
	public final   String tab_ConcentrationAdjustment = "Concentration Adjustment";

	//systemDataFileNames
	public final   String file_UserChosenFileForOutput = "User Chosen File";
	public final   String file_ChemicalData = "src/systemData/01ChemicalProperties.csv";
	public final   String file_HenrysConstantData = "src/systemData/02ChemicalProperties.csv";
	public final   String file_ChemicalRiskData = "src/systemData/03ChemicalProperties.csv";
	public final   String file_SuggestedValues = "src/systemData/06SuggestedValues.csv";
	public final   String file_ParameterChoices = "src/systemData/05ParameterChoices.csv";

	//input names
	public final   String name_AirExchange = "Air Exchange Rate";

	//qualifier names
	public final   String qual_min = "min";
	public final   String qual_max = "max";
	public final   String qual_OneValue = "one value";

	//window size
	public final   double pref_WIDTH = 1200;
	public final   double pref_HEIGHT = 550;

	//canvas size
	public final   int canvas_width = 1200;
	public final   int canvas_height = 550;

	//
	public final   String s_BROWSER = "Browser";

	public NameConstants(){}
}
