package util;

import java.text.DecimalFormat;

public class OutputFormatter 
{

	public OutputFormatter(){}
	
	public String getFormattedString(double dValue)
	{
	   	//truncate output numbers
    	DecimalFormat formatterScientific = new DecimalFormat("#.##E0");
    	DecimalFormat formatterStandard = new DecimalFormat("#.##");
    	String sOutput = "";
    	
    	//use standard notation for values from 0.01 to 100.0 (especially for percentages
    	if (0.01<= dValue && dValue <= 1000.0)
    	{
    		sOutput = formatterStandard.format(dValue);
    	}
    	else if (-1000.00 <= dValue && dValue <= -0.01)
    	{
    		sOutput = formatterStandard.format(dValue);
    	}
    	else if (dValue == 0.0)
        {
           sOutput = "0.0 ";	
        }
    	else
    	{
    		//use scientific notation
    		sOutput = formatterScientific.format(dValue);
    	}
    	
    	
    	
    	return sOutput;
	}	
	
}
