package util;

public class QuickSort 
{
	 
	     
	    
	    private int iLength;
	    private double dArray[];
	     
	 
	    public void sort(double[] dArray) 
	    {
	         
	        if (dArray == null || dArray.length == 0) {return;}
	     
	        this.dArray = dArray;
	        iLength = dArray.length;
	        quickSort(0, iLength - 1);
	    }
	 
	    private void quickSort(int iLow, int iHigh) 
	    {
	         
	        int i = iLow;
	        int j = iHigh;
	        // calculate pivot number, I am taking pivot as middle index number
	        double dPivot = dArray[iLow+(iHigh-iLow)/2];
	        // Divide into two arrays
	        while (i <= j) 
	        {
	            //identify elements that are below and above pivot; then switch them   
	            while (this.dArray[i] < dPivot) {i++;}
	            while (this.dArray[j] > dPivot) {j--;}
	            if (i <= j) 
	            {
	                exchangeNumbers(i, j);
	                //move index to next position on both sides
	                i++;
	                j--;
	            }
	        }
	        // call quickSort() method recursively
	        if (iLow < j){quickSort(iLow, j);}
	        if (i < iHigh){quickSort(i, iHigh);}
	    }
	 
	    private void exchangeNumbers(int i, int j) {
	        double  dTemp = dArray[i];
	        dArray[i] = dArray[j];
	        dArray[j] = dTemp;
	    }
	     
	    public static void main(String a[]){
	         
	        QuickSort sorter = new QuickSort();
	        //double[] dInput = {24,2,45,20,56,75,2,56,99,53,12};
	        //double[] dInput = {3,1};
	        //double[] dInput = {24,2,45,20,56,75,2,56,57,58,59, 99,53,12};
	        double[] dInput = {24,2,3,4,5,45,20,56,75,2,56,57,58,59, 99,53,12};
	        for(int i=0;i<dInput.length;i++)
	        {
	            System.out.print(dInput[i]);
	            System.out.print(" ");
	        }
	        System.out.println("");
	        sorter.sort(dInput);
	        for(int i=0;i<dInput.length;i++)
	        {
	            System.out.print(dInput[i]);
	            System.out.print(" ");
	        }
	    }
	
 
}
