package util;

import java.io.File;

/**
 * Stripper   class for removing characters from strings
 *            This implementation avoids retyping code in many other applications
 * @author Jim Weaver
 * 11-15-2012
 *
 */
public class Stripper 
{

	
	public Stripper(){}
	
	
	  /**
	   * removeCharacter remove a character from a string
	   * @param c       character to remove from string
	   * @param sName   string from which to remove character
	   * @return
	   */
	  public String removeCharacter(char c,String sName)
	  {
		  String sTemp="";
		  int iNumber = sName.length();
		  for (int i=0;i<iNumber;i++)
		  {
			  if (sName.charAt(i)!=c){sTemp = sTemp + sName.charAt(i);}
		  }
		  return sTemp;
	  }
	
	  /**
	   * *equals       are two strings equal (ignoring case and spaces)?
	   *               ( %%% for typing fewer characters ### )
	   * @param sOne   First String to check
	   * @param sTwo   Second String to check
	   * @return
	   */
	  public boolean equals (String sOne, String sTwo)
	  {
		  return this.areTheyEqual(sOne, sTwo);
	  }
	  
	  /**
	   * * are They Equal   are two strings equal (ignoring case and spaces)?
	   * @param sOne   First String to check
	   * @param sTwo   Second String to check
	   * @return
	   */
	   public boolean areTheyEqual(String sOne, String sTwo)
	   {
		   return areTheyEqual(sOne,sTwo,' ');
	   }

	  
	  
	  /**
	   * are They Equal
	   * @param sOne   First String to check
	   * @param sTwo   Second String to check
	   * @param c      Character to omit from both strings
	   * @return
	   */
	  public boolean areTheyEqual(String sOne, String sTwo, char c)
	  {
		  boolean bReturn = true;
		  
		  String sTempOne = this.removeCharacter(c,sOne);
		  String sTempTwo = this.removeCharacter(c,sTwo);
		  if (sTempOne.equalsIgnoreCase(sTempTwo)){bReturn = true;}
		  else {bReturn = false;}
		  
		  return bReturn;
	  }
	  
}
