package util;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

/**
 * VersionCompilation  class to compile information about the version of each class
 * used in a model
 * @author Jim Weaver
 * 
 * 11-2-2012
 *
 */
public class VersionCompilation 
{
    private ArrayList<JavaFile> alJavaFiles;
    
	public VersionCompilation()
	{
		alJavaFiles = new ArrayList<JavaFile>();
		
		//create an entry for "VersionCompilation" itself
		this.setFileData("VersionCompilation",
				         "Version Compilation",
		                 "Development Version 0.00",
		                 "c:\\Documents and Settings\\jweaver\\workspace\\RiverModel\\src\\util\\VersionCompilation.java",
		                 "c:\\Documents and Settings\\jweaver\\workspace\\RiverModel\\bin\\util\\VersionCompilation.class");
	}

	
	//set data for a JavaFile
	//  sName = name of java file
	//  sInstantiatedName = name assigned to instantiated object upon creation
	//  sVersion = string of version information
	//  sJavaFileName = location of java file as a string
	//  sclassFileName = location of class file as a string (class file == compiled java file)
	public void setFileData(String sName, String sInstantiatedName, String sVersion, String sJavaFileName, String sClassFileName)
	{
		Boolean bNameAlready = false;
		JavaFile jf = new JavaFile();
		
		//save the inputs for the java file
		jf.setName(sName);
		jf.setInstantiatedName(sInstantiatedName);
		jf.setVersion(sVersion);
		jf.setJavaFileName(sJavaFileName);
		jf.setClassFileName(sClassFileName);
		
		//get the dates for the file names
		jf.setJavaFileDate(this.getFileDate(sJavaFileName));
		jf.setClassFileDate(this.getFileDate(sClassFileName));
		
		
		
		//check for duplication by name and instantiated name
		//(if both are the same, the JavaFile has already been logged)
		for (JavaFile jafi: alJavaFiles)
		{	
			//if the instantiated name and the class name match the object is already in the collection
			//(this happens because classes are recreated during MonteCarlo runs)
			if (jafi.getInstantiatedName().equalsIgnoreCase(jf.getInstantiatedName())  &&
				jafi.getName().equalsIgnoreCase(jf.getName())	)       {bNameAlready=true;}
		}
		
		//add file to collection if this object has not been added before
		//(necessary because some objects are recreated for each monte carlo run)
		if (bNameAlready==false){alJavaFiles.add(jf);}
	}
	

	
	/**
	 * 
	 * @param fl   FileLogger passed in.
	 * @return
	 */
	public void writeVersionInformation(FileLogger fl)
	{
		
		//get all the file data and write it to the filelogger
		for (JavaFile jf:  alJavaFiles)
		{
			String sOut = "";
			sOut = sOut + jf.getName() + ",";
			sOut = sOut + jf.getInstantiatedName() + ",";
			sOut = sOut + jf.getVersion() + ",";
			sOut = sOut + jf.getJavaFileName() + ",";
			sOut = sOut + jf.getJavaFileDate() + ",";
			sOut = sOut + jf.getClassFileName() + ",";
			sOut = sOut + jf.getClassFileDate() + ",";
			fl.logMessage(sOut);
		}
	}
	
	public void writeVersionInformationHeading(FileLogger fl)
	{
		fl.logMessage(" ");
		fl.logMessage(" ");
		fl.logMessage("Version Information");
		String sOut = "Class Name,";
		sOut = sOut + "Instantiated Name,";
		sOut = sOut + "Version,";
		sOut = sOut + "Java File Location,";
		sOut = sOut + "Java File Date,";
		sOut = sOut + "Class File Location,";
		sOut = sOut + "Class File Date,";
		fl.logMessage(sOut);
	}
	
	
	//get the date for last modification off the disk drive
	public String getFileDate(String sFileName)
	{	
		File file = new File(sFileName);
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        //test outputs
		//System.out.println("Before Format : " + file.lastModified());
		//System.out.println("After Format : " + sdf.format(file.lastModified()));
		return sdf.format(file.lastModified());
	}
	
	
	/**
	 * JavaFile  internal class for saving data on each java file in a model
	 * @author Jim Weaver
	 * 11-25-2012
	 *
	 */
	class JavaFile
	{
		//name for JavaFile
		private String sName;
		//name for instantiated object
		private String sInstantiatedName;
		//version string
		private String sVersion;
		//string for java file name
		private String sJavaFileName;
		//string for java file date
		private String sJavaDate;
		//string for class file name
		private String sClassFileName;
		//string for class file date
		private String sClassDate;
		
		
		JavaFile(){}
		
		//sets
		public void setName(String sName){this.sName = sName;}
		public void setInstantiatedName(String sInstantiatedName){this.sInstantiatedName =  sInstantiatedName;}
		public void setVersion(String sVersion){this.sVersion = sVersion;}
		public void setJavaFileName(String sJavaFileName){this.sJavaFileName= sJavaFileName;}
		public void setJavaFileDate(String sJavaDate){this.sJavaDate = sJavaDate;}
		public void setClassFileName(String sClassFileName){this.sClassFileName = sClassFileName;}
		public void setClassFileDate(String sClassDate){this.sClassDate = sClassDate;}
		
		//gets
		public String getName(){return this.sName;}
		public String getInstantiatedName(){return this.sInstantiatedName;}
		public String getVersion(){return this.sVersion;}
		public String getJavaFileName(){return this.sJavaFileName;}
		public String getJavaFileDate(){return this.sJavaDate;}
		public String getClassFileName(){return this.sClassFileName;}
		public String getClassFileDate(){return this.sClassDate;}
		
	}
}
