c**** RDTECH_MOVES
c
      subroutine rdtech_moves( ierr )
c
c-----------------------------------------------------------------------
c
c    Reads the technology fractions by equipment type for each
c    model year.
c    This version os for the file format generated by the MOVES GUI.
c
c    Argument declaration.
c     Inputs: 
c     Outputs:
c       ierr    I  error flag
c       
c-----------------------------------------------------------------------
c    LOG:
c-----------------------------------------------------------------------
c
c      03/15/12  --gwilson-- original development
c
c-----------------------------------------------------------------------
c    Include files:
c-----------------------------------------------------------------------
c
      IMPLICIT NONE

      include 'nonrdprm.inc'
      include 'nonrdio.inc'
      include 'nonrdefc.inc'
      include 'nonrdeqp.inc'
c
c-----------------------------------------------------------------------
c    Argument declarations:
c-----------------------------------------------------------------------
c
      integer*4     ierr
c
c-----------------------------------------------------------------------
c    External functions:
c-----------------------------------------------------------------------
c
c   strmin  I   returns the actual length of a string (min of 1)
c
      integer*4 strmin
c
c-----------------------------------------------------------------------
c    Local variables:
c-----------------------------------------------------------------------
c
      character*(4*MXSTR) line1, line2
      character*20        keywrd, keyin
      character*10        asctmp
      character*10        tectmp
      integer*4           irec, iyrtmp, istrt, ntch, itch, ifac, jerr
      integer*4           ntchtot, i
      real*4              tecval, hptmpb, hptmpe
      real*4              sumtec
c
c-----------------------------------------------------------------------
c   Entry point:
c-----------------------------------------------------------------------
c
c   --- set error flag ---
c
      ierr = IFAIL
      irec = 0
      ntchcd = 0
c
c  --- open the file ---
c
      open(IORTCH,file=tchfl,ERR=7008,status='UNKNOWN')
      rewind(IORTCH)
c
c  ---- find the /TECH FRAC/ keyword ----
c
      keywrd = '/MOVES TECH FRAC/'
      call fndkey( jerr, IORTCH, keywrd )
      if( jerr .NE. ISUCES ) then
        ierr = ISKIP
        goto 9999
      endif
c
c   --- read two lines, one identification, the other data ---
c
      ntchtot = 1
  111 continue
      irec = irec + 1
      read(IORTCH,8000,ERR=7000,END=7007) line1
c
c   --- look for /END/ keyword ---
c
      keyin = line1(1:20)
      call lftjst( keyin )
      call low2up( keyin )
      if( keyin .EQ. KEYEND ) goto 222
c
      read(IORTCH,8000,ERR=7000,END=7007) line2
      call spinit()
c
c   --- look for /END/ keyword ---
c
      keyin = line1(1:20)
      call lftjst( keyin )
      call low2up( keyin )
      if( keyin .EQ. KEYEND ) goto 222
c
c   --- skip if this is not an identifier record ---
c
      if( line1(6:15) .EQ. '          ' ) goto 111
c
c   --- parse the identification line ---
c
      asctmp = line1(6:15)
      read(line1(21:25),'(F5.0)',ERR=7004) hptmpb
      read(line1(26:30),'(F5.0)',ERR=7004) hptmpe
      tectmp = line1(35:44)
      call lftjst( tectmp )
      call low2up( tectmp )
c
c   --- parse the data record ---
c
      read(line2(1:5),'(I5)',ERR=7004) iyrtmp
      read(line2(35:44),'(F10.0)',ERR=7004) tecval
c
c   --- find the index into arrays for this equipment ---
c
      do ifac=1,ntchcd
         if( asctch(ifac) .EQ. asctmp .AND.
     &         iyrtch(ifac) .EQ. iyrtmp .AND.
     &                 tchhpb(ifac) .EQ. hptmpb .AND.
     &                            tchhpe(ifac) .EQ. hptmpe) then
            do i=1,ntech(ifac)
c
c   --- skip if already in list (different year) ---
c
               if( tectmp .EQ. tectyp(ifac,i) ) then
                  tchfrc(ifac,i) = tecval
                  goto 111
               endif
            enddo
c
c   --- new tech type for this equipment, add to arrays ---
c
            ntech(ifac) = ntech(ifac) + 1
            if( ntech(ifac) .GT. MXTECH ) goto 7003
            tectyp(ifac,ntech(ifac)) = tectmp
            tchfrc(ifac,ntech(ifac)) = tecval
            goto 111
          endif
      enddo
c
c  --- not found, add it to list ----
c
      ntchcd = ntchcd + 1
      if( ntchcd .GT. MXTECD ) goto 7002
      asctch(ntchcd) = asctmp
      iyrtch(ntchcd) = iyrtmp
      tchhpb(ntchcd) = hptmpb
      tchhpe(ntchcd) = hptmpe
      ntech(ntchcd)  = 1
      tectyp(ntchcd,1) = tectmp
      tchfrc(ntchcd,1) = tecval
c
c  --- get next record ---
c
      goto 111
c
c  --- entire file read ---
c
  222 continue
      close(IORTCH)
c
c   --- renormalize the technology fractions to make sure they add to
c       one, write warning if more than 5% error ---

      do 40 ntch = 1, ntchcd
c
         sumtec = 0.
c
         do 50 itch = 1, ntech(ntch)
             sumtec = sumtec + tchfrc(ntch,itch)
   50    continue
c
         if ( ABS(sumtec-1.0) .GT. 0.002 ) then
           write(IOWMSG,'(/,1X,2A)',ERR=9999) 'WARNING:  Technology ',
     &        'fractions do not add to 1.  Renormalizing...'
           write(IOWMSG,'(12X,4(A,3X))') 'Equipment', '    HP range',
     &                                    '  Year', 'Original Sum'
           write(IOWMSG,'(12X,A,2(3X,F5.0),3X,I4,3X,F6.4)') 
     &                      asctch(ntch), tchhpb(ntch), tchhpe(ntch), 
     &                      iyrtch(ntch), sumtec
           call chkwrn(jerr,IDXWTC)
           if( jerr .NE. ISUCES ) goto 9999
         endif
         do 45 itch = 1,ntech(ntch)
            if( sumtec .GT. 0. ) 
     &             tchfrc(ntch,itch) = tchfrc(ntch,itch) / sumtec
   45    continue
   40 continue
c
c  --- return ---
c
      ierr = ISUCES
      goto 9999
c
c-----------------------------------------------------------------------
c   Error messages:
c-----------------------------------------------------------------------
c
 7000 continue
      write(IOWSTD,'(/,1X,3A,I6)',ERR=9999) 
     &             'ERROR:  Reading technology fraction file ',
     &                       tchfl(:strmin(tchfl)),' at record ',irec
      write(IOWMSG,'(/,1X,3A,I6)',ERR=9999) 
     &             'ERROR:  Reading technology fraction file ',
     &                       tchfl(:strmin(tchfl)),' at record ',irec
      goto 9999
c
 7002 continue
      write(IOWSTD,'(/,1X,3A,/,9X,A,I5)',ERR=9999)
     &         'ERROR:  Number of distinct ',
     &         'technology fractions in file ', tchfl(:strmin(tchfl)),
     &         'exceeds max ',MXTECD
      write(IOWMSG,'(/,1X,3A,/,9X,A,I5)',ERR=9999)
     &         'ERROR:  Number of distinct ',
     &         'technology fractions in file ', tchfl(:strmin(tchfl)),
     &         'exceeds max ',MXTECD
      goto 9999
c
 7003 continue
      write(IOWSTD,'(/,1X,3A,/,9X,A,I5)',ERR=9999) 'ERROR:  Number of ',
     &       'technology types in technology fractions file ',
     &       tchfl(:strmin(tchfl)),'exceeds max ', MXTECH
      write(IOWMSG,'(/,1X,3A,/,9X,A,I5)',ERR=9999) 'ERROR:  Number of ',
     &       'technology types in technology fractions file ',
     &       tchfl(:strmin(tchfl)),'exceeds max ', MXTECH
      goto 9999
c
 7004 continue
      write(IOWSTD,'(/,1X,3A,/,9X,2A)',ERR=9999) 'ERROR:  Reading ',
     &         'technology fractions file ',tchfl(:strmin(tchfl)),
     &                           'Line read: ',line1(:strmin(line1))
      write(IOWMSG,'(/,1X,3A,/,9X,2A)',ERR=9999) 'ERROR:  Reading ',
     &         'technology fractions file ',tchfl(:strmin(tchfl)),
     &                           'Line read: ',line1(:strmin(line1))
      goto 9999
c
 7006 continue
      write(IOWSTD,'(/,1X,3A,/,9X,3A)',ERR=9999) 
     &       'ERROR:  Cannot find ', keywrd(:strmin(keywrd)),
     &                   ' packet','of technology fractions file ',
     &                                   tchfl(:strmin(tchfl))
      write(IOWMSG,'(/,1X,3A,/,9X,3A)',ERR=9999)
     &       'ERROR:  Cannot find ', keywrd(:strmin(keywrd)),
     &                                   keywrd(:strmin(keywrd)),
     &                   ' packet','of technology fractions file ',
     &                                   tchfl(:strmin(tchfl))
      goto 9999
c
 7007 continue
      write(IOWSTD,'(/,1X,A,/,9X,3A)',ERR=9999)
     &     'ERROR:  Unexpected end-of-file reached','reading ',
     &        'technology fractions file ', tchfl(:strmin(tchfl))
      write(IOWMSG,'(/,1X,A,/,9X,3A)',ERR=9999)
     &     'ERROR:  Unexpected end-of-file reached','reading ',
     &        'technology fractions file ', tchfl(:strmin(tchfl))
      goto 9999
c
 7008 continue
      write(IOWSTD,'(/,1X,2A)',ERR=9999) 'ERROR: Opening file ',
     &                                           tchfl(:strmin(tchfl))
      write(IOWMSG,'(/,1X,2A)',ERR=9999) 'ERROR: Opening file ',
     &                                           tchfl(:strmin(tchfl))
      goto 9999
c
 7009 continue
      write(IOWSTD,'(/,1X,3A,/,9X,2A)',ERR=9999) 'ERROR:  Reading ',
     &         'technology fractions file ',tchfl(:strmin(tchfl)),
     &                           'Line read: ',line2(:strmin(line2))
      write(IOWMSG,'(/,1X,3A,/,9X,2A)',ERR=9999) 'ERROR:  Reading ',
     &         'technology fractions file ',tchfl(:strmin(tchfl)),
     &                           'Line read: ',line2(:strmin(line2))
      goto 9999
c
c-----------------------------------------------------------------------
c   Format statements:
c-----------------------------------------------------------------------
c
 8000 format(A)
c
c-----------------------------------------------------------------------
c   Return point:
c-----------------------------------------------------------------------
c
 9999 continue
      return
      end
