package pmtotal

import (
	"fmt"
	"mwo"
)

/**
 * @algorithm
 * @owner PM 10 Calculator
 * @calculator
**/

// Initialize package-level variables, creating empty lookup tables.
func init() {
}

func StartSetup() {

}

// Complete any pending asychronous operations initiated during StartSetup().
func FinishSetup() {
	// There are no asynchronous reads, so nothing to do here.

	// Done
	fmt.Println("PM Total finished reading setup files.")
}

func contains(s []int, e int) bool {
	for _, a := range s {
		if a == e {
			return true
		}
	}
	return false
}

// Launch computation threads. Each thread reads from the inputBlocks channel and writes to the outputBlocks channel.
func StartCalculating(howManyThreads int, inputBlocks chan *mwo.MWOBlock, outputBlocks chan *mwo.MWOBlock) {
	for i := 0; i < howManyThreads; i++ {
		go calculate(inputBlocks, outputBlocks)
	}
}

func calculate(inputBlocks chan *mwo.MWOBlock, outputBlocks chan *mwo.MWOBlock) {
	for {
		b := <-inputBlocks

		var newFuelBlocks []*mwo.FuelBlock // created on demand in order to save memory

		for _, fb := range b.FuelBlocks {
			// Skip any block that doesn't have a required input pollutant
			if contains([]int{101, 102, 105, 111, 112, 115}, fb.Key.PollutantID) == false {
				continue
			}

			innerFuelBlocks := make(map[int]*mwo.FuelBlock)

			for _, e := range fb.Emissions { // For every fuel formulation's emissions...
				ff := mwo.FuelFormulations[e.FuelFormulationID]
				if ff == nil {
					fmt.Println("Unable to find fuel formulation ", e.FuelFormulationID)
					continue
				}

				emissions := make(map[int]*mwo.MWOEmission)

				ppid100 := 100*100 + fb.Key.ProcessID
				ppid110 := 110*100 + fb.Key.ProcessID

				if mwo.NeededPolProcessIDs[ppid100] && contains([]int{101, 102, 105}, fb.Key.PollutantID) {
					emissions[100] = mwo.NewEmissionScaled(e, 1)
				} else if mwo.NeededPolProcessIDs[ppid110] && contains([]int{111, 112, 115}, fb.Key.PollutantID) {
					emissions[110] = mwo.NewEmissionScaled(e, 1)
				}

				for pollutantID, e := range emissions {
					if e == nil {
						continue
					}

					// Make a FuelBlock for the pollutant if one doesn't already exist.
					// Copy everything in the key and change the key's pollutantID.
					nfb := innerFuelBlocks[pollutantID]
					if nfb == nil {
						nfb = mwo.NewFuelBlock(fb)
						nfb.Key.PollutantID = pollutantID
						nfb.Key.PolProcessID = pollutantID*100 + nfb.Key.ProcessID
						innerFuelBlocks[pollutantID] = nfb
					}

					// Add the emissions to the fuel block.
					nfb.AddEmission(e)
				}
			}

			// Add new values to the list of new fuel blocks
			for _, nfb := range innerFuelBlocks {
				if nfb.NeedsGFRE {
					// Apply any GeneralFuelRatio[Expression] at the fuel formulation level
					// No GFRE is used by the HCSpeciation calculator.
				}
				if newFuelBlocks == nil {
					newFuelBlocks = make([]*mwo.FuelBlock, 0, cap(b.FuelBlocks))
				}
				newFuelBlocks = append(newFuelBlocks, nfb)
			}
		}

		// Add new fuel blocks to the main block
		if newFuelBlocks != nil {
			for _, nfb := range newFuelBlocks {
				b.AddFuelBlock(nfb)
			}
		}

		outputBlocks <- b
	}
}
