-- Adjust the distribution within the ExtendedIdleHours table using
-- user-supplied adjustments.
-- Author Wesley Faler
-- Version 2017-09-19

drop procedure if exists spAdjustExtendedIdle;

BeginBlock
create procedure spAdjustExtendedIdle()
begin
	declare targetZoneID int default ##zoneID##;
	declare targetYearID int default ##yearID##;
	declare activityZoneID int default ##activityZoneID##;
	declare howMany int default 0;

	-- hotellingHourFraction
	set howMany=0;
	select count(*) into howMany from hotellingHourFraction where zoneID=targetZoneID;
	set howMany=ifnull(howMany,0);
	if(howMany > 0) then
		alter table ExtendedIdleHours add column dayID smallint not null default 0;
		alter table ExtendedIdleHours add column hourID smallint not null default 0;

		drop table if exists hotellingTemp;

		create table hotellingTemp like ExtendedIdleHours;
		alter table hotellingTemp drop primary key;

		update ExtendedIdleHours set dayID=mod(hourDayID,10), hourID=floor(hourDayID/10);

		insert into hotellingTemp (hourDayID,hourID,dayID,monthID,yearID,ageID,zoneID,sourceTypeID,extendedIdleHours)
		select 0 as hourDayID,0 as hourID,dayID,monthID,yearID,ageID,zoneID,sourceTypeID,
			sum(extendedIdleHours) as extendedIdleHours
		from ExtendedIdleHours
		where yearID = targetYearID and zoneID = targetZoneID
		group by monthID,yearID,ageID,zoneID,dayID
		order by null;

		delete from ExtendedIdleHours where yearID = targetYearID and zoneID = targetZoneID;

		insert into ExtendedIdleHours (hourDayID,monthID,yearID,ageID,zoneID,sourceTypeID,extendedIdleHours)
		select (o.hourID*10+o.dayID) as hourDayID,s.monthID,s.yearID,s.ageID,s.zoneID,s.sourceTypeID,
			s.extendedIdleHours*o.hourFraction as extendedIdleHours
		from hotellingTemp s
		inner join hotellingHourFraction o using (zoneID,dayID);

		drop table hotellingTemp;

		alter table ExtendedIdleHours drop column dayID;
		alter table ExtendedIdleHours drop column hourID;
	end if;

	-- hotellingAgeFraction
	set howMany=0;
	select count(*) into howMany from hotellingAgeFraction where zoneID=targetZoneID;
	set howMany=ifnull(howMany,0);
	if(howMany > 0) then
		drop table if exists hotellingTemp;

		create table hotellingTemp like ExtendedIdleHours;
		alter table hotellingTemp drop primary key;

		insert into hotellingTemp (hourDayID,monthID,yearID,ageID,zoneID,sourceTypeID,extendedIdleHours)
		select hourDayID,monthID,yearID,0 as ageID,zoneID,sourceTypeID,
			sum(extendedIdleHours) as extendedIdleHours
		from ExtendedIdleHours
		where yearID = targetYearID and zoneID = targetZoneID
		group by sourceTypeID, hourDayID, monthID, yearID, zoneID
		order by null;

		delete from ExtendedIdleHours where yearID = targetYearID and zoneID = targetZoneID;

		insert into ExtendedIdleHours (hourDayID,monthID,yearID,ageID,zoneID,sourceTypeID,extendedIdleHours)
		select s.hourDayID,s.monthID,s.yearID,o.ageID,s.zoneID,s.sourceTypeID,
			s.extendedIdleHours*o.ageFraction as extendedIdleHours
		from hotellingTemp s
		inner join hotellingAgeFraction o using (zoneID);

		drop table hotellingTemp;
	end if;

	-- HotellingHoursPerDay
	set howMany=0;
	select count(*) into howMany from hotellingHoursPerDay where zoneID=targetZoneID;
	set howMany=ifnull(howMany,0);
	if(howMany > 0) then
		alter table ExtendedIdleHours add column dayID smallint not null default 0;
		alter table ExtendedIdleHours add column hourID smallint not null default 0;

		drop table if exists hotellingTemp;

		create table hotellingTemp (
			dayID smallint not null,
			monthID smallint not null,
			yearID smallint not null,
			ageID smallint not null,
			zoneID int not null,
			hotellingHoursPerDay double not null,
			primary key (dayID,monthID,yearID,ageID,zoneID)
		);

		update hotellingHoursPerDay, dayOfAnyWeek
		set hotellingHoursPerDay = hotellingHoursPerDay * noOfRealDays
		where hotellingHoursPerDay.dayID = dayOfAnyWeek.dayID
		and hotellingHoursPerDay.zoneID = targetZoneID;

		update ExtendedIdleHours set dayID=mod(hourDayID,10), hourID=floor(hourDayID/10)
		where zoneID = targetZoneID and yearID = targetYearID;

		insert into hotellingTemp (zoneID,monthID,dayID,yearID,ageID,hotellingHoursPerDay)
		select h.zoneID,monthID,dayID,yearID,ageID, sum(case when opModeFraction>0 then extendedIdleHours/opModeFraction else 0 end) as hotellingHoursPerDay
		from ExtendedIdleHours h
		inner join HotellingActivityDistribution hac on (
			beginModelYearID <= yearID - ageID
			and endModelYearID >= yearID - ageID
			and opModeID = 200
			and hac.zoneID = activityZoneID
		)
		where yearID = targetYearID and h.zoneID = targetZoneID
		group by monthID,dayID,yearID,ageID;
 
		drop table if exists hotellingTempRatio;

		create table hotellingTempRatio like hotellingTemp;

		insert into hotellingTempRatio (yearID,ageID,zoneID,monthID,dayID,hotellingHoursPerDay)
		select a.yearID,a.ageID,a.zoneID,a.monthID,a.dayID,
			case when a.hotellingHoursPerDay > 0 then (b.hotellingHoursPerDay/a.hotellingHoursPerDay)
			else 0 end as hotellingHoursPerDay
		from hotellingTemp a
		inner join hotellingHoursPerDay b using (zoneID,dayID,yearID);

		update ExtendedIdleHours, hotellingTempRatio
		set ExtendedIdleHours.extendedIdleHours = ExtendedIdleHours.extendedIdleHours * hotellingTempRatio.hotellingHoursPerDay
		where ExtendedIdleHours.zoneID = hotellingTempRatio.zoneID
		and ExtendedIdleHours.dayID = hotellingTempRatio.dayID
		and ExtendedIdleHours.monthID = hotellingTempRatio.monthID
		and ExtendedIdleHours.ageID = hotellingTempRatio.ageID
		and ExtendedIdleHours.yearID = targetYearID
		and hotellingTempRatio.yearID = targetYearID;

		drop table hotellingTemp;
		drop table hotellingTempRatio;

		update hotellingHoursPerDay, dayOfAnyWeek
		set hotellingHoursPerDay = hotellingHoursPerDay / noOfRealDays
		where hotellingHoursPerDay.dayID = dayOfAnyWeek.dayID
		and hotellingHoursPerDay.zoneID = targetZoneID;

		alter table ExtendedIdleHours drop column dayID;
		alter table ExtendedIdleHours drop column hourID;
	end if;

	-- hotellingMonthAdjust
	update ExtendedIdleHours, hotellingMonthAdjust
	set extendedIdleHours = extendedIdleHours * monthAdjustment
	where ExtendedIdleHours.monthID = hotellingMonthAdjust.monthID
	and ExtendedIdleHours.yearID = targetYearID and ExtendedIdleHours.zoneID = targetZoneID
	and hotellingMonthAdjust.zoneID = targetZoneID;
end
EndBlock

call spAdjustExtendedIdle();
drop procedure if exists spAdjustExtendedIdle;
