-- Adjust the distribution within the HotellingHours table using
-- user-supplied adjustments.
-- Author Wesley Faler
-- Version 2017-09-19

drop procedure if exists spAdjustHotelling;

BeginBlock
create procedure spAdjustHotelling()
begin
	declare targetZoneID int default ##zoneID##;
	declare targetYearID int default ##yearID##;
	declare activityZoneID int default ##activityZoneID##;
	declare howMany int default 0;

	-- hotellingHourFraction
	set howMany=0;
	select count(*) into howMany from hotellingHourFraction where zoneID=targetZoneID;
	set howMany=ifnull(howMany,0);
	if(howMany > 0) then
		alter table HotellingHours add column dayID smallint not null default 0;
		alter table HotellingHours add column hourID smallint not null default 0;

		drop table if exists hotellingTemp;

		create table hotellingTemp like HotellingHours;
		alter table hotellingTemp drop primary key;

		update HotellingHours set dayID=mod(hourDayID,10), hourID=floor(hourDayID/10);

		insert into hotellingTemp (hourDayID,hourID,dayID,monthID,yearID,ageID,zoneID,sourceTypeID,hotellingHours)
		select 0 as hourDayID,0 as hourID,dayID,monthID,yearID,ageID,zoneID,sourceTypeID,
			sum(hotellingHours) as hotellingHours
		from HotellingHours
		where yearID = targetYearID and zoneID = targetZoneID
		group by monthID,yearID,ageID,zoneID,dayID
		order by null;

		delete from HotellingHours where yearID = targetYearID and zoneID = targetZoneID;

		insert into HotellingHours (hourDayID,monthID,yearID,ageID,zoneID,sourceTypeID,hotellingHours)
		select (o.hourID*10+o.dayID) as hourDayID,s.monthID,s.yearID,s.ageID,s.zoneID,s.sourceTypeID,
			s.hotellingHours*o.hourFraction as hotellingHours
		from hotellingTemp s
		inner join hotellingHourFraction o using (zoneID,dayID);

		drop table hotellingTemp;

		alter table HotellingHours drop column dayID;
		alter table HotellingHours drop column hourID;
	end if;

	-- hotellingAgeFraction
	set howMany=0;
	select count(*) into howMany from hotellingAgeFraction where zoneID=targetZoneID;
	set howMany=ifnull(howMany,0);
	if(howMany > 0) then
		drop table if exists hotellingTemp;

		create table hotellingTemp like HotellingHours;
		alter table hotellingTemp drop primary key;

		insert into hotellingTemp (hourDayID,monthID,yearID,ageID,zoneID,sourceTypeID,hotellingHours)
		select hourDayID,monthID,yearID,0 as ageID,zoneID,sourceTypeID,
			sum(hotellingHours) as hotellingHours
		from HotellingHours
		where yearID = targetYearID and zoneID = targetZoneID
		group by sourceTypeID, hourDayID, monthID, yearID, zoneID
		order by null;

		delete from HotellingHours where yearID = targetYearID and zoneID = targetZoneID;

		insert into HotellingHours (hourDayID,monthID,yearID,ageID,zoneID,sourceTypeID,hotellingHours)
		select s.hourDayID,s.monthID,s.yearID,o.ageID,s.zoneID,s.sourceTypeID,
			s.hotellingHours*o.ageFraction as hotellingHours
		from hotellingTemp s
		inner join hotellingAgeFraction o using (zoneID);

		drop table hotellingTemp;
	end if;

	-- HotellingHoursPerDay
	set howMany=0;
	select count(*) into howMany from hotellingHoursPerDay where zoneID=targetZoneID;
	set howMany=ifnull(howMany,0);
	if(howMany > 0) then
		alter table HotellingHours add column dayID smallint not null default 0;
		alter table HotellingHours add column hourID smallint not null default 0;

		drop table if exists hotellingTemp;

		create table hotellingTemp (
			dayID smallint not null,
			monthID smallint not null,
			yearID smallint not null,
			ageID smallint not null,
			zoneID int not null,
			hotellingHoursPerDay double not null,
			primary key (dayID,monthID,yearID,ageID,zoneID)
		);

		update hotellingHoursPerDay, dayOfAnyWeek
		set hotellingHoursPerDay = hotellingHoursPerDay * noOfRealDays
		where hotellingHoursPerDay.dayID = dayOfAnyWeek.dayID
		and hotellingHoursPerDay.zoneID = targetZoneID;

		update HotellingHours set dayID=mod(hourDayID,10), hourID=floor(hourDayID/10)
		where zoneID = targetZoneID and yearID = targetYearID;

		insert into hotellingTemp (yearID,ageID,zoneID,monthID,dayID,hotellingHoursPerDay)
		select yearID,ageID,zoneID,monthID,dayID, sum(hotellingHours) as hotellingHoursPerDay
		from HotellingHours
		where zoneID = targetZoneID
		group by monthID,dayID,yearID,ageID;

		drop table if exists hotellingTempRatio;

		create table hotellingTempRatio like hotellingTemp;

		insert into hotellingTempRatio (yearID,ageID,zoneID,monthID,dayID,hotellingHoursPerDay)
		select a.yearID,a.ageID,a.zoneID,a.monthID,a.dayID,
			case when a.hotellingHoursPerDay > 0 then (b.hotellingHoursPerDay/a.hotellingHoursPerDay)
			else 0 end as hotellingHoursPerDay
		from hotellingTemp a
		inner join hotellingHoursPerDay b using (zoneID,dayID,yearID);

		update HotellingHours, hotellingTempRatio
		set HotellingHours.hotellingHours = HotellingHours.hotellingHours * hotellingTempRatio.hotellingHoursPerDay
		where HotellingHours.ageID = hotellingTempRatio.ageID
		and HotellingHours.zoneID = hotellingTempRatio.zoneID
		and HotellingHours.dayID = hotellingTempRatio.dayID
		and HotellingHours.monthID = hotellingTempRatio.monthID
		and HotellingHours.yearID = targetYearID
		and hotellingTempRatio.yearID = targetYearID;

		drop table hotellingTemp;
		drop table hotellingTempRatio;

		update hotellingHoursPerDay, dayOfAnyWeek
		set hotellingHoursPerDay = hotellingHoursPerDay / noOfRealDays
		where hotellingHoursPerDay.dayID = dayOfAnyWeek.dayID
		and hotellingHoursPerDay.zoneID = targetZoneID;

		alter table HotellingHours drop column dayID;
		alter table HotellingHours drop column hourID;
	end if;

	-- hotellingMonthAdjust
	update HotellingHours, hotellingMonthAdjust
	set hotellingHours = hotellingHours * monthAdjustment
	where HotellingHours.monthID = hotellingMonthAdjust.monthID
	and HotellingHours.yearID = targetYearID and HotellingHours.zoneID = targetZoneID
	and hotellingMonthAdjust.zoneID = targetZoneID;
end
EndBlock

call spAdjustHotelling();
drop procedure if exists spAdjustHotelling;
