-- Adjust the distribution within the Starts table using
-- user-supplied adjustments by month, hour, sourcetype, and day.

-- Author Wesley Faler
-- Author John Covey
-- Version 2018-07-09

-- @algorithm starts = population * startsPerDayPerVehicle * ageFraction * monthAdjustment * allocationFraction
-- @owner Starts

drop procedure if exists spAdjustStarts;

BeginBlock
create procedure spAdjustStarts()
begin
	declare targetYearID int default ##yearID##;
	declare targetZoneID int default ##zoneID##;
	
	declare startsCnt int default 0;
	declare startsPerDayCnt int default 0;
	declare startsPerDayPerVehicleCnt int default 0;
	select count(*) into startsCnt from starts;
	select count(*) into startsPerDayCnt from startsPerDay;
	select count(*) into startsPerDayPerVehicleCnt from startsPerDayPerVehicle;
	
	if (startsCnt > 0 and startsPerDayPerVehicleCnt > 0) then
		insert into tempMessages (message)
			select 'WARNING : Detected that user has imported Starts and StartsPerDayPerVehicle. Only imported Starts will be used.' from dual;					

	else 
		drop table if exists tempStartsPerDay;
		CREATE TABLE tempStartsPerDay (
		  dayID smallint(6) NOT NULL DEFAULT 0,
		  sourceTypeID smallint(6) NOT NULL DEFAULT 0,
		  ageID smallint(6) NOT NULL DEFAULT 0,
		  startsPerDay double DEFAULT NULL,
		  PRIMARY KEY (sourceTypeID,ageID,dayID),
		  KEY hourDayID (dayID),
		  KEY ageID (ageID),
		  KEY sourceTypeID (sourceTypeID)
		);
		
		if (startsPerDayCnt > 0) then
			insert into tempMessages (message)
				select 'WARNING : Detected that user has imported StartsPerDay. These values will be used instead of StartsPerDayPerVehicle.' from dual;					

			insert into tempStartsPerDay (dayID, sourceTypeID, ageID, startsPerDay) 
				select dayID, sourceTypeID, ageID, startsPerDay from startsPerDay;			
		else
			insert into tempStartsPerDay (dayID, sourceTypeID, ageID, startsPerDay)
				  select distinct spdpv.dayID as dayID,
					spdpv.sourceTypeID as sourceTypeID,
					spdpv.ageID as ageID,
					sty.sourceTypePopulation * spdpv.startsPerDayPerVehicle as startsPerDay
				from StartsPerDayPerVehicle spdpv
				inner join sourceTypeYear sty on
					sty.sourceTypeID = spdpv.sourceTypeID
				where sty.yearID = targetYearID;
		
		end if;

		insert into starts (
			hourDayID, monthID, yearID, ageID,
			zoneID, sourceTypeID, starts, startsCV, isUserInput
			)

		select distinct
			(shf.hourID*10+shf.dayID) as hourDayID,
			sma.monthID as monthID,
			targetYearID as yearID,
			tspd.ageID as ageID,
			targetZoneID as zoneID,
			tspd.sourceTypeID as sourceTypeID,
			(tspd.startsPerDay * stad.ageFraction 
			   * sma.monthAdjustment *	shf.allocationFraction * doa.noOfRealDays
			   * ifnull(z.startAllocFactor, 1)) as starts,
		  0 as startsCV,
		 'N' as isUserInput
		from tempStartsPerDay tspd
		inner join SourceTypeAgeDistribution stad on
			stad.sourceTypeID = tspd.sourceTypeID
			and stad.ageID = tspd.ageID
			and stad.yearID = targetYearID
		inner join StartsMonthAdjust sma on
			sma.sourceTypeID = tspd.sourceTypeID  
		inner join StartsHourFraction shf on
			shf.sourceTypeID = tspd.sourceTypeID
			and shf.dayID = tspd.dayID
		inner join dayOfAnyWeek doa on
			doa.dayID = shf.dayID
		left join zone z on
			z.zoneID = targetZoneID;
	end if;
	drop table if exists tempStartsPerDay;
end
EndBlock

call spAdjustStarts();
drop procedure if exists spAdjustStarts;
