-- --------------------------------------------------------------------------------------
-- Convert a MOVES2014A CDM or PDM database to MOVES2017 format.
-- No changes are made to the original input database.
-- Run this script in the context of a new database.
-- Populate ##defaultdb## with the name of the default database.
-- Populate ##inputdb## with the name of the original 2014A CDM or PDM database.
--
-- Author John Covey
-- Version 2018-02-27
-- --------------------------------------------------------------------------------------

-- Copy tables in a 2014A database
create table if not exists auditlog like ##inputdb##.auditlog;
create table if not exists avft like ##inputdb##.avft;
create table if not exists avgspeeddistribution like ##inputdb##.avgspeeddistribution;
create table if not exists county like ##inputdb##.county;
create table if not exists dayvmtfraction like ##inputdb##.dayvmtfraction;
create table if not exists fuelformulation like ##inputdb##.fuelformulation;
create table if not exists fuelsupply like ##inputdb##.fuelsupply;
create table if not exists fuelsupplyyear like ##inputdb##.fuelsupplyyear;
create table if not exists fuelusagefraction like ##inputdb##.fuelusagefraction;
create table if not exists hotellingactivitydistribution like ##inputdb##.hotellingactivitydistribution;
create table if not exists hotellingagefraction like ##inputdb##.hotellingagefraction;
create table if not exists hotellinghourfraction like ##inputdb##.hotellinghourfraction;
create table if not exists hotellinghoursperday like ##inputdb##.hotellinghoursperday;
create table if not exists hotellingmonthadjust like ##inputdb##.hotellingmonthadjust;

create table if not exists hourvmtfraction like ##inputdb##.hourvmtfraction;
create table if not exists hpmsvtypeday like ##inputdb##.hpmsvtypeday;

create table if not exists hpmsvtypeyear like ##inputdb##.hpmsvtypeyear;
create table if not exists imcoverage like ##inputdb##.imcoverage;
--create table if not exists link like ##inputdb##.link;
--create table if not exists linksourcetypehour like ##inputdb##.linksourcetypehour;
create table if not exists monthvmtfraction like ##inputdb##.monthvmtfraction;
--create table if not exists offnetworklink like ##inputdb##.offnetworklink;
create table if not exists onroadretrofit like ##inputdb##.onroadretrofit;
--create table if not exists opmodedistribution like ##inputdb##.opmodedistribution;
--create table if not exists regioncounty like ##inputdb##.regioncounty;
create table if not exists roadtype like ##inputdb##.roadtype;
create table if not exists roadtypedistribution like ##inputdb##.roadtypedistribution;
create table if not exists sourcetypeagedistribution like ##inputdb##.sourcetypeagedistribution;
create table if not exists sourcetypedayvmt like ##inputdb##.sourcetypedayvmt;
create table if not exists sourcetypeyear like ##inputdb##.sourcetypeyear;
create table if not exists sourcetypeyearvmt like ##inputdb##.sourcetypeyearvmt;
create table if not exists starts like ##inputdb##.starts;

create table if not exists startshourfraction like ##inputdb##.startshourfraction;
-- alter the startshourfraction table.
alter table startshourfraction
add sourceTypeID smallint(6) NOT NULL DEFAULT 0,
drop zoneid;
alter table startshourfraction
CHANGE COLUMN sourceTypeID sourceTypeID SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '' AFTER hourID,
drop primary key,
add primary key (dayid,hourid,sourcetypeid);

create table if not exists startsmonthadjust like ##inputdb##.startsmonthadjust;
-- alter the startsmonthadjust table.
alter table startsmonthadjust
add sourceTypeID smallint(6) NOT NULL DEFAULT 0;
alter table startsmonthadjust
CHANGE COLUMN sourceTypeID sourceTypeID SMALLINT(6) NOT NULL DEFAULT 0 COMMENT '' AFTER monthID,
drop primary key,
add primary key (monthid,sourcetypeid);

-- create the startsopmodedistribution table.
CREATE TABLE startsopmodedistribution (
  dayID smallint(6) NOT NULL DEFAULT 0,
  hourID smallint(6) NOT NULL DEFAULT 0,
  sourceTypeID smallint(6) NOT NULL DEFAULT 0,
  ageID smallint(6) NOT NULL DEFAULT 0,
  opModeID smallint(6) NOT NULL DEFAULT 0,
  opModeFraction double DEFAULT NULL,
  PRIMARY KEY (dayid,hourid,sourceTypeID,ageID,opmodeid),
  KEY dayID (dayID),
  KEY hourid (hourID),
  KEY sourceTypeID (sourceTypeID),
  KEY ageID (ageID)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- create starts per day table.
-- dropping the existing table, rather than alter it.
drop table if exists startsperday;
CREATE TABLE startsperday (
  dayID smallint(6) NOT NULL DEFAULT 0,
  sourceTypeID smallint(6) NOT NULL DEFAULT 0,
  ageID smallint(6) NOT NULL DEFAULT 0,
  startsPerDay double DEFAULT NULL,
  PRIMARY KEY (sourceTypeID,ageID,dayID),
  KEY hourDayID (dayID),
  KEY ageID (ageID),
  KEY sourceTypeID (sourceTypeID)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- create starts per day per vehicle table.
drop table if exists startsperdaypervehicle;
CREATE TABLE startsperdaypervehicle (
  dayID smallint(6) NOT NULL DEFAULT 0,
  sourceTypeID smallint(6) NOT NULL DEFAULT 0,
  ageID smallint(6) NOT NULL DEFAULT 0,
  startsPerDayPerVehicle double DEFAULT NULL,
  PRIMARY KEY (sourceTypeID,ageID,dayID),
  KEY hourDayID (dayID),
  KEY ageID (ageID),
  KEY sourceTypeID (sourceTypeID)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


create table if not exists state like ##inputdb##.state;
create table if not exists year like ##inputdb##.year;

create table if not exists zone like ##inputdb##.zone;
-- alter the zone table.
alter table zone
drop startallocfactor;

create table if not exists zonemonthhour like ##inputdb##.zonemonthhour;
create table if not exists zoneroadtype like ##inputdb##.zoneroadtype;

-- Provide tables that are needed in MOVES2014A but may not have been in the 2014 database
--create table if not exists nrfuelsupply like ##inputdb##.nrfuelsupply;
-- Author Wesley Faler
-- Version 2017-09-29
-- --------------------------------------------------------------------------------------

-- Alter schema of existing tables
delete from roadType where roadTypeID in (6,7,8,9);
alter table roadType drop column rampFraction;
alter table county add column countyTypeID int not null default '1';
alter table state add column idleRegionID int not null default '1';

-- Copy tables in a MOVES2014A database
create table if not exists avft like ##inputdb##.avft;
create table if not exists avgspeeddistribution like ##inputdb##.avgspeeddistribution;
create table if not exists county like ##inputdb##.county;
create table if not exists countyyear like ##inputdb##.countyyear;
create table if not exists dayvmtfraction like ##inputdb##.dayvmtfraction;
create table if not exists driveschedulesecondlink like ##inputdb##.driveschedulesecondlink;
create table if not exists fuelformulation like ##inputdb##.fuelformulation;
create table if not exists fuelsupply like ##inputdb##.fuelsupply;
create table if not exists fuelusagefraction like ##inputdb##.fuelusagefraction;
create table if not exists hourvmtfraction like ##inputdb##.hourvmtfraction;
create table if not exists hpmsvtypeyear like ##inputdb##.hpmsvtypeyear;
create table if not exists imcoverage like ##inputdb##.imcoverage;
create table if not exists importstartsopmodedistribution like ##inputdb##.importstartsopmodedistribution;
create table if not exists link like ##inputdb##.link;
create table if not exists linksourcetypehour like ##inputdb##.linksourcetypehour;
create table if not exists monthvmtfraction like ##inputdb##.monthvmtfraction;
create table if not exists offnetworklink like ##inputdb##.offnetworklink;
create table if not exists onroadretrofit like ##inputdb##.onroadretrofit;
create table if not exists opmodedistribution like ##inputdb##.opmodedistribution;
create table if not exists regioncounty like ##inputdb##.regioncounty;
create table if not exists roadtype like ##inputdb##.roadtype;
create table if not exists roadtypedistribution like ##inputdb##.roadtypedistribution;
create table if not exists sourcetypeagedistribution like ##inputdb##.sourcetypeagedistribution;
create table if not exists sourcetypeyear like ##inputdb##.sourcetypeyear;
create table if not exists starts like ##inputdb##.starts;
create table if not exists startshourfraction like ##inputdb##.startshourfraction;
create table if not exists startsmonthadjust like ##inputdb##.startsmonthadjust;
create table if not exists startsperday like ##inputdb##.startsperday;
create table if not exists startssourcetypefraction like ##inputdb##.startssourcetypefraction;
create table if not exists state like ##inputdb##.state;
create table if not exists year like ##inputdb##.year;
create table if not exists zone like ##inputdb##.zone;
create table if not exists zonemonthhour like ##inputdb##.zonemonthhour;
create table if not exists zoneroadtype like ##inputdb##.zoneroadtype;
create table if not exists HPMSVTypeDay like ##defaultdb##.HPMSVTypeDay;
create table if not exists SourceTypeDayVMT like ##defaultdb##.SourceTypeDayVMT;
create table if not exists SourceTypeYearVMT like ##defaultdb##.SourceTypeYearVMT;
create table if not exists nrfuelsupply like ##inputdb##.nrfuelsupply;

-- Provide tables that are needed but may not have been in the MOVES2014A database
create table if not exists totalIdleFraction like ##defaultdb##.totalIdleFraction;
create table if not exists idleDayAdjust like ##defaultdb##.idleDayAdjust;
create table if not exists idleMonthAdjust like ##defaultdb##.idleMonthAdjust;
create table if not exists idleModelYearGrouping like ##defaultdb##.idleModelYearGrouping;

-- Update hotelling tables
drop table if exists hotellingHourFraction;
drop table if exists hotellingAgeFraction;
drop table if exists hotellingMonthAdjust;
drop table if exists hotellingHoursPerDay;
drop table if exists hotellingactivitydistribution;

create table if not exists hotellingHourFraction like ##inputdb##.hotellingHourFraction;
create table if not exists hotellingAgeFraction like ##inputdb##.hotellingAgeFraction;
create table if not exists hotellingMonthAdjust like ##inputdb##.hotellingMonthAdjust;
create table if not exists hotellingHoursPerDay like ##inputdb##.hotellingHoursPerDay;
create table if not exists hotellingactivitydistribution like ##inputdb##.hotellingactivitydistribution;
drop table if exists hotellingHours;

-- Copy data from the input database.
-- Errors here are ignored by the scripting engine and occur when a table
-- is not present in the input database.

insert ignore into auditlog select * from ##inputdb##.auditlog;
insert ignore into avft select * from ##inputdb##.avft;
insert ignore into avgspeeddistribution select * from ##inputdb##.avgspeeddistribution;
insert ignore into county select * from ##inputdb##.county;
insert ignore into dayvmtfraction select * from ##inputdb##.dayvmtfraction;
insert ignore into fuelformulation select * from ##inputdb##.fuelformulation;
insert ignore into fuelsupply select * from ##inputdb##.fuelsupply;
insert ignore into fuelsupplyyear select * from ##inputdb##.fuelsupplyyear;
insert ignore into fuelusagefraction select * from ##inputdb##.fuelusagefraction;
insert ignore into hotellingactivitydistribution select * from ##inputdb##.hotellingactivitydistribution;
insert ignore into hotellingagefraction select * from ##inputdb##.hotellingagefraction;
insert ignore into hotellinghourfraction select * from ##inputdb##.hotellinghourfraction;
insert ignore into hotellinghoursperday select * from ##inputdb##.hotellinghoursperday;
insert ignore into hotellingmonthadjust select * from ##inputdb##.hotellingmonthadjust;
insert ignore into hourvmtfraction select * from ##inputdb##.hourvmtfraction;
insert ignore into hpmsvtypeday select * from ##inputdb##.hpmsvtypeday;
insert ignore into hpmsvtypeyear select * from ##inputdb##.hpmsvtypeyear;
insert ignore into imcoverage select * from ##inputdb##.imcoverage;
insert ignore into monthvmtfraction select * from ##inputdb##.monthvmtfraction;
insert ignore into onroadretrofit select * from ##inputdb##.onroadretrofit;
insert ignore into roadtypedistribution select * from ##inputdb##.roadtypedistribution;
insert ignore into roadtype select * from ##inputdb##.roadtype;
insert ignore into sourcetypeagedistribution select * from ##inputdb##.sourcetypeagedistribution;
insert ignore into sourcetypedayvmt select * from ##inputdb##.sourcetypedayvmt;
insert ignore into sourcetypeyear select * from ##inputdb##.sourcetypeyear;
insert ignore into sourcetypeyearvmt select * from ##inputdb##.sourcetypeyearvmt;
insert ignore into starts select * from ##inputdb##.starts;
insert ignore into state select * from ##inputdb##.state;
insert ignore into year select * from ##inputdb##.year;
insert ignore into zone select zoneID, countyID, idleAllocFactor, SHPAllocFactor from ##inputdb##.zone;
insert ignore into zonemonthhour select * from ##inputdb##.zonemonthhour;
insert ignore into zoneroadtype select * from ##inputdb##.zoneroadtype;
insert ignore into avft select * from ##inputdb##.avft;
insert ignore into avgspeeddistribution select * from ##inputdb##.avgspeeddistribution;
insert ignore into county select * from ##inputdb##.county;
insert ignore into countyyear select * from ##inputdb##.countyyear;
insert ignore into dayvmtfraction select * from ##inputdb##.dayvmtfraction;
insert ignore into driveschedulesecondlink select * from ##inputdb##.driveschedulesecondlink;
insert ignore into fuelformulation select * from ##inputdb##.fuelformulation;
insert ignore into fuelsupply select * from ##inputdb##.fuelsupply;
insert ignore into fuelusagefraction select * from ##inputdb##.fuelusagefraction;
insert ignore into hotellingactivitydistribution select * from ##inputdb##.hotellingactivitydistribution;
insert ignore into hotellinghours select * from ##inputdb##.hotellinghours;
insert ignore into hourvmtfraction select * from ##inputdb##.hourvmtfraction;
insert ignore into hpmsvtypeyear select * from ##inputdb##.hpmsvtypeyear;
insert ignore into imcoverage select * from ##inputdb##.imcoverage;
insert ignore into importstartsopmodedistribution select * from ##inputdb##.importstartsopmodedistribution;
insert ignore into link select * from ##inputdb##.link;
insert ignore into linksourcetypehour select * from ##inputdb##.linksourcetypehour;
insert ignore into monthvmtfraction select * from ##inputdb##.monthvmtfraction;
insert ignore into offnetworklink select * from ##inputdb##.offnetworklink;
insert ignore into onroadretrofit select * from ##inputdb##.onroadretrofit;
insert ignore into opmodedistribution select * from ##inputdb##.opmodedistribution;
insert ignore into regioncounty select * from ##inputdb##.regioncounty;
insert ignore into roadtype select * from ##inputdb##.roadtype;
insert ignore into roadtypedistribution select * from ##inputdb##.roadtypedistribution;
insert ignore into sourcetypeagedistribution select * from ##inputdb##.sourcetypeagedistribution;
insert ignore into sourcetypeyear select * from ##inputdb##.sourcetypeyear;
insert ignore into starts select * from ##inputdb##.starts;
insert ignore into startshourfraction select * from ##inputdb##.startshourfraction;
insert ignore into startsmonthadjust select * from ##inputdb##.startsmonthadjust;
insert ignore into startsperday select * from ##inputdb##.startsperday;
insert ignore into startssourcetypefraction select * from ##inputdb##.startssourcetypefraction;
insert ignore into state select * from ##inputdb##.state;
insert ignore into year select * from ##inputdb##.year;
insert ignore into zone select * from ##inputdb##.zone;
insert ignore into zonemonthhour select * from ##inputdb##.zonemonthhour;
insert ignore into zoneroadtype select * from ##inputdb##.zoneroadtype;
insert ignore into HPMSVTypeDay select * from ##inputdb##.HPMSVTypeDay;
insert ignore into SourceTypeDayVMT select * from ##inputdb##.SourceTypeDayVMT;
insert ignore into SourceTypeYearVMT select * from ##inputdb##.SourceTypeYearVMT;
insert ignore into nrfuelsupply select * from ##inputdb##.nrfuelsupply;

insert ignore into hotellingHourFraction select * from ##inputdb##.hotellingHourFraction;
insert ignore into hotellingAgeFraction select * from ##inputdb##.hotellingAgeFraction;
insert ignore into hotellingMonthAdjust select * from ##inputdb##.hotellingMonthAdjust;
insert ignore into hotellingHoursPerDay select * from ##inputdb##.hotellingHoursPerDay;
insert ignore into hotellingactivitydistribution select * from ##inputdb##.hotellingactivitydistribution;

-- Check for warning or error messages
drop procedure if exists spConvert2014ACDMPDM;

BeginBlock

create procedure spConvert2014ACDMPDM()
begin
	declare howMany int default 0;
	declare isCustomDomain int default 0;

	-- No actions are needed here
end
EndBlock

call spConvert2014ACDMPDM();
drop procedure if exists spConvert2014ACDMPDM;
