-- Author Wesley Faler
-- Author John Covey
-- Version 2018-03-20

drop procedure if exists spCheckStartsImporter;

BeginBlock
create procedure spCheckStartsImporter()
begin
	-- Mode 0 is run after importing
	-- Mode 1 is run to check overall success/failure, allowing data from the default database
	-- Mode 2 is run to check overall success/failure, requiring no data from the default database
	declare mode int default ##mode##;

	-- Scale 0 is national
	-- Scale 1 is single county
	-- Scale 2 is project domain
	declare scale int default ##scale##;

	declare howMany int default 0;
	
	
	-- startsHourFraction
	set howMany=0;
	select count(*) into howMany from startsHourFraction;
	set howMany=ifnull(howMany,0);
	if(howMany > 0) then
		insert into importTempMessages (message)	
		select distinct
			case
			  when d.dayID is null then  concat('ERROR: StartsHourFraction with dayID ',s.dayID,' is unknown')
			  when hoad.hourID is null then  concat('ERROR: StartsHourFraction with hourID ',s.hourID,' is unknown')
			  when sut.sourceTypeID is null then  concat('ERROR: StartsHourFraction with sourceTypeID ',s.sourceTypeID,' is unknown')
		    else null end as message
		from startsHourFraction s
		left join ##defaultDatabase##.dayofanyweek d
		  on s.dayID = d.dayID
		left join ##defaultDatabase##.hourofanyday hoad
		  on s.hourID = hoad.hourID
		left join ##defaultDatabase##.sourceusetype sut
		  on s.sourceTypeID = sut.sourceTypeID
		  where d.dayID is null or hoad.hourID is null or sut.sourceTypeID is null;
		  
		insert into importTempMessages (message)
		select concat('ERROR: StartsHourFraction with Day ',dayID,', Source Type ',sourceTypeID,' allocation fraction is not 1.0 but instead ',round(sum(allocationFraction),4)) as message
		from startsHourFraction
		group by dayID, sourceTypeID
		having round(sum(allocationFraction),4) <> 1.0000;

		insert into importTempMessages (message)
		select concat('ERROR: StartsHourFraction with Day ',dayID,', Source Type ',sourceTypeID,', Hour ',hourID,' has allocationFraction < 0') as message
		from startsHourFraction
		where allocationFraction < 0;
		
		insert into importTempMessages (message)
		select concat('ERROR: StartsHourFraction with Day ',dayID,', Source Type ',sourceTypeID,', Hour ',hourID,' has null allocationFraction') as message
		from startsHourFraction
		where allocationFraction is null;
		
		insert into importTempMessages (message)
		select concat('ERROR: StartsHourFraction with Source Type ',sourceTypeID,' and Day ',dayID,' has missing hours') as message
		  from (
			select shf.sourceTypeID,shf.dayID,count(distinct shf.hourID) hourIDCnt from startshourfraction shf
			join ##defaultDatabase##.hourday hd
			  on hd.dayID = shf.dayID
			  and hd.hourID = shf.hourID
			group by shf.sourceTypeID, shf.dayID) a
		where hourIDCnt <> 24;

	end if;

	-- StartsPerDayPerVehicle
	set howMany=0;
	select count(*) into howMany from startsPerDayPerVehicle;
	set howMany=ifnull(howMany,0);
	if(howMany > 0) then
		insert into importTempMessages (message)
		select distinct
			case
			  when d.dayID is null then  concat('ERROR: StartsPerDayPerVehicle with dayID ',s.dayID,' is unknown')
			  when sut.sourceTypeID is null then  concat('ERROR: StartsPerDayPerVehicle with sourceTypeID ',s.sourceTypeID,' is unknown')
			  when ac.ageID is null then  concat('ERROR: StartsPerDayPerVehicle with ageID ',s.ageID,' is unknown')
		    else null end as message
		from startsPerDayPerVehicle s
		left join ##defaultDatabase##.dayofanyweek d
		  on s.dayID = d.dayID
		left join ##defaultDatabase##.sourceusetype sut
		  on s.sourceTypeID = sut.sourceTypeID
		left join ##defaultDatabase##.agecategory ac
		  on s.ageID = ac.ageID
		  where d.dayID is null or sut.sourceTypeID is null or ac.ageID is null;
	  
		insert into importTempMessages (message)
		select concat('ERROR: StartsPerDayPerVehicle with Day ',dayID,', Source Type ',sourceTypeID,', Age ',ageID,' has StartsPerDayPerVehicle < 0') as message
		from StartsPerDayPerVehicle
		where StartsPerDayPerVehicle < 0;

	end if;

	-- startsMonthAdjust
	set howMany=0;
	select count(*) into howMany from startsMonthAdjust;
	set howMany=ifnull(howMany,0);
	if(howMany > 0) then
		insert into importTempMessages (message)
		select distinct
			case
			  when m.monthID is null then  concat('ERROR: StartsMonthAdjust with monthID ',s.monthID,' is unknown')
			  when sut.sourceTypeID is null then  concat('ERROR: StartsMonthAdjust with sourceTypeID ',s.sourceTypeID,' is unknown')
		    else null end as message
		from startsMonthAdjust s
		left join ##defaultDatabase##.monthofanyyear m
		  on s.monthID = m.monthID
		left join ##defaultDatabase##.sourceusetype sut
		  on s.sourceTypeID = sut.sourceTypeID
		  where m.monthID is null or sut.sourceTypeID is null;
	  
		insert into importTempMessages (message)
		select concat('ERROR: StartsMonthAdjust with Month ',monthID,', Source Type ',sourceTypeID,' has monthAdjustment < 0') as message
		from startsMonthAdjust
		where monthAdjustment < 0;
	end if;

	-- startsOpModeDistribution
	set howMany=0;
	select count(*) into howMany from startsOpModeDistribution;
	set howMany=ifnull(howMany,0);
	if(howMany > 0) then
		insert into importTempMessages (message)
		select distinct
			case
			  when d.dayID is null then  concat('ERROR: StartsOpModeDistribution with dayID ',s.dayID,' is unknown')
			  when hoad.hourID is null then  concat('ERROR: StartsOpModeDistribution with hourID ',s.hourID,' is unknown')
			  when sut.sourceTypeID is null then  concat('ERROR: StartsOpModeDistribution with sourceTypeID ',s.sourceTypeID,' is unknown')
			  when ac.ageID is null then  concat('ERROR: StartsOpModeDistribution with ageID ',s.ageID,' is unknown')
			  when ac.ageID is null then  concat('ERROR: StartsOpModeDistribution with opModeID ',s.opModeID,' is unknown')
		    else null end as message
		from startsOpModeDistribution s
		left join ##defaultDatabase##.dayofanyweek d
		  on s.dayID = d.dayID
		left join ##defaultDatabase##.hourofanyday hoad
		  on s.hourID = hoad.hourID
		left join ##defaultDatabase##.sourceusetype sut
		  on s.sourceTypeID = sut.sourceTypeID
		left join ##defaultDatabase##.agecategory ac
		  on s.ageID = ac.ageID
		left join ##defaultDatabase##.operatingmode om
		  on s.ageID = ac.ageID
		  where d.dayID is null or hoad.hourID is null or sut.sourceTypeID is null or ac.ageID is null or om.opModeID is null;
	  
		insert into importTempMessages (message)
		select concat('ERROR: StartsOpModeDistribution with Day ',dayId,', Hour ,',hourId,'Source Type ',sourceTypeID,', Age ',ageID,' op mode fraction is not 1.0 but instead ',round(sum(opModeFraction),4)) as message
		from startsOpModeDistribution
		group by dayId,hourId,sourceTypeID, ageID
		having round(sum(opModeFraction),4) <> 1.0000;
		
		insert into importTempMessages (message)
		select concat('ERROR: StartsOpModeDistribution with Day ',dayID,',Hour ',hourID,',Source Type ',sourceTypeID,',Age ',ageID,',Op Mode ',opModeID,' has value < 0') as message
		from startsOpModeDistribution
		where opModeFraction < 0;		

		insert into importTempMessages (message)
		select concat('ERROR: StartsOpModeDistribution with Day ',dayID,',Hour ',hourID,',Source Type ',sourceTypeID,',Age ',ageID,',Op Mode ',opModeID,' has null value') as message
		from startsOpModeDistribution
		where opModeFraction is null;		

		select count(*) into howMany from ##defaultDatabase##.operatingmode
		where minSoakTime is not null or maxSoakTime is not null;

		insert into importTempMessages (message)
		select concat('ERROR: StartsOpModeDistribution with Day ',dayID,', Hour ',hourID, ', Source Type ',sourceTypeID,', and Age ',ageID,' has missing Op Mode') as message
		  from (
			select somd.dayID, somd.hourID,somd.sourceTypeID,somd.ageID,count(distinct somd.opModeID) opModeIDCnt 
			from startsOpModeDistribution somd
			join ##defaultDatabase##.operatingmode om
			  on om.opModeID = somd.opModeID
      	   where om.minSoakTime is not null or om.maxSoakTime is not null
           group by somd.dayID, somd.hourID,somd.sourceTypeID,somd.ageID) a
		where opModeIDCnt <> howMany;

	end if;
	
	create table if not exists auditLog (
		whenHappened datetime not null,
		importerName varchar(100) not null,
		briefDescription varchar(100) null,
		fullDescription varchar(4096) null,
		key logByDate (whenHappened),
		key logByImporter (importerName)
	);

	insert into auditlog (whenHappened, importerName,briefDescription)
	select current_timestamp, 'Starts',message from importTempMessages;

end
EndBlock

call spCheckStartsImporter();
drop procedure if exists spCheckStartsImporter;
