/**************************************************************************************************
 * @(#)LogHandler.java 
 *
 *************************************************************************************************/
package gov.epa.otaq.moves.common;

/**
 * Interface for a Log Handler. A Log Handler logs the messages generated by an application. There
 * may be multiple Log Handlers for each application and each Log Handler may log messages in 
 * different ways. For example, the Log Handler for a GUI application may pop up a dialog box 
 * asking the user to confirm the message while the Log Handler for a command-line utility may 
 * simply write the message to System.out. Each message also has an assigned message category that
 * may be used in determining how the message is logged. See the LogMessageCategory class for a
 * description of the defined categories. Typical ways of logging messages include writing them to
 * a file or System.out, displaying them individually in confirmation boxes or together in a 
 * "message log," or writing them to a database table.
 *
 * @author		Cimulus
 * @version		2003-08-27
**/
public interface LogHandler {
	/**
	 * Logs the message to some medium based on the type.
	 * @param	category The category of the log message.
	 * @param	message The String to get logged.
	**/
	public void handleLog(LogMessageCategory category, String message);
}
