/*
 * @(#)Section508Test
 */
 
package gov.epa.otaq.moves.systemtests.test508;

import junit.framework.*;
import junit.extensions.TestSetup;
import javax.swing.plaf.metal.*;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.*;
import java.awt.*;
import java.util.*;
import javax.accessibility.*;
import gov.epa.otaq.moves.systemtests.test508.*;
import gov.epa.otaq.moves.master.framework.*;
import gov.epa.otaq.moves.common.*;
import gov.epa.otaq.moves.master.gui.*;

/**
 * Section508Test. Enumerates all visible controls and tests for Section 508 Accessibility Compliance.
 * 
 * @author  	Bill Shaw
 * @version		2017-09-30
**/
public class Section508Test extends TestCase {

	static MOVESWindow movesWindow;
	static int depthCount = 0;
	static int itemCount = 0;

	public Section508Test(String name) {
		super(name);
	}
	
	public static void main(String args[]) {
		junit.textui.TestRunner.run(Section508Test.class);
	}
	
	public void testEnum() throws Exception {
		assertNotNull(movesWindow);  // instantiated?

		listAllComponentsIn(movesWindow.getContentPane());
	}
	
	public static Test suite() {
		TestSuite suite = new TestSuite(Section508Test.class);

		TestSetup wrapper = new TestSetup(suite) {
			protected void setUp() throws Exception {
				boolean okToPopupMessages = false; 
				
				if(MOVESAPI.hasMasterOnThisComputer()){
					String message = "A MOVES instance is already running, or a firewall is blocking port(s) used by MOVES.\nStartup of this instance of the MOVES master cannot continue.";
					Logger.log(LogMessageCategory.ERROR, message);
					System.exit(0);
					return;
				}

				if (!SystemConfiguration.theSystemConfiguration.didLoad) {
					String message = "The system configuration failed to load.";
					Logger.log(LogMessageCategory.ERROR, message);
					//System.exit(0);
					return;
				}
				
				movesWindow = new MOVESWindow(okToPopupMessages);

				//System.out.println("Enumerating Window Controls...");
				listAllComponentsIn(movesWindow.getContentPane());
			}
			protected void tearDown() throws Exception {}
		};
		return wrapper;
	}

	public static void listAllComponentsIn(Container parent) {
		depthCount++;
		itemCount++;

		for (Component c : parent.getComponents()) {
			AccessibleContext ac = c.getAccessibleContext();  //ac is of type Accessible
			if (c.toString().indexOf("MetalSplitPaneDivider") != -1) {
				assertNotNull(true);
			} else if (c instanceof JTextField) {
				System.out.println("Text: " + ((JTextField) c).getText());
			} else if (c instanceof MetalScrollButton) {
				assertNotNull(c instanceof MetalScrollButton);
			} else if (c instanceof JButton) {
				assertTrue("Button " + ((JButton) c).getText() + " has no hotkey.", ((JButton) c).getDisplayedMnemonicIndex() != -1);
			} else if (c instanceof JViewport) {
				assertNotNull(c instanceof JViewport);
			} else if (c instanceof JListWithToolTips) {
				assertNotNull(c instanceof JListWithToolTips);
			} else if (c instanceof JScrollPane) {
				assertNotNull(c instanceof JScrollPane);
			} else if (c instanceof JScrollBar) {
				assertNotNull(c instanceof JScrollBar);
			} else if (c instanceof JProgressBar) {
				assertNotNull(c instanceof JProgressBar	);
			} else if (c instanceof JPanel) {
				assertNotNull(c instanceof JPanel);
			} else if (c instanceof JLabel) {
				String labelText = StringUtilities.safeGetString(((JLabel)c).getText()).trim();
				if(labelText.equalsIgnoreCase("Ready...")) {
					// Nothing to do with these special case labels.
				} else if(labelText.length() > 0) { // Only labels with text need menumonics
					assertTrue("JLabel " + ((JLabel)c).toString() + " has no hotkey.", ((JLabel) c).getDisplayedMnemonicIndex() != -1);
				}
			} else if (c instanceof JSplitPane) {
				assertNotNull(c instanceof JSplitPane);
			} else if (c instanceof CellRendererPane) {
				assertNotNull(c instanceof CellRendererPane);
			} else if (c instanceof JCheckBox) {
				assertTrue("Button " + ((AbstractButton) c).getText() + " has no hotkey.", ((JCheckBox) c).getDisplayedMnemonicIndex() != 1);
			} else if (c instanceof JRadioButton) {
				String ap = ac.getAccessibleParent().toString();
				if (ap.indexOf("MOVESNavigation") != -1) { //Left Navigation Panel
					assertNotNull(true);
				} else {
					assertTrue("JRadioButton " + ac.getAccessibleName() + " appeared outside of left pane.", ((AbstractButton) c).getMnemonic() != -1);
					/*
					System.out.println("======================================================");
					System.out.println("AccessibleChildrenCount: " + ac.getAccessibleChildrenCount());
					System.out.println("AccessibleName: " + ac.getAccessibleName());
					System.out.println("AccessibleDescription: " + ac.getAccessibleDescription());
					System.out.println("AccessibleRole: " + ac.getAccessibleRole());
					System.out.println("AccessibleStateSet: " + ac.getAccessibleStateSet());
					System.out.println("Mnemonic: " + ((AbstractButton) c).getMnemonic());  
					*/
				}
			} else {
				System.out.println("======================================================");
				System.out.println(c.getClass().getName() + " " + c.getName());
				/*
				System.out.println("AccessibleName: " + ac.getAccessibleName());
				System.out.println("AccessibleDescription: " + ac.getAccessibleDescription());
				*/
			}

			/*
 			if (c instanceof JComponent) {
				String ttText = ((JComponent)c).getToolTipText();
				boolean ttEmpty = (ttText == null || ttText.length() == 0);
				boolean toolTipOK = !ttEmpty
					|| c instanceof JTree
					|| c instanceof JEditorPane
					|| c instanceof JList
					|| c instanceof JRootPane
					|| c instanceof JScrollBar;
			}
			*/

			if (c instanceof Container) {
			   listAllComponentsIn((Container)c);
			   //depthCount--;
			} 
		}
	}
}
