USE MOVESDEFAULT;

--
--	Populate the SourceUseType table with the spreadsheet values
--

DELETE FROM SourceUseType;

INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (21, 20, 'Passenger Car', 0.105140939597315, 0.00134408359983785, 0.000330758827700588, 1, 1.62);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (31, 30, 'Passenger Truck', NULL, NULL, NULL, NULL, NULL);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (32, 30, 'Light Commercial Truck', NULL, NULL, NULL, NULL, NULL);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (51, 50, 'Refuse Truck', NULL, NULL, NULL, NULL, NULL);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (52, 50, 'Single-Unit Commercial Truck', NULL, NULL, NULL, NULL, NULL);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (53, 50, 'Single-Unit Delivery Truck', NULL, NULL, NULL, NULL, NULL);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (54, 50, 'Motorhome', NULL, NULL, NULL, NULL, NULL);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (43, 40, 'School Bus', 0.092, 0, 0.000213559322033898, 1, 11.8);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (42, 40, 'Urban Bus', NULL, NULL, NULL, NULL, NULL);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (41, 40, 'Interstate Bus', NULL, NULL, NULL, NULL, NULL);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (61, 60, 'Combination Commercial Truck', NULL, NULL, NULL, NULL, NULL);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (62, 60, 'Combination Delivery Truck', NULL, NULL, NULL, NULL, NULL);
INSERT IGNORE INTO SourceUseType (sourceTypeID, HPMSVTypeID, sourceTypeName, rollingTermA, rotatingTermB, dragTermC, frictionTermGamma, sourceMass) VALUES (11, 10, 'Motorcycle', NULL, NULL, NULL, NULL, NULL);

--
--	Populate the RoadTypeDistribution table with the spreadsheet values
--

delete from roadtypedistribution;

INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 23, 0.143769715351135);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 25, 0.0657057331719793);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 27, 0.144182088412497);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 29, 0.118617834793357);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 31, 0.049586152893694);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 33, 0.0808355461983662);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 11, 0.0985179736412002);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 13, 0.0909794920800644);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 15, 0.0625171222903638);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 17, 0.075971557403984);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 19, 0.0214455563297288);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (21, 21, 0.0478712274336302);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 23, 0.143769715351135);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 25, 0.0657057331719793);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 27, 0.144182088412497);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 29, 0.118617834793357);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 31, 0.049586152893694);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 33, 0.0808355461983662);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 11, 0.0985179736412002);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 13, 0.0909794920800644);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 15, 0.0625171222903638);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 17, 0.075971557403984);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 19, 0.0214455563297288);
INSERT INTO RoadTypeDistribution (sourceTypeID, roadTypeID, roadTypeVMTFraction) values (43, 21, 0.0478712274336302);

--
--	Populate the AvgSpeedDistribution table with the spreadsheet values
--

delete from avgspeeddistribution;

INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 1, 0.0083);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 2, 0.0272);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 3, 0.021);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 4, 0.0224);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 5, 0.0217);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 6, 0.0381);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 7, 0.0344);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 8, 0.0536);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 9, 0.0614);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 10, 0.07);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 11, 0.2507);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 12, 0.115);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 13, 0.255);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (21, 23, 71, 14, 0.0212);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 1, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 2, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 3, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 4, 1);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 5, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 6, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 7, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 8, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 9, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 10, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 11, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 12, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 13, 0);
INSERT INTO AvgSpeedDistribution (sourceTypeID, roadTypeID, hourDayID, avgSpeedBinID, avgSpeedFraction) VALUES (43, 33, 71, 14, 0);

--
--	Populate the AvgSpeedBin table with the spreadsheet values
--

-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (1, 2.5, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (2, 5, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (3, 10, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (4, 15, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (5, 20, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (6, 25, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (7, 30, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (8, 35, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (9, 40, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (10,45, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (11,50, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (12,55, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (13,60, NULL);
-- INSERT INTO AvgSpeedBin (avgSpeedBinID, avgBinSpeed, avgSpeedBinDesc) values (14,65, NULL);

--
--	Populate the DriveScheduleAssoc table with the spreadsheet values
--

delete from drivescheduleassoc;

INSERT INTO DriveScheduleAssoc (sourceTypeID, roadTypeID, driveScheduleID) VALUES (21, 23, 1);
INSERT INTO DriveScheduleAssoc (sourceTypeID, roadTypeID, driveScheduleID) VALUES (21, 23, 2);
INSERT INTO DriveScheduleAssoc (sourceTypeID, roadTypeID, driveScheduleID) VALUES (21, 23, 3);
INSERT INTO DriveScheduleAssoc (sourceTypeID, roadTypeID, driveScheduleID) VALUES (21, 23, 4);
INSERT INTO DriveScheduleAssoc (sourceTypeID, roadTypeID, driveScheduleID) VALUES (21, 23, 5);
INSERT INTO DriveScheduleAssoc (sourceTypeID, roadTypeID, driveScheduleID) VALUES (21, 23, 6);
INSERT INTO DriveScheduleAssoc (sourceTypeID, roadTypeID, driveScheduleID) VALUES (43, 33, 7);

--
--	Populate the DriveScheduleAssoc table with the spreadsheet values
--

delete from driveschedule;

INSERT INTO DriveSchedule (driveScheduleID, averageSpeed, driveScheduleName) VALUES (1, 63.2, 'High Speed Freeway Cycle (Light-Duty)');
INSERT INTO DriveSchedule (driveScheduleID, averageSpeed, driveScheduleName) VALUES (2, 59.7, 'LOS AC Freeway Cycle (Light-Duty)');
INSERT INTO DriveSchedule (driveScheduleID, averageSpeed, driveScheduleName) VALUES (3, 52.9, 'LOS D Freeway Cycle (Light-Duty)');
INSERT INTO DriveSchedule (driveScheduleID, averageSpeed, driveScheduleName) VALUES (4, 30.5, 'LOS E Freeway Cycle (Light-Duty)');
INSERT INTO DriveSchedule (driveScheduleID, averageSpeed, driveScheduleName) VALUES (5, 18.6, 'LOS F Freeway Cycle (Light-Duty)');
INSERT INTO DriveSchedule (driveScheduleID, averageSpeed, driveScheduleName) VALUES (6, 13.1, 'LOS G Freeway Cycle (Light-Duty)');
INSERT INTO DriveSchedule (driveScheduleID, averageSpeed, driveScheduleName) VALUES (7, 3.7, 'Urban Bus Cycle');

--
--	Populate the DriveScheduleSecond table with the spreadsheet values
--

delete from driveschedulesecond;

insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 0, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 1, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 2, 67.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 3, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 4, 67.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 5, 66.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 6, 66.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 7, 65.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 8, 67.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 9, 68.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 10, 68.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 11, 68.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 12, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 13, 71.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 14, 72.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 15, 72.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 16, 71.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 17, 71.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 18, 70.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 19, 72.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 20, 73.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 21, 73.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 22, 74.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 23, 74.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 24, 74.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 25, 73.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 26, 73.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 27, 73.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 28, 72.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 29, 70.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 30, 68.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 31, 66.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 32, 65);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 33, 62.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 34, 60.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 35, 63.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 36, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 37, 64.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 38, 64.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 39, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 40, 66.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 41, 67.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 42, 67.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 43, 66.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 44, 66.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 45, 66.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 46, 67.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 47, 67.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 48, 67.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 49, 67.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 50, 67.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 51, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 52, 66.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 53, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 54, 66.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 55, 65.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 56, 65.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 57, 65.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 58, 64.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 59, 64.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 60, 62.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 61, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 62, 59.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 63, 58.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 64, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 65, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 66, 56.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 67, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 68, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 69, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 70, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 71, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 72, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 73, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 74, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 75, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 76, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 77, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 78, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 79, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 80, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 81, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 82, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 83, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 84, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 85, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 86, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 87, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 88, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 89, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 90, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 91, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 92, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 93, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 94, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 95, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 96, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 97, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 98, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 99, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 100, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 101, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 102, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 103, 56.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 104, 56.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 105, 57.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 106, 57.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 107, 56.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 108, 56.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 109, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 110, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 111, 56.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 112, 56.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 113, 56.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 114, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 115, 56.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 116, 57);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 117, 56.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 118, 56.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 119, 56.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 120, 56.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 121, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 122, 56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 123, 56.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 124, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 125, 56.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 126, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 127, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 128, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 129, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 130, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 131, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 132, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 133, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 134, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 135, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 136, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 137, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 138, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 139, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 140, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 141, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 142, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 143, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 144, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 145, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 146, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 147, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 148, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 149, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 150, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 151, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 152, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 153, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 154, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 155, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 156, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 157, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 158, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 159, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 160, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 161, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 162, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 163, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 164, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 165, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 166, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 167, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 168, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 169, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 170, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 171, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 172, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 173, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 174, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 175, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 176, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 177, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 178, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 179, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 180, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 181, 58.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 182, 58.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 183, 58.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 184, 59.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 185, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 186, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 187, 59.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 188, 58.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 189, 58.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 190, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 191, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 192, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 193, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 194, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 195, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 196, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 197, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 198, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 199, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 200, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 201, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 202, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 203, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 204, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 205, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 206, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 207, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 208, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 209, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 210, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 211, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 212, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 213, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 214, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 215, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 216, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 217, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 218, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 219, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 220, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 221, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 222, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 223, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 224, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 225, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 226, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 227, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 228, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 229, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 230, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 231, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 232, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 233, 66.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 234, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 235, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 236, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 237, 65.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 238, 65.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 239, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 240, 66.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 241, 65.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 242, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 243, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 244, 65.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 245, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 246, 66.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 247, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 248, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 249, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 250, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 251, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 252, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 253, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 254, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 255, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 256, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 257, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 258, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 259, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 260, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 261, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 262, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 263, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 264, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 265, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 266, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 267, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 268, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 269, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 270, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 271, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 272, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 273, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 274, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 275, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 276, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 277, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 278, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 279, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 280, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 281, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 282, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 283, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 284, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 285, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 286, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 287, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 288, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 289, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 290, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 291, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 292, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 293, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 294, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 295, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 296, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 297, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 298, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 299, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 300, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 301, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 302, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 303, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 304, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 305, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 306, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 307, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 308, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 309, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 310, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 311, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 312, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 313, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 314, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 315, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 316, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 317, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 318, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 319, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 320, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 321, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 322, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 323, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 324, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 325, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 326, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 327, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 328, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 329, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 330, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 331, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 332, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 333, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 334, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 335, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 336, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 337, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 338, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 339, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 340, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 341, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 342, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 343, 69.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 344, 69.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 345, 70.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 346, 70.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 347, 69.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 348, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 349, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 350, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 351, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 352, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 353, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 354, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 355, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 356, 69.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 357, 69.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 358, 69.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 359, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 360, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 361, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 362, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 363, 69.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 364, 69.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 365, 69.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 366, 69.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 367, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 368, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 369, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 370, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 371, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 372, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 373, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 374, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 375, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 376, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 377, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 378, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 379, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 380, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 381, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 382, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 383, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 384, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 385, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 386, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 387, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 388, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 389, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 390, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 391, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 392, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 393, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 394, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 395, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 396, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 397, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 398, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 399, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 400, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 401, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 402, 62.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 403, 62);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 404, 61.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 405, 61.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 406, 61.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 407, 61.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 408, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 409, 61.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 410, 61.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 411, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 412, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 413, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 414, 60.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 415, 60.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 416, 60.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 417, 61.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 418, 61.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 419, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 420, 61.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 421, 62);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 422, 61.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 423, 61.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 424, 61.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 425, 61.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 426, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 427, 61.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 428, 61.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 429, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 430, 62.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 431, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 432, 62.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 433, 62.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 434, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 435, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 436, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 437, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 438, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 439, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 440, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 441, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 442, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 443, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 444, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 445, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 446, 69.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 447, 69.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 448, 69.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 449, 70.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 450, 71);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 451, 71.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 452, 72.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 453, 72.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 454, 71.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 455, 70.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 456, 69.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 457, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 458, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 459, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 460, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 461, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 462, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 463, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 464, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 465, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 466, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 467, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 468, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 469, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 470, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 471, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 472, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 473, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 474, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 475, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 476, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 477, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 478, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 479, 66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 480, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 481, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 482, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 483, 69.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 484, 69.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 485, 71.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 486, 71.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 487, 72.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 488, 72.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 489, 72.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 490, 71.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 491, 71.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 492, 70.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 493, 70.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 494, 69.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 495, 69.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 496, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 497, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 498, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 499, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 500, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 501, 66.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 502, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 503, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 504, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 505, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 506, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 507, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 508, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 509, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 510, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 511, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 512, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 513, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 514, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 515, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 516, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 517, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 518, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 519, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 520, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 521, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 522, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 523, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 524, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 525, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 526, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 527, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 528, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 529, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 530, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 531, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 532, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 533, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 534, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 535, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 536, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 537, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 538, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 539, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 540, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 541, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 542, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 543, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 544, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 545, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 546, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 547, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 548, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 549, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 550, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 551, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 552, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 553, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 554, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 555, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 556, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 557, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 558, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 559, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 560, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 561, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 562, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 563, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 564, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 565, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 566, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 567, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 568, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 569, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 570, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 571, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 572, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 573, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 574, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 575, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 576, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 577, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 578, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 579, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 580, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 581, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 582, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 583, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 584, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 585, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 586, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 587, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 588, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 589, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 590, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 591, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 592, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 593, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 594, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 595, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 596, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 597, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 598, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 599, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 600, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 601, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 602, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 603, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 604, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 605, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 606, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 607, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 608, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (1, 609, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 0, 43.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 1, 47.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 2, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 3, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 4, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 5, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 6, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 7, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 8, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 9, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 10, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 11, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 12, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 13, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 14, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 15, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 16, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 17, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 18, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 19, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 20, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 21, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 22, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 23, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 24, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 25, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 26, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 27, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 28, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 29, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 30, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 31, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 32, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 33, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 34, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 35, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 36, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 37, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 38, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 39, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 40, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 41, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 42, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 43, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 44, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 45, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 46, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 47, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 48, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 49, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 50, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 51, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 52, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 53, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 54, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 55, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 56, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 57, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 58, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 59, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 60, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 61, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 62, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 63, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 64, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 65, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 66, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 67, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 68, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 69, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 70, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 71, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 72, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 73, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 74, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 75, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 76, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 77, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 78, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 79, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 80, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 81, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 82, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 83, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 84, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 85, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 86, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 87, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 88, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 89, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 90, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 91, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 92, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 93, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 94, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 95, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 96, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 97, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 98, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 99, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 100, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 101, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 102, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 103, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 104, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 105, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 106, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 107, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 108, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 109, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 110, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 111, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 112, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 113, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 114, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 115, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 116, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 117, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 118, 51.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 119, 49.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 120, 49.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 121, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 122, 51.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 123, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 124, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 125, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 126, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 127, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 128, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 129, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 130, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 131, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 132, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 133, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 134, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 135, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 136, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 137, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 138, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 139, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 140, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 141, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 142, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 143, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 144, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 145, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 146, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 147, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 148, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 149, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 150, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 151, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 152, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 153, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 154, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 155, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 156, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 157, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 158, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 159, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 160, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 161, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 162, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 163, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 164, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 165, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 166, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 167, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 168, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 169, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 170, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 171, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 172, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 173, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 174, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 175, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 176, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 177, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 178, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 179, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 180, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 181, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 182, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 183, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 184, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 185, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 186, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 187, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 188, 51.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 189, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 190, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 191, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 192, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 193, 51.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 194, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 195, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 196, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 197, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 198, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 199, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 200, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 201, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 202, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 203, 51.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 204, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 205, 50.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 206, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 207, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 208, 48.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 209, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 210, 50.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 211, 51.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 212, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 213, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 214, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 215, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 216, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 217, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 218, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 219, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 220, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 221, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 222, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 223, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 224, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 225, 51.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 226, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 227, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 228, 50.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 229, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 230, 51.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 231, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 232, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 233, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 234, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 235, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 236, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 237, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 238, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 239, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 240, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 241, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 242, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 243, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 244, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 245, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 246, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 247, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 248, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 249, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 250, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 251, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 252, 49.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 253, 47.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 254, 46.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 255, 45.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 256, 44.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 257, 44.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 258, 45.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 259, 46.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 260, 46.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 261, 46.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 262, 46.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 263, 46.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 264, 46.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 265, 48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 266, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 267, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 268, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 269, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 270, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 271, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 272, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 273, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 274, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 275, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 276, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 277, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 278, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 279, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 280, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 281, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 282, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 283, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 284, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 285, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 286, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 287, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 288, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 289, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 290, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 291, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 292, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 293, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 294, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 295, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 296, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 297, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 298, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 299, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 300, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 301, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 302, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 303, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 304, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 305, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 306, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 307, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 308, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 309, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 310, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 311, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 312, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 313, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 314, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 315, 64.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 316, 64);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 317, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 318, 63.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 319, 62.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 320, 62.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 321, 63.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 322, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 323, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 324, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 325, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 326, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 327, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 328, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 329, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 330, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 331, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 332, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 333, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 334, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 335, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 336, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 337, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 338, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 339, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 340, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 341, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 342, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 343, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 344, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 345, 64.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 346, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 347, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 348, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 349, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 350, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 351, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 352, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 353, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 354, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 355, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 356, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 357, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 358, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 359, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 360, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 361, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 362, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 363, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 364, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 365, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 366, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 367, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 368, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 369, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 370, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 371, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 372, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 373, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 374, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 375, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 376, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 377, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 378, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 379, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 380, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 381, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 382, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 383, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 384, 61);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 385, 60.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 386, 61.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 387, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 388, 62.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 389, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 390, 64.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 391, 64.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 392, 65.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 393, 66.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 394, 66.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 395, 67.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 396, 68.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 397, 68.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 398, 68.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 399, 68.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 400, 67.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 401, 67.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 402, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 403, 65.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 404, 65);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 405, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 406, 64.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 407, 63.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 408, 63.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 409, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 410, 61.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 411, 60.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 412, 60.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 413, 59.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 414, 60);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 415, 60.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 416, 60.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 417, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 418, 60.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 419, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 420, 59.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 421, 59.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 422, 58.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 423, 57.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 424, 57.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 425, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 426, 58.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 427, 59.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 428, 60);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 429, 61);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 430, 61.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 431, 62);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 432, 62.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 433, 64.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 434, 65);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 435, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 436, 67.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 437, 68.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 438, 69.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 439, 69.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 440, 70.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 441, 71.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 442, 72.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 443, 72.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 444, 73.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 445, 73);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 446, 73.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 447, 72.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 448, 72.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 449, 72.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 450, 71.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 451, 70.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 452, 70.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 453, 69.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 454, 70);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 455, 69.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 456, 70.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 457, 70.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 458, 71.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 459, 70.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 460, 70.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 461, 69.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 462, 68.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 463, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 464, 68.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 465, 67.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 466, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 467, 67.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 468, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 469, 67.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 470, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 471, 67.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 472, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 473, 67.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 474, 67.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 475, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 476, 67.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 477, 67.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 478, 67.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 479, 67.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 480, 67.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 481, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 482, 68);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 483, 68.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 484, 68.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 485, 68.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 486, 68.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 487, 68.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 488, 69.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 489, 69.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 490, 68.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 491, 68.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 492, 68.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 493, 67.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 494, 67);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 495, 66.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 496, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 497, 65.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 498, 64.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 499, 64.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 500, 63.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 501, 63.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 502, 62.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 503, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 504, 61.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 505, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 506, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 507, 59.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 508, 59.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 509, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 510, 58.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 511, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 512, 57.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 513, 56.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 514, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (2, 515, 57.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 0, 41.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 1, 41.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 2, 43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 3, 43.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 4, 43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 5, 43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 6, 44.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 7, 45.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 8, 46.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 9, 47.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 10, 47.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 11, 48.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 12, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 13, 49.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 14, 50.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 15, 51.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 16, 51.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 17, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 18, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 19, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 20, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 21, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 22, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 23, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 24, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 25, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 26, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 27, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 28, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 29, 61.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 30, 62.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 31, 62.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 32, 63.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 33, 64.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 34, 64.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 35, 64);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 36, 62.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 37, 61.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 38, 61.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 39, 61.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 40, 62.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 41, 62.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 42, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 43, 63.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 44, 64.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 45, 64.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 46, 65.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 47, 64.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 48, 64);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 49, 64.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 50, 65.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 51, 65.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 52, 66.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 53, 66.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 54, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 55, 68.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 56, 68.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 57, 68.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 58, 69.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 59, 70);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 60, 70.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 61, 70.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 62, 70.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 63, 69.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 64, 69.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 65, 68.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 66, 67.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 67, 67);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 68, 66.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 69, 65.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 70, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 71, 66.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 72, 67.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 73, 67.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 74, 68.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 75, 67.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 76, 66.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 77, 65.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 78, 66.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 79, 66.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 80, 67.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 81, 67);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 82, 66.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 83, 66.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 84, 65.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 85, 65);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 86, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 87, 64);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 88, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 89, 63.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 90, 62.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 91, 62.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 92, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 93, 62.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 94, 61.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 95, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 96, 61.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 97, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 98, 60);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 99, 59);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 100, 58.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 101, 57.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 102, 56.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 103, 52.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 104, 51);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 105, 49.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 106, 48.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 107, 47.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 108, 46.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 109, 46.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 110, 47.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 111, 47.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 112, 48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 113, 48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 114, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 115, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 116, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 117, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 118, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 119, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 120, 49.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 121, 50.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 122, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 123, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 124, 48.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 125, 48.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 126, 48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 127, 48.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 128, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 129, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 130, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 131, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 132, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 133, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 134, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 135, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 136, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 137, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 138, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 139, 50.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 140, 51.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 141, 51.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 142, 51.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 143, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 144, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 145, 51.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 146, 51.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 147, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 148, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 149, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 150, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 151, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 152, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 153, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 154, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 155, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 156, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 157, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 158, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 159, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 160, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 161, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 162, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 163, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 164, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 165, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 166, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 167, 45.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 168, 45.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 169, 44.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 170, 44.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 171, 42.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 172, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 173, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 174, 41.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 175, 43.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 176, 45.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 177, 47.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 178, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 179, 51.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 180, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 181, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 182, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 183, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 184, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 185, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 186, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 187, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 188, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 189, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 190, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 191, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 192, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 193, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 194, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 195, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 196, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 197, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 198, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 199, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 200, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 201, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 202, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 203, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 204, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 205, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 206, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 207, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 208, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 209, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 210, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 211, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 212, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 213, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 214, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 215, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 216, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 217, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 218, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 219, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 220, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 221, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 222, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 223, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 224, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 225, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 226, 64.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 227, 64.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 228, 63.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 229, 63.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 230, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 231, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 232, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 233, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 234, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 235, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 236, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 237, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 238, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 239, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 240, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 241, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 242, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 243, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 244, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 245, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 246, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 247, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 248, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 249, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 250, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 251, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 252, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 253, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 254, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 255, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 256, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 257, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 258, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 259, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 260, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 261, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 262, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 263, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 264, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 265, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 266, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 267, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 268, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 269, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 270, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 271, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 272, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 273, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 274, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 275, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 276, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 277, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 278, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 279, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 280, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 281, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 282, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 283, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 284, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 285, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 286, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 287, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 288, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 289, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 290, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 291, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 292, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 293, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 294, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 295, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 296, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 297, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 298, 58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 299, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 300, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 301, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 302, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 303, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 304, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 305, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 306, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 307, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 308, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 309, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 310, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 311, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 312, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 313, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 314, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 315, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 316, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 317, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 318, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 319, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 320, 51.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 321, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 322, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 323, 48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 324, 46.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 325, 44.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 326, 40.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 327, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 328, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 329, 41.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 330, 42.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 331, 43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 332, 43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 333, 43.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 334, 44.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 335, 44.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 336, 43.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 337, 43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 338, 42.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 339, 41.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 340, 41.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 341, 41.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 342, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 343, 39.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 344, 39.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 345, 38.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 346, 38.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 347, 37.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 348, 36.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 349, 35.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 350, 35.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 351, 34.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 352, 34.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 353, 36.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 354, 36.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 355, 37.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 356, 38.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 357, 39.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 358, 39.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 359, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 360, 40.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 361, 41.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 362, 41.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 363, 42.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 364, 43.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 365, 44.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 366, 45.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 367, 46.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 368, 45.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 369, 45.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 370, 44.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 371, 44.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 372, 43.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 373, 42.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 374, 40.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 375, 39.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 376, 38.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 377, 38.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 378, 38);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 379, 36.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 380, 32.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 381, 30.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 382, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 383, 26.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 384, 26.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 385, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 386, 29.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 387, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 388, 26.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 389, 27.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 390, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 391, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 392, 28.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 393, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 394, 29.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 395, 30.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 396, 31.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 397, 32.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 398, 33.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 399, 34.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 400, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 401, 35.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 402, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 403, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 404, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (3, 405, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 0, 33.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 1, 33.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 2, 33);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 3, 31.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 4, 32.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 5, 32.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 6, 33.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 7, 34.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 8, 36.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 9, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 10, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 11, 32.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 12, 32.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 13, 31.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 14, 31.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 15, 32.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 16, 31.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 17, 31.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 18, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 19, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 20, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 21, 20.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 22, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 23, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 24, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 25, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 26, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 27, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 28, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 29, 10.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 30, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 31, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 32, 10.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 33, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 34, 10.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 35, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 36, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 37, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 38, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 39, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 40, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 41, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 42, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 43, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 44, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 45, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 46, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 47, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 48, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 49, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 50, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 51, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 52, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 53, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 54, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 55, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 56, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 57, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 58, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 59, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 60, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 61, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 62, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 63, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 64, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 65, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 66, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 67, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 68, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 69, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 70, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 71, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 72, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 73, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 74, 22.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 75, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 76, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 77, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 78, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 79, 22.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 80, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 81, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 82, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 83, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 84, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 85, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 86, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 87, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 88, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 89, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 90, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 91, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 92, 15.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 93, 15.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 94, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 95, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 96, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 97, 22.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 98, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 99, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 100, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 101, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 102, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 103, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 104, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 105, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 106, 26.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 107, 28.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 108, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 109, 31.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 110, 31.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 111, 31.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 112, 31.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 113, 31.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 114, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 115, 29.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 116, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 117, 26.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 118, 26.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 119, 25.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 120, 25.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 121, 25.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 122, 26.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 123, 26.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 124, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 125, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 126, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 127, 30.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 128, 31.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 129, 33);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 130, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 131, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 132, 36.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 133, 38);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 134, 38.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 135, 39.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 136, 39.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 137, 39.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 138, 39.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 139, 38.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 140, 38.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 141, 38.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 142, 38.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 143, 38);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 144, 37.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 145, 37.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 146, 36.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 147, 36.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 148, 36.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 149, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 150, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 151, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 152, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 153, 34.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 154, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 155, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 156, 34.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 157, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 158, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 159, 34.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 160, 34.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 161, 34.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 162, 33.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 163, 33.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 164, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 165, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 166, 34.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 167, 32.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 168, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 169, 28.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 170, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 171, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 172, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 173, 27.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 174, 27.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 175, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 176, 27.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 177, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 178, 28.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 179, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 180, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 181, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 182, 28.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 183, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 184, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 185, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 186, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 187, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 188, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 189, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 190, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 191, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 192, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 193, 1.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 194, 2.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 195, 2.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 196, 2.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 197, 1.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 198, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 199, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 200, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 201, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 202, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 203, 1.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 204, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 205, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 206, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 207, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 208, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 209, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 210, 22.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 211, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 212, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 213, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 214, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 215, 10.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 216, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 217, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 218, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 219, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 220, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 221, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 222, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 223, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 224, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 225, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 226, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 227, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 228, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 229, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 230, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 231, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 232, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 233, 15.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 234, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 235, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 236, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 237, 20.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 238, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 239, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 240, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 241, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 242, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 243, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 244, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 245, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 246, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 247, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 248, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 249, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 250, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 251, 26.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 252, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 253, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 254, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 255, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 256, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 257, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 258, 30.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 259, 30.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 260, 31.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 261, 32.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 262, 33.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 263, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 264, 36.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 265, 38);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 266, 38.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 267, 38.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 268, 39.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 269, 40.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 270, 41.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 271, 41.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 272, 41.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 273, 42.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 274, 42.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 275, 42.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 276, 42.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 277, 42.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 278, 43.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 279, 44.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 280, 44.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 281, 43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 282, 40.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 283, 38.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 284, 36.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 285, 36.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 286, 35.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 287, 37.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 288, 38.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 289, 39.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 290, 39.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 291, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 292, 41.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 293, 42.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 294, 43.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 295, 45.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 296, 46.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 297, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 298, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 299, 51.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 300, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 301, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 302, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 303, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 304, 54.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 305, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 306, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 307, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 308, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 309, 55.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 310, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 311, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 312, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 313, 58.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 314, 59.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 315, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 316, 59.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 317, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 318, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 319, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 320, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 321, 61.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 322, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 323, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 324, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 325, 60.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 326, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 327, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 328, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 329, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 330, 63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 331, 62.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 332, 62.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 333, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 334, 62.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 335, 61.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 336, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 337, 61.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 338, 60.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 339, 59.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 340, 58.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 341, 57.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 342, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 343, 56.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 344, 57.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 345, 56.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 346, 56.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 347, 55.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 348, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 349, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 350, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 351, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 352, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 353, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 354, 50.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 355, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 356, 50.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 357, 51.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 358, 51.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 359, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 360, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 361, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 362, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 363, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 364, 52.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 365, 52.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 366, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 367, 53.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 368, 53.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 369, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 370, 54.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 371, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 372, 54.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 373, 53);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 374, 49.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 375, 48.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 376, 48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 377, 46.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 378, 45.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 379, 44.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 380, 44.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 381, 44.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 382, 44.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 383, 43.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 384, 43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 385, 43.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 386, 44.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 387, 45.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 388, 46.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 389, 45.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 390, 45.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 391, 45.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 392, 44.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 393, 44.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 394, 43.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 395, 41.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 396, 38.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 397, 37.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 398, 37.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 399, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 400, 33.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 401, 32.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 402, 31.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 403, 30.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 404, 30.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 405, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 406, 26.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 407, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 408, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 409, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 410, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 411, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 412, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 413, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 414, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 415, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 416, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 417, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 418, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 419, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 420, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 421, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 422, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 423, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 424, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 425, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 426, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 427, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 428, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 429, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 430, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 431, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 432, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 433, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 434, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 435, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 436, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 437, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 438, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 439, 5.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 440, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 441, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 442, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 443, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 444, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 445, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 446, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 447, 10.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 448, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 449, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 450, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 451, 1.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 452, 0.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 453, 0.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 454, 0.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (4, 455, 1.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 0, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 1, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 2, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 3, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 4, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 5, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 6, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 7, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 8, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 9, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 10, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 11, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 12, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 13, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 14, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 15, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 16, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 17, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 18, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 19, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 20, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 21, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 22, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 23, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 24, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 25, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 26, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 27, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 28, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 29, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 30, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 31, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 32, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 33, 3.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 34, 2.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 35, 0.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 36, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 37, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 38, 0.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 39, 1.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 40, 2.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 41, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 42, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 43, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 44, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 45, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 46, 10);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 47, 10);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 48, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 49, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 50, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 51, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 52, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 53, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 54, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 55, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 56, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 57, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 58, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 59, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 60, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 61, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 62, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 63, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 64, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 65, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 66, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 67, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 68, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 69, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 70, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 71, 20.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 72, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 73, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 74, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 75, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 76, 26.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 77, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 78, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 79, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 80, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 81, 30.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 82, 31.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 83, 31.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 84, 31.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 85, 32.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 86, 33);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 87, 33);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 88, 33);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 89, 32.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 90, 31.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 91, 30.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 92, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 93, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 94, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 95, 26.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 96, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 97, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 98, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 99, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 100, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 101, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 102, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 103, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 104, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 105, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 106, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 107, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 108, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 109, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 110, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 111, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 112, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 113, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 114, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 115, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 116, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 117, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 118, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 119, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 120, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 121, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 122, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 123, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 124, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 125, 15.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 126, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 127, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 128, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 129, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 130, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 131, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 132, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 133, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 134, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 135, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 136, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 137, 15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 138, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 139, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 140, 10);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 141, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 142, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 143, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 144, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 145, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 146, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 147, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 148, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 149, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 150, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 151, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 152, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 153, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 154, 15.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 155, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 156, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 157, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 158, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 159, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 160, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 161, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 162, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 163, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 164, 15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 165, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 166, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 167, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 168, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 169, 26.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 170, 26.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 171, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 172, 20.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 173, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 174, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 175, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 176, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 177, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 178, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 179, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 180, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 181, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 182, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 183, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 184, 10);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 185, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 186, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 187, 1.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 188, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 189, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 190, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 191, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 192, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 193, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 194, 0.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 195, 2.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 196, 3.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 197, 3.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 198, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 199, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 200, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 201, 10);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 202, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 203, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 204, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 205, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 206, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 207, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 208, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 209, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 210, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 211, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 212, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 213, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 214, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 215, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 216, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 217, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 218, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 219, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 220, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 221, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 222, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 223, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 224, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 225, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 226, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 227, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 228, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 229, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 230, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 231, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 232, 15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 233, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 234, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 235, 15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 236, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 237, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 238, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 239, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 240, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 241, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 242, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 243, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 244, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 245, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 246, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 247, 26.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 248, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 249, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 250, 30.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 251, 31.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 252, 33);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 253, 34.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 254, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 255, 35.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 256, 36.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 257, 36.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 258, 36.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 259, 36.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 260, 35.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 261, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 262, 34.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 263, 35.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 264, 37.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 265, 39.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 266, 39.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 267, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 268, 40.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 269, 40.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 270, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 271, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 272, 39.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 273, 41.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 274, 42.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 275, 43.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 276, 43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 277, 42.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 278, 40.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 279, 37.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 280, 36.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 281, 32.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 282, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 283, 26.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 284, 25.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 285, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 286, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 287, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 288, 26.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 289, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 290, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 291, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 292, 30.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 293, 30.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 294, 31.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 295, 32.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 296, 32.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 297, 32.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 298, 31.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 299, 31.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 300, 30.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 301, 30.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 302, 28.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 303, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 304, 27.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 305, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 306, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 307, 28.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 308, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 309, 28.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 310, 28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 311, 26.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 312, 25.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 313, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 314, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 315, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 316, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 317, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 318, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 319, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 320, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 321, 20.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 322, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 323, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 324, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 325, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 326, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 327, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 328, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 329, 3.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 330, 3.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 331, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 332, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 333, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 334, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 335, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 336, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 337, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 338, 15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 339, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 340, 10.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 341, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 342, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 343, 3.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 344, 2.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 345, 1.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 346, 2.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 347, 3.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 348, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 349, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 350, 3.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 351, 1.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 352, 0.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 353, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 354, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 355, 0.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 356, 1.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 357, 1.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 358, 1.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 359, 0.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 360, 1.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 361, 3.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 362, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 363, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 364, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 365, 20.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 366, 20.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 367, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 368, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 369, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 370, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 371, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 372, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 373, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 374, 20.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 375, 22.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 376, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 377, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 378, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 379, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 380, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 381, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 382, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 383, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 384, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 385, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 386, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 387, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 388, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 389, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 390, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 391, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 392, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 393, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 394, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 395, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 396, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 397, 22.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 398, 20.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 399, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 400, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 401, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 402, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 403, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 404, 15.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 405, 15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 406, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 407, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 408, 15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 409, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 410, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 411, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 412, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 413, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 414, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 415, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 416, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 417, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 418, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 419, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 420, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 421, 26.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 422, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 423, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 424, 31.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 425, 33.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 426, 35.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 427, 37.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 428, 38.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 429, 39.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 430, 42.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 431, 44.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 432, 45.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 433, 46.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 434, 46.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 435, 47.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 436, 48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 437, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 438, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 439, 49.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 440, 49.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (5, 441, 49.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 0, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 1, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 2, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 3, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 4, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 5, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 6, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 7, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 8, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 9, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 10, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 11, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 12, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 13, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 14, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 15, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 16, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 17, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 18, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 19, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 20, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 21, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 22, 10);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 23, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 24, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 25, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 26, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 27, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 28, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 29, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 30, 10.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 31, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 32, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 33, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 34, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 35, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 36, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 37, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 38, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 39, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 40, 10);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 41, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 42, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 43, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 44, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 45, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 46, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 47, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 48, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 49, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 50, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 51, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 52, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 53, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 54, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 55, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 56, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 57, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 58, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 59, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 60, 5.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 61, 3.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 62, 1.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 63, 1.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 64, 3.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 65, 5.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 66, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 67, 5.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 68, 5.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 69, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 70, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 71, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 72, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 73, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 74, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 75, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 76, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 77, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 78, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 79, 10);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 80, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 81, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 82, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 83, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 84, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 85, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 86, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 87, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 88, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 89, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 90, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 91, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 92, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 93, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 94, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 95, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 96, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 97, 15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 98, 15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 99, 14.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 100, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 101, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 102, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 103, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 104, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 105, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 106, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 107, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 108, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 109, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 110, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 111, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 112, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 113, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 114, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 115, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 116, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 117, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 118, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 119, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 120, 2.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 121, 0.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 122, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 123, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 124, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 125, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 126, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 127, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 128, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 129, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 130, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 131, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 132, 1.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 133, 4.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 134, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 135, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 136, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 137, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 138, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 139, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 140, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 141, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 142, 15.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 143, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 144, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 145, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 146, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 147, 20.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 148, 21.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 149, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 150, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 151, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 152, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 153, 22.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 154, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 155, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 156, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 157, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 158, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 159, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 160, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 161, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 162, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 163, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 164, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 165, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 166, 20.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 167, 22.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 168, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 169, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 170, 24.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 171, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 172, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 173, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 174, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 175, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 176, 22.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 177, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 178, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 179, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 180, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 181, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 182, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 183, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 184, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 185, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 186, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 187, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 188, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 189, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 190, 15.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 191, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 192, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 193, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 194, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 195, 4.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 196, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 197, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 198, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 199, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 200, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 201, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 202, 4.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 203, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 204, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 205, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 206, 5.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 207, 6.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 208, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 209, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 210, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 211, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 212, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 213, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 214, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 215, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 216, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 217, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 218, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 219, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 220, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 221, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 222, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 223, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 224, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 225, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 226, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 227, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 228, 1.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 229, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 230, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 231, 1.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 232, 2.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 233, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 234, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 235, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 236, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 237, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 238, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 239, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 240, 8.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 241, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 242, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 243, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 244, 4.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 245, 5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 246, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 247, 5.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 248, 6.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 249, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 250, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 251, 8.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 252, 10);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 253, 10.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 254, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 255, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 256, 11.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 257, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 258, 10.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 259, 10);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 260, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 261, 9.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 262, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 263, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 264, 7.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 265, 5.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 266, 4.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 267, 3.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 268, 3.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 269, 2.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 270, 1.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 271, 1.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 272, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 273, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 274, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 275, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 276, 1.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 277, 4.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 278, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 279, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 280, 10.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 281, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 282, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 283, 13.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 284, 13.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 285, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 286, 11.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 287, 10.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 288, 8.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 289, 7.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 290, 6.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 291, 9.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 292, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 293, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 294, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 295, 11.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 296, 12.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 297, 13.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 298, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 299, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 300, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 301, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 302, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 303, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 304, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 305, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 306, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 307, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 308, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 309, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 310, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 311, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 312, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 313, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 314, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 315, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 316, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 317, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 318, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 319, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 320, 17.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 321, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 322, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 323, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 324, 15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 325, 14.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 326, 15.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 327, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 328, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 329, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 330, 18.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 331, 20);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 332, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 333, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 334, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 335, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 336, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 337, 25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 338, 25.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 339, 25.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 340, 26.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 341, 26.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 342, 27.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 343, 28.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 344, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 345, 31.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 346, 32.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 347, 33.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 348, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 349, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 350, 34.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 351, 33);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 352, 31.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 353, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 354, 27.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 355, 26.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 356, 21.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 357, 19.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 358, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 359, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 360, 16.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 361, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 362, 16.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 363, 16.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 364, 17.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 365, 18.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 366, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 367, 18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 368, 19.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 369, 21.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 370, 23.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 371, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 372, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 373, 23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 374, 23.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 375, 24.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 376, 26.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 377, 27.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 378, 29.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 379, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 380, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 381, 30);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 382, 31.1);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 383, 31.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 384, 33);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 385, 33.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 386, 34.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 387, 34.9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 388, 35.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (6, 389, 35.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, -1, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 0, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 1, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 2, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 3, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 4, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 5, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 6, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 7, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 8, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 9, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 10, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 11, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 12, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 13, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 14, 0.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 15, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 16, 9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 17, 10.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 18, 10.59);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 19, 10.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 20, 9.63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 21, 9.11);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 22, 9.33);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 23, 10.74);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 24, 12.21);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 25, 11.22);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 26, 7.98);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 27, 4.62);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 28, 3.06);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 29, 1.8);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 30, 0.27);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 31, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 32, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 33, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 34, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 35, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 36, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 37, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 38, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 39, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 40, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 41, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 42, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 43, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 44, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 45, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 46, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 47, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 48, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 49, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 50, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 51, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 52, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 53, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 54, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 55, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 56, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 57, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 58, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 59, 0.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 60, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 61, 9.42);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 62, 14.27);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 63, 15.64);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 64, 15.34);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 65, 14.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 66, 13.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 67, 14.28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 68, 15.86);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 69, 15.82);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 70, 15.36);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 71, 14.47);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 72, 13.74);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 73, 14.13);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 74, 17.24);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 75, 20.91);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 76, 23.94);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 77, 27.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 78, 29.72);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 79, 30.66);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 80, 30.39);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 81, 28.42);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 82, 27.15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 83, 28.13);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 84, 29.43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 85, 29.72);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 86, 27.95);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 87, 26.11);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 88, 24.18);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 89, 20.11);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 90, 16.31);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 91, 13.65);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 92, 11.79);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 93, 8.15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 94, 5.22);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 95, 3.16);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 96, 1.65);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 97, 0.24);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 98, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 99, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 100, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 101, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 102, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 103, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 104, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 105, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 106, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 107, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 108, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 109, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 110, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 111, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 112, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 113, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 114, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 115, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 116, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 117, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 118, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 119, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 120, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 121, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 122, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 123, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 124, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 125, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 126, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 127, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 128, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 129, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 130, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 131, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 132, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 133, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 134, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 135, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 136, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 137, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 138, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 139, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 140, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 141, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 142, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 143, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 144, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 145, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 146, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 147, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 148, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 149, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 150, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 151, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 152, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 153, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 154, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 155, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 156, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 157, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 158, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 159, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 160, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 161, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 162, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 163, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 164, 0.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 165, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 166, 9.02);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 167, 10.75);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 168, 10.58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 169, 9.58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 170, 6.57);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 171, 3.49);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 172, 2.55);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 173, 0.42);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 174, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 175, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 176, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 177, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 178, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 179, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 180, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 181, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 182, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 183, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 184, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 185, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 186, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 187, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 188, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 189, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 190, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 191, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 192, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 193, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 194, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 195, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 196, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 197, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 198, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 199, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 200, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 201, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 202, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 203, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 204, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 205, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 206, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 207, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 208, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 209, 0.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 210, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 211, 9.38);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 212, 13.87);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 213, 14.73);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 214, 14.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 215, 13.87);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 216, 13.65);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 217, 13.93);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 218, 15.14);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 219, 15.13);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 220, 14.15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 221, 12.16);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 222, 9.09);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 223, 6.57);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 224, 3.52);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 225, 2.63);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 226, 1.02);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 227, 0.12);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 228, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 229, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 230, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 231, 0.14);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 232, 1.69);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 233, 6.01);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 234, 9.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 235, 9.97);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 236, 8.22);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 237, 5.74);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 238, 4.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 239, 4.51);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 240, 5.32);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 241, 7.4);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 242, 8.92);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 243, 8.72);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 244, 7.29);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 245, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 246, 3.08);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 247, 1.95);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 248, 0.3);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 249, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 250, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 251, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 252, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 253, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 254, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 255, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 256, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 257, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 258, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 259, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 260, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 261, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 262, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 263, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 264, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 265, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 266, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 267, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 268, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 269, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 270, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 271, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 272, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 273, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 274, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 275, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 276, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 277, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 278, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 279, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 280, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 281, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 282, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 283, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 284, 0.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 285, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 286, 9.42);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 287, 14.21);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 288, 15.11);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 289, 14.59);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 290, 13.77);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 291, 13.83);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 292, 14.45);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 293, 15.45);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 294, 14.27);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 295, 11.13);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 296, 7.35);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 297, 3.61);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 298, 2.61);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 299, 0.87);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 300, 0.09);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 301, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 302, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 303, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 304, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 305, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 306, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 307, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 308, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 309, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 310, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 311, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 312, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 313, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 314, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 315, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 316, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 317, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 318, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 319, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 320, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 321, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 322, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 323, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 324, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 325, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 326, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 327, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 328, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 329, 0.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 330, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 331, 9.5);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 332, 14.93);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 333, 16.23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 334, 15.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 335, 14.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 336, 13.57);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 337, 13.83);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 338, 15.79);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 339, 15.95);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 340, 15.24);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 341, 14.42);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 342, 13.29);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 343, 10.79);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 344, 7.02);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 345, 3.55);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 346, 2.71);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 347, 1.62);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 348, 0.24);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 349, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 350, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 351, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 352, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 353, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 354, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 355, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 356, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 357, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 358, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 359, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 360, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 361, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 362, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 363, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 364, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 365, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 366, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 367, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 368, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 369, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 370, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 371, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 372, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 373, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 374, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 375, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 376, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 377, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 378, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 379, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 380, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 381, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 382, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 383, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 384, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 385, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 386, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 387, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 388, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 389, 0.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 390, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 391, 9);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 392, 10.6);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 393, 10.57);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 394, 10.03);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 395, 9.43);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 396, 8.85);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 397, 8.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 398, 8.89);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 399, 11.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 400, 13.02);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 401, 11.85);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 402, 8.52);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 403, 4.71);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 404, 3.14);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 405, 2.46);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 406, 0.84);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 407, 0.09);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 408, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 409, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 410, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 411, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 412, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 413, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 414, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 415, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 416, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 417, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 418, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 419, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 420, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 421, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 422, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 423, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 424, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 425, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 426, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 427, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 428, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 429, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 430, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 431, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 432, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 433, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 434, 0.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 435, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 436, 9.02);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 437, 10.75);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 438, 10.58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 439, 9.58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 440, 6.57);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 441, 3.49);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 442, 2.65);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 443, 1.17);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 444, 0.15);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 445, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 446, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 447, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 448, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 449, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 450, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 451, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 452, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 453, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 454, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 455, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 456, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 457, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 458, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 459, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 460, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 461, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 462, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 463, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 464, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 465, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 466, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 467, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 468, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 469, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 470, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 471, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 472, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 473, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 474, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 475, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 476, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 477, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 478, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 479, 0.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 480, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 481, 9.28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 482, 13.02);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 483, 13.73);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 484, 13.36);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 485, 12.69);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 486, 13.75);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 487, 15.14);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 488, 15.13);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 489, 14.31);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 490, 13.94);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 491, 14.76);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 492, 17.2);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 493, 19.25);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 494, 19.37);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 495, 18.83);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 496, 18.47);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 497, 19.71);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 498, 19.77);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 499, 19.21);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 500, 18.44);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 501, 17.58);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 502, 16.05);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 503, 12.84);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 504, 9.71);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 505, 6.39);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 506, 3.46);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 507, 2.77);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 508, 2.07);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 509, 0.33);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 510, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 511, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 512, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 513, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 514, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 515, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 516, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 517, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 518, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 519, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 520, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 521, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 522, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 523, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 524, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 525, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 526, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 527, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 528, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 529, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 530, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 531, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 532, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 533, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 534, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 535, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 536, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 537, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 538, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 539, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 540, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 541, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 542, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 543, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 544, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 545, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 546, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 547, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 548, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 549, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 550, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 551, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 552, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 553, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 554, 0.48);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 555, 4.56);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 556, 9.02);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 557, 10.77);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 558, 10.77);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 559, 10.23);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 560, 9.65);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 561, 9.28);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 562, 9.57);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 563, 11.26);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 564, 12.7);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 565, 12.03);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 566, 8.13);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 567, 4.62);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 568, 3.12);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 569, 2.31);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 570, 0.81);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 571, 0.09);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 572, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 573, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 574, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 575, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 576, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 577, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 578, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 579, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 580, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 581, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 582, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 583, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 584, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 585, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 586, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 587, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 588, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 589, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 590, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 591, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 592, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 593, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 594, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 595, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 596, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 597, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 598, 0);
insert into driveschedulesecond (drivescheduleid, second, speed) values (7, 599, 0);

--
--	Populate the OperatingMode table with the spreadsheet values
--

-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (1, 'ESP Bin 1', -999, -2);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (2, 'ESP Bin 2', -2, 0);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (3, 'ESP Bin 3', 0, 1);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (4, 'ESP Bin 4', 1, 4);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (5, 'ESP Bin 5', 4, 7);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (6, 'ESP Bin 6', 7, 10);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (7, 'ESP Bin 7', 10, 13);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (8, 'ESP Bin 8', 13, 16);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (9, 'ESP Bin 9', 16, 19);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (10, 'ESP Bin 10', 19, 23);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (11, 'ESP Bin 11', 23, 28);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (12, 'ESP Bin 12', 28, 33);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (13, 'ESP Bin 13', 33, 39);
-- INSERT INTO OperatingMode (opModeID, opModeName, lowerBound, upperBound) VALUES (14, 'ESP Bin 14', 39, 999);

--
--	Populate the Link table with the spreadsheet values
--

INSERT IGNORE INTO Link (linkID, countyID, zoneID, roadTypeID, linkLength, linkVolume, grade) VALUES (2616123, 26161, 261610, 23, null, null, 0);
INSERT IGNORE INTO Link (linkID, countyID, zoneID, roadTypeID, linkLength, linkVolume, grade) VALUES (2616133, 26161, 261610, 33, null, null, 0);
