unit CommandLine;

interface

Procedure ExecuteAndSave;

implementation

Uses  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, FileCtrl, Thread, LinkedThread,
  Menus, ExtCtrls, ToolWin, ComCtrls, Global, AQStudy, Librarys2, Main, Parent, LinkedSegs, ExportResults,
  Basins, Registry, ImgList, AQUAOBJ, AQBaseForm, LinkedInterface, Db,  System.UITypes, Study_IO;

function AttachConsole(dwProcessID: Integer): Boolean; stdcall; external 'kernel32.dll';
function FreeConsole(): Boolean; stdcall; external 'kernel32.dll';

Var WriteToConsole: Boolean;

Procedure WriteMessage(Msg: String);
Begin
  If WriteToConsole then Writeln(Msg)
                    else ShowMessage(Msg);
End;

Procedure ExecuteAndSave;
Var IsALS, IsLinked: Boolean;
    SaveName: AnsiString;
    IncomingFile: AnsiString;
    PNewLinked: TLinkedSegs;
    PNewStudy : TAQUATOXSegment;
    TS: TSimulation;
    TLS: TLinkedSimulation;
Begin
  PNewLinked := nil;
  WriteToConsole := AttachConsole(-1);

  IncomingFile := ParamStr(2);
  IncomingFile := RelToAbs(IncomingFile, GetCurrentDir);

  If Not FileExists(IncomingFile) then
    Begin
      WriteMessage('File Not Found: '+IncomingFile);
      FreeConsole;
      Halt;
    End;

  IsALS := Uppercase(ExtractFileExt(IncomingFile))='.ALS';

  SuppressGUI := True;

  SaveName := ParamStr(3);
  if SaveName <> '' then SaveName := RelToAbs(SaveName, GetCurrentDir);

  if IsALS then PNewLinked := OpenLS(IncomingFile)
           else LoadFile(PNewStudy, IncomingFile,IsLinked);
  if IsLinked then PNewLinked := OpenLS(IncomingFile);  // open linked text file

  IsLinked := IsLinked or IsALS;
  if IsLinked then
    Begin
      if PNewLinked = nil then exit;
      LinkedForm := TLinkedForm.Create(nil,PNewLinked);
      LinkedForm.LinkedSegmts := PNewLinked;
      PNewLinked.TemplateSeg.Control_Is_Running := (ECSave or ECExp);
      if PNewLinked.Verify_Runnable(False) then
        Begin
          TLS := TLinkedSimulation.Create(PNewLinked, PNewLinked, nil,nil,False);
          TLS.WaitFor;
          TLS.Terminate;
          if SaveName <> '' then Begin PNewLInked.DirName := ''; PNewLinked.FileName := SaveName; End;
          if (ECSave or EPSave)
            then LinkedForm.Save1Click(nil)
            else Begin
                   if SaveName = '' then SaveName := ChangeFileExt(IncomingFile,'.csv');
                   ExportLinkedResults(nil,(ECSave or ECExp),PNewLinked,SaveName);
                 End;
          WriteMessage('Linked-Mode Run Completed Successfully and File Saved');
        End
      else WriteMessage('Simulation is not Valid.  Run in GUI for details.');
    End
  else
    Begin
      if PNewStudy = nil then exit;
      PNewStudy.Control_Is_Running := (ECSave or ECExp);
      PrimaryInterface := TPrimaryInterface.Create(nil,PNewStudy);
      if PNewStudy.Verify_Runnable((ECSave or ECExp),False) then
        Begin
          TS := TSimulation.Create(PNewStudy, PNewStudy, nil,False);
          TS.WaitFor;
          TS.Terminate;
          if SaveName <> '' then Begin PNewStudy.DirName := ''; PNewStudy.FileName := SaveName; End;
          if (ECSave or EPSave)
            then PrimaryInterface.Save1Click(nil)
            else Begin
                   if SaveName = '' then SaveName := ChangeFileExt(IncomingFile,'.csv');
                   ExportResults1(nil,(ECSave or ECExp),PNewStudy,SaveName);
                 End;

          WriteMessage('Run Completed Successfully and File Saved');
        End
      else WriteMessage('Simulation is not Valid.  Run in GUI for details.');

    End;

  FreeConsole;
End;

end.
