//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
// 
unit ExportResults;

interface

Uses Dialogs,  AQUAOBJ, AQStudy, LinkedSegs, Global, Variants,
  FireDAC.Comp.Client, GraphChc, OleCtrls;

Procedure ExportResults1(SaveDialog1: TSaveDialog; ControlExport: Boolean;
                         OStudy: TAQUATOXSegment; InFileN: AnsiString);

Procedure ExportLinkedResults(SaveDialog1: TSaveDialog; ControlExport: Boolean; LS: TLinkedSegs; InFileN: AnsiString);

{---------------------------------------------------------------------------------------}

implementation

Uses Controls, Wait, ActiveX, Windows, SysUtils, DB, Forms, Basins, ExcelFuncs, Excel2000, System.UITypes;

Procedure ExportResults1(SaveDialog1: TSaveDialog; ControlExport: Boolean;
                         OStudy: TAQUATOXSegment; InFileN: AnsiString);

Type TExportType = (CSV,XT_EXCEL);
Var Extension,FileName,OutDir,OutFile     : AnsiString;
    FileLoop, Loop, NumFields, CurrHeaderIndex, TopIndex,
    OuterLoop, Num_To_Write, BottomHeader : Integer;
    OutResults : ResultsType;
    PR         : TResults;
    DP         : TDataPoint;
    SegLoop    : VerticalSegments;
    PH         : TResHeader;
    CSVFile    : TextFile;
    ExportType : TExportType;
    ExcelRow,ExcelCol,MaxFields  : Integer;
    LastAnsiString,XLSFileName : AnsiString;
    ExportGenScn: Boolean;
    TEx: TExcelOutput;

            {-------------------------------------------------------------------------------}
            Function DisplayGraphChoiceDlg:Boolean;
            Var I: Integer;
                MR: TModalResult;
            Begin
              DisplayGraphChoiceDlg := False;

              {Clear the graphing choice dialog}
              GraphChoiceDlg.SourceList.Clear;
              GraphChoiceDlg.DstList.Clear;

              {SETUP AND DISPLAY THE RESULTS THAT CAN BE EXPORTED}

              GraphChoiceDlg.Caption := 'AQUATOX-- Select Results to Export';
              GraphChoiceDlg.DstLabel.Caption := 'Results to Export:';
              If GenScnInstalled then GraphChoiceDlg.GenScnButton.Visible := True;

              If ControlExport then OutResults:=OStudy.SV.ControlResults
                               else OutResults:=OStudy.SV.Results;

              For I := 0 to OutResults[Epilimnion].Headers.Count-1 do
                Begin
                  PH := OutResults[Epilimnion].Headers.At(I);
                  GraphChoiceDlg.MasterList.Add(PH.ListStr);
                End;

              ExportGenScn := False;
              Mr := GraphChoiceDlg.ShowModal;
              GraphChoiceDlg.GenScnButton.Visible := False;
              If Mr = MrCancel then Exit;
              If Mr = MrYes then
                Begin
                  ExportGenScn := True;
                  Exit;
                End;

              NumFields := GraphChoiceDlg.DstList.Items.Count;
              If NumFields < 1 then
                Begin
                  MessageDlg('You have not selected any results to export.',mterror,[mbOK],0);
                  Exit;
                End;

              DisplayGraphChoiceDlg := True;

            End;

            {-------------------------------------------------------------------------------}
            Procedure SetupOutputDatabase(Num: Integer);
            Begin
              OutDir:=ExtractFilePath(FileName);
              OutFile:=ExtractFileName(FileName);
              If SegLoop=Hypolimnion then Outfile:='Hyp_'+Outfile;

              Extension := LowerCase(ExtractFileExt(FileName));

              MaxFields := 1000;

              If (SaveDialog1<>nil) and (Num=1) and (NumFields>MAXFIELDS) and (ExportType<>XT_Excel) and (SegLoop=Epilimnion) then
                  MessageDlg('The export will be broken up into more than one file as it has over '+
                     IntToStr(MaxFields)+' fields.',mtinformation,[mbOK],0);

              If Not SuppressGUI then WaitDlg.Update;

              If (Num>1) then
                Begin
                  Delete(OutFile,Pos(Extension,Lowercase(OutFile)),Length(Extension));
                  OutFile:=OutFile+IntToStr(Num)+Extension;
                End;
            End;
            {-------------------------------------------------------------------------------}
            Function SetupTable(Nm: AnsiString): Boolean;
            Var TabName: AnsiString;
            Begin
             Result := True;
             If ExportType = CSV then
               Begin
                 ASSIGNFILE(CSVFile,OutDir + Nm);
                 Rewrite(CSVFile);
                 Write(CSVFile,'Date,');
                 Write(CSVFile,'Time,');
                 Exit;
               End;

             If ExportType = XT_EXCEL then
               Begin
                 Coinitialize(nil);
                 If (FileLoop=1) and (SegLoop = Epilimnion)
                   then
                     Begin
                       TEx := TExcelOutput.Create(False);
                       If Not TEx.OpenFiles then
                         Begin
                           TEx := nil;
                           Raise EAQUATOXError.Create('Error Exporting Results');
                         End;
                       TEx.FileN := OutDir + Nm;
                     End
                   else TEx.WS := TEx.Wbk.Sheets.Add(EmptyParam,TEx.Wbk.sheets.item[TEx.Wbk.sheets.count],1,xlWorkSheet,TEx.LCID) as _Worksheet;

                 TabName := 'AQUATOX Export';
                 If FileLoop>1 then TabName := 'AQUATOX' + '('+IntToStr(FileLoop)+')';
                 If SegLoop = Hypolimnion then TabName := TabName + ' Hypolimnion';
                 TEx.WS.Name := TabName;

                 TEx.WS.Cells.Item[1,1].Value := 'Date:';
                 TEx.WS.Cells.Item[2,1].Value := 'Time:';

                 Exit;
               End;

            End; {SetupTable}
            {-------------------------------------------------------------------------------}
            Procedure MakeExportEntry(N: Integer; RC: TResultsCollection);
            Var Name: AnsiString;
                TFD : TFieldDef;
                PH2 : TResHeader;
            Begin
              PH2 :=RC.Headers.At(N);
              Name:=PH2.ListStr;

              {If Name<>'Undisplayed' then }
                If ExportType = CSV
                  then Begin
                         While Pos(',',Name)>0 do
                           Delete(Name,Pos(',',Name),1);
                         Write(CSVFile,Name+',');
                       End
                  else If ExportType = XT_EXCEL
                    then
                      Begin
                        Inc(ExcelCol);
                        TEx.WS.Cells.Item[1,ExcelCol+1].Value := Name;
                      End;
            End;
            {-------------------------------------------------------------------------------}
Var EFE, BaseName, CAdd: AnsiString;
Begin  {Procedure ExportResults1}
  TEx := nil;
  TeaseInc:=1;

  If not SuppressGUI then Application.CreateForm(TGraphChoiceDlg, GraphChoiceDlg);

  Try

  If SaveDialog1=nil
    then Begin
           FileName := InFileN;
           If Pos('xls',LowerCase(ExtractFileExt(InFileN))) > 0
             then ExportType := XT_EXCEL
             else ExportType := CSV;

           If ControlExport then OutResults:=OStudy.SV.ControlResults
                            else OutResults:=OStudy.SV.Results;
           NumFields := OutResults[Epilimnion].Headers.Count
         End
    else
      Begin
        If not DisplayGraphChoiceDlg then
          Begin
            If ExportGenScn then LBasinsInfo.ExportGenScn(False,OStudy,nil);
            Exit;
          End;

        SaveDialog1.Title:='Export Results As:';

        BaseName := ExtractFileName(OStudy.FileName);
        Delete(BaseName,Length(BaseName)-3,4);
        If ControlExport then Cadd := '_C' else CAdd:='';
        SaveDialog1.FileName := {OStudy.DirName + }BaseName + '_Export'+CAdd+'.xls';
        SaveDialog1.Filter := 'Excel Format (*.xls)|*.XLS|Comma Separated (*.csv)|*.CSV';
        SaveDialog1.FilterIndex := 1;
        If not SaveDialog1.Execute then exit;
        FileName:=SaveDialog1.FileName;

        EFE := Lowercase(ExtractFileExt(FileName));
        If (EFE <> '.xls') and (EFE <> '.xlsx') and (EFE <> '.csv')  then
            Case SaveDialog1.FilterIndex of
               1: FileName:=FileName+'.xls';
               else FileName:=FileName+'.csv';
             End; {Case}

       If FileExists(SaveDialog1.FileName) then If Not DeleteFile(SaveDialog1.FileName)
         then Begin
                If (SaveDialog1<>nil) then MessageDlg('Cannot gain exclusive access to the file to overwrite it.',mtError,[mbOK],0);
                Exit;
              End;

        Case SaveDialog1.FilterIndex of
           1: ExportType := XT_Excel;
           else ExportType := CSV;
         End; {Case}
     End;

   If not SuppressGUI then WaitDlg.Setup('Please Wait One Moment, Exporting Data');

TRY
  FOR SegLoop:=Epilimnion to Hypolimnion DO
    Begin
      BottomHeader := 0;

      If (OutResults[SegLoop].Count > 0) then
        Begin
          SetupOutputDatabase(1);

          For FileLoop:=1 to (((NumFields-1) div (MAXFIELDS-1))+1) do
            Begin
              If (FileLoop>1) then SetupOutputDatabase(FileLoop);
              SetupTable(OutFile);

              {Calculate Top Field for this File}
              If NumFields < (FileLoop*(MAXFIELDS-1))
                 then TopIndex :=(NumFields mod (MAXFIELDS-1))
                 else TopIndex := MAXFIELDS-1;

              ExcelCol := 1;
              ExcelRow := 0;
              {Create Appropriate Fields to Export}
              CurrHeaderIndex:=BottomHeader-1;
              For Loop := 1 to TopIndex do
                Begin
                  Repeat
                    Inc(CurrHeaderIndex);
                    PH := OutResults[Epilimnion].Headers.At(CurrHeaderIndex);
                  Until (SaveDialog1=nil) or (GraphChoiceDlg.DstList.Items.IndexOf(PH.ListStr)>-1);

                  MakeExportEntry(CurrHeaderIndex,OutResults[SegLoop]);
                End;

              If ExportType=CSV then WriteLn(CSVFile);
              If ExportType = XT_Excel then
                Begin
                  Inc(ExcelRow);
                  ExcelCol:=1;
                End;

              {Write the datapoints into the Export Table}
              Num_to_Write := OutResults[SegLoop].Count-1;

              For OuterLoop:=0 to Num_to_Write do
                Begin
                  PR  :=OutResults[SegLoop].At(OuterLoop);
                  Case ExportType of
                    CSV: Begin
                            Write(CSVFile,DateToStr(PR.Date),', ');
                            Write(CSVFile,TimeToStr(PR.Date));
                         End;
                    else Begin
                           TEx.WS.Cells.Item[ExcelRow+1,1].Value := DateToStr(PR.Date);
                           TEx.WS.Cells.Item[ExcelRow+1,ExcelCol+1].Value := TimeToStr(PR.Date);
                         End;
                  End; {Case}

                  CurrHeaderIndex:=BottomHeader-1;
                  For Loop := 1 to TopIndex do
                    Begin
                      Repeat
                        Inc(CurrHeaderIndex);
                        PH := OutResults[Epilimnion].Headers.At(CurrHeaderIndex);
                      Until (SaveDialog1=nil) or (GraphChoiceDlg.DstList.Items.IndexOf(PH.ListStr)>-1);
                      DP := PR.DataPoints.At(PH.PointIndex);
                      Case ExportType of
                        CSV: Write(CSVFile,',' + FloatToStr(DP.State));
                        Else Begin
                               Inc(ExcelCol);
                               TEx.WS.Cells.Item[ExcelRow+1,ExcelCol+1].Value := DP.State;
                             End;
                      End; {Case}
                    End;

                  Case ExportType of
                    CSV: Writeln(CSVFile);
                    Else Begin Inc(ExcelRow);ExcelCol := 1; End;
                  End; {Case}

                  Inc(TeaseInc);
                  If Not SuppressGUI and (TeaseInc=3)
                    then Begin WaitDlg.Tease; TeaseInc:=1; End;
                End;

              If ExportType=CSV then CloseFile(CSVFile);

              If ExportType = XT_Excel then
                Begin
                   TEx.WS.Range['A1', 'A1'].EntireColumn.NumberFormat := 'm/d/yyyy';
                   TEx.WS.Range['B1', 'B1'].EntireColumn.NumberFormat := 'h:mm AM/PM';

                   TEx.WS.Cells.Item[2,2].Select;
                   TEx.Excel.ActiveWindow.FreezePanes := True;

                End;


              BottomHeader:=CurrHeaderIndex+1;  {For next File}

           End; {FileLoop}

       END; {If Not NoResults}
  END; {For SegLoop:=Epilimnion to Hypolimnion}

    If ExportType = XT_Excel then
      Begin
        TEx.WS := TEx.Excel.Worksheets.Item[1] as _Worksheet;
        TEx.WS.Activate(TEx.LCID) ;
        TEx.SaveandClose;
      End;

    If not SuppressGUI then WaitDlg.Hide;
    If SaveDialog1 <> nil then MessageDlg('Export Completed Successfully.',mtinformation,[mbok],0);

  EXCEPT

     If TEx<>nil then TEx.CloseFiles;

     If not SuppressGUI then WaitDlg.Hide;
     Raise;
  END;

  Finally
    If Not SuppressGUI then GraphchoiceDlg.Free;
  End;


End;


{------------------------------------------------------------------------------------------}


{                                        LINKED EXPORT BELOW                               }


{------------------------------------------------------------------------------------------}

procedure ExportLinkedResults(SaveDialog1: TSaveDialog; ControlExport: Boolean;
                        LS: TLinkedSegs;InFileN: AnsiString);

Type TExportType = (CSV,XT_EXCEL);
Var Extension,FileName,OutDir,OutFile     : AnsiString;
    NumFields, CurrHeaderIndex, TopIndex, BottomSegInd,
    BottomHeader,Num_To_Write : Integer;
    OutResults : ResultsType;
    PR         : TResults;
    DP         : TDataPoint;
    ExportType : TExportType;
    SegCount   : Integer;
    PH         : TResHeader;
    CSVFile    : TextFile;
    ExcelRow,ExcelCol,MaxFields  : Integer;
    AQTS       : TAQUATOXSegment;
    LastAnsiString : AnsiString;
    FieldHeaders: Array[1..1001] of AnsiString;
    SegIndex: Integer;
    {Excel Vars}
    TEx: TExcelOutput;

            {-------------------------------------------------------------------------------}
            Function DisplayGraphChoiceDlg:Boolean;
            Var I: Integer;
            Begin
              DisplayGraphChoiceDlg := False;

              {Setup GraphChoice Dialog}
              GraphChoiceDlg.IncAllBtn.Enabled := True;

              {Clear the graphing choice dialog}
              GraphChoiceDlg.SourceList.Clear;
              GraphChoiceDlg.DstList.Clear;

              {SETUP AND DISPLAY THE RESULTS THAT CAN BE EXPORTED}
              If ControlExport
                then GraphChoiceDlg.Caption := 'Linked AQUATOX-- Select Control Results to Export'
                else GraphChoiceDlg.Caption := 'Linked AQUATOX-- Select Perturbed Results to Export';

              GraphChoiceDlg.DstLabel.Caption := 'Results to Export:';

              AQTS := LS.SegmentColl.At(0);
              If ControlExport then OutResults:=AQTS.SV.ControlResults
                               else OutResults:=AQTS.SV.Results;

              For I := 0 to OutResults[Epilimnion].Headers.Count-1 do
                Begin
                  PH := OutResults[Epilimnion].Headers.At(I);
                  GraphChoiceDlg.MasterList.Add(PH.HeadStr);
                End;

{              because of rates files there can be different #s of vars in each seg...  causing crash? }

              If GraphChoiceDlg.ShowModal=MrCancel then Exit;
              NumFields := GraphChoiceDlg.DstList.Items.Count;
              If NumFields < 1 then
                Begin
                  MessageDlg('You have not selected any results to export.',mterror,[mbOK],0);
                  Exit;
                End;

              DisplayGraphChoiceDlg := True;
            End;
            {-------------------------------------------------------------------------------}
            Procedure SetupOutputDatabase(Num: Integer);
            Begin
              AQTS := LS.SegmentColl.At(0);
              If ControlExport then OutResults:=AQTS.SV.ControlResults
                               else OutResults:=AQTS.SV.Results;

              OutDir:=ExtractFilePath(FileName);
              OutFile:=ExtractFileName(FileName);

              Extension := LowerCase(ExtractFileExt(Outfile));

              MaxFields := 1000;

              If (Num=1) and (NumFields*SegCount>MAXFIELDS) and (ExportType<>XT_Excel) then
                  If (SaveDialog1<>nil) then MessageDlg('The export will be broken up into more than one file as it has over '+
                     IntToStr(MaxFields)+' fields.',mtinformation,[mbOK],0);

              If Not SuppressGUI then WaitDlg.Update;

              If Num>1 then
                Begin
                  Delete(OutFile,Pos(Extension,Lowercase(OutFile)),Length(Extension));
                  OutFile:=OutFile+IntToStr(Num)+Extension;
                End;
            End;
            {-------------------------------------------------------------------------------}
            Function SetupTable(Nm: AnsiString; Num: Integer): Boolean;
            Var TabName: AnsiString;
            Begin
             Result := True;
             If ExportType = CSV then
               Begin
                 ASSIGNFILE(CSVFile,OutDir + Nm);
                 Rewrite(CSVFile);
                 Write(CSVFile,'Date,');
                 Exit;
               End;

             If ExportType = XT_EXCEL then
               Begin
                 Coinitialize(nil);

                 If (Num=1)
                   then
                     Begin
                       TEx := TExcelOutput.Create(False);
                       If Not TEx.OpenFiles then
                         Begin
                           TEx := nil;
                           Raise EAQUATOXError.Create('Error Exporting Results');
                         End;
                       TEx.FileN := OutDir + Nm;
                     End
                   else TEx.WS := TEx.Wbk.Sheets.Add(EmptyParam,TEx.Wbk.sheets.item[TEx.Wbk.sheets.count],1,xlWorkSheet,TEx.LCID) as _Worksheet;

                 TabName := 'AQUATOX Export';
                 If Num>1 then TabName := 'AQUATOX' + '('+IntToStr(Num)+')';
                 TEx.WS.Name := TabName;

                 TEx.WS.Cells.Item[1,1].Value := 'Date:';
                 TEx.WS.Cells.Item[2,1].Value := 'Time:';

                 Exit;
               End;

            End; {SetupTable}
            {-------------------------------------------------------------------------------}
            Procedure MakeExportEntry(N: Integer; RC: TResultsCollection; SegID: AnsiString);
            Var Name: AnsiString;
                PH2 : TResHeader;
            Begin
              PH2 :=RC.Headers.At(N);
              Name:=PH2.ListStr;

              {If Name<>'Undisplayed' then }
                Begin
                  Name := SegID + '_'+ Name;
                  If ExportType = CSV
                    then Begin
                           While Pos(',',Name)>0 do
                             Delete(Name,Pos(',',Name),1);
                           Write(CSVFile,Name+',');
                         End
                    else If ExportType = XT_Excel
                      then
                        Begin
                         Name := 'S' + Name; Inc(ExcelCol);
                         TEx.WS.Cells.Item[1,ExcelCol+1].Value := Name;
                        End
                    else;
                End;
            End;
            {-------------------------------------------------------------------------------}

    Procedure Doit;    {linked export}
    Var FileLoop, Loop, OuterLoop: Integer;
        Found: Boolean;
    Begin
      TEx := nil;
      SegCount := LS.SegmentColl.Count;

      TeaseInc:=1;

      If SaveDialog1=nil
         then Begin
                FileName := InFileN;
                If Pos('xls',LowerCase(ExtractFileExt(InFileN))) > 0
                  then ExportType := XT_EXCEL
                  else ExportType := CSV;
                AQTS := LS.SegmentColl.At(0);
                If ControlExport then OutResults:=AQTS.SV.ControlResults
                                 else OutResults:=AQTS.SV.Results;
                NumFields := OutResults[Epilimnion].Headers.Count
              End
         else
           Begin
              If not DisplayGraphChoiceDlg then Exit;

              SaveDialog1.Title:='Export Results As:';
              SaveDialog1.InitialDir := ''; // Output_Dir;
              SaveDialog1.FileName := '';
              SaveDialog1.Filter := 'Excel Format (*.xls*)|*.XLS*|Comma Separated (*.csv)|*.CSV';

              If not SaveDialog1.Execute then exit;
              FileName:=SaveDialog1.FileName;

             If FileExists(SaveDialog1.FileName) then If Not DeleteFile(SaveDialog1.FileName)
               then Begin
                      If (SaveDialog1<>nil) then MessageDlg('Cannot gain exclusive access to the file to overwrite it.',mtError,[mbOK],0);
                      Exit;
                    End;

              If ExtractFileExt(FileName) = '' then
                  Case SaveDialog1.FilterIndex of
                     1: FileName:=FileName+'.xls';
                     else FileName:=FileName+'.csv';
                   End; {Case}

              Case SaveDialog1.FilterIndex of
                 1: ExportType := XT_Excel;
                 else ExportType := CSV;
               End; {Case}
           End; {SaveDlg not nil}

    If Not SuppressGUI then
    If ControlExport
      then WaitDlg.Setup('Please Wait One Moment, Exporting Control Results')
      else WaitDlg.Setup('Please Wait, Exporting Perturbed Results');

    TRY
        BottomSegInd := 0;
        BottomHeader := 0;

        If (OutResults[Epilimnion].Count > 0) then
          Begin
            SetupOutputDatabase(1);

            For FileLoop:=1 to ((((NumFields*SegCount)-1) div (MAXFIELDS-1))+1) do
              Begin
                If (FileLoop>1) then SetupOutputDatabase(FileLoop);
                SetupTable(OutFile,FileLoop);

                {Calculate Top Field for this File}
                If (NumFields*SegCount) < (FileLoop*(MAXFIELDS-1))
                   then TopIndex :=((NumFields*SegCount) mod (MAXFIELDS-1))
                   else TopIndex := MAXFIELDS-1;

                ExcelCol := 0;
                ExcelRow := 0;

                {Create Appropriate Fields to Export (labels in Excel file)}
                SegIndex := BottomSegInd;
                CurrHeaderIndex:= BottomHeader-1;
                If BottomHeader<>0 then   {IF not the first File or Page written}
                      Repeat
                        Inc(CurrHeaderIndex);  {Find the current header}
                        PH := OutResults[Epilimnion].Headers.At(CurrHeaderIndex);
                      Until (SaveDialog1=nil) or (GraphChoiceDlg.DstList.Items.IndexOf(PH.HeadStr)>-1);

                For Loop := 1 to TopIndex do  {Top Index in this page or file}
                  Begin
                    Inc(SegIndex);
                    If SegIndex>SegCount then SegIndex := 1;     {Find Relevant Result in order of Sorted Headers}
                    If SegIndex=1 then
                      Repeat
                        Inc(CurrHeaderIndex);
                        PH := OutResults[Epilimnion].Headers.At(CurrHeaderIndex);
                      Until (SaveDialog1=nil) or (GraphChoiceDlg.DstList.Items.IndexOf(PH.HeadStr)>-1);

                    AQTS := LS.SegmentColl.At(SegIndex-1);
                    MakeExportEntry(CurrHeaderIndex,OutResults[Epilimnion],AQTS.SegNumber);
                    FieldHeaders[Loop] := PH.HeadStr;
                  End;

              If ExportType=CSV then WriteLn(CSVFile);
              If ExportType = XT_Excel then
                Begin
                  Inc(ExcelRow);
                  ExcelCol:=0;
                End;


                Num_to_Write:=999999;  {find seg with fewest number of dates, write that number... all segs should have an equal number}
                For OuterLoop := 0 to SegCount-1 do
                  Begin
                    AQTS := LS.SegmentColl.At(OuterLoop);
                    If ControlExport then OutResults:=AQTS.SV.ControlResults
                                     else OutResults:=AQTS.SV.Results;
                    If Num_to_Write > OutResults[Epilimnion].Count-1 then
                       Num_to_Write := OutResults[Epilimnion].Count-1;   {Number of Date Fields to write}
                  End;

                CurrHeaderIndex:= BottomHeader-1;
                {Write the datapoints into the Export Table}
                For OuterLoop:=0 to Num_to_Write do {Number of Date Fields to write}
                  Begin
                    PR := OutResults[Epilimnion].At(OuterLoop);

                    Case ExportType of       {WRITE THE DATE}
                      CSV: Write(CSVFile,DateToStr(PR.Date));
                      else TEx.WS.Cells.Item[ExcelRow+1,ExcelCol+1].Value := PR.Date;
                    End; {Case  WRITE THE DATE}

                    SegIndex := BottomSegInd;
                    For Loop := 1 to TopIndex do  {loop through number of output fields}
                      Begin
                        Inc(SegIndex);  {move through segments one-by-one}
                        If SegIndex>SegCount then SegIndex := 1;

                        AQTS := LS.SegmentColl.At(SegIndex-1);
                        If ControlExport then OutResults:=AQTS.SV.ControlResults
                                         else OutResults:=AQTS.SV.Results;

                        CurrHeaderIndex := -1;
                        Found := False;
                        If (CurrHeaderIndex < OutResults[Epilimnion].Headers.Count-1) then
                          Repeat
                            Inc(CurrHeaderIndex);
                            PH := OutResults[Epilimnion].Headers.At(CurrHeaderIndex);
                            Found := FieldHeaders[Loop]= PH.Headstr;
                          Until Found or (CurrHeaderIndex = OutResults[Epilimnion].Headers.Count-1);

                        If Found then
                          Begin
                            PR := OutResults[Epilimnion].At(OuterLoop);
                            DP := PR.DataPoints.At(PH.PointIndex);
                          End;

                        If Found then
                            Case ExportType of
                              CSV: Write(CSVFile,',' + FloatToStr(DP.State));
                              Else Begin
                                     Inc(ExcelCol);
                                     TEx.WS.Cells.Item[ExcelRow+1,ExcelCol+1].Value := DP.State;
                                   End;
                            End; {Case}

                        If Not Found then
                            Case ExportType of
                              CSV: Write(CSVFile,', N A');
                              XT_Excel:
                                   Begin
                                     Inc(ExcelCol);
                                     TEx.WS.Cells.Item[ExcelRow+1,ExcelCol+1].Value := 'N A';
                                   End;
                            End; {Case}
                      End;

                    Case ExportType of
                      CSV: Writeln(CSVFile);
                      Else Begin Inc(ExcelRow);ExcelCol := 0; End;
                    End; {Case}

                    Inc(TeaseInc);
                    If Not SuppressGUI then If TeaseInc=3 then Begin WaitDlg.Tease; TeaseInc:=1; End;
                  End;

                If ExportType=CSV then CloseFile(CSVFile);

              If ExportType = XT_Excel then
                Begin
                   TEx.WS.Range['A1', 'A1'].EntireColumn.NumberFormat := 'm/d/yyyy';

                   TEx.WS.Cells.Item[2,2].Select;
                   TEx.Excel.ActiveWindow.FreezePanes := True;
                 End;

                BottomSegInd := SegIndex;  {for next file}
                BottomHeader := CurrHeaderIndex;

             End; {FileLoop}

         END; {If There are Results}

      If ExportType = XT_Excel then TEx.SaveandClose;
      If Not SuppressGUI then WaitDlg.Hide;
      If (SaveDialog1<>nil) then MessageDlg('Export Completed Successfully.',mtinformation,[mbok],0);

      EXCEPT

         If Not SuppressGUI then WaitDlg.Hide;

         If TEx<>nil then TEx.CloseFiles;
         GraphChoiceDlg.Free;
         Raise;
      END;

    End;

Begin
  If Not SuppressGUI then Application.CreateForm(TGraphChoiceDlg, GraphChoiceDlg);
  Doit;
  GraphChoiceDlg.Free;
End;


end.
