//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
//
unit MigrEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, DBGrids, ExtCtrls, DBCtrls, Buttons, AQUAOBJ, Global,
  Loadings, LinkedSegs, AQStudy;

type
  TMigrForm = class(TForm)
    OKBtn: TBitBtn;
    Label5: TLabel;
    Panel1: TPanel;
    Label2: TLabel;
    LengthLabel: TLabel;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ToBox1: TComboBox;
    f1: TEdit;
    m1: TEdit;
    d1: TEdit;
    m2: TEdit;
    d2: TEdit;
    f2: TEdit;
    ToBox2: TComboBox;
    m3: TEdit;
    d3: TEdit;
    f3: TEdit;
    ToBox3: TComboBox;
    m4: TEdit;
    d4: TEdit;
    f4: TEdit;
    ToBox4: TComboBox;
    m5: TEdit;
    d5: TEdit;
    f5: TEdit;
    ToBox5: TComboBox;
    SummarizeButton: TButton;
    SMemo: TListBox;
    EditButton: TButton;
    TestLinks: TButton;
    SegBox: TComboBox;
    procedure EditBoxExit(Sender: TObject);
    procedure ToBoxChange(Sender: TObject);
    procedure MonthExit(Sender: TObject);
    procedure DayExit(Sender: TObject);
    procedure SummarizeButtonClick(Sender: TObject);
    procedure SMemoDblClick(Sender: TObject);
    procedure EditButtonClick(Sender: TObject);
    procedure SMemoClick(Sender: TObject);
    procedure TestLinksClick(Sender: TObject);
    procedure SegBoxChange(Sender: TObject);
  private
    { Private declarations }
  public
    LinkedSegmts : TLinkedSegs;
    ThisAQTS  : TAQUATOXSegment;
    TheIDs    : TListBoxIDs;
    PMigr     : PMigrInputType;
    AnimName  : String;
    AnimID    : AllVariables;

    AllAnimID : Array[0..200] of AllVariables;
    ALLAQTS   : Array[0..200] of TAQUATOXSegment;
    AllAnims  : Array[0..200] of String;
    AllMIs    : Array[0..200] of PMigrInputType;
    Function  EditMigr(LS,TAQTS: Pointer): Boolean;
    Procedure UpdateScreen;
    Procedure SetupMigrEdit;
    { Public declarations }
  end;

var
  MigrForm: TMigrForm;

implementation

uses imp_load, System.UITypes;

Procedure TMigrForm.UpdateScreen;
Var Loop, Index: Integer;
Begin
  Caption := 'Migration from '+ThisAQTS.SegNumber+' for '+AnimName;

  Index:=-1;
  For Loop:=0 to ToBox1.Items.Count-1 do
    If PMigr^[1].ToSeg = TheIDs[Loop] then Index:=Loop;
  ToBox1.ItemIndex := Index;
  If Index=-1 then PMigr^[1].FracMigr := 0;

  Index:=-1;
  For Loop:=0 to ToBox2.Items.Count-1 do
    If PMigr^[2].ToSeg = TheIDs[Loop] then Index:=Loop;
  ToBox2.ItemIndex := Index;
  If Index=-1 then PMigr^[2].FracMigr := 0;

  Index:=-1;
  For Loop:=0 to ToBox3.Items.Count-1 do
    If PMigr^[3].ToSeg = TheIDs[Loop] then Index:=Loop;
  ToBox3.ItemIndex := Index;
  If Index=-1 then PMigr^[3].FracMigr := 0;

  Index:=-1;
  For Loop:=0 to ToBox4.Items.Count-1 do
    If PMigr^[4].ToSeg = TheIDs[Loop] then Index:=Loop;
  ToBox4.ItemIndex := Index;
  If Index=-1 then PMigr^[4].FracMigr := 0;

  Index:=-1;
  For Loop:=0 to ToBox5.Items.Count-1 do
    If PMigr^[5].ToSeg = TheIDs[Loop] then Index:=Loop;
  ToBox5.ItemIndex := Index;
  If Index=-1 then PMigr^[5].FracMigr := 0;


  M1.Text:=IntToStr(PMigr^[1].MM);
  M2.Text:=IntToStr(PMigr^[2].MM);
  M3.Text:=IntToStr(PMigr^[3].MM);
  M4.Text:=IntToStr(PMigr^[4].MM);
  M5.Text:=IntToStr(PMigr^[5].MM);

  D1.Text:=IntToStr(PMigr^[1].DD);
  D2.Text:=IntToStr(PMigr^[2].DD);
  D3.Text:=IntToStr(PMigr^[3].DD);
  D4.Text:=IntToStr(PMigr^[4].DD);
  D5.Text:=IntToStr(PMigr^[5].DD);

  F1.Text:=FloatToStrF(PMigr^[1].FracMigr,ffgeneral,15,4);
  F2.Text:=FloatToStrF(PMigr^[2].FracMigr,ffgeneral,15,4);
  F3.Text:=FloatToStrF(PMigr^[3].FracMigr,ffgeneral,15,4);
  F4.Text:=FloatToStrF(PMigr^[4].FracMigr,ffgeneral,15,4);
  F5.Text:=FloatToStrF(PMigr^[5].FracMigr,ffgeneral,15,4);

End;

procedure TMigrForm.SegBoxChange(Sender: TObject);
Var PA: TAnimal;
begin
   ThisAQTS := LinkedSegmts.SegmentColl.At(SegBox.ItemIndex);
   PA := ThisAQTS.SV.GetStatePointer(AnimID,StV,WaterCol);
   PMigr := @PA.MigrInput;
   SetupMigrEdit;
end;

Procedure TMigrForm.SetupMigrEdit;
Var Loop2: Integer;
    PATS: TAQUATOXSegment;
    MigrIDIndx: Integer;
    SegWereIn: Integer;

Begin
  MigrIDIndx:=0;
  SegWereIn := 0;
  
  SegBox.Items.Clear;
  MigrForm.ToBox1.Items.Clear;  {set up the migration form}
      With LinkedSegmts do
        For Loop2 := 0 to SegmentColl.Count - 1 do
          Begin
            PATS := SegmentColl.At(Loop2);
            SegBox.Items.Add(PATS.SegNumber);

            If PATS.SegNumber = ThisAQTS.SegNumber  {can't migrate to itself}
              then SegWereIn := Loop2
              else
                Begin
                  MigrForm.ToBox1.Items.Add('['+ PATS.SegNumber + ']: '+PATS.StudyName);
                  MigrForm.TheIDs[MigrIdIndx] := PATS.SegNumber;
                  Inc(MigrIDIndx);
                End;

          End;

  SegBox.ItemIndex := SegWereIn;

  ToBox2.Items := ToBox1.Items;
  ToBox3.Items := ToBox1.Items;
  ToBox4.Items := ToBox1.Items;
  ToBox5.Items := ToBox1.Items;



  UpdateScreen;
End;

Function TMigrForm.EditMigr(LS,TAQTS: Pointer): Boolean;
Begin
  EditMigr := False;
  ThisAQTS := TAQTS;
  LinkedSegmts := LS;

  SetupMigrEdit;

  If ShowModal=MROK then
    Begin
      EditMigr := True;
    End;
End;

{$R *.DFM}

procedure TMigrForm.EditBoxExit(Sender: TObject);
Var Conv: Double;
    Result: Integer;

Begin
  Val(Trim(TEdit(Sender).Text),Conv,Result);
  Conv:=Abs(Conv);
  If (Result<>0) or (Conv>1.0)
    then MessageDlg('Incorrect Numerical Format Entered; Enter a Fraction Between 0 and 1',mterror,[mbOK],0)
    else Case TComponent(Sender).Name[2] of
      '1': PMigr^[1].FracMigr := Conv;
      '2': PMigr^[2].FracMigr := Conv;
      '3': PMigr^[3].FracMigr := Conv;
      '4': PMigr^[4].FracMigr := Conv;
      '5': PMigr^[5].FracMigr := Conv;
     end; {case}

  UpdateScreen;
End;




procedure TMigrForm.EditButtonClick(Sender: TObject);
Var i: Integer;
begin
   For i := 0 to SMemo.Items.Count-1 do
   IF SMemo.Selected[i] then
    Begin
     PMigr := AllMIs[i];
     AnimName := AllAnims[i];
     AnimID := AllAnimID[i];
     ThisAQTS := ALLAQTS[i];
     SetupMigrEdit;
   End;

   SummarizeButtonClick(nil);
end;

procedure TMigrForm.ToBoxChange(Sender: TObject);
Var CharID: Char;
    IntID: Integer;
    ThisBox: TComboBox;
Begin
   CharID := TComponent(Sender).Name[6];
   IntID := StrToInt(CharID);
   Case CharID of
        '1': ThisBox := ToBox1;
        '2': ThisBox := ToBox2;
        '3': ThisBox := ToBox3;
        '4': ThisBox := ToBox4;
        else ThisBox := ToBox5;
      end; {case}

   If ThisBox.ItemIndex<0
     then PMigr^[IntID].ToSeg := ''
     else PMigr^[IntID].ToSeg := TheIDs[ThisBox.ItemIndex];
   UpdateScreen;
End;

procedure TMigrForm.MonthExit(Sender: TObject);
Var Conv: Double;
    ConvInt: Integer;
    Result: Integer;
Begin
  Val(Trim(TEdit(Sender).Text),Conv,Result);
  ConvInt:=Trunc(Abs(Conv));
  If (Result<>0) or (Conv<0) or (Conv>12)
    then MessageDlg('To input a month, enter an integer from "1" to "12" or "0" to indicate no migration.',mterror,[mbOK],0)
    else Case TComponent(Sender).Name[2] of
      '1': PMigr^[1].MM := ConvInt;
      '2': PMigr^[2].MM := ConvInt;
      '3': PMigr^[3].MM := ConvInt;
      '4': PMigr^[4].MM := ConvInt;
      '5': PMigr^[5].MM := ConvInt;
     end; {case}
  UpdateScreen;
end;

procedure TMigrForm.SMemoClick(Sender: TObject);
begin
  EditButton.Enabled := True;
end;

procedure TMigrForm.SMemoDblClick(Sender: TObject);
begin
  EditButtonClick(nil);
end;



procedure TMigrForm.SummarizeButtonClick(Sender: TObject);

    Function SegmentExists(SegNum:String): Boolean;
    Var Loop2: Integer;
    Begin
      Result := False;
       With LinkedSegmts do
        For Loop2 := 0 to SegmentColl.Count - 1 do
          Begin
            If TAQUATOXSegment(SegmentColl.At(Loop2)).SegNumber = SegNum then
              Begin
                Result := True;
                Break;
              End;
          End;
    End;

    Procedure ShowSummary;
    Var AnimLoop: AllVariables;
        i, MigrIndex: Integer;
        NMigrRecords: Integer;
        TA: TAnimal;
        TS: TStates;
        TAQTS: TAQUATOXSegment;
    Begin
      SMemo.Items.Clear;
      NMigrRecords := 0;
      For AnimLoop := FirstAnimal to LastAnimal do
        For i := 0 to LinkedSegmts.SegmentColl.Count-1 do
          Begin
            TAQTS := LinkedSegmts.SegmentColl.At(i);
            TS := TAQTS.SV;
            TA := TS.GetStatePointer(AnimLoop,StV,WaterCol);
            IF TA<> nil then
              For MigrIndex := 1 to 5 do
                If (TA.MigrInput[MigrIndex].FracMigr>0) then
                 Begin
                   If SegmentExists(TA.MigrInput[MigrIndex].ToSeg) then
                    Begin
                      SMemo.Items.Add(TA.PName^ + ': on '+ IntToStr(TA.MigrInput[MigrIndex].MM)+'/'+IntToStr(TA.MigrInput[MigrIndex].DD) + '  '+
                                      IntToStr(Trunc(TA.MigrInput[MigrIndex].FracMigr*100))+'.'+IntToStr(Round((TA.MigrInput[MigrIndex].FracMigr*100 -Trunc(TA.MigrInput[MigrIndex].FracMigr*100))*10))+
                                      '% Migrates from '+TAQTS.SegNumber +' to ' + TA.MigrInput[MigrIndex].ToSeg);
                      AllMIs[NMigrRecords] := @(TA.MigrInput);
                      AllAnims[NMigrRecords] := TA.PName^;
                      AllAnimID[NMigrRecords] := TA.NState;
                      ALLAQTS[NMigrRecords] := TAQTS;
                      Inc(NMigrRecords);
                    End
                      else {segment does not exist}
                        Begin
                          TA.MigrInput[MigrIndex].MM := 0;
                          TA.MigrInput[MigrIndex].DD := 0;
                          TA.MigrInput[MigrIndex].FracMigr := 0;
                          TA.MigrInput[MigrIndex].ToSeg := '';
                        End;
                 End;
          End;

      If Not NMigrRecords=0 then SMemo.Items.Add('No Migration Inputs');

    End;  {ShowSummary}

begin
  If SummarizeButton.Caption[1] = 'S'
    then Begin
           SummarizeButton.Caption := 'Back';
           SMemo.Visible := True;
           EditButton.Visible := True;
           SMemo.BringToFront;
           ShowSummary;
         End
    else Begin
           SummarizeButton.Caption := 'Summarize';
           SMemo.Visible := False;
           EditButton.Visible := False;
         End;
end;


procedure TMigrForm.TestLinksClick(Sender: TObject);
begin
  If LinkedSegmts.Verify_Runnable(True) then
     MessageDlg('Migration Setup Linkages have been tested.  If any errors were found they have been displayed.',mtinformation,[mbOK],0);
end;

procedure TMigrForm.DayExit(Sender: TObject);
Var Conv: Double;
    ConvInt: Integer;
    Result: Integer;
Begin
  Val(Trim(TEdit(Sender).Text),Conv,Result);
  ConvInt:=Trunc(Abs(Conv));
  If (Result<>0) or (Conv<0) or (Conv>31)
    then MessageDlg('To input a day, enter an integer from "1" to "31" or "0" to indicate no migration.',mterror,[mbOK],0)
    else Case TComponent(Sender).Name[2] of
      '1': PMigr^[1].DD := ConvInt;
      '2': PMigr^[2].DD := ConvInt;
      '3': PMigr^[3].DD := ConvInt;
      '4': PMigr^[4].DD := ConvInt;
      '5': PMigr^[5].DD := ConvInt;
     end; {case}
  UpdateScreen;
end;

end.
