//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
// 
unit Study_io;

interface

uses WinTypes, WinProcs, Classes, StdCtrls, Dialogs, AQStudy, SysUtils, TCollect, Global;

Procedure SaveFile(AQTStudy: TAQUATOXSegment);
Procedure LoadFile(Var AQTStudy: TAQUATOXSegment;FileName: AnsiString; var IsLinked: Boolean);

implementation

uses Wait, Main, AQUAOBJ, BufferTStream, System.UITypes;

Procedure SaveFile(AQTStudy: TAQUATOXSegment);

Var FileStream: TWriteCachedFileStream;
    TF: TextFile;
    PC_FileN:  AnsiString;
Begin

  TSText := lowercase(ExtractFileExt(AQTStudy.FileName)) = '.txt';
  FileStream := nil;
  GlobalTS := nil;

  If (not TSText) and (LowerCase(ExtractFileExt(AQTStudy.FileName)) <> '.aps') then
     AQTStudy.FileName := AQTStudy.FileName + '.aps';

  PC_FileN:=AQTStudy.DirName+AQTStudy.FileName;

  Try
    If TSText
      then
        Begin
           AssignFile(GlobalTextF,PC_FileN);
           Rewrite(GlobalTextF);
           GlobalLN := 0;
           Writeln(GlobalTextF,'--- AQUATOX SIMULATION: TEXT BASED I/O FILE ---');
        End
      else
        Begin
          FileStream:=TWriteCachedFileStream.Create(PC_FileN,fmCreate);
          GlobalTS := FileStream;
        End;
  Except
    MessageDlg(Exception(ExceptObject).Message,mterror,[mbOK],0);
    If FileStream<>nil then FileStream.Destroy;
    if TSText then CloseFile(GlobalTextF);
    Exit;
  End; {Try Except}


  TRY

  AQTStudy.Store(True,TStream(FileStream));
  AQTStudy.TimeLoaded := Now;
  AQTStudy.LastChange := AQTStudy.TimeLoaded;

  Finally

  If FileStream<>nil then FileStream.Destroy;
  if TSText then CloseFile(GlobalTextF);

  End;
End;

Procedure LoadFile(Var AQTStudy: TAQUATOXSegment;FileName: AnsiString; var IsLinked: Boolean);

Var FileStream : TReadOnlyCachedFileStream;
    PC_FileN    :  Array[0..255] of Char;
    VersionCheck : String[10];
    ReadVers: Double;
    ReadStr: String;

Begin
  IsLinked := False;
  If AQTStudy<>nil then AQTStudy.Destroy;

  StrPCopy(PC_FileN,FileName);

  TSText := lowercase(ExtractFileExt(FileName)) = '.txt';
  FileStream := nil;
  GlobalTS := nil;

  Try
    If TSText
      then
        Begin
           AssignFile(GlobalTextF,PC_FileN);
           Reset(GlobalTextF);
           Readln(GlobalTextF,ReadStr);  // '--- AQUATOX SIMULATION: TEXT BASED I/O FILE ---'
           if Pos('LINKED',ReadStr) > 0 then Begin
                                               IsLinked := True;
                                               Exit;
                                             End;

           Readln(GlobalTextF,ReadStr);  // 'TAQUATOXSegment
           GlobalLN := 2;

        End
      else
        Begin
          FileStream:=TReadOnlyCachedFileStream.Create(PC_FileN,fmOpenRead);
          GlobalTS := FileStream;
        End;

  Except
    MessageDlg(Exception(ExceptObject).Message,mterror,[mbOK],0);
    AQTStudy:=nil;
    If FileStream<>nil then FileStream.Destroy;
    if TSText then CloseFile(GlobalTextF);
    EPert:=False;  ECont:=False;  EPSave:=False;  ECSave:=False; EPExp := False; ECExp := False;
    Exit;
  End; {Try Except}

  {Check Version #}

  TSRead('VersionWrite',VersionCheck,Sizeof(VersionCheck));
  Try
    VersionNum:=0;
    ReadVers:=strToFloat(AbbrAnsiString(VersionCheck,' '));
    VersionNum:=StrToFloat(AbbrAnsiString(VersionStr,' '));
  Except
    MessageDlg('File version unreadable: Does not seem to be a valid AQUATOX input File ',mterror,[mbOK],0);
    AQTStudy:=nil;
    If FileStream<>nil then FileStream.Destroy;
    if TSText then CloseFile(GlobalTextF);
    Exit;
  End; {Try Except}

  If (ReadVers<VersionNum) and not (SuppressGUI or EPert or ECont) then
     MessageDlg('Converting from '+Trim(VersionCheck)+' to '+Trim (VersionStr),MTInformation,[MbOK],0);

  If ReadVers<1.999
    then MessageDlg('File versions pre 2.00 are not supported by Version 3.00 and above.  (You may access your file by loading it into Release 2 and then saving as version 2.00 or higher)',mterror,[mbOK],0)
    else If ReadVers>VersionNum
      then
         Begin
            MessageDlg('File Version ('+Trim(VersionCheck)+') is Greater than Executable Version: Unreadable.',mterror,[mbOK],0);
            AQTStudy:=nil;
         End
      else
         Try
           AQTStudy:=TAQUATOXSegment.Load(False,True,TStream(FileStream),ReadVers,True,True); {Call Load Method}
           AQTStudy.FileName:=ExtractFileName(FileName);
           AQTStudy.DirName:=ExtractFilePath(FileName);
           AQTStudy.TimeLoaded := Now;
           AQTStudy.LastChange := AQTStudy.TimeLoaded;
         Except
           MessageDlg(Exception(ExceptObject).Message,mterror,[mbOK],0);
           If FileStream <>nil then FileStream.Destroy;
           Try
             If AQTStudy<> nil then AQTStudy.Destroy;
           Except
             AQTStudy := nil;
           End;
         End;

  If FileStream<>nil then FileStream.Destroy;
  if TSText then CloseFile(GlobalTextF);

End;

end.
