//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
// 
{ TTestSite STORE AND LOAD HAVE BEEN MOVED TO SITE.INC }
{ TLOAD STORE AND TLOAD LOAD MOVED TO LOADING.INC      }
{ TCHEMICAL STORE AND LOAD IN CHEMICAL.INC             }

Procedure TStates.Store(IsTemp: Boolean; var st: Tstream);
Var Loop: VerticalSegments;
    WriteMultiRec, WriteSed: Boolean;
    i, SedLoop: Integer;
    BlankPLoad: TLoadings;
    OTT, TypLoop: T_SVType;
    nsLoop: AllVariables;
    TD: TDistribution;

Begin
     If TSText then TSWriteObjectHeader('TStates');

     Inherited;  {TCollection}

     StoreCollectionitems(IsTemp, St,Self);

     TSWrite('MeanDischarge',MeanDischarge);

     TSWrite('HypoTempIC',HypoTempIC);
     If TSText then TS_Write_LoadingsRec('HypoTempLoads',HypoTempLoads,False,True)
               else With HypoTempLoads Do
                  Begin
     St.write(HypoTempLoads,Sizeof(HypoTempLoads));
       Loadings.Store(IsTemp, St);
       StoreCollectionitems(IsTemp, St,Loadings);
      End;

     If TSText then TS_Write_LoadingsRec('Shade',Shade,False,True)
               else With Shade Do
                  Begin
     St.write(Shade,Sizeof(Shade));
       Loadings.Store(IsTemp, St);
       StoreCollectionitems(IsTemp, St,Loadings);
      End;

     If TSText then TS_Write_LoadingsRec('Z_Thermocline',Z_Thermocline,False,True)
               else With Z_Thermocline Do
                  Begin
     St.write(Z_Thermocline,Sizeof(Z_Thermocline));
       Loadings.Store(IsTemp, St);
       StoreCollectionitems(IsTemp, St,Loadings);
      End;

     TSWrite('CalcVelocity',CalcVelocity);
     DynVelocity.Store(IsTemp, St);
     StoreCollectionitems(IsTemp, St, DynVelocity);

   If StoreResults then
    For Loop:=Epilimnion to Hypolimnion do
     begin
       Results[Loop].Store(IsTemp, St);
       StoreCollectionitems(IsTemp, St,Results[loop]);
       ControlResults[loop].Store(IsTemp, St);
       StoreCollectionitems(IsTemp, St,ControlResults[loop]);
     end;

   If StoreDistribs then
    Begin
      if TSText then
        Begin
          TSWrite('N Used Distributions',Distributions.CountUsed);
          for i := 0 to Distributions.Count-1 do
            Begin
              TD := Distributions.At(i);
              if TD.UseDist or TD.UseForSens then TD.Store(IsTemp,St);
            End;
        End
      else
        Begin
      Distributions.Store(IsTemp, St);
      StoreCollectionitems(IsTemp, St,Distributions);
    End;
    End;

    If IsTemp then
      Begin
        If TSText then TSReadWrite_Control_Opt_Rec(False,PControlInfo^,versionnum)
                  else ST.Write(PControlInfo^,Sizeof(PControlInfo^));
        TSWrite('PSavePPB^',PSavePPB^);
        TSWrite('PSaveBAFs^',PSaveBAFs^);
      End;

     WriteMultiRec := (PMultiRec<>nil) and (GetStatePointer(Fish1,StV,WaterCol)<>nil);
     TSWrite('WriteMultiRec',WriteMultiRec);
     If (WriteMultiRec) then with PMultiRec^ do
       Begin
         If IsTemp then
           Begin
             TSWrite('PNumAges^',PNumAges^);
             TSWrite('PSpawnAge^',PSpawnAge^);
             TSWrite('PName^',PName^,Sizeof(PName^));
           End;
           TSReadWrite_AgeDist(False,InitCond,VersionNum);
           TSReadWrite_AgeDist(False,Loadings,VersionNum);

           for OTT := FirstOrgTxTyp to LastOrgTxTyp do
             Begin
               TSReadWrite_AgeDist(False,ChemIC[OTT],VersionNum);
               TSReadWrite_AgeDist(False,ChemLoad[OTT],VersionNum);
             End;

         If IsTemp then
           Begin
             TSReadWrite_AgeDist(False,PLipidFrac^,VersionNum);
             TSReadWrite_AgeDist(False,PMortCoeff^,VersionNum);
             TSReadWrite_AgeDist(False,PMeanWeight^,VersionNum);
           End;
       End;

     If LinkedMode and (Not IsTemp) then  {Used only in linked segments}
       Begin
         TSWrite('IsStrat',IsStrat);
         TSWrite('IsEpilimnion',IsEpilimnion);

         TSWrite('AutoCalcXSec',AutoCalcXSec);
         XSecData.Store(IsTemp, St);
         StoreCollectionitems(IsTemp, St,XSecData);
       End;

     WriteSed := True;
     if TSText then
        Begin
          WriteSed := SedModelIncluded;
          TSWrite('WriteSed',WriteSed);
          if WriteSed then
          For SedLoop := 1 to 10 do
            TSReadWrite_BedRecord(False,SedData[SedLoop],VersionNum)
        End
      else St.Write(SedData,Sizeof(SedData));

     BlankPLoad := TLoadings.Init(2,2);
     if WriteSed then
     For SedLoop := 1 to 10 do
       If SedLoop>SedLayers
         then
           Begin
             BlankPLoad.Store(IsTemp, St);
             StoreCollectionitems(IsTemp, St,BlankPLoad);
           End
         else
           Begin
             TLoadings(SedData[SedLoop].UpperDispCoeff).Store(IsTemp, St);
             StoreCollectionitems(IsTemp, St,SedData[SedLoop].UpperDispCoeff);
           End;
     BlankPLoad.Destroy;

     TSWrite('SedNonReactive',SedNonReactive);

     For nsLoop := Cohesives to SedmLabDetr do
       TSWrite('Densities'+IntToStr(Ord(nsLoop)),Densities[nsloop]);
     TSWrite('UseSSC',UseSSC);
     TSWrite('MaxUpperThick',MaxUpperThick);
     TSWrite('BioTurbThick',BioTurbThick);

     ObservedData.Store(IsTemp,St);
     Graphs.Store(IsTemp,St);

   TSWrite('UseConstZMean',UseConstZMean);
   DynZMean.Store(IsTemp,St);
   StoreCollectionitems(IsTemp,St,DynZMean);

   TSWrite('UseConstEvap',UseConstEvap);
   DynEvap.Store(IsTemp,St);
   StoreCollectionitems(IsTemp,St,DynEvap);

   If TSText then TSReadWrite_TrophInt('Gull Pref',False,@GullPref,VersionNum)
             else St.Write(GullPref,Sizeof(GullPref));

   for TypLoop := FirstOrgTxTyp to LastOrgTxTyp do
       TSWrite('GullBMF'+IntToStr(ORD(TypLoop)),GullBMF[TypLoop]);
   for TypLoop := FirstOrgTxTyp to LastOrgTxTyp do
       TSWrite('GullRef'+IntToStr(ORD(TypLoop)),GullRef[TypLoop],Sizeof(GullRef[TypLoop]));
   for TypLoop := FirstOrgTxTyp to LastOrgTxTyp do
       TSWrite('GullClear'+IntToStr(ORD(TypLoop)),GullClear[TypLoop]);
   for TypLoop := FirstOrgTxTyp to LastOrgTxTyp do
       TSWrite('GullClearRef'+IntToStr(ORD(TypLoop)),GullClearRef[TypLoop],Sizeof(GullClearRef[TypLoop]));

   TSReadWrite_EstSaltLoadingRecord(False,EstuarySaltLoads,VersionNum);
   TSWrite('Diagenesis_Steady_State',Diagenesis_Steady_State);

  TSWriteCloseObject;
End;


Procedure TSReadWrite_AgeDist(Read: Boolean; var Rc:AgeDist; ReadVersionNum: Double);
Var i, Dt: Byte;
Begin
  if not TSText then
    Begin
      If Read then GlobalTS.Read(RC,Sizeof(RC))
              else GlobalTS.Write(RC,Sizeof(RC));
      Exit;
    End;

   TSReadWrite_OpenObject(Read,'AgeDist');

   TSReadWrite(Read,'UserDefined',Rc.UserDefined);

   Dt := Byte(Rc.DType);
   TSReadWrite(Read,'DType',Dt);
   Rc.DType := TDistType(Dt);

   for i:= 1 to 4 do
     TSReadWrite(Read,'Parm'+IntToStr(i),Rc.Parm[i]);

   for i:= 1 to 4 do
     TSReadWrite(Read,'Vals'+IntToStr(i),Rc.Vals[i]);

   TSReadWrite(Read,'LoadNotes1',RC.LoadNotes1,Sizeof(RC.LoadNotes1));
   TSReadWrite(Read,'LoadNotes2',RC.LoadNotes2,Sizeof(RC.LoadNotes2));

  TSReadWrite_CloseObject(Read);
End;



Procedure TSReadWrite_MigrInputType(Read: Boolean; Rc:PMigrInputType; ReadVersionNum: Double);
Var i: Integer;

Begin
  if not TSText then
    Begin
      If Read then GlobalTS.Read(RC^,Sizeof(RC^))
              else GlobalTS.Write(RC^,Sizeof(RC^));
      Exit;
    End;

   TSReadWrite_OpenObject(Read,'AnadromousInputRec');

   for i:= 1 to 5 do
     Begin
       TSReadWrite(Read,'FracMigr',Rc^[i].FracMigr);
       TSReadWrite(Read,'ToSeg',Rc^[i].ToSeg ,Sizeof(Rc^[i].ToSeg ));
       TSReadWrite(Read,'MM',Rc^[i].MM);
       TSReadWrite(Read,'DD',Rc^[i].DD);
     End;

  TSReadWrite_CloseObject(Read);
End;

Procedure TSReadWrite_AnadromousInputRec(Read: Boolean; var Rc:AnadromousInputRec; ReadVersionNum: Double);
Begin
  TSReadWrite_OpenObject(Read,'AnadromousInputRec');
  TSReadWrite(Read,'IsAnadromous',Rc.IsAnadromous);
  TSReadWrite(Read,'YearsOffSite',Rc.YearsOffSite);
  TSReadWrite(Read,'DateJuvMigr',Rc.DateJuvMigr);
  TSReadWrite(Read,'DateAdultReturn',Rc.DateAdultReturn);
  TSReadWrite(Read,'FracMigrating',Rc.FracMigrating);
  TSReadWrite(Read,'MortalityFrac',Rc.MortalityFrac);

  TSReadWrite_CloseObject(Read);
End;


Procedure TStates.WriteText;

    Procedure WriteAgeDist(Name: AnsiString; Var AD: AgeDist);
    var i: Integer;
    Begin With AD do
     Begin
      Write(LF,Name+': ');
      If UserDefined then Write(LF,'User Defined - ')
                     else Write(LF,'Distribution Defined - ');
      For i := 1 to PMultiRec^.PNumAges^ do
        Write(LF,IntToSTr(i)+': '+FloatToSTrF(Vals[i],ffgeneral,5,5)+';  ');
      Writeln(LF);
      If LoadNotes1 <> '' then Writeln(LF,LoadNotes1);
      If LoadNotes2 <> '' then Writeln(LF,LoadNotes2);
     End;
    End;

Var Chem: FirstOrgTxTyp..LastOrgTxTyp;
    nsLoop: AllVariables;
    SedLoop: Integer;
Begin
   WriteTextCollection(LF,Self);
   Writeln(LF,'Hypolimnion Temperature IC: ',FloatToStrF(HypoTempIC,ffgeneral,5,5));
   LoadingsRectoText(LF,HypoTempLoads,False);

   If PMultiRec<>nil then
    If GetStatePointer(Fish1,StV,WaterCol) <> nil then
     With PMultiRec^ do
       Begin
         Writeln(LF,'---------------------------------------');
         Writeln(LF,'MULTI-AGE-CLASS-FISH PARAMETERS');
         Writeln(LF,'Name: '+PName^);
         Writeln(LF,'NumAges: '+IntToStr(PNumAges^));
         Writeln(LF,'SpawnAge: '+FloatToStrF(PSpawnAge^,ffgeneral,5,5));
         WriteAgeDist('Init Cond',InitCond);
         WriteAgeDist('Loadings',Loadings);
         For Chem := FirstOrgTxTyp to LastOrgTxTyp do
          If GetStatePointer(AssocToxSV(Chem),StV,WaterCol) <> nil then
            Begin
             WriteAgeDist('T'+IntToStr(ORD(Chem)-1)+ 'IC',ChemIC[Chem]);
             WriteAgeDist('T'+IntToStr(ORD(Chem)-1)+ 'Load',ChemLoad[Chem]);
            End;
         WriteAgeDist('LipidFrac',PLipidFrac^);
         WriteAgeDist('MortCoeff',PMortCoeff^);
         WriteAgeDist('MeanWeight',PMeanWeight^);
       End;

   Writeln(LF,'---------------------------------------');
   Write(LF, 'Shade Inputs: ');
   LoadingsRectoText(LF,Shade,False);
   Writeln(LF);

   If Not Z_Thermocline.NoUserLoad
      then Begin
             Writeln(LF,'---------------------------------------');
             Write(LF, 'Thermocline Depth Inputs: ');
             LoadingsRectoText(LF,Z_Thermocline,False);
             Writeln(LF);
           End;

   If Not CalcVelocity then
     Begin
       Writeln(LF,'---------------------------------------');
       Write(LF, 'Dynamic Velocity Inputs: ');
       WriteTextCollection(LF,DynVelocity);
       Writeln(LF);
     End;

   If Not UseConstZMean then
     Begin
       Writeln(LF,'---------------------------------------');
       Write(LF, 'Dynamic ZMean Selected: ');
       WriteTextCollection(LF,DynZMean);
       Writeln(LF);
     End;

   If Not UseConstEvap then
     Begin
       Writeln(LF,'---------------------------------------');
       Write(LF, 'Dynamic Evap Selected: ');
       WriteTextCollection(LF,DynEvap);
       Writeln(LF);
     End;


   If LinkedMode then  {Used only in linked segments}
       Begin
         If IsStrat then
           Begin
             Write(LF,'PART OF LINKED STRATIFIED PAIR -- ');
             If IsEpilimnion then Writeln(LF,'EPILIMNION')
                             else Writeln(LF,'HYPOLIMNION');
           End;

         If Not AutoCalcXSec then
           Begin
             Writeln(LF,'---------------------------------------');
             Write(LF, 'User Entered Cross Sections: ');
             WriteTextCollection(LF,XSecData);
             Writeln(LF);
           End;
       End;

   If SedModelIncluded then
     Begin
       Writeln(LF,'---------------------------------------');
       Writeln(LF,'MULTI LAYER SEDIMENT MODEL');
       If SedNonReactive then Writeln(LF,'Sediment Layers are Non-Reactive');

       For SedLoop := 1 to 10 do
         If SedLoop<=SedLayers
           then with SedData[SedLoop] do
             Begin
               Writeln(LF,'LAYER '+IntToStr(SedLoop));
               Writeln(LF,'Initial Bed Depth '+ FloatToStrF(BedDepthIC,ffgeneral,5,5));
               Write(LF,'UpperDispCoeff ');
               WriteTextCollection(LF,UpperDispCoeff);
               Writeln(LF);
               Writeln(LF,'================');
             End;

       Write(LF,'Densities');
       For nsLoop := Cohesives to SedmLabDetr do
         Write(LF,', '+StateText(nsloop,stv,watercol)+': '+FloatToStrF(Densities[nsloop],ffgeneral,5,5));
       Writeln(LF,';');

       Writeln(LF,'MaxUpperThick '+FloatToStrF(MaxUpperThick,ffgeneral,5,5));
       Writeln(LF,'BioTurbThick '+FloatToStrF(BioTurbThick,ffgeneral,5,5));
       If UseSSC then Writeln(LF,'Sand, Silt, Clay Model Used to Calculate Erosion & Deposition.');

     End;

   If Location.SiteType=Estuary then
     with EstuarySaltLoads do
       Begin
         Writeln(LF,'================');
         Writeln(LF,'Estuary Salt Water Loadings, in mg/L');
         Writeln(LF,'Ammonia Load: '+FloatToStrF(AmmoniaLoad,ffgeneral,5,5)+' -- '+XAmmoniaLoad);
         Writeln(LF,'Nitrate Load: '+FloatToStrF(NitrateLoad,ffgeneral,5,5)+' -- '+XNitrateLoad);
         Writeln(LF,'Phosphate Load: '+FloatToStrF(PhosphateLoad,ffgeneral,5,5)+' -- '+XPhosphateLoad);
         Writeln(LF,'O2 Load: '+FloatToStrF(O2Load,ffgeneral,5,5)+' -- '+XO2Load);
         Writeln(LF,'CO2 Load: '+FloatToStrF(CO2Load,ffgeneral,5,5)+' -- '+XCO2Load);
         Writeln(LF,'================');
       End;

End;



Constructor TStates.Load(LinkedM,IsTemp: Boolean; St: Tstream; ReadVersionNum: Double; LoadResults, LoadDistribs: Boolean);

Type
RateInfoType = Packed Record  // obsolete but needed for reading
                 Dirnm,FileNm: String[255];
                 WriteDaily      : Boolean;
                 NotUsed         : Boolean;
                 FileInit        : Array[VerticalSegments] of Boolean;
                 NotUsed2        : Boolean;      // WriteToMemory set to true permanently, 8/27/2010
               End;

Var Loop: VerticalSegments;
    ToxLoop: T_SVType;
    ReadMultiRec, ReadSed: Boolean;
    Blank: InteractionFields;
    Junk: Double;
    NUsedDist, i, SedLoop: Integer;
    LayLoop: T_SVLayer;
    nsLoop, DLoop: AllVariables;
    NotUsed: Array[1..3076] of Byte;
    OldControlInfo: Array[1..5] of Control_Opt_SubRec;
    GraphDat, CGraphDat, DGraphDat: TOldGraphSetupRecord;
    RateInfo: RateInfoType;
    OTT, TypLoop: T_SVType;
    TD: TDistribution;

Begin
   TSReadObjectHeader('TStates');

   If IsTemp then PStatesTemplate := Self
             else PStatesTemplate := nil;

   If IsTemp then
     Begin
       New(PMessageStr);
       PMessageStr^ := '';
       New(PMessageErr);
       PMessageErr^ := False
     End;

    If IsTemp then New(PModelTimeStep);

    LinkedMode := LinkedM;

    WaterVolZero := False;
    Water_Was_Zero := False;
    Last_Non_Zero_Vol := 0;

    HypoSegment:=nil;
    EpiSegment:=nil;
    VSeg:=Epilimnion;  {Always set to this on the read}

    Inherited Load(IsTemp,St,ReadVersionNum);   {inherited, TCollection}
    LoadCollectionitems(IsTemp,St,Self,True,ReadVersionNum);

    TSRead('MeanDischarge',MeanDischarge);

    If ReadVersionNum< 2.99 then St.Read(NotUsed,3076);   {mercuryparams}

   TSRead('HypoTempIC',HypoTempIC);

   If TSText then TS_Read_LoadingsRec('HypoTempLoads',HypoTempLoads,False,True,ReadVersionNum)
             else With HypoTempLoads Do
    Begin
                 St.read(HypoTempLoads,Sizeof(HypoTempLoads));
     Loadings:=nil;
     Loadings:=TLoadings.Load(IsTemp, St,ReadVersionNum);
     LoadCollectionitems(IsTemp, St,Loadings,False,ReadVersionNum);
     Alt_Loadings[PointSource]:=nil;
     Alt_Loadings[DirectPrecip]:=nil;
     Alt_Loadings[NonPointSource]:=nil;
     MultLdg := 1.0;

    End;

   IF ReadVersionNum<1.88 then HypoTempLoads.NoUserLoad := False;

   If ReadVersionNum>2.99
     Then
       Begin
          If TSText then TS_Read_LoadingsRec('Shade',Shade,False,True,ReadVersionNum)
             else With Shade Do
          Begin
                 St.read(Shade,Sizeof(Shade));
           Loadings:=nil;
           Loadings:=TLoadings.Load(IsTemp, St,ReadVersionNum);
           LoadCollectionitems(IsTemp, St,Loadings,False,ReadVersionNum);
           Alt_Loadings[PointSource]:=nil;
           Alt_Loadings[DirectPrecip]:=nil;
           Alt_Loadings[NonPointSource]:=nil;
           MultLdg := 1.0;
          End;
       End // rvn > 2.99
     Else Shade := EmptyLoad;

   If ReadVersionNum>3.475
     Then
       Begin
          If TSText then TS_Read_LoadingsRec('Z_Thermocline',Z_Thermocline,False,True,ReadVersionNum)
             else With Z_Thermocline Do
          Begin
                 St.read(Z_Thermocline,Sizeof(Z_Thermocline));
           Loadings:=nil;
           Loadings:=TLoadings.Load(IsTemp, St,ReadVersionNum);
           LoadCollectionitems(IsTemp, St,Loadings,False,ReadVersionNum);
           Alt_Loadings[PointSource]:=nil;
           Alt_Loadings[DirectPrecip]:=nil;
           Alt_Loadings[NonPointSource]:=nil;
           MultLdg := 1.0;
          End;
       End
     Else Begin
            Z_Thermocline := EmptyLoad;
            Z_ThermoCline.NoUserLoad := True;
          End;


   If ReadVersionNum>3.025
     Then
       Begin
         TSRead('CalcVelocity',CalcVelocity);
         DynVelocity:=nil;
         DynVelocity:=TLoadings.Load(IsTemp, St,ReadVersionNum);
         LoadCollectionitems(IsTemp, St,DynVelocity,False,ReadVersionNum);
       End
     Else
       Begin
         CalcVelocity := True;
         DynVelocity  := TLoadings.Init(2,10);
       End;

   TeaseInc:=1;

   If LoadResults then
     For Loop:=Epilimnion to Hypolimnion do
        begin
          Results[loop]:=TResultsCollection.Load(IsTemp, St,ReadVersionNum);
          LoadCollectionitems(IsTemp, St,Results[loop],False,ReadVersionNum);
          ControlResults[loop]:=TResultsCollection.Load(IsTemp, St,ReadVersionNum);
          LoadCollectionitems(IsTemp, St,ControlResults[loop],False,ReadVersionNum);
        end
     else
      For Loop:=Epilimnion to Hypolimnion do
        begin
          Results[loop]:=TResultsCollection.Init;
          ControlResults[loop]:=TResultsCollection.Init;
        end;

   If LoadDistribs then
    Begin
      if TSText then
        Begin
          TSRead('N Used Distributions',NUsedDist);
          Distributions := TDistributionList.Init(NUsedDist,50);

          for i := 0 to NUsedDist-1 do
            Begin
              TD := TDistribution.Load(IsTemp,st,ReadVersionNum);
              Distributions.Insert(TD)
            End;
        End
      else
        Begin
                Distributions:=TDistributionList.Load(IsTemp,St,ReadVersionNum);
          LoadCollectionitems(IsTemp, St,Distributions,False,ReadVersionNum);
        End;
                Distributions.Duplicates:=True;
    End;

   If (Not LoadDistribs) then Distributions := Nil;

   if ReadVersionNum < 3.955 then
    If IsTemp then
     St.Read(RateInfo,Sizeof(RateInfo));

    If IsTemp then
      Begin
       New(PControlInfo);
       If (readversionNum<2.99)
         then
           Begin
             St.Read(OldControlInfo,Sizeof(OldControlInfo));
             PControlInfo^.Tox      := OldControlInfo[1];
             PControlInfo^.Nutrient := OldControlInfo[3];
             PControlInfo^.Sediment := OldControlInfo[4];
             PControlInfo^.Detritus := OldControlInfo[5];
           End
         Else
           If TSText then TSReadWrite_Control_Opt_Rec(True,PControlInfo^,ReadVersionNum)
                     else ST.Read(PControlInfo^,Sizeof(PControlInfo^));
      End;

     If IsTemp then
       Begin
         New(PSavePPB);
         PSavePPB^:=True;
         TSRead('PSavePPB^',PSavePPB^);
       End;

     If IsTemp then
       Begin
         New(PSaveBAFs);
         PSaveBAFs^:=True;
         If ReadVersionNum > 2.99 then TSRead('PSaveBAFs^',PSaveBAFs^);
       End;

     If Not IsTemp then
       Begin
         PControlInfo := nil;
         PSavePPB := nil;
       End;

     If ReadVersionNum < 1.8499
       then ReadMultiRec := False
       else TSRead('WriteMultiRec',ReadMultiRec);
     If ReadMultiRec then
       Begin
         New(PMultiRec);
         {Current Version}
          with PMultiRec^ do
           Begin
             If IsTemp then
               Begin
                 New(PNumAges);
                 New(PSpawnAge);
                 New(PName);
                 New(PLipidFrac);
                 New(PMortCoeff);
                 New(PMeanWeight);
                 TSRead('PNumAges^',PNumAges^);
                 TSRead('PSpawnAge^',PSpawnAge^);
                 TSRead('PName^',PName^,Sizeof(PName^));
               End;
             If ReadVersionNum<3.00 then if not TSText then St.Read(Junk,2);

             TSReadWrite_AgeDist(True,InitCond,ReadVersionNum);
             TSReadWrite_AgeDist(True,Loadings,ReadVersionNum);

             for OTT := FirstOrgTxTyp to LastOrgTxTyp do
               Begin
                 TSReadWrite_AgeDist(True,ChemIC[OTT],ReadVersionNum);
                 TSReadWrite_AgeDist(True,ChemLoad[OTT],ReadVersionNum);
               End;

             If IsTemp then
               Begin
                 TSReadWrite_AgeDist(True,PLipidFrac^,ReadVersionNum);
                 TSReadWrite_AgeDist(True,PMortCoeff^,ReadVersionNum);
                 TSReadWrite_AgeDist(True,PMeanWeight^,ReadVersionNum);
               End;
           End;
       End;


     If not ReadMultiRec then PMultiRec := nil;

     VertDispersionCalcDate  :=-99;
     OldVertDispersionVal    :=-99;

     TimeLastGullConc := -99;
     TimeLastInorgSedAvg[True] := -99;
     TimeLastInorgSedAvg[False] := -99;

     DerivStep := 0;

   For ToxLoop := FirstToxTyp to LastToxTyp do
     Begin
       Diff[ToxLoop] := 0;
       For LayLoop := SedLayer1 to LowestLayer do
         PoreDiff[ToxLoop,LayLoop] := 0;
       FirstExposure[ToxLoop] := 0;
     End;

   Anoxic      := False;
   OOSStack := nil;
   PAllSVsColl := nil;
   In_FB_Links := nil; Out_FB_Links := nil;
   In_Cs_Links := nil; Out_Cs_Links := nil;

   If LinkedMode and (Not IsTemp) then   {Used only in linked segments}
       Begin
         TSRead('IsStrat',IsStrat);
         TSRead('IsEpilimnion',IsEpilimnion);

         TSRead('AutoCalcXSec',AutoCalcXSec);
         XSecData := TLoadings.Load(IsTemp, St,ReadVersionNum);
         LoadCollectionitems(IsTemp, St,XSecData,False,ReadVersionNum);
       End
     else
       Begin
         IsStrat := False;      {these vars are not used in single-segment mode}
         IsEpilimnion := True;
         AutoCalcXSec := True;
         XSecData := nil;
       End;

   ReadSed := True;
   if TSText then TSRead('WriteSed',ReadSed);

   If (ReadVersionNum < 2.99) or (TSText and (not ReadSed))
     then
       For i:=1 to 10 do
         With SedData[i] do
           Begin
              BedDepthIC         := 0.3; {m}
              BedDensity         := 0; {g/cm3}
              NotUsed            := 0;
              UpperDispCoeff     := TLoadings.Init(3,3); {m2/d}
              FracWater          := 0; {fraction}
              BedVolume          := 0; {current, m3}
              DynBedDepth        := 0; {m3}
              VolumeLost         := 0; {m3}
              PoreSqueeze        := 0; {m3}
           End;

   If ReadVersionNum > 2.99
     then
       Begin
         if TSText then
            Begin
              if ReadSed then
              For SedLoop := 1 to 10 do
                TSReadWrite_BedRecord(True,SedData[SedLoop],ReadVersionNum)
            End
          else St.Read(SedData,Sizeof(SedData));

         if ReadSed then
         For i:=1 to 10 do
           Begin
             SedData[i].UpperDispCoeff := TLoadings.Load(IsTemp, St,ReadVersionNum);
             LoadCollectionitems(IsTemp, St,SedData[i].UpperDispCoeff,False,ReadVersionNum);
           End;
       End;

   If ReadVersionNum > 3.015 then TSRead('SedNonReactive',SedNonReactive)
                             else SedNonReactive := False;

   If ReadVersionNum> 2.99 then
     For DLoop := Cohesives to SedmLabDetr do
       TSRead('Densities'+IntToStr(Ord(DLoop)),Densities[DLoop])
     else For DLoop := Cohesives to SedmLabDetr do
       Densities[DLoop] := 0;

   If ReadVersionNum > 3.175 then TSRead('UseSSC',UseSSC)
                             else UseSSC := False;

   MaxUpperThick := 0.5;
   BioTurbThick  := 0.2;
   If ReadVersionNum> 2.99 then
     Begin
        TSRead('MaxUpperThick',MaxUpperThick);
        TSRead('BioTurbThick',BioTurbThick);
     End;


   If ReadVersionNum > 3.29
     then
       Begin
         ObservedData := TObservedData.Load(IsTemp,St,ReadVersionNum);
         Graphs := TGraphs.Load(IsTemp,St, ReadVersionNum);
       End
     else
       Begin
         ObservedData := TObservedData.Create;
         Graphs := TGraphs.Create;

          If ReadVersionNum > 3.145 then
           Begin
             St.Read(GraphDat,Sizeof(GraphDat));
             St.Read(CGraphDat,Sizeof(GraphDat));
             St.Read(DGraphDat,Sizeof(GraphDat));
           End
          else
           Begin
             St.Read(GraphDat,215);
             St.Read(CGraphDat,215);
             St.Read(DGraphDat,215);
             GraphDat.XMin := 0;
             GraphDat.XMAX := 0;
             CGraphDat.XMin := 0;
             CGraphDat.XMAX := 0;
             DGraphDat.XMin := 0;
             DGraphDat.XMAX := 0;
           End;
       End;

   If ReadVersionNum>2.585
     Then
       Begin
         TSRead('UseConstZMean',UseConstZMean);
         DynZMean:=nil;
         DynZMean:=TLoadings.Load(IsTemp,St,ReadVersionNum);
         LoadCollectionitems(IsTemp,St,DynZMean,False,ReadVersionNum);
       End
     Else
       Begin
         UseConstZMean := True;
         DynZMean  := TLoadings.Init(10,50);
       End;

   If ReadVersionNum>3.735
     Then
       Begin
         TSRead('UseConstEvap',UseConstEvap);
         DynEvap:=nil;
         DynEvap:=TLoadings.Load(IsTemp,St,ReadVersionNum);
         LoadCollectionitems(IsTemp,St,DynEvap,False,ReadVersionNum);
       End
     Else
       Begin
         UseConstEvap := True;
         DynEvap  := TLoadings.Init(10,50);
       End;


    If IsTemp then New(ProgData);

    IF ReadVersionNum>3.105 then
      Begin
        If ReadVersionNum > 3.905
             then Begin
                    If TSText then TSReadWrite_TrophInt('Gull Pref',True,@GullPref,ReadVersionNum)
                              else St.Read(GullPref,Sizeof(GullPref));
                  End
             else TranslateTrophInt(St,ReadVersionNum,GullPref);

         for TypLoop := FirstOrgTxTyp to LastOrgTxTyp do
             TSRead('GullBMF'+IntToStr(ORD(TypLoop)),GullBMF[TypLoop]);
         for TypLoop := FirstOrgTxTyp to LastOrgTxTyp do
             TSRead('GullRef'+IntToStr(ORD(TypLoop)),GullRef[TypLoop],Sizeof(GullRef[TypLoop]));
         for TypLoop := FirstOrgTxTyp to LastOrgTxTyp do
             TSRead('GullClear'+IntToStr(ORD(TypLoop)),GullClear[TypLoop]);
         for TypLoop := FirstOrgTxTyp to LastOrgTxTyp do
             TSRead('GullClearRef'+IntToStr(ORD(TypLoop)),GullClearRef[TypLoop],Sizeof(GullClearRef[TypLoop]));
      End
    else
      Begin
       For ToxLoop := FirstOrgTxTyp to LastOrgTxTyp do
           Begin
              GullBMF  [ToxLoop] := 0;
              GullClear[ToxLoop] := 0;
              GullRef  [ToxLoop] := '';
              GullClearRef[ToxLoop] := '';
           End;
         Blank.Pref   := 0;
         Blank.ECoeff := 0;
         Blank.XInteraction := '';
         For nsloop := Cohesives to LastBiota do
           GullPref[nsloop] := Blank;
     End;

   If ReadVersionNum > 3.565
     then TSReadWrite_EstSaltLoadingRecord(True,EstuarySaltLoads,ReadVersionNum)
     else with EstuarySaltLoads do
          Begin
            AmmoniaLoad := 0.02; {mg/L}
            XAmmoniaLoad := 'Data from Galveston Bay, TX';
            NitrateLoad := 0.05; {mg/L}
            XNitrateLoad := 'Data from Galveston Bay, TX';
            PhosphateLoad := 0.03; {mg/L}
            XPhosphateLoad := 'Data from Galveston Bay, TX';
            O2Load := 7.0; {mg/L}
            XO2Load := 'Default oxygen inflow to lower segment';
            CO2Load := 90.0; {mg/L}
            XCO2Load := 'Anthoni, Dr. J. Floor,  2006, Chemical Composition of Seawater';
          End;

   If ReadVersionNum > 3.765
     then TSRead('Diagenesis_Steady_State',Diagenesis_Steady_State)
     else Diagenesis_Steady_State := False;

   BirdPrey:= TCollection.Init(10,5);
   PO2Concs := TLoadings.Init(100,50);
   PSedConcs := TLoadings.Init(100,50);
   PLightVals := TLoadings.Init(50,50);

   LastPctEmbedCalc := -99;
   PercentEmbedded := 0;

   TSReadCloseObject;
End;

{- - - - - - - - - - - - - - - - - - - - - ---------------------------------------------------------}

Procedure TStateVariable.WriteText;
Var PNO3: TNO3Obj;
Begin
     Writeln(LF);
     Writeln(LF,'-----------------------------------------------');
     Writeln(LF,'Name: '+OutputText(NState,SVType,Layer,'',False,False,0));
     Writeln(LF,'SV Display: '+PName^);
     Writeln(LF,'InitialCond: '+FloatToStrF(InitialCond,ffgeneral,5,5));
{     Writeln(LF,'State: '+FloatToStrF(State,ffgeneral,5,5); }

     If nstate=WindLoading then Writeln(LF,'Mean Wind Loading: '+FloatToStrF(TWindLoading(Self).MeanValue,ffgeneral,5,5));

     If nstate=Ammonia then
       Begin
         PNo3 := GetStatePointer(Nitrate,StV,WaterCol);
         If PNo3.TN_IC then Writeln(LF,'NOTE:  AMMONIA INITIAL CONDITION IGNORED AS NITRATE INITIAL CONDITION IS ENTERED AS TOTAL N');
         If PNo3.TN_Inflow then Writeln(LF,'NOTE:  AMMONIA INFLOW LOADINGS ARE IGNORED AS NITRATE INFLOW LOADINGS ARE ENTERED AS TOTAL N');
       End;

     LoadingsRectoText(LF,LoadsRec,Has_Alt_Loadings(nstate,svtype,Layer));
     If LoadNotes1 <> '' then  Writeln(LF,'LoadNotes1: '+LoadNotes1);
     If LoadNotes2 <> '' then Writeln(LF,'LoadNotes2: '+LoadNotes2);
End;


Procedure TStateVariable.Store(IsTemp: Boolean; var st: Tstream);
var loop: Alt_LoadingsType;
Begin
     If TSText then TSWriteObjectHeader('TStateVariable');
     TSWrite('InitialCond',InitialCond);
     TSWrite('State',State);
     TSWrite('nState',Byte(nState));
     TSWrite('SVType',Byte(SVType));
     TSWrite('Layer',Byte(Layer));

     If IsTemp then TSWrite('PName^',PName^,Sizeof(PName^));

     {ALLSTATES SET IN TAQTSTUDY.LOAD}
     if TSText then TS_Write_LoadingsRec('',LoadsRec,Has_Alt_Loadings(nstate,SVType,Layer),True)
     else With LoadsRec Do
      Begin
       Loadings.Store(IsTemp, St);  // theresaproblemhere
       StoreCollectionitems(IsTemp, St,Loadings);

       TSWrite('ConstLoad',ConstLoad);
       TSWrite('UseConstant',UseConstant);
       TSWrite('NoUserLoad',NoUserLoad);

       TeaseInc:=1;
       For Loop:=PointSource to NonPointSource do
           begin
             TSWrite('Alt_ConstLoad[loop]',Alt_ConstLoad[loop]);
             TSWrite('Alt_UseConstant[loop]',Alt_UseConstant[loop]);
             TSWrite('Alt_MultLdg[loop]',Alt_MultLdg[loop]);
             If Has_Alt_Loadings(nstate,SVType,Layer)
                then begin
                        Alt_Loadings[Loop].Store(IsTemp, St);
                        StoreCollectionitems(IsTemp, St,Alt_Loadings[Loop]);
                     end;
           End
      End;

     If IsTemp then
       Begin
         TSWrite('PRequiresData^',PRequiresData^);
         TSWrite('PHasData^',PHasData^);
       End;

     TSWrite('StateUnit',StateUnit,9);
     TSWrite('LoadingUnit',LoadingUnit,9);
     TSWrite('LoadsRec.MultLdg',LoadsRec.MultLdg);

     TSWrite('yHold',yHold);
     TSWrite('YOrig',YOrig);
     TSWrite('yout',yout);
     TSWrite('stepres[1]',stepres[1]);
     TSWrite('yError',yError);
     TSWrite('yScale',yScale);

     If IsTemp then
       TSWrite('PShowRates^',PShowRates^);

     If nstate=WindLoading then TSWrite('TWindLoading.MeanValue',TWindLoading(Self).MeanValue);

     TSWrite('LoadNotes1',LoadNotes1,Sizeof(LoadNotes1));
     TSWrite('LoadNotes2',LoadNotes2,Sizeof(LoadNotes2));

     If IsTemp then
       TSWrite('PTrackResults^',PTrackResults^);

     TSWriteCloseObject;
End;


Constructor TLight.Load(IsTemp: Boolean;Var St: TStream; ReadVersionNum: Double);
Begin
  TSReadObjectHeader('TLight');

  Inherited Load(IsTemp, St,ReadVersionNum);
  If ReadVersionNum<1.729
    then
      Begin
        CalculatePhotoperiod:=True;
        UserPhotoPeriod :=0;
      End
    else
      Begin
        TSRead('CalculatePhotoperiod',CalculatePhotoperiod);
        TSRead('UserPhotoPeriod',UserPhotoPeriod);
      End;
  TSReadCloseObject;
End;


Constructor  TStateVariable.Load(IsTemp: Boolean;Var st: Tstream; ReadVersionNum: Double);
Var Loop: Alt_LoadingsType;
    NamePos: Integer;
    Ordinl: Byte;
    PTR: Boolean;

Begin
   TSReadObjectHeader('TStateVariable');

   IsTemplate := IsTemp;

   TSRead('InitialCond',InitialCond);
   TSRead('State',State);

   TSRead('nState',Ordinl);
   nstate := AllVariables(Ordinl);
   If ReadVersionNum < 3.905 then
     nstate := UpdateNState(nstate,ReadVersionNum);

   TSRead('SVType',Ordinl);
   SVType := T_SVType(Ordinl);

   If ReadVersionNum < 3.00
     then Layer := WaterCol
     else Begin
            TSRead('Layer',Ordinl);
            Layer := T_SVLayer(Ordinl);
          End;

   If (nstate=Avail_Silica) and (Layer=SedLayer1) then Layer := SedLayer2; {fix errant location assignment}
   If (nstate=Methane) and (Layer=SedLayer1) then Layer := SedLayer2; {fix errant location assignment}

   If IsTemp then Begin
                    New(PName);
                    TSRead('PName^',PName^,Sizeof(PName^));
                    If Pos('Bl-green',PName^) = 1 then
                      Begin
                        Delete(PName^,1,8);
                        PName^ := 'Cyanobacteria'+PName^;
                      End;

                    If ReadVersionNum < 3.905 then
                      Begin
                        NamePos := Pos(': [',PName^);
                        If NamePos > 0 then
                          Begin
                            Delete(PName^,1,NamePos-1);
                            PName^ := StateText(NState,StV,Layer) + PName^;
                          End;
                      End;
                  End;

   {ALLSTATES SET IN TAQTSTUDY.LOAD}
     if TSText then TS_Read_LoadingsRec('',LoadsRec,Has_Alt_Loadings(nstate,SVType,Layer),True,ReadVersionNum)
     else With LoadsRec Do
     Begin
       Loadings:=TLoadings.Load(IsTemp, St,ReadVersionNum);
       LoadCollectionitems(IsTemp, St,Loadings,False,ReadVersionNum);

           TSRead('ConstLoad',ConstLoad);
           TSRead('UseConstant',UseConstant);
           TSRead('NoUserLoad',NoUserLoad);


       { READ ALTERNATIVE LOADINGS }
       For Loop:=PointSource to NonPointSource do
          Begin
                TSRead('Alt_ConstLoad[loop]',Alt_ConstLoad[loop]);
                TSRead('Alt_UseConstant[loop]',Alt_UseConstant[loop]);
                TSRead('Alt_MultLdg[loop]',Alt_MultLdg[loop]);

            If ((nstate=Oxygen) and (ReadVersionNum < 3.0)) or
               ((nstate in [firstfish..lastfish]) and (ReadVersionNum< 3.705)) or     //10-15-2010
               ((nstate in [firstanimal..lastinvert]) and (ReadVersionNum< 3.855))   //10/24/2012
              Then
                 Begin
                   Alt_Loadings[Loop]:=TLoadings.Init(2,1);
                   Alt_ConstLoad[Loop]:=0;
                   Alt_UseConstant[Loop]:=true;
                   Alt_MultLdg[Loop]:=1.0;
                 End
              Else If Has_Alt_Loadings(nstate,SVType,Layer)
                then
                  begin
                    Alt_Loadings[Loop]:=TLoadings.Load(IsTemp, St,ReadVersionNum);
                    LoadCollectionitems(IsTemp, St,Alt_Loadings[loop],False,ReadVersionNum);
                  end
                else Alt_Loadings[Loop]:=nil;
          End;

     End; {With LoadsRec}

   If IsTemp then
     Begin
       New(PRequiresData);
       New(PHasData);
       TSRead('PRequiresData^',PRequiresData^);
       TSRead('PHasData^',PHasData^);
     End;

   TSRead('StateUnit',StateUnit,9);
   TSRead('LoadingUnit',LoadingUnit,9);

   TSRead('LoadsRec.MultLdg',LoadsRec.MultLdg);
   TSRead('yHold',yHold);
   TSRead('YOrig',YOrig);
   TSRead('yout',yout);
   TSRead('stepres[1]',stepres[1]);
   TSRead('yError',yError);
   TSRead('yScale',yScale);

  If IsTemp then
    Begin
      New(PShowRates);
      TSRead('PShowRates^',PShowRates^);
    End;

  RateColl  := nil;
  RateIndex := -1;

  If nstate=WindLoading then TSRead('TWindLoading.MeanValue',TWindLoading(Self).MeanValue);

  LoadNotes1 := '';  LoadNotes2 := '';
  If ReadVersionNum > 1.635 then
    begin
      TSRead('LoadNotes1',LoadNotes1,Sizeof(LoadNotes1));
      TSRead('LoadNotes2',LoadNotes2,Sizeof(LoadNotes2));
    end;

  If IsTemp then
    Begin
      New(PTrackResults);
      If ReadVersionNum>1.799 then Begin
                                     TSRead('PTrackResults^',PTR);
                                     PTrackResults^ := PTR;
                                   End
                              else PTrackResults^:=True;
    End;

  If Not IsTemp then
    Begin
      PShowRates := nil;
      PTrackResults := nil;
      PRequiresData := nil;
      PHasData := nil;
      Dispose(PName);
      PName := nil;
    End;

   TSReadCloseObject;
End;


Procedure TLight.Store(IsTemp: Boolean; var st: Tstream);
Begin
  If TSText then TSWriteObjectHeader('TLight');

  Inherited; {TStateVariable}

  TSWrite('CalculatePhotoperiod',CalculatePhotoperiod);
  TSWrite('UserPhotoPeriod',UserPhotoPeriod);
  TSWriteCloseObject;
End;

Procedure TLight.WriteText;
Begin
 Inherited WriteText(LF);   {TStateVariable}
 Write(LF,'CalculatePhotoperiod: '); If CalculatePhotoperiod then Writeln(LF,'TRUE') else Writeln(LF,'FALSE');
 Writeln(LF,'UserPhotoPeriod: '+FloatToStrF(UserPhotoPeriod,ffgeneral,5,5));
End;

Constructor TOrganism.Load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Var toxloop, SVTyp: T_SVType;
    i, steploop: integer;
    ionized, bloop: boolean;
    Junk: Double;
Begin
  TSReadObjectHeader('TOrganism');

  Inherited Load(IsTemp, St,ReadVersionNum);   {TStateVariable}

  if not TSText then
      Begin
        st.Read(LCInfinite,Sizeof(LCInfinite));
        st.Read(PrevFracKill,Sizeof(PrevFracKill));

  If ReadVersionNum<2.499
    then
      Begin
              st.Read(DeltaCumFracKill,Sizeof(PrevFracKill));
        For steploop := 2 to 6 do
         For toxloop := FirstOrgTxTyp to LastOrgTxTyp do
           DeltaCumFracKill[ToxLoop,1{,StepLoop}] := 0;
      End
          else st.Read(DeltaCumFracKill,Sizeof(DeltaCumFracKill));

  If ReadVersionNum<3.00
            Then for i := 1 to 10 do
              ST.Read(Junk,Sizeof(Junk));

          st.Read(Resistant,Sizeof(Resistant));

  If ReadVersionNum > 3.165
    then
      Begin
                st.Read(AmmoniaPrevFracKill,Sizeof(AmmoniaPrevFracKill));
                st.Read(AmmoniaDeltaCumFracKill,Sizeof(AmmoniaDeltaCumFracKill));
                st.Read(AmmoniaDeltaResistant,Sizeof(AmmoniaDeltaResistant));
                st.Read(AmmoniaResistant,Sizeof(AmmoniaResistant));
      End
    else
      Begin
         For Ionized := False to True do
           Begin
             For StepLoop := 1 to 6 do
               Begin
                 AmmoniaDeltaCumFracKill[ionized,StepLoop] := 0;
                 AmmoniaDeltaResistant  [ionized,StepLoop] := 0;
               End;
             AmmoniaResistant[ionized]    :=0;
             AmmoniaPrevFracKill[ionized] :=0;
           End;
      End;

   If ReadVersionNum > 3.455
    then
      Begin
                st.Read(SedPrevFracKill,Sizeof(SedPrevFracKill));
                st.Read(SedDeltaCumFracKill,Sizeof(SedDeltaCumFracKill));
                st.Read(SedDeltaResistant,Sizeof(SedDeltaResistant));
                st.Read(SedResistant,Sizeof(SedResistant));
      End
    else
      Begin
         For StepLoop := 1 to 6 do
           Begin
             SedDeltaCumFracKill[StepLoop] := 0;
             SedDeltaResistant  [StepLoop] := 0;
           End;
         SedResistant    :=0;
         SedPrevFracKill :=0;
      End;

      End;

  TSReadCloseObject;

End;

Procedure TOrganism.Store(IsTemp: Boolean; var st: Tstream);
Var SVTyp: T_SVType;
Begin
  If TSText then TSWriteObjectHeader('TOrganism');

  Inherited; {TStateVariable}

  if not TSText then
      Begin
  st.write(LCInfinite,Sizeof(LCInfinite));
  st.write(PrevFracKill,Sizeof(PrevFracKill));
  st.write(DeltaCumFracKill,Sizeof(DeltaCumFracKill));
  st.write(Resistant,Sizeof(Resistant));

  st.write(AmmoniaPrevFracKill,Sizeof(AmmoniaPrevFracKill));
  st.write(AmmoniaDeltaCumFracKill,Sizeof(AmmoniaDeltaCumFracKill));
  st.write(AmmoniaDeltaResistant,Sizeof(AmmoniaDeltaResistant));
  st.write(AmmoniaResistant,Sizeof(AmmoniaResistant));

  st.write(SedPrevFracKill,Sizeof(SedPrevFracKill));
  st.write(SedDeltaCumFracKill,Sizeof(SedDeltaCumFracKill));
  st.write(SedDeltaResistant,Sizeof(SedDeltaResistant));
  st.write(SedResistant,Sizeof(SedResistant));
      End;

  TSWriteCloseObject;
End;

Procedure TNO3Obj.Store(IsTemp: Boolean;Var st: Tstream);
Begin
   If TSText then TSWriteObjectHeader('TNO3Obj');

  Inherited; {TRemineralize}

 TSWrite('TN_IC',TN_IC);
 TSWrite('TN_Inflow',TN_Inflow);
 TSWrite('TN_PS',TN_PS);
 TSWrite('TN_NPS',TN_NPS);
 TSWriteCloseObject;

End;

Procedure TNo3Obj.WriteText;
Begin
   Inherited; {TStateVariable}

 {   Writeln(LF,'FracAvail: '+FloatToStrF(FracAvail,ffgeneral,5,5);
     Writeln(LF,'Alt_FracAvail[pointsource]: '+FloatToStrF(Alt_FracAvail[pointsource],ffgeneral,5,5);
     Writeln(LF,'Alt_FracAvail[nonpointsource]: '+FloatToStrF(Alt_FracAvail[nonpointsource],ffgeneral,5,5); NOT USED}
     Write(LF,'TN_IC: '); If TN_IC then Writeln(LF,'TRUE') else Writeln(LF,'FALSE');
     Write(LF,'TN_Inflow: '); If TN_Inflow then Writeln(LF,'TRUE') else Writeln(LF,'FALSE');
     Write(LF,'TN_PS: '); If TN_PS then Writeln(LF,'TRUE') else Writeln(LF,'FALSE');
     Write(LF,'TN_NPS: '); If TN_NPS then Writeln(LF,'TRUE') else Writeln(LF,'FALSE');
End;

Constructor TNO3Obj.Load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Var ALLoop: Alt_LoadingsType;
    Bool: Boolean;
Begin
  TSReadObjectHeader('TNO3Obj');

 inherited Load(IsTemp,St,ReadVersionNum);   {inherited TRemineralize}
 If ReadVersionNum>2.515
   then
     Begin
       TSRead('TN_IC',TN_IC);
       TSRead('TN_Inflow',TN_Inflow);
       TSRead('TN_PS',TN_PS);
       If ReadVersionNum < 2.575 then st.read(Bool,Sizeof(Boolean));
       TSRead('TN_NPS',TN_NPS);
       if ReadVersionNum < 3.965 then
         Begin
       st.read(NotUsed,Sizeof(NotUsed));
       For ALLoop:=PointSource to NonPointSource do
         st.read(Alt_NotUsed[ALLoop], Sizeof(Alt_NotUsed[ALLoop]));
       If ReadVersionNum < 2.575 then st.read(Bool,Sizeof(Boolean));
         End;
     End // RVN > 2.515
   else
     Begin
       TN_IC := False;
       TN_Inflow := False;
       TN_PS := False;
       TN_NPS := False;
{       FracAvail := 1;
       For ALLoop:=PointSource to NonPointSource do
         Alt_FracAvail[ALLoop]:=1;  NOT USED}
     End;
 TSReadCloseObject;

End;


Procedure TPO4Obj.Store(IsTemp: Boolean; Var st: Tstream);
Var ALLoop: Alt_LoadingsType;
Begin
  If TSText then TSWriteObjectHeader('TPO4Obj');

  Inherited;  {TRemineralize}

 TSWrite('FracAvail',FracAvail);
 For ALLoop:=PointSource to NonPointSource do
       TSWrite('Alt_FracAvail[ALLoop]',Alt_FracAvail[ALLoop]);

 TSWrite('TP_IC',TP_IC);
 TSWrite('TP_Inflow',TP_Inflow);
 TSWrite('TP_PS',TP_PS);
 TSWrite('TP_NPS',TP_NPS);

 TSWriteCloseObject;
End;

Procedure TPO4Obj.WriteText;
Begin
  Inherited WriteText(LF);   { TStateVariable}

     Writeln(LF,'FracAvail: '+FloatToStrF(FracAvail,ffgeneral,5,5));
     Writeln(LF,'Alt_FracAvail[pointsource]: '+FloatToStrF(Alt_FracAvail[pointsource],ffgeneral,5,5));
     Writeln(LF,'Alt_FracAvail[nonpointsource]: '+FloatToStrF(Alt_FracAvail[nonpointsource],ffgeneral,5,5));
     Write(LF,'TP_IC: '); If TP_IC then Writeln(LF,'TRUE') else Writeln(LF,'FALSE');
     Write(LF,'TP_Inflow: '); If TP_Inflow then Writeln(LF,'TRUE') else Writeln(LF,'FALSE');
     Write(LF,'TP_PS: '); If TP_PS then Writeln(LF,'TRUE') else Writeln(LF,'FALSE');
     Write(LF,'TP_NPS: '); If TP_NPS then Writeln(LF,'TRUE') else Writeln(LF,'FALSE');
End;



Constructor TPO4Obj.Load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Var ALLoop: Alt_LoadingsType;
    Bool: Boolean;
Begin
  TSReadObjectHeader('TPO4Obj');

 inherited; {TRemineralize.Load(IsTemp, St,ReadVersionNum) }

 If ReadVersionNum>1.725
   then
     Begin
       TSRead('FracAvail',FracAvail);
       For ALLoop:=PointSource to NonPointSource do
         TSRead('Alt_FracAvail[ALLoop]',Alt_FracAvail[ALLoop]);
     End
   else
     Begin
       MessageDlg2 ('Fractions Available for Phosphate loadings are being initialized to 1.0',mtInformation,[mbOK],0);
       FracAvail := 1;
       For ALLoop:=PointSource to NonPointSource do
         Alt_FracAvail[ALLoop]:=1;
     End;

 If (ReadVersionNum>2.515) and (ReadVersionNum < 2.575) then TSRead('Bool',Bool);

 If ReadVersionNum>2.575
   then
     Begin
       TSRead('TP_IC',TP_IC);
       TSRead('TP_Inflow',TP_Inflow);
       TSRead('TP_PS',TP_PS);
       TSRead('TP_NPS',TP_NPS);
     End
   else
     Begin
       TP_IC := False;
       TP_Inflow := False;
       TP_PS := False;
       TP_NPS := False;
     End;

   TSReadCloseObject;

End;


Procedure  TphObj.Store(IsTemp: Boolean; var st: Tstream);
Begin
   If TSText then TSWriteObjectHeader('TphObj');
   inherited;
   TSWrite('alkalinity',alkalinity);
   TSWriteCloseObject;
End;


Procedure TphObj.WriteText;
Begin
  Inherited;  {TStateVariable.WriteText(LF);}
  Writeln(LF,'Alkalinity: '+FloatToStrF(Alkalinity,ffgeneral,5,5));
End;


Constructor  TphObj.Load(IsTemp: Boolean; var st: Tstream; ReadVersionNum: Double);
Begin
  TSReadObjectHeader('TphObj');

  inherited;
  If ReadVersionNum > 2.535 then TSRead('alkalinity',alkalinity)
                            else alkalinity := 1000; { ( default ueq CaCO3/L) }
  TSReadCloseObject;
End;

Procedure  TPreference.Store(IsTemp: Boolean; var st: Tstream);
Begin
     If TSText then TSWriteObjectHeader('TPreference');
     TSWrite('Preference',Preference);
     TSWrite('EgestCoeff',EgestCoeff);
     TSWrite('nState',Byte(nState));
     TSWriteCloseObject;

End;

Procedure TPreference.WriteText;
Begin
  If Preference = 0 then exit;
  Write(LF,OutputText(nstate,stv,watercol,'',False,False,0));
  Write(LF,'  Preference: '+FloatToStrF(Preference,ffgeneral,5,5));
  Writeln(LF,'  EgestCoeff: '+FloatToStrF(EgestCoeff,ffgeneral,5,5));
End;


Constructor  TPreference.Load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Begin
   TSReadObjectHeader('TPreference');

   TSRead('Preference',Preference);
   TSRead('EgestCoeff',EgestCoeff);
   TSRead('nState',Byte(nState));
   If (ReadVersionNum<=3.905) then nstate := Updatenstate(nstate,readversionnum);
   TSReadCloseObject;
End;

Procedure  TAnimal.Store(IsTemp: Boolean; var st: Tstream);
Begin
  If TSText then TSWriteObjectHeader('TAnimal');

  Inherited;   {   TOrganism.Store(IsTemp, St);   }
   If IsTemp then
     Begin
       if TSText then TSReadWrite_AnimalRecord(False,PAnimalData^,VersionNum)
                 else ST.Write(PAnimalData^,Sizeof(PAnimalData^));
        TSReadWrite_TrophInt('TrophInt',False,PTrophInt,VersionNum);
     End;

   MyPrey.Store(IsTemp, St);
   StoreCollectionitems(IsTemp, St,MyPrey);

   TSWrite('CalcLipid',CalcLipid);
   TSWrite('Spawned',Spawned);
   TSWrite('SpawnTimes',SpawnTimes);
   TSReadWrite_AnadromousInputRec(False,AnadRec,VersionNum);
   If IsTemp then
     TSWrite('PSameSpecies^',Byte(PSameSpecies^));

  TSReadWrite_MigrInputType(False,@MigrInput,VersionNum);

  TSWriteCloseObject;

End;


Procedure  TAnimal.WriteText;
Var MLoop: Integer;
Begin
   inherited; { TStateVariable.WriteText(LF)}
     AnimRec_To_Text(LF, PAnimalData^);

     Writeln(LF,'--- TROPHIC INTERACTIONS ---');
     ChangeData;  {reload original preferences from entry screen}
     WriteTextCollection(LF,MyPrey);

     If PSameSpecies^ <> NullStateVar then
       Writeln(LF,'Same Species as :'+StateText(PSameSpecies^,Stv,WaterCol));

     For MLoop := 1 to 5 do
      With MigrInput[MLoop] do
       If FracMigr > 0 then
        Writeln(LF,FloatToStrF(FracMigr,ffgeneral,5,5)+' Migrates to '
                   +ToSeg+' on Day: '+IntToStr(DD) + ' of Month: '+IntToStr(MM));
End;


Constructor TAnimal.Load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Var Junk: Double;
    MigrLoop, Ordinl: Byte;
    Loop: AllVariables;
    ToxLoop: T_SVType;
    OAD: OldZooRecord;
    BlankIF: InteractionFields;
Begin
   TSReadObjectHeader('TAnimal');
     inherited; {TOrganism.Load(IsTemp, St,ReadVersionNum)}

     If IsTemp then
       Begin
         New(PAnimalData);
         New(PTrophInt);
         BlankIF.Pref := 0;
         BlankIF.ECoeff:= 0;
         BlankIF.XInteraction:= '';
         For loop := Cohesives to LastBiota do
           pTrophInt^[Loop] := blankif;

         if TSText
           then TSReadWrite_AnimalRecord(True,PAnimalData^,ReadVersionNum)
           else if ReadVersionNum > 3.67 then St.Read(PAnimalData^,Sizeof(PAnimalData^))
          else If ReadVersionNum > 3.605
              then St.Read(PAnimalData^,10275)
           else
             Begin
               If ReadVersionNum > 3.165
                     then St.Read(OAD,Sizeof(OAD))
                 else If ReadVersionNum > 2.999
                       then St.Read(OAD,2403)
                   else TranslateAnimalData(St,ReadVersionNum,OAD,IsInvertebrate);
                TranslateAnimalData2(OAD,PAnimalData^);
             End;

         If ReadVersionNum > 3.905
             then TSReadWrite_TrophInt('TrophInt',True,PTrophInt,ReadVersionNum)
             else TranslateTrophInt(St,ReadVersionNum,PTrophInt^);


         If ReadVersionNum < 3.455 then with PAnimalData^ do
           Begin
             Sorting              := 1;    {3.46, SABS}
             XSorting             := 'Default -- no sediment effect';
             SuspSedFeeding       := False;
             XSuspSedFeeding      := 'Default -- no sediment effect';
             SlopeSSFeed          := 0;
             InterceptSSFeed      := 0;
             XSlopeSSFeed         := 'Default -- no sediment effect';
             XInterceptSSFeed     := 'Default -- no sediment effect';
             SenstoSediment       := 'Zero Sensitivity';
             XSensToSediment      := 'Default -- no sediment effect';
             Trigger              := 0;
             XTrigger             := 'Default -- no sediment effect';
           End;

         If ReadVersionNum < 3.535 then with PAnimalData^ do
           Begin
             SenstoPctEmbed       := False;
             PctEmbedThreshold   := 100;
             XPctEmbedThreshold  := 'No effect';
           End;

         If ReadVersionNum < 3.575 then
           Begin
             PAnimalData^.BenthicDesignation := '';
           End;

         If ReadVersionNum < 3.671 then
           Begin
             PAnimalData^.ScientificName := '';
           End;

         If ReadVersionNum < 3.885 then
           Begin
             PAnimalData^.CanSeekRefuge := IsFish and not ((nstate in [DepFeeder1, DepFeeder2, Clams1])); {which are infauna}
                                                                  {reserve Clams2 for mussels, Corbicula}
             PAnimalData^.Visual_Feeder := NState in [SmForageFish1..LgForageFish2,SmGameFish1..Fish15];
           End;

         If ReadVersionNum < 3.915 then
           Begin
             PAnimalData^.Burrow_Index := 0;
             PAnimalData^.XBurrow_Index := 'Default: No Refuge from Predators by Burrowing';
           End;


         If PAnimalData^.Animal_Type = 'Pelagic Invert.' then PAnimalData^.Animal_Type := 'Plankton Invert';
       End;

     If Not IsTemp then
       Begin
         PAnimalData := nil;
         PTrophInt := nil;
       End;

     If IsTemp and (ReadVersionNum < 3.155) then with PAnimaldata^ do
       Begin
         O2_LethalConc  := 1.0;
         O2_LethalPct   := 50;
         O2_LCRef       := 'Default';

         O2_EC50growth  := 2.0;
         XO2_EC50growth := 'Default';
         O2_EC50repro   := 3.0;
         XO2_EC50repro  := 'Default';
       End;

     If IsTemp and (ReadVersionNum < 3.165) then with PAnimaldata^ do
       Begin
         Ammonia_LC50 := 25;   {3-6-2008}
         XAmmonia_LC50 := 'Default';
       End;

     If IsTemp and (ReadVersionNum < 3.845) then with PAnimaldata^ do
       If UseAllom_C then
         Begin
           CMax := RoundDec(5,CA * POWER(MeanWeight,CB));   //10/11/12
           XCMax := 'Allometric Parameters';
         End;

     If IsTemp and (ReadVersionNum < 3.845) then with PAnimaldata^ do
       If UseAllom_R then
         Begin;
           EndogResp := RoundDec(5, RA * 1.5 * POWER(MeanWeight,RB));   //10/11/12
           XEndogResp := 'Allometric Parameters';
         End;


     MyPrey:=TCollection.Load(IsTemp, St,ReadVersionNum);
     LoadCollectionitems(IsTemp,St,MyPrey,False,ReadVersionNum);

     TSRead('CalcLipid',CalcLipid);
     TSRead('Spawned',Spawned);

     If ReadVersionNum > 1.849 then TSRead('SpawnTimes',SpawnTimes);

     If ReadVersionNum > 3.775
        then TSReadWrite_AnadromousInputRec(True,AnadRec,ReadVersionNum)
        else
           Begin
             AnadRec.IsAnadromous := False;
             AnadRec.YearsOffSite := 3;
             AnadRec.DateJuvMigr := 70;
             AnadRec.DateAdultReturn := 100;
             AnadRec.FracMigrating := 0.2;
             AnadRec.MortalityFrac := 0.5;
           End;

     If (ReadVersionNum < 2.99) then
        begin
          TSRead('Junk',Junk); {HG_EC50_Growth}
          TSRead('Junk',Junk); {HG_EC50_Repro}
        end;

    If IsTemp then ChangeData;

    PromoteLoss:=0;
    PromoteGain:=0;
    POlder := nil; PYounger :=nil;
    OysterCategory := 0;
    EmergeInsect:=0;
    Recruit:=0;
    IsLeavingSeg:=False;
    SumPrey := 0;
    RecrSave := 0;

    PSameSpecies := nil;
    If IsTemp or (ReadVersionNum<3.115) then
      Begin
        New(PSameSpecies);
        TSRead('PSameSpecies^',Ordinl);
        PSameSpecies^ := AllVariables(Ordinl);
        If (ReadVersionNum<=3.905) then PSameSpecies^ := UpdateNstate(PSameSpecies^,readversionnum);
      End;

    MortRates.OtherMort := 0;
    For ToxLoop := FirstOrgTxTyp to LastOrgTxTyp do
        MortRates.OrgPois[ToxLoop] := 0;

   If ReadVersionNum < 2.999
     Then
       For MigrLoop := 1 to 5 do
         Begin
           MigrInput[MigrLoop].FracMigr := 0;
           MigrInput[MigrLoop].ToSeg := '';
           MigrInput[MigrLoop].DD := 0;
           MigrInput[MigrLoop].MM := 0;
         End
     Else TSReadWrite_MigrInputType(True,@MigrInput,ReadVersionNum);

   LastO2CalcTime[O2Mortality] := -99;  {init optimization vars.}
   LastO2CalcTime[O2Repro_Red] := -99;
   LastO2CalcTime[O2Growth_Red] := -99;
   LastSedCalcTime := -99;

   TSReadCloseObject;
End;




Procedure  TPlant.Store(IsTemp: Boolean; var st: Tstream);
Begin
  If TSText then TSWriteObjectHeader('TPlant');

  Inherited;  { TOrganism.Store(IsTemp, St);   }
  If IsTemp then If TSText then TSReadWrite_PlantRecord(False, PAlgalRec^, VersionNum)
                           else St.Write(PAlgalRec^,Sizeof(PAlgalRec^));
  If IsTemp then TSWrite('PSameSpecies^',Byte(PSameSpecies^));
  TSWriteCloseObject;

End;

Procedure  TPlant.WriteText;
Begin
     inherited; { TStateVariable.WriteText(LF); }
     PlantRec_To_Text(LF, PAlgalRec^);

     If PSameSpecies^ <> NullStateVar then
       Writeln(LF,'Same Species as :'+StateText(PSameSpecies^,Stv,WaterCol));
End;



Constructor  TPlant.Load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Const Diatom_to_ChlA = 26;  {g carbon/g chlorophyll}  // JSC 9/28/2012, now part of PlantRecord
      Cyano_to_Chla  = 130; {g carbon/g chlorophyll}  // JSC 9/28/2012,
      Greens_to_Chla = 137; {g carbon/g chlorophyll}  // JSC 9/28/2012, greens and "others"
Var ToxLoop: T_SVType;
    Junk: Double;
    OPR: OldPlantRecord;
    Ordinl: Byte;
Begin
  If TSText then TSreadObjectHeader('TPlant');
     Inherited; {TOrganism.Load(IsTemp, St,ReadVersionNum);}
     If IsTemp then
       Begin
        New(PAlgalRec);
        If ((ReadVersionNum >  3.825) and (ReadVersionNum< 3.845)) or (ReadVersionNum > 3.945) then //1/9/2017 pull forward NME and 3.1+ studies
          Begin
              if TSText then TSReadWrite_PlantRecord(True, PAlgalRec^, ReadVersionNum)
                        else St.Read(PAlgalRec^,Sizeof(PAlgalRec^))
          End
         else If ReadVersionNum > 3.67 then St.read(PAlgalRec^,7631)
          else If ReadVersionNum > 3.605
           then St.read(PAlgalRec^,7011)
           else
            Begin  {OldPlantRec}
             If ReadVersionNum<2.99
               then TranslateAlgalRec(St,ReadVersionNum,OPR,nstate)
               else St.read(OPR,Sizeof(OPR));

               If LowerCase(OPR.ToxicityRecord)='blue-greens' then
                  OPR.ToxicityRecord:='Bluegreens';

               If IsTemp and (ReadVersionNum < 3.485) then With OPR do
                   UseAdaptiveLight := False;

               If IsTemp and (ReadVersionNum < 3.495) then With OPR do
                 Begin
                   MinLightSat := 80;    XMinLightSat := 'Default';
                   MaxLightSat := 300;   XMaxLightSat := 'Default';
                 End;

               If IsTemp and (ReadVersionNum < 3.405) then With OPR do
                 Begin
                   PctSloughed   := 90;
                   XPctSloughed  := '90% lost in sloughing event as default';
                 End;

               If ReadVersionNum<2.99 then
                 Begin
                   OPR.Macrophyte_Type := 'benthic';
                   St.read(Junk,Sizeof(Junk)); {>=1.799}
                 End;

              TranslateAlgalRec2(OPR,PAlgalRec^);
           End; {OPR}

         If ReadVersionNum < 3.685 then
           Begin
             PAlgalRec^.PlantFracLipid := 0.2;
             PAlgalRec^.XPlantFracLipid := 'Default when loading simulation.';
           End;

         If ReadVersionNum < 3.795 then
           PAlgalRec^.SurfaceFloating := (nstate in [BlGreens1..BlGreens6]) and (not IsPeriphyton);

         If (ReadVersionNum>3.935) and (ReadVersionNum<3.945) then  // fix location of Plant to Chla record
          with PAlgalRec^ do
           Begin
             Plant_to_Chla := NHalfSatInternal ;
             XPlant_to_Chla := XNHalfSatInternal ;
           End;

         If ReadVersionNum < 3.935 then
          Begin
            If (nstate in [FirstBlGreen..LastBlGreen]) then PAlgalRec^.Plant_to_Chla := 45
                                                       else PAlgalRec^.Plant_to_Chla := 28;
            PAlgalRec^.XPlant_to_Chla := 'Ambrose et al., 1991 -- EPA Rel. 3.1 Default';

            If ReadVersionNum > 3.90 then
              If (nstate in [FirstBlGreen..LastBlGreen])
                then PAlgalRec^.Plant_to_Chla := Cyano_to_ChlA
                else if (nstate in [FirstDiatom..LastDiatom])
                  then PAlgalRec^.Plant_to_Chla := Diatom_to_ChlA
                  else PAlgalRec^.Plant_to_Chla := Greens_to_ChlA;
          End; {ReadVersionNum < 3.935}



         If (ReadVersionNum < 3.825) or ((ReadVersionNum > 3.835) and (ReadVersionNum < 3.945)) then with PAlgalRec^ do
           Begin
              NHalfSatInternal     := 0.009;
              XNHalfSatInternal    := 'WASP7, Ambrose et al. 2006';
              PHalfSatInternal     := 0.0013;
              XPHalfSatInternal    := 'WASP7, Ambrose et al. 2006';
              MaxNUptake           := 0.72;
              XMaxNUptake          := 'WASP7, Ambrose et al. 2006';
              MaxPUptake           := 0.05;
              XMaxPUptake          := 'WASP7, Ambrose et al. 2006';
              Min_N_Ratio          := 0.0072;
              XMin_N_Ratio         := 'WASP7, Ambrose et al. 2006';
              Min_P_Ratio          := 0.001;
              XMin_P_Ratio         := 'WASP7, Ambrose et al. 2006';
           End;
       End; {IsTemp}

   If Not IsTemp then PAlgalRec := nil;

    MortRates.OtherMort := 0;
    For ToxLoop := FirstOrgTxTyp to LastOrgTxTyp do
        MortRates.OrgPois[ToxLoop] := 0;

  If IsTemp then ChangeData;

  PSameSpecies := nil;
  If ReadVersionNum<2.525
    then Begin
            New(PSameSpecies);
            PSameSpecies^:=nullstatevar
         End
    else If IsTemp or (ReadVersionNum<3.115) then
         Begin
           New(PSameSpecies);
            TSRead('PSameSpecies^',Ordinl);
            PSameSpecies^ := AllVariables(Ordinl);
           If ReadVersionNum<3.905 then PSameSpecies^ := UpdateNstate(PSameSpecies^,readversionnum);
         End;

  TSReadCloseObject;

End;





{--------------------------------------------------------------------}

Constructor TVolume.Load(IsTemp: Boolean; Var st: TStream; ReadVersionNum: Double);
Var Ordinl: Byte;
Begin
 If TSText then TSReadObjectHeader('TVolume');
 Inherited; { TStateVariable.Load(IsTemp, St,ReadVersionNum);}

 TSRead('Calc_Method', Ordinl);
 Calc_Method := VolumeMethType(Ordinl);

 If ReadVersionNum > 3.415
   then
     Begin
       TSRead('StratInflow', Ordinl);
       StratInflow := FlowType(Ordinl);
       TSRead('StratOutflow', Ordinl);
       StratOutflow := FlowType(Ordinl);
     End
   else Begin StratInflow:=FtBoth; StratOutflow:=FTBoth;  End;

 If ReadVersionNum > 3.505 then
     Begin
         TSRead('StratAutomatically',StratAutomatically);
         StratDates:=nil;
         StratDates:=TLoadings.Load(IsTemp,St,ReadVersionNum);
         LoadCollectionitems(IsTemp,St,StratDates,False,ReadVersionNum);
       End
     Else
       Begin
         StratAutomatically := True;
         StratDates  := TLoadings.Init(10,50);
       End;

 Inflow:=0; Discharg:=0;
 InflowLoad:=0;   DischargeLoad:=0; KnownValueLoad:=0;
 LastTimeTA := 0; LastCalcTA := 0;
 OOSDischFracLoad:=0; OOSInflowFracLoad:=0;
 TSReadCloseObject;
End;

Procedure TVolume.WriteText;
Begin
 inherited; { TStateVariable.WriteText(LF);   }
 Write(LF,'Water Volume Calculation Method: ');
 Case Calc_Method of
   Manning: Writeln(LF,'Mannings Eqn.');
   KeepConst: Writeln(LF,'Keep Const.');
   Dynam: Writeln(LF,'Dynamic.');
   KnownVal: Writeln(LF,'Use Known Val.');
 End; {Case}

 Case StratInflow of
   FTEpi: Writeln(LF,'Inflow to Epilimnion');
   FTHyp: Writeln(LF,'Inflow to Hypolimnion');
 End;

 Case StratOutflow of
   FTEpi: Writeln(LF,'Outflow to Epilimnion');
   FTHyp: Writeln(LF,'Outflow to Hypolimnion');
 End;

 IF not StratAutomatically then
   Begin
       Writeln(LF,'---------------------------------------');
       Writeln(LF,'Stratification at user input dates:');
       WriteTextCollection(LF,StratDates);
       Writeln(LF);
   End;

End;

Procedure TVolume.Store(IsTemp: Boolean; var st: TStream);
Begin
 If TSText then TSWriteObjectHeader('TVolume');
 Inherited;   { TStateVariable.Store(IsTemp, St);   }
 TSWrite('Calc_Method',Byte(Calc_Method));
 TSWrite('StratInflow',Byte(StratInflow));
 TSWrite('StratOutflow',Byte(StratOutflow));
 TSWrite('StratAutomatically',StratAutomatically);
 StratDates.Store(IsTemp, St);
 StoreCollectionitems(IsTemp, St,StratDates);
 TSWriteCloseObject;
End;

{--------------------------------------------------------------------}

Procedure  TToxics.Store(IsTemp: Boolean; var st: Tstream);
Begin
 If TSText then TSWriteObjectHeader('TToxics');

  Inherited;
     TSWrite('ppb',ppb);
     TSWrite('Carrier',Byte(Carrier));
  TSWriteCloseObject;

End;


Constructor TToxics.load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Var NotUsed1,NU2,NU3,junk: Double;
    Ordinl: Byte;
Begin
   If TSText then TSReadObjectHeader('TToxics');
     inherited; {TStateVariable.Load(IsTemp, St,ReadVersionNum);   }
   TSRead('ppb',ppb);
   if ReadVersionNum < 3.955 then TSRead('junk',junk);
     If ReadVersionNum < 3.00 then
       Begin
       TSRead('NotUsed1',NotUsed1);
       TSRead('NU2',NU2);
       TSRead('NU3',NU2);
       End;

   TSRead('Carrier',Ordinl);
   Carrier := AllVariables(Ordinl);
     If ReadVersionNum<3.905 then Carrier := UpdateNState(Carrier,ReadVersionNum);
     Carrier:=nstate;
     If nstate in [FirstTox..LastTox] then Carrier:=NullStateVar;
     RecrSave  :=0;
  TSReadCloseObject;
End;


Procedure  TFishTox.Store(IsTemp: Boolean; var st: Tstream);
Begin

  Inherited;
{     TToxics.Store(IsTemp, St);   }
End;

Constructor  TFishTox.load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Begin
     inherited; {TToxics.Load(IsTemp, St,ReadVersionNum);   }
End;


Procedure  TResHeader.Store(IsTemp: Boolean; var st: Tstream);
Begin
  If TSText then TSWriteObjectHeader('TResHeader');

  TSWrite('AllState',Byte(AllState));
  TSWrite('SVType',Byte(SVType));
  TSWrite('Layer',Byte(Layer));

  TSWrite('HeadStr',HeadStr,Sizeof(HeadStr));
  TSWrite('UnitStr',UnitStr,Sizeof(UnitStr));
  TSWrite('PPB',     PPB);
  TSWrite('ToxVar',  ToxVar);
  if TSText then TSWrite('BAFVar',BAFVar)
            else ST.Write(BAFVar,Sizeof(BAFVar));
  TSWrite('RateVar',RateVar);
  if TSText then TSWrite('SortIndex',SortIndex)
            else ST.Write(SortIndex,Sizeof(SortIndex));
  TSWrite('PointIndex',PointIndex);
  TSWrite('RateIndex',RateIndex);
  TSWriteCloseObject;

End;



Constructor  TResHeader.load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Var BAFBool: Boolean;
    Ordinl: Byte;
Begin
  If TSText then TSReadObjectHeader('TResHeader');

  TSRead('AllState',Ordinl);
  AllState := AllVariables(Ordinl);
  TSRead('SVType',Ordinl);
  SVType := T_SVType(Ordinl);
  If (ReadVersionNum > 3.305) then Begin
                                     TSRead('Layer',Ordinl);
                                     Layer := T_SVLayer(Ordinl);
                                   End
                              else Layer := WaterCol;

   If (ReadVersionNum < 3.905) and (SVType = StV) then
     AllState := UpdateNState(AllState,ReadVersionNum);

  TSRead('HeadStr',HeadStr,Sizeof(HeadStr));
  TSRead('UnitStr',UnitStr,Sizeof(UnitStr));
  TSRead('PPB',PPB);
  TSRead('ToxVar',ToxVar);
  If ReadVersionNum < 3.695 then
    Begin
      TSRead('BAFBool', BAFBool);
      BAFVar := 0;
      If BAFBool then BAFVar := 1;
    End
   else Begin if TSText then begin TSRead('BAFVar',Ordinl); BAFVar := Ordinl; end
                        else ST.Read(BAFVar,Sizeof(BAFVar));
        End;

  If ReadVersionNum > 3.185 then TSRead('RateVar',RateVar)
                            else RateVar := False;
  if TSText then TSRead('SortIndex',SortIndex)
            else ST.Read(SortIndex,Sizeof(SortIndex));
  TSRead('PointIndex',PointIndex);

  If ReadVersionNum < 3.415 then RateIndex := 0
                            else TSRead('RateIndex',RateIndex);

  If (ReadVersionNum < VersionNum) and (ReadVersionNum > 3.4201)
     then SortIndex := CalcUniqueIndex(AllState,SVType,Layer,PPB,ToxVar,RateVar,BAFVar,RateIndex);

  TSReadCloseObject;
End;


Procedure  TResultsCollection.Store(IsTemp: Boolean; var st: Tstream);
Begin
  If TSText then TSWriteObjectHeader('TResultsCollection');

  Inherited;
     Headers.Store(IsTemp, St);
     StoreCollectionitems(IsTemp, St,Headers);
  TSWriteCloseObject;

End;

Constructor  TResultsCollection.load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Begin
  If TSText then TSReadObjectHeader('TResultsCollection');
  inherited Load(IsTemp,St,ReadVersionNum); {TCollection}

  Headers:=THeaderColl.Load(IsTemp, St,ReadVersionNum);
  LoadCollectionitems(IsTemp, St,Headers,True, ReadVersionNum);
  TSReadCloseObject;
End;


Procedure  TResults.Store(IsTemp: Boolean; var st: Tstream);
Var i: Integer;
Begin

   If TSText then
     Begin
       If Date = Trunc(Date) then Write(GlobalTextF,'{ Results at '+DateToStr(Date)+'; ')
                             else Write(GlobalTextF,'{ Results at '+DateTimeToStr(Date)+'; ');
       Write(GlobalTextF,'n='+IntToStr(DataPoints.Count)+'; ');
       for i := 0 to DataPoints.Count-1 do
         Write(GlobalTextF,TDataPoint(DataPoints.At(i)).State,'; ');
       Writeln(GlobalTextF,'}');
     End
   else
     Begin
       TSWrite('Date',Date);
     Datapoints.Store(IsTemp, St);
     StoreCollectionitems(IsTemp, St,DataPoints);
     End;

End;

Constructor  TResults.load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Var Ch: AnsiChar; i, Count: Integer; TDP: TDataPoint;

  Function ReadStr(Delim:AnsiChar):String;
  Begin
     Result := '';
     Ch := ' ';
     Repeat
       Result := Result + Ch;
       Read(GlobalTextF,Ch);
     Until Ch=Delim;
  End;

begin
   If TSText then
     Begin
       Try
       For i:=1 to 13 do Read(GlobalTextF,Ch);  // remove '{ Results at '
       Date := StrToDateTime(ReadStr(';'));
       For i:=1 to 3 do Read(GlobalTextF,Ch);   // remove ' n='
       Count := StrToInt(ReadStr(';'));
       DataPoints := TCollection.Init(Count,50);
       for i := 0 to Count-1 do
         Begin
           TDP := TDataPoint.Init_Header_Exists(StrToFloat(ReadStr(';')));
           DataPoints.Insert(TDP);
         End;
       Readln(GlobalTextF);
       Inc(GlobalLn);
       Except
         MessageDlg(Exception(ExceptObject).Message,mterror,[mbOK],0);
         raise EAQUATOXError.Create('Error reading Results at line '+IntToStr(GlobalLn));
       End;
     End
  else
    Begin
     st.read(Date,Sizeof(Date));
     Datapoints:=TCollection.Load(IsTemp, St,ReadVersionNum);
     LoadCollectionitems(IsTemp, St,DataPoints,False,ReadVersionNum);
    End;

     Final := True;
End;

Procedure  TDataPoint.Store(IsTemp: Boolean; var st: Tstream);
Begin
   If TeaseScreen then
     Begin
       Inc(TeaseInc);
       If TeaseInc=1000 then Begin WaitDlg.Tease; TeaseInc:=1; End;
     End;

     TSWrite('State',State);
End;

Constructor  TDataPoint.load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Var Junk: Word;

Begin
  If TeaseScreen then
     Begin
       Inc(TeaseInc);
       If TeaseInc=1000 then Begin WaitDlg.Tease; TeaseInc:=1; End;
     End;

   If ReadVersionNum < 1.725 then
      St.Read(Junk,1);

//    TSRead('State',State);
     st.read(State,Sizeof(State));
End;


Constructor TSuspSediment.Load(IsTemp: Boolean; Var St: Tstream; ReadVersionNum: Double);

Var junk: Double;

Begin
   inherited; {TStateVariable.Load(IsTemp, St,ReadVersionNum);   }

   If ReadVersionNum < 1.999
     then
       Begin
         TSRead('junk',junk);
         TSRead('junk',junk);
         TSRead('junk',junk);
       End;

End;


Constructor TSandSiltClay.Load(IsTemp: Boolean; St: Tstream; ReadVersionNum: Double);
Begin
  If TSText then TSReadObjectHeader('TSandSiltClay');
   inherited Load(IsTemp, St, ReadVersionNum);   {TStateVariable}
   TSRead('FracInBed',FracInBed);
   TSRead('Frac_Silt_Scour',Frac_Silt_Scour);
   TSRead('Frac_Silt_Dep',Frac_Silt_Dep);
   If ReadVersionNum > 3.445
     then TSRead('TSS_Solids',TSS_Solids)
     else TSS_Solids := True;
   Deposition := 0;
   TSReadCloseObject;

End;

Procedure TSandsiltclay.WriteText;
Begin
  inherited; { TStateVariable.WriteText(LF);   }
  Writeln(LF,'FracInBed: '+FloatToStrF(FracInBed,ffgeneral,5,5));
  Writeln(LF,'Frac_Silt_Scour: '+FloatToStrF(Frac_Silt_Scour,ffgeneral,5,5));
  Writeln(LF,'Frac_Silt_Dep: '+FloatToStrF(Frac_Silt_Dep,ffgeneral,5,5));
  If (NState = TSS) and TSS_Solids then Writeln(LF,'TSS represents Solids (including organics)')
                                   else Writeln(LF,'TSS represents Inorganic Sediments Only');

End;

Procedure TSandSiltClay.Store(IsTemp: Boolean; var st: Tstream);
Begin
  If TSText then TSWriteObjectHeader('TSandSiltClay');

  Inherited;
{   TStateVariable.Store(IsTemp, St);   }
   TSWrite('FracInBed',FracInBed);
   TSWrite('Frac_Silt_Scour',Frac_Silt_Scour);
   TSWrite('Frac_Silt_Dep',Frac_Silt_Dep);
   TSWrite('TSS_Solids',TSS_Solids);
   TSWriteCloseObject;

End;


Procedure TSuspSediment.Store(IsTemp: Boolean; var st: Tstream);

Begin
  Inherited;
{   TStateVariable.Store(IsTemp, St);   }
End;

Constructor TBottomSediment.Load(IsTemp: Boolean; Var St: Tstream; ReadVersionNum: Double);
Var Junk: Double;
Begin
   If TSText then TSReadObjectHeader('TBottomSediment');

   inherited; {TStateVariable.Load(IsTemp, St,ReadVersionNum);    }

   If (NState in [Cohesives..NonCohesives2]) and (Layer=SedLayer1) then
      If ReadVersionNum > 1.999
        then
           Begin
             Load_Loadings('LScour',IsTemp, LScour,St,ReadVersionNum);
             Load_Loadings('LDeposition',IsTemp,LDeposition,St,ReadVersionNum);
           End
        else
           Begin
             LScour   := EmptyLoad;
             LDeposition := EmptyLoad;
           End;

  If ReadVersionNum>1.99 then TSRead('Junk',Junk);

  TSReadCloseObject;
End;


Procedure TBottomSediment.Writetext;
Begin
 inherited; { TStateVariable.WriteText(LF);   }
 Write(LF,'SCOUR INPUTS-- ');
 LoadingsRectoText(LF,LScour,False);
 Write(LF,'DEPOSITION INPUTS-- ');
 LoadingsRectoText(LF,LDeposition,False);
End;


Procedure TBottomSediment.Store(IsTemp: Boolean; var st: Tstream);
Var Junk: Double;
Begin
  If TSText then TSWriteObjectHeader('TBottomSediment');

  Inherited;

   If (NState in [Cohesives..NonCohesives2]) and (Layer=SedLayer1) then
     Begin
       Store_Loadings('LScour',IsTemp,LScour,St);
       Store_Loadings('LDeposition',IsTemp,LDeposition,St);
     End;
   Junk := 56;  {lucky number}
   TSWrite('Junk',Junk);
  TSWriteCloseObject;

End;


Procedure TStateVariable.Store_Loadings(LoadNm: AnsiString; IsTemp: Boolean; Var Ld: LoadingsRecord; Var st: TStream);
{Note this does not load and save MultLdg}
Begin
  if TSText
   then TS_Write_LoadingsRec(LoadNm,Ld,False,False)
   else
  With Ld Do
    Begin
      Loadings.Store(IsTemp, St);
      StoreCollectionitems(IsTemp, St,Loadings);
        TSWrite('ConstLoad',ConstLoad);
        TSWrite('UseConstant',UseConstant);
        TSWrite('NoUserLoad',NoUserLoad);
    End;
End;


Procedure TStateVariable.Load_Loadings(LoadNm: AnsiString; IsTemp: Boolean; Var Ld: LoadingsRecord; Var St: TStream; ReadVersionNum: Double);
{Note this does not load and save MultLdg}
Begin
 if TSText
   then TS_Read_LoadingsRec(LoadNm,Ld,False,False,ReadVersionNum)
   else With Ld Do
    Begin
      Loadings := TLoadings.Load(IsTemp, St,ReadVersionNum);
      LoadCollectionitems(IsTemp, St,Loadings,False,ReadVersionNum);

      TSRead('ConstLoad',ConstLoad);
      TSRead('UseConstant',UseConstant);
      TSRead('NoUserLoad',NoUserLoad);
    End;
 Ld.MultLdg := 1;
End;


Constructor TBottomCohesives.Load(IsTemp: Boolean; Var St: Tstream; ReadVersionNum: Double);
Begin
  If TSText then TSReadObjectHeader('TBottomCohesives');

  inherited; {    TBottomSediment.Load(IsTemp, St,ReadVersionNum);    }

  If (Layer=SedLayer1) then
    If ReadVersionNum > 1.99
      then
         Begin
           Load_Loadings('LErodVel',IsTemp,LErodVel,st,ReadVersionNum);
           Load_Loadings('LDepVel',IsTemp,LDepVel,st,ReadVersionNum);
         End
      else
         Begin
           LErodVel:= EmptyLoad;
           LDepVel := EmptyLoad;
         End;
  EVel:=0;  DVel:=0;

  TSReadCloseObject;
End;

Procedure TBottomCohesives.Store(IsTemp: Boolean; var st: Tstream);
Begin
  If TSText then TSWriteObjectHeader('TBottomCohesives');

  Inherited;
{   TBottomSediment.Store(IsTemp, St);    }

   If (Layer=SedLayer1) then
     Begin
       Store_Loadings('LErodVel',IsTemp,LErodVel,st);
       Store_Loadings('LDepVel',IsTemp,LDepVel,st);
     End;

    TSWriteCloseObject;
End;

Procedure TBottomCohesives.Writetext;
Begin
 inherited; {  TStateVariable.WriteText(LF);   }
 Write(LF,'ERODE VEL. INPUTS-- ');
 LoadingsRectoText(LF,LErodVel,False);
 Write(LF,'DEP.VEL. INPUTS-- ');
 LoadingsRectoText(LF,LDepVel,False);
End;

Procedure TWindLoading.Writetext;
Begin
 inherited; {  TStateVariable.WriteText(LF);   }
 FloatToStrF(MeanValue,ffgeneral,5,5)
End;

Constructor TBuriedDetr1.Load(IsTemp:Boolean; St: Tstream; ReadVersionNum: Double);
Var Assoc_Tox,Assoc_MeHg, Assoc_HgII: Double;
Begin
   inherited Load(IsTemp, St,ReadVersionNum);    {TStateVariable}

   If ReadVersionNum<1.799 then
     Begin
       TSRead('Assoc_Tox',Assoc_Tox);
       TSRead('Assoc_MeHg',Assoc_MeHg);
       TSRead('Assoc_HgII',Assoc_HgII);
       {AssocTox, MeHg, HgII is now irrelevant}
     End;

  TotalScour :=0;       {g/m2 d}
  Frac_Sed_Scour:=0;
  Frac_Buried_Scour:=0;
  BuriedDetr_To_Sed:=0;  {g/m2 d}
  TotalDep:=0;           {g/m2 d}
  Frac_Dep_ToSed:=0;
  Frac_Dep_ToBuried:=0;
  SedDetr_To_Buried:=0;  {mg/L}
End;

Procedure TBuriedDetr1.Store(IsTemp: Boolean; var st: Tstream);
Begin
  Inherited; {TStateVariable}
End;


Constructor TBuriedDetrTox1.Load(IsTemp:Boolean; St: Tstream; ReadVersionNum: Double);
Begin
   Inherited Load(IsTemp, St,ReadVersionNum);   {TToxics }
End;

Procedure TBuriedDetrTox1.Store(IsTemp: Boolean; var st: Tstream);
Begin
  Inherited;  {TToxics}
End;

Procedure TDissRefrDetr.Store(IsTemp: Boolean; Var st: Tstream);
Var Alt_Loop: Alt_LoadingsType;
    ToxLoop: T_SVType;
Begin
  If TSText then TSWriteObjectHeader('TDissRefrDetr (has Susp&Diss loadings)');

  With InputRecord do
    Begin
      if TSText then
        Begin
          TSWrite('DataType',Byte(DataType));
          TSWrite('InitCond',InitCond);
          TSWrite('Percent_PartIC',Percent_PartIC);
          TSWrite('Percent_RefrIC',Percent_RefrIC);
          TS_Write_LoadingsRec('Susp&Diss',Load,True,True);
          TS_Write_LoadingsRec('Percent_Part',Percent_Part,True,True);
          TS_Write_LoadingsRec('Percent_Refr',Percent_Refr,True,True);

          For ToxLoop := FirstToxTyp to LastToxTyp do
            Begin
              TSWrite('T'+IntToStr(ORD(ToxLoop))+' Init Cond',ToxInitCond[ToxLoop]);
              TS_Write_LoadingsRec('T'+IntToStr(ORD(ToxLoop)),ToxLoad[ToxLoop],True,True);
            End;
        End
      else
        Begin
          ST.Write(InputRecord,Sizeof(InputRecord));

      Load.Loadings.Store(IsTemp, St);
      StoreCollectionitems(IsTemp, St,Load.Loadings);
      For ToxLoop := FirstToxTyp to LastToxTyp do
        Begin
          ToxLoad[ToxLoop].Loadings.Store(IsTemp, St);
          StoreCollectionitems(IsTemp, St,ToxLoad[ToxLoop].Loadings);
        End;

      For Alt_Loop := PointSource to NonPointSource do
         With Load do
           Begin
             Alt_Loadings[Alt_Loop].Store(IsTemp, St);
             StoreCollectionitems(IsTemp, St,Alt_Loadings[Alt_Loop]);
           End;

      Percent_Part.Loadings.Store(IsTemp, St);
      StoreCollectionitems(IsTemp, St,Percent_Part.Loadings);
      Percent_Refr.Loadings.Store(IsTemp, St);
      StoreCollectionitems(IsTemp, St,Percent_Refr.Loadings);

      {Handle PS, NPS Loadings}
      For Alt_Loop := PointSource to NonPointSource do
         Begin
           Percent_Part.Alt_Loadings[Alt_Loop].Store(IsTemp, St);
           StoreCollectionitems(IsTemp, St,Percent_Part.Alt_Loadings[Alt_Loop]);
           Percent_Refr.Alt_Loadings[Alt_Loop].Store(IsTemp, St);
           StoreCollectionitems(IsTemp, St,Percent_Refr.Alt_Loadings[Alt_Loop]);
           For ToxLoop := FirstToxTyp to LastToxTyp do
             Begin
               ToxLoad[ToxLoop].Alt_Loadings[Alt_Loop].Store(IsTemp, St);
               StoreCollectionitems(IsTemp, St,ToxLoad[ToxLoop].Alt_Loadings[Alt_Loop]);
             End;
         End;
    End;
    End;

  Inherited; {TRemineralize}
  TSWriteCloseObject;
End;

Procedure TDissRefrDetr.WriteText;
Var Chem: FirstOrgTxTyp..LastOrgTxTyp;
Begin
  inherited; { TStateVariable.WriteText(LF);   }

  With InputRecord do
    Begin
      Write(LF,'Percent_Part: ');
      LoadingsRectoText(LF,Percent_Part,False);
      Write(LF,'Percent_Refr: ');
      LoadingsRectoText(LF,Percent_Refr,False);
      Writeln(LF,'InitCond: '+FloatToStrF(InitCond,ffgeneral,5,5));
      LoadingsRectoText(LF,Load,True);
       For Chem := FirstOrgTxTyp to LastOrgTxTyp do
        If GetStatePointer(AssocToxSV(Chem),StV,WaterCol) <> nil then
          Begin
            Writeln(LF,'T'+IntToStr(ORD(Chem)-1)+' Init Cond: '+FloatToStrF(ToxInitCond[Chem],ffgeneral,5,5));
            LoadingsRectoText(LF,ToxLoad[Chem],False);
          End;
      Writeln(LF,'Percent_PartIC: '+FloatToStrF(Percent_PartIC,ffgeneral,5,5));
      Writeln(LF,'Percent_RefrIC: '+FloatToStrF(Percent_RefrIC,ffgeneral,5,5));
    End;
End;


Constructor TDissRefrDetr.Load(IsTemp: Boolean; Var st: Tstream;ReadVersionNum: Double);

Type Rel2InputRecord=  {Release 2}
     Packed Record
       Percent_Partold, Percent_Refrold,
       InitCondold                     : Double;
       MeHg_InitC, HgII_InitC          : Double;
       ToxInitCondold                  : ToxInitCondType;
       Load,MeHgLoad,HgIILoad          : LoadingsRecord;
       ToxLoadold                      : ToxLoadType;
       DataTypeold                     : DetrDataType;
                               f1,f2,f3: Byte; {d4-5}
       Percent_PartIC, Percent_RefrIC  : Double;
     End; {record}


Var Alt_Loop: Alt_LoadingsType;
    Rel2IR: Rel2InputRecord;
    ToxLoop: T_SVType;

    Function EmptyLoad: LoadingsRecord;
    Begin
       EmptyLoad.Loadings:=TLoadings.Init(2,1);
       EmptyLoad.ConstLoad:=0;
       EmptyLoad.MultLdg := 1.0;
       EmptyLoad.UseConstant:=True;
       EmptyLoad.NoUserLoad:=False;
       EmptyLoad.Alt_Loadings[PointSource]   := nil;
       EmptyLoad.Alt_Loadings[DirectPrecip]  := nil;
       EmptyLoad.Alt_Loadings[NonPointSource]:= nil;
       EmptyLoad.Alt_UseConstant[PointSource]   := True;
       EmptyLoad.Alt_UseConstant[DirectPrecip]  := True;
       EmptyLoad.Alt_UseConstant[NonPointSource]:= True;
       EmptyLoad.Alt_MultLdg[PointSource]   := 1;
       EmptyLoad.Alt_MultLdg[DirectPrecip]  := 1;
       EmptyLoad.Alt_MultLdg[NonPointSource]:= 1;
    End;

Begin
  If TSText then TSReadObjectHeader('TDissRefrDetr (has Susp&Diss loadings)');

  If ReadVersionNum < 3.00
    Then Begin
           Inherited Load(IsTemp, St,ReadVersionNum);
           ST.Read(Rel2IR,Sizeof(Rel2IR));
         End
    else With InputRecord do
          Begin
            If TSText then
              Begin
                TSRead('DataType',Byte(DataType));
                TSRead('InitCond',InitCond);
                TSRead('Percent_PartIC',Percent_PartIC);
                TSRead('Percent_RefrIC',Percent_RefrIC);
                TS_Read_LoadingsRec('Susp&Diss',Load,True,True,ReadVersionNum);
                TS_Read_LoadingsRec('Percent_Part',Percent_Part,True,True,ReadVersionNum);
                TS_Read_LoadingsRec('Percent_Refr',Percent_Refr,True,True,ReadVersionNum);

                For ToxLoop := FirstToxTyp to LastToxTyp do
                  Begin
                    TSRead('T'+IntToStr(ORD(ToxLoop))+' Init Cond',ToxInitCond[ToxLoop]);
                    TS_Read_LoadingsRec('T'+IntToStr(ORD(ToxLoop)),ToxLoad[ToxLoop],True,True,ReadVersionNum);
                  End;
              End  //is TSText
            else ST.Read(InputRecord,Sizeof(InputRecord));
          End; // with InputRecord

  If (ReadVersionNum < 3.765) and (InputRecord.DataType = CBOD) and (Not BODConvertWarning) then
    Begin
      MessageDlg2 ('Warning: Your study has inputs of organic matter in BOD units. AQUATOX 3.1 uses a different method '+
                   'than Release 3.0 for converting CBOD to organic matter, based on percent refractory rather than BOD5_CBODu. '+
                   '(Please see equation 148c in the latest Tech. Doc.).  The quantity of OM loaded into your system may be different '+
                   'than in previous model results.  Note, the default BOD5_CBODu ratio was 2.47 which corresponds to a 60% refractory loading.'
                    ,mtWarning,[mbOK],0);
      BODConvertWarning := True;
    End;

  If ReadVersionNum<3.00 then with InputRecord do
    Begin
      DataType :=  Rel2IR.DataTypeold;
      InitCond :=  Rel2IR.InitCondold;
      Percent_PartIC :=  Rel2IR.Percent_PartIC;
      Percent_RefrIC :=  Rel2IR.Percent_RefrIC;
      Load           :=  Rel2IR.Load;
      Percent_Part := EmptyLoad;
      Percent_Refr := EmptyLoad;
      Percent_Part.ConstLoad := Rel2IR.Percent_Partold;
      Percent_Refr.ConstLoad := Rel2IR.Percent_Refrold;
      Percent_RefrIC := Rel2IR.Percent_RefrIC;
      Percent_PartIC := Rel2IR.Percent_PartIC;
      Percent_Part.UseConstant := True;
      Percent_Refr.UseConstant := True;
      ToxInitCond  := Rel2IR.ToxInitCondold;
      ToxLoad      := Rel2IR.ToxLoadold;
      InputRecord.Percent_Part.Loadings := TLoadings.Init(10,20);
      InputRecord.Percent_Refr.Loadings := TLoadings.Init(10,20);
      For Alt_Loop := PointSource to NonPointSource do
        Begin
          InputRecord.Percent_Part.Alt_UseConstant[Alt_Loop] := True;
          InputRecord.Percent_Refr.Alt_UseConstant[Alt_Loop] := True;
          InputRecord.Percent_Refr.Alt_ConstLoad[Alt_Loop] :=Rel2IR.Percent_Refrold;
          InputRecord.Percent_Part.Alt_ConstLoad[Alt_Loop] :=Rel2IR.Percent_Partold;

          InputRecord.Percent_Part.Alt_Loadings[Alt_Loop] := TLoadings.Init(10,20);
          InputRecord.Percent_Refr.Alt_Loadings[Alt_Loop] := TLoadings.Init(10,20);
          For ToxLoop := FirstToxTyp to LastToxTyp do
            Begin
              ToxLoad[ToxLoop].Alt_Loadings[Alt_Loop] := TLoadings.Init(10,20);
              ToxLoad[ToxLoop].Alt_UseConstant[Alt_Loop] := True;
              ToxLoad[ToxLoop].Alt_MultLdg[Alt_Loop] := 1.0;
              ToxLoad[ToxLoop].Alt_ConstLoad[Alt_Loop] := 0;
            End;
        End;
    end;

  If ReadVersionNum < 2.999 then with InputRecord do
    Begin
      Load.Loadings := TLoadings.Load(IsTemp, St,ReadVersionNum);
      LoadCollectionitems(IsTemp, St,Load.Loadings,False,ReadVersionNum);
      For ToxLoop := FirstToxTyp to LastToxTyp do
        Begin
          ToxLoad[ToxLoop].Loadings := TLoadings.Load(IsTemp, St,ReadVersionNum);
          LoadCollectionitems(IsTemp, St,ToxLoad[ToxLoop].Loadings,False,ReadVersionNum);
        End;

      Rel2IR.MeHgLoad.Loadings := TLoadings.Load(IsTemp, St,ReadVersionNum);
      LoadCollectionItems(IsTemp, St,Rel2IR.MeHgLoad.Loadings,False,ReadVersionNum);
      Rel2IR.hgiiLoad.Loadings := TLoadings.Load(IsTemp, St,ReadVersionNum);
      LoadCollectionItems(IsTemp, St,Rel2IR.hgiiLoad.Loadings,False,ReadVersionNum);
      For Alt_Loop := PointSource to NonPointSource do
         With Load do
           Begin
             Alt_Loadings[Alt_Loop] := TLoadings.Load(IsTemp, St,ReadVersionNum);
             LoadCollectionitems(IsTemp, St,Alt_Loadings[Alt_Loop],False,ReadVersionNum);
           End;
    End;


  If (ReadVersionNum > 2.999) and not TSText
    then With InputRecord do
    Begin
      Load.Loadings := TLoadings.Load(IsTemp, St,ReadVersionNum);
      LoadCollectionitems(IsTemp, St,Load.Loadings,False,ReadVersionNum);
      For ToxLoop := FirstToxTyp to LastToxTyp do
        Begin
          ToxLoad[ToxLoop].Loadings := TLoadings.Load(IsTemp, St,ReadVersionNum);
          LoadCollectionitems(IsTemp, St,ToxLoad[ToxLoop].Loadings,False,ReadVersionNum);
        End;

      For Alt_Loop := PointSource to NonPointSource do
         With Load do
           Begin
             Alt_Loadings[Alt_Loop] := TLoadings.Load(IsTemp, St,ReadVersionNum);
             LoadCollectionitems(IsTemp, St,Alt_Loadings[Alt_Loop],False,ReadVersionNum);
           End;

      Percent_Part.Loadings := TLoadings.Load(IsTemp, St,ReadVersionNum);
      LoadCollectionitems(IsTemp, St,Percent_Part.Loadings,False,ReadVersionNum);
      Percent_Refr.Loadings := TLoadings.Load(IsTemp, St,ReadVersionNum);
      LoadCollectionitems(IsTemp, St,Percent_Refr.Loadings,False,ReadVersionNum);

      {Handle PS, NPS Loadings}
      For Alt_Loop := PointSource to NonPointSource do
         Begin
           Percent_Part.Alt_Loadings[Alt_Loop] := TLoadings.Load(IsTemp, St,ReadVersionNum);
           LoadCollectionitems(IsTemp, St,Percent_Part.Alt_Loadings[Alt_Loop],False,ReadVersionNum);
           Percent_Refr.Alt_Loadings[Alt_Loop] := TLoadings.Load(IsTemp, St,ReadVersionNum);
           LoadCollectionitems(IsTemp, St,Percent_Refr.Alt_Loadings[Alt_Loop],False,ReadVersionNum);
           For ToxLoop := FirstToxTyp to LastToxTyp do
             Begin
               ToxLoad[ToxLoop].Alt_Loadings[Alt_Loop] := TLoadings.Load(IsTemp, St,ReadVersionNum);
               LoadCollectionitems(IsTemp, St,ToxLoad[ToxLoop].Alt_Loadings[Alt_Loop],False,ReadVersionNum);
             End;
         End;
    End;

  If ReadVersionNum >= 2.999 then Inherited Load(IsTemp, St,ReadVersionNum); {TRemineralize}
  TSReadCloseObject;
End;

Procedure TCo2Obj.Store(IsTemp: Boolean; Var st: Tstream);
Begin
  If TSText then TSWriteObjectHeader('TCO2Obj');

  TSWrite('ImportCO2Equil',ImportCO2Equil);
  Co2Equil.Store(IsTemp, St);
  StoreCollectionitems(IsTemp, St,Co2Equil);
  inherited;
  TSWriteCloseObject;

End;

Procedure TCo2Obj.WriteText;
Begin
  If ImportCo2Equil  then
     Begin
       Write(LF,'-- Using time-series CO2 Equilibria -- ');
       WriteTextCollection(LF,Co2Equil);
       Writeln(LF);
     End;
  inherited
End;

Constructor TCo2Obj.Init(Ns : StateVariables; SVT: T_SVType; aName : AnsiString; P : TStates;
                       IC : double; IsTempl: Boolean);
Begin
  ImportCO2Equil := False;
  Co2Equil  := TLoadings.Init(2,10);
  inherited;
End;


Destructor TCo2Obj.Destroy;
Begin
  Co2Equil.Destroy;
End;

Constructor TCo2Obj.Load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Begin
  If TSText then TSReadObjectHeader('TCO2Obj');

  If ReadVersionNum < 3.765
    then
      Begin
        ImportCO2Equil := False;
        Co2Equil  := TLoadings.Init(2,10);
      End
    else
      Begin
        TSRead('ImportCO2Equil',ImportCO2Equil);
        Co2Equil:=nil;
        Co2Equil:=TLoadings.Load(IsTemp, St,ReadVersionNum);
        LoadCollectionitems(IsTemp, St,Co2Equil,False,ReadVersionNum);
      End;

  inherited;
  TSReadCloseObject;
End;


Procedure TO2Obj.Store(IsTemp: Boolean; Var st: Tstream);
Begin
  If TSText then TSWriteObjectHeader('TO2Obj');

  TSWrite('Threshhold',Threshhold);
  TSWrite('CalcDuration',CalcDuration);
  TSWrite('NoLoadOrWash',NoLoadOrWash);
  inherited;
  TSWriteCloseObject;
End;

Procedure TO2Obj.WriteText;
Begin
  If NoLoadOrWash then Write(LF,'-- OXYGEN INFLOW LOADS AND WASHOUT TURNED OFF --');
  inherited
End;

Constructor TO2Obj.Load(IsTemp: Boolean; Var st: Tstream; ReadVersionNum: Double);
Begin
  If TSText then TSReadObjectHeader('TO2Obj');

  If ReadVersionNum < 3.155
    then
      Begin
        CalcDuration := False;
        Threshhold := 3.0;
      End
    else
      Begin
        TSRead('Threshhold',Threshhold);
        TSRead('CalcDuration',CalcDuration);
      End;

  NoLoadOrWash := False;
  If ReadVersionNum > 3.175 then TSRead('NoLoadOrWash',NoLoadOrWash);
  inherited;
  TSReadCloseObject;
End;



Procedure TPlantToxRecord.Store(IsTemp: Boolean; var st: TStream);
Begin
  If TSText then TSWriteObjectHeader('TPlantToxRecord');

  TSWrite('Plant_name',Plant_name,Sizeof(Plant_name));
  TSWrite('EC50_photo',EC50_photo);
  TSWrite('EC50_exp_time',EC50_exp_time);
  TSWrite('EC50_dislodge',EC50_dislodge);
  TSWrite('EC50_comment',EC50_comment,Sizeof(EC50_comment));
  TSWrite('K2',K2);

  TSWrite('K1',K1);
  TSWrite('Entered_BCF',Entered_BCF);

  TSWrite('Bio_rate_const',Bio_rate_const);
  TSWrite('LC50',LC50);
  TSWrite('LC50_exp_time',LC50_exp_time);
  TSWrite('LC50_comment',LC50_comment,Sizeof(LC50_comment));
  TSWrite('Lipid_frac',Lipid_frac);
  TSWrite('LC50_Slope',LC50_SLope);
  TSWriteCloseObject;

End;

Procedure TPlantToxRecord.WriteText;
Begin
   Writeln(LF,' + + + + + + + + + + + + + + ');
   Writeln(LF,'Plant_name: '+Plant_name);
   Writeln(LF,'EC50_photo: '+FloatToStrF(EC50_photo,ffgeneral,5,5));
   Writeln(LF,'EC50_exp_time: '+FloatToStrF(EC50_exp_time,ffgeneral,5,5));
   Writeln(LF,'EC50_dislodge: '+FloatToStrF(EC50_dislodge,ffgeneral,5,5));
   Writeln(LF,'EC50_comment: '+EC50_comment);
   Writeln(LF,'K2: '+FloatToStrF(K2,ffgeneral,5,5));
   Writeln(LF,'K1: '+FloatToStrF(K1,ffgeneral,5,5));
   Writeln(LF,'Entered_BCF: '+FloatToStrF(Entered_BCF,ffgeneral,5,5));
   Writeln(LF,'Bio_rate_const: '+FloatToStrF(Bio_rate_const,ffgeneral,5,5));
   Writeln(LF,'LC50: '+FloatToStrF(LC50,ffgeneral,5,5));
   Writeln(LF,'LC50_exp_time: '+FloatToStrF(LC50_exp_time,ffgeneral,5,5));
   Writeln(LF,'LC50_comment: '+LC50_comment);
   Writeln(LF,'Lipid_frac: '+FloatToStrF(Lipid_frac,ffgeneral,5,5));
   if LC50_Slope > 0 then
     Writeln(LF,'LC50_Slope: '+FloatToStrF(LC50_Slope,ffgeneral,5,5));
End;



Constructor TPlantToxRecord.Load(IsTemp: Boolean; Var st: Tstream;ReadVersionNum: Double);
Begin
  If TSText then TSReadObjectHeader('TPlantToxRecord');

  TSRead('Plant_name',Plant_name,Sizeof(Plant_name));
  TSRead('EC50_photo',EC50_photo);
  TSRead('EC50_exp_time',EC50_exp_time);
  TSRead('EC50_dislodge',EC50_dislodge);
  If ReadVersionNum > 3.605
    then TSRead('EC50_comment',EC50_comment,Sizeof(EC50_comment))
    else St.Read(EC50_comment,Sizeof(RefShortString));
  TSRead('K2',K2);
  If ReadVersionNum>2.545 then
    Begin
      TSRead('K1',K1);
      TSRead('Entered_BCF',Entered_BCF);
    End;
  TSRead('Bio_rate_const',Bio_rate_const);
  TSRead('LC50',LC50);
  TSRead('LC50_exp_time',LC50_exp_time);
  If ReadVersionNum > 3.605
    then TSRead('LC50_comment',LC50_comment,Sizeof(LC50_comment))
    else St.Read(LC50_comment,Sizeof(RefShortString));
  If ReadVersionNum>1.855 then TSRead('Lipid_frac',Lipid_frac)
                          else Lipid_Frac := 0.2;
  if (ReadVersionNum > 3.835)
     then TSRead('LC50_Slope',LC50_Slope)
     else LC50_Slope := 0;
  TSReadCloseObject;

End;


Procedure TAnimalToxRecord.Store(IsTemp: Boolean; var st: TStream);

Begin
  If TSText then TSWriteObjectHeader('TAnimalToxRecord');
   TSWrite('Animal_name',Animal_name,Sizeof(Animal_name));
   TSWrite('LC50',LC50);
   TSWrite('LC50_exp_time',LC50_exp_time);
   TSWrite('LC50_comment',LC50_comment,Sizeof(LC50_comment));
   TSWrite('Entered_K2',Entered_K2);

   TSWrite('Entered_K1',Entered_K1);
   TSWrite('Entered_BCF',Entered_BCF);

   TSWrite('Bio_rate_const',Bio_rate_const);
   TSWrite('EC50_growth',EC50_growth);
   TSWrite('Growth_exp_time',Growth_exp_time);
   TSWrite('EC50_repro',EC50_repro);
   TSWrite('Repro_exp_time',Repro_exp_time);
   TSWrite('EC50_comment',EC50_comment,Sizeof(EC50_comment));
   TSWrite('Mean_wet_wt',Mean_wet_wt);
   TSWrite('Lipid_frac',Lipid_frac);
   TSWrite('Drift_Thresh',Drift_Thresh);  //   (2/10/2009)
   TSWrite('Drift_Comment',Drift_Comment,Sizeof(Drift_Comment));
   TSWrite('LC50_Slope',LC50_SLope);
     TSWriteCloseObject;

End;

Procedure TAnimalToxRecord.WriteText;
Begin
   Writeln(LF,' + + + + + + + + + + + + + + ');
   Writeln(LF,'Animal_name: '+Animal_name);
   Writeln(LF,'LC50: '+FloatToStrF(LC50,ffgeneral,5,5));
   Writeln(LF,'LC50_exp_time: '+FloatToStrF(LC50_exp_time,ffgeneral,5,5));
   Writeln(LF,'LC50_comment: '+LC50_comment);
   Writeln(LF,'Entered_K2: '+FloatToStrF(Entered_K2,ffgeneral,5,5));
   Writeln(LF,'Entered_K1: '+FloatToStrF(Entered_K1,ffgeneral,5,5));
   Writeln(LF,'Entered_BCF: '+FloatToStrF(Entered_BCF,ffgeneral,5,5));
   Writeln(LF,'Bio_rate_const: '+FloatToStrF(Bio_rate_const,ffgeneral,5,5));
   Writeln(LF,'EC50_growth: '+FloatToStrF(EC50_growth,ffgeneral,5,5));
   Writeln(LF,'Growth_exp_time: '+FloatToStrF(Growth_exp_time,ffgeneral,5,5));
   Writeln(LF,'EC50_repro: '+FloatToStrF(EC50_repro,ffgeneral,5,5));
   Writeln(LF,'Repro_exp_time: '+FloatToStrF(Repro_exp_time,ffgeneral,5,5));
   Writeln(LF,'EC50_comment: '+EC50_comment);
   Writeln(LF,'Mean_wet_wt: '+FloatToStrF(Mean_wet_wt,ffgeneral,5,5));
   Writeln(LF,'Lipid_frac: '+FloatToStrF(Lipid_frac,ffgeneral,5,5));
   Writeln(LF,'Drift_Thresh: '+FloatToStrF(Drift_Thresh,ffgeneral,5,5));
   Writeln(LF,'Drift_Comment: '+Drift_Comment);
   if LC50_Slope > 0 then
     Writeln(LF,'LC50_Slope: '+FloatToStrF(LC50_Slope,ffgeneral,5,5));
End;

Constructor TAnimalToxRecord.Load(IsTemp: Boolean; Var st: Tstream;ReadVersionNum: Double);
Begin
  If TSText then TSReadObjectHeader('TAnimalToxRecord');
   TSRead('Animal_name',Animal_name,Sizeof(Animal_name));
   TSRead('LC50',LC50);
   TSRead('LC50_exp_time',LC50_exp_time);
   If ReadVersionNum > 3.605
     then TSRead('LC50_comment',LC50_comment,Sizeof(LC50_comment))
     else St.Read(LC50_comment,Sizeof(RefShortString));
   TSRead('Entered_K2',Entered_K2);
   If ReadVersionNum>2.545 then
     Begin
       TSRead('Entered_K1',Entered_K1);
       TSRead('Entered_BCF',Entered_BCF);
     End;
   TSRead('Bio_rate_const',Bio_rate_const);
   TSRead('EC50_growth',EC50_growth);
   TSRead('Growth_exp_time',Growth_exp_time);
   TSRead('EC50_repro',EC50_repro);
   TSRead('Repro_exp_time',Repro_exp_time);
   If ReadVersionNum > 3.605
     then TSRead('EC50_comment',EC50_comment,Sizeof(EC50_comment))
     else St.read(EC50_comment,Sizeof(RefShortString));
   TSRead('Mean_wet_wt',Mean_wet_wt);
   TSRead('Lipid_frac',Lipid_frac);
   If ReadVersionNum>1.725 then
     Begin
       If ReadVersionNum > 3.605
         then TSRead('Drift_Thresh',Drift_Thresh)
         else St.read(Drift_Thresh,Sizeof(RefShortString));

       If ReadVersionNum > 3.605
         then TSRead('Drift_Comment',Drift_Comment,Sizeof(Drift_Comment))
         else St.read(Drift_Comment,Sizeof(RefShortString));

       if ReadVersionNum > 3.835
          then TSRead('LC50_Slope',LC50_Slope)
          else LC50_Slope := 0;

     End
   else
     If (Animal_Name = 'Chironomid') or
        (Animal_Name = 'Stonefly') or
        (Animal_Name = 'Ostracod') or
        (Animal_Name = 'Amphipod') or
        (Animal_Name = 'Isopod') or
        (Animal_Name = 'Corbicula') or
        (Animal_Name = 'Mayfly') or
        (Animal_Name = 'Other') then
       Begin
         Drift_Thresh:=EC50_Growth / 20;
         Drift_Comment := '5% of EC50Growth.';
         LC50_Slope := 0;
       End
     else
       Begin
         Drift_Thresh  :=0;
         Drift_Comment := 'N.A. not zoobenthos';
         LC50_Slope := 0;
       End;
     TSReadCloseObject;
End;




Procedure Write_CheckSum(Var St : TStream);
Var CheckSum: Integer;
Begin
  CheckSum := 5656;
  TSWrite('CheckSum',CheckSum);
End;

Function Read_CheckSum(St : TStream; ReadVersionNum: Double): Boolean;
Var CheckSum: Integer;
Begin
  CheckSum := 5656;
  if ReadVersionNum > 3.945 then TSRead('CheckSum',CheckSum);
  Result := (CheckSum = 5656);

End;

