//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
//
unit dbentry;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, FileCtrl, Global, DB, AQBaseform,
   librarys, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client,
  FireDAC.UI.Intf, FireDAC.Stan.Def, FireDAC.Stan.Pool, FireDAC.Phys,
  FireDAC.VCLUI.Wait;

type
  TDB_GetEntry = class(TLibrary_File)
    Header: TLabel;
    EntryList2: TListBox;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure EntryListClick(Sender: TObject);
    procedure EntryList2Click(Sender: TObject);
    procedure FileEditChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
     {Set by user, Input Variables}
     HeadAnsiString,DefaultDbName: AnsiString;
     {The Return Variables}
    DBName,FileDir,TableN,Entry : AnsiString;
    Function GetEntry: Boolean;
    Function LoadToUnderlyingData(DefaultTable: AnsiString; InTable:TFDTable):Boolean;
    Procedure CreateScreen;
    { Public declarations }
  end;

var
  DB_GetEntry: TDB_GetEntry;

Function IndexByName(InTable: TFDTable; InStr: AnsiString): Integer;

implementation

uses EstKPSed, ChemTox, ec50lc50, regress, StreamFrm, PFAK2s, Chem,
  Site,Plant,Animal,Remin, SV_IO ;



Function IndexByName(InTable: TFDTable; InStr: AnsiString): Integer;
Var Found: Boolean;
Begin
  Result := 0;
  InTable.First;
  Repeat
    Inc(Result);
    Found := InTable.Fields[0].AsAnsiString = InStr;
    If Not Found then InTable.Next;
  Until Found;
End;



procedure TDB_GetEntry.Button1Click(Sender: TObject);
begin
  OpenDialog1.InitialDir := Default_Dir;
  OpenDialog1.Title := 'Select the SQLite File to read from';
  OpenDialog1.Filter := 'SQLite files (*.sdb)|*.SDB|All files (*.*)|*.*';
  If not OpenDialog1.Execute then Exit;
  FileEdit.Text := OpenDialog1.FileName;
  UpdateTableList;

end;




procedure TDB_GetEntry.CreateScreen;
begin
  DBName := Default_Dir + 'AQUATOX.SDB';
  FileDir := Default_Dir;
  FDConnection1.Params.DriverID:='SQLite';
  FDConnection1.Params.Database:=DBName;
  TableN := DefaultDbName;

  FileEdit.Text := DBName;
  RadioButton1.Caption:='Default '+DefaultDbName+' DB';
  RadioButton1.Checked:=True;
  RadioButton1Click(nil);
  EntryListClick(nil);

  Header.Caption:=HeadAnsiString;

end;

procedure TDB_GetEntry.EntryList2Click(Sender: TObject);
begin
   If (EntryList2.ItemIndex=-1) then OK_Button.Enabled:=False
   else
     Begin
       Entry := EntryList2.Items.Strings[EntryList2.ItemIndex];
       OK_Button.Enabled:=Entry <>'';
     End;
end;

procedure TDB_GetEntry.EntryListClick(Sender: TObject);
Var
   FileIsThere: Boolean;
   ShortFileN, Holder,
   DBName,CorrectDbName,Dir: AnsiString;
   Loop,RecNum: Integer;

begin
  OK_Button.Enabled:=False;
  EntryList2.Items.Clear;

  DbName:=FileEdit.Text;
  FileDir := ExtractFileDir(DBName);

  if RadioButton2.Checked then  //not default
    Begin
     if EntryList.ItemIndex < 0 then Exit;
     TableN := EntryList.Items.Strings[EntryList.ItemIndex];
    End;

  {Check and see if file exists}
  FileIsThere:=FileExists(DbName);
  If Not FileIsThere then Exit;

  {Get Entry Names if File Exists}
  SaveTable.TableName:=TableN;
  Try
     SaveTable.Active:=True;
     With SaveTable do begin
          First;
          SaveTable.Connection.FetchOptions.RecordCountMode := cmTotal;
          SaveTable.Refresh;
          RecNum:=RecordCount;
          If RecNum>0 then
             For loop:=1 to RecNum do
                 begin
                     Holder:=Fields[0].AsAnsiString;
                     EntryList2.Items.Add(Holder);
                     Next;
                  end; {for do}
          EntryList2.Update;
     end; {with}
  Except
  End;
  SaveTable.Active:=False;
end;

procedure TDB_GetEntry.FileEditChange(Sender: TObject);
begin
  DBName := FileEdit.Text;
  inherited;
  if True then

  EntryListClick(nil);
end;

procedure TDB_GetEntry.FormResize(Sender: TObject);
begin
  if Width > (597-274) then
   Begin
     FileEdit.Width := Width - (597-274);
     EntryList.Width := Width - (597-274);
   End;
end;

function TDB_GetEntry.GetEntry: Boolean;
begin
   GetEntry:=False;
   CreateScreen;
   If Showmodal = Mrok then GetEntry:=True;
end;

function TDB_GetEntry.LoadToUnderlyingData(DefaultTable: AnsiString;InTable: TFDTable): Boolean;
Var LoadOK: Boolean;
    ChemRecHolder:  ChemicalRecord;
    AnimRecHolder:  ZooRecord;
    PlantRecHolder: PlantRecord;
    ReminRecHolder: ReminRecord;
    SiteRecHolder:  SiteRecord;
    DBName, ProgDBName: String;

Begin
  With Db_GetEntry do
  begin
    HeadAnsiString:='Select '+DefaultTable+' Entry to Load:';

    ProgDBName := Program_Dir + 'ProgramDBs.sdb';
    DBName := InTable.Connection.Params.Database;
    Db_GetEntry.DefaultDbName:=DefaultTable;

    If Not GetEntry
      Then LoadOK := False
      Else Case DefaultTable[1] of
            'C' : LoadOK:=Dbase_to_ChemRecord2  (DBName,TableN,Entry,-1,ChemRecHolder);
            'A' : LoadOK:=DBase_to_AnimalRecord2(DBName,TableN,Entry,-1,AnimRecHolder);
            'P' : LoadOK:=DBase_to_PlantRecord2 (DBName,TableN,Entry,-1,PlantRecHolder);
            'R' : LoadOK:=DBase_to_ReminRecord2 (DBName,TableN,Entry,ReminRecHolder);
            'S' : LoadOK:=DBase_to_SiteRecord2  (DBName,TableN,Entry,SiteRecHolder);
            else LoadOK := False;
           end; {Case}

    If LoadOK then
      With InTable do
        begin
          Active:=False;
          EmptyTable(InTable);
          Active:=True;
          Append;
          Fields[0].AsAnsiString:='Holder';
          Post;
          Active:=False;
          Case DefaultTable[1] of
              'C' : ChemRecord_to_Dbase2  (ProgDBName,'CHEMFORM','Holder',ChemRecHolder,False);
              'A' : AnimalRecord_to_Dbase2(ProgDBName,'ANIMFORM','Holder',AnimRecHolder,False);
              'P' : PlantRecord_To_Dbase2 (ProgDBName,'PLNTFORM','Holder',PlantRecHolder,False);
              'R' : ReminRecord_To_Dbase2 (ProgDBName,'REMNFORM','Holder',ReminRecHolder,False);
              'S' : SiteRecord_To_Dbase2  (ProgDBName,'SITEFORM','Holder',SiteRecHolder,False);
             else LoadOK := False;
           End; {Case}
          Active:=True;
        End; {with}
  End; {with DB_Entry}

  LoadToUnderlyingData := LoadOK;
end;

procedure TDB_GetEntry.RadioButton1Click(Sender: TObject);
begin
   Width := 297;
   DBName := Default_Dir + 'AQUATOX.SDB';
   FileDir := Default_Dir;
   TableN := DefaultDBName;
   FileEdit.Text := DBName;

   Label2.Visible := False;
   Button1.Visible := False; //browse button
   EntryList.Visible := False;
end;

procedure TDB_GetEntry.RadioButton2Click(Sender: TObject);
begin
   Width := 600;

   Label2.Visible := True;
   Button1.Visible := True; //browse button
   EntryList.Visible := True;
end;

{$R *.DFM}

end.
