//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
//
{************************}
{*}    UNIT Global;    {*}
{************************}
interface

uses Sysutils, Winprocs, TCollect, Dialogs, Classes, Graphics, Forms, Controls, StdCtrls, DBGrids;

(*VAR P_REMOVAL_S_LP : DOUBLE;
      N_REMOVAL_S_LP : DOUBLE;  {6/21/2011 LIPSKY CODE} *)

Const
{***  This version number must be a 10 character AnsiString! ***}
{  Follow the number with a space, to ensure correct interpretation  }
{  VersionStr          = '#.## ?????' }
   VersionStr : AnsiString = '3.972     ';
   BuildStr   : AnsiString = '3.20 b 011';

{  VersionStr is used in the about/splash screen and also is written to the saved-data
   file in order to automatically upgrade versions if the data-structures change.     }

   WRITE_STEIN_DURING_RUN = TRUE;

   {Uncertainty Data}
   Num_of_Reg_Distributions  = 277; {Number of Registered Distributions Currently in DISTRIBS.PAS}
   InitialCond_RegDist_Index = 122; {Set to correct number for units to be correct :INITIAL CONDITION}
   LogKow_RegDist_Index      = 6;   {Set to correct number to allow for below zero draws}
   ConstLoad_RegDist_Index   = 123; {Important for units and Uncert.Pas Warning    :CONST LOAD}
   DP_RegDist_Index          = 126; {                                              :DIRECT PRECIP }
   PS_RegDist_Index          = 127; {Needed to evaluate if Alt_Loadings present    :POINT SOURCE }
   NPS_RegDist_Index         = 128; {Needed to evaluate if Alt_Loadings present    :Non POINT SOURCE }

   MAX_SENS_OUTPUTS          = 100; {only track 100 outputs at this time due to Excel column limitation}

   Def2SedLabDetr : Double = 0.5;   {Defecation that is labile -- Const used in Toxprocs.Inc, Reminerl.Inc, State.Inc}
   Detr_OM_2_OC   : Double = 1.90;  {Organic Matter in Detritus over OC in Detritus, Winberg et al. 1971 }

type
   PDouble= ^Double;
   PTextFile = ^TextFile;
{  PNotes = ^TNotes;
   TNotes = array[0..4096] of Char; }

   {Note, changes to this list affect loading of saved runs.  See TRANSLATE.INC

          Specific updates required are "updatenstate" and when it is called
          "translatetrophint" and the logic for when it is called
          graphs may not render properly, see UpdateUniqueIndex                 }

  PAllVariables =^AllVariables;
  AllVariables = (
 {Toxicants}       H2OTox1,  H2OTox2,  H2OTox3,  H2OTox4,  H2OTox5,
                   H2OTox6,  H2OTox7,  H2OTox8,  H2OTox9,  H2OTox10,
                   H2OTox11, H2OTox12, H2OTox13, H2OTox14, H2OTox15,
                   H2OTox16, H2OTox17, H2OTox18, H2OTox19, H2OTox20,

 {Nutrients 20}     Ammonia, Nitrate, Phosphate, CO2, Oxygen,

 {Porewater}       PoreWater, ReDOMPore, LaDOMPore,  {m3/m2, ug/L pw}
 {Sediments}       Sand, Silt, Clay, TSS,

 {Diagenesis}      Silica, Avail_Silica, COD, TAM, Methane, Sulfide,
                   POC_G1, POC_G2, POC_G3,   {H2}
                   PON_G1, PON_G2, PON_G3,   {H2}
                   POP_G1, POP_G2, POP_G3,   {H2}

 {Mult.Layer Segs} Cohesives, NonCohesives, NonCohesives2, {g/m2, ug/m2}
 {Estuarine vsn.}  Salinity,

 {Detritus: Sedm}  SedmRefrDetr, SedmLabDetr,
 {Detritus: Diss}  DissRefrDetr, DissLabDetr,
 {Detritus: Susp}  SuspRefrDetr, SuspLabDetr,

 {Buried Detritus} BuriedRefrDetr, BuriedLabileDetr,

 {Plants: Algae}   Diatoms1, Diatoms2, Diatoms3, Diatoms4, Diatoms5, Diatoms6,
                   Greens1, Greens2, Greens3, Greens4, Greens5, Greens6,
                   BlGreens1, BlGreens2, BlGreens3, BlGreens4,BlGreens5,BlGreens6,
                   OtherAlg1, OtherAlg2,
 {Plants: Macro}   Macrophytes1, Macrophytes2, Macrophytes3, Macrophytes4, Macrophytes5, Macrophytes6,

 {6/23/2014, reorganization of guilds,  Brought into 3.2 12/16/2016}
 {Animls: SuspFd}  SuspFeeder1 {85}, SuspFeeder2, SuspFeeder3, SuspFeeder4, SuspFeeder5, SuspFeeder6, SuspFeeder7, SuspFeeder8, SuspFeeder9,
 {Animls: DepFd}   DepFeeder1, DepFeeder2, DepFeeder3,
 {Animls }         Veliger1, Veliger2, Spat1, Spat2,
                   Clams1, Clams2, Clams3, Clams4, Snail1, Snail2,
 {Animls: SPInvrt} SmallPI1, SmallPI2,
 {Animls: PInvrt}  PredInvt1, PredInvt2, PredInvt3, PredInvt4,

 {Animals: Fish}   SmForageFish1, SmForageFish2, LgForageFish1, LgForageFish2,
 { size classes}   SmBottomFish1, SmBottomFish2, LgBottomFish1, LgBottomFish2,
                   SmGameFish1,   SmGameFish2,   SmGameFish3,   SmGameFish4,
                   LgGameFish1,   LgGameFish2,   LgGameFish3,   LgGameFish4,

 {Multi Age Fish}  Fish1, Fish2, Fish3, Fish4, Fish5, Fish6, Fish7, Fish8,
                   Fish9, Fish10, Fish11, Fish12, Fish13, Fish14, Fish15,

 {Driving Vars}    Volume,  Temperature,   WindLoading,   Light,  pH,

                   NullStateVar  {has utility uses}  );

Const HOURLYLIST = [ammonia..oxygen,sand..TSS,light,cohesives..NonCohesives2, DissRefrDetr..SuspLabDetr, Volume]; {List of variables with hourly loadings enabled}

      { Below constants help further characterize the above enumerated list...
          they must be updated when the list changes }

       FirstState   = H2OTox1;        LastState   = NullStateVar;
       FirstDetr    = SedmRefrDetr;   LastDetr    = SuspLabDetr;
       FirstPlant   = Diatoms1;       LastPlant   = Macrophytes6;
       FirstAlgae   = Diatoms1;       LastAlgae   = OtherAlg2;
       FirstDiatom  = Diatoms1;       LastDiatom  = Diatoms6;
       FirstGreens  = Greens1;        LastGreens  = Greens6;
       FirstBlGreen = BlGreens1;      LastBlGreen = BlGreens6;
       FirstMacro   = Macrophytes1;   LastMacro   = Macrophytes6;
       FirstAnimal  = SuspFeeder1;      LastAnimal  = Fish15;
       FirstInvert  = SuspFeeder1;      LastInvert  = PredInvt4;
       FirstDetrInv = DepFeeder1;      LastDetrInv = DepFeeder3;
       FirstFish    = SmForageFish1;  LastFish    = Fish15;
       FirstBiota   = Diatoms1;       LastBiota   = Fish15;  {this definition does not include detritus}
       FirstTox     = H2OTox1;        LastTox     = H2OTox20;
       FirstOrgTox  = H2OTox1;        LastOrgTox  = H2OTox20;

Type   PAlt_LoadingsType = ^Alt_LoadingsType;
       Alt_LoadingsType = (PointSource,DirectPrecip,NonPointSource);
       TDistType        = (Triangular,Uniform,Normal,LogNormal);

       StateVariables   =  H2OTox1..NullStateVar;
       VerticalSegments =  (Epilimnion,Hypolimnion);
       PTimeStepType    =  ^TimeStepType;
       TimeStepType     =  (TSHourly,TSDaily);

Const  InflowLoadT = PointSource;
       DischargeLoadT = DirectPrecip;

Type
  T_SVType   = {sv types}     ( StV, Porewaters,
                                OrgTox1,  OrgTox2,  OrgTox3,  OrgTox4,  OrgTox5,
                                OrgTox6,  OrgTox7,  OrgTox8,  OrgTox9,  OrgTox10,
                                OrgTox11, OrgTox12, OrgTox13, OrgTox14, OrgTox15,
                                OrgTox16, OrgTox17, OrgTox18, OrgTox19, OrgTox20,
                 {output types} NotUsed,  NotUsed2, OtherOutput, NTrack, PTrack,
                {Internal Nuts} NIntrnl, PIntrnl);

  T_SVLayer  = {Location of SV} (WaterCol,  SedLayer1, SedLayer2, SedLayer3,
                                 SedLayer4, SedLayer5, SedLayer6, SedLayer7,
                                 SedLayer8, SedLayer9, SedLayer10);

Const  LowestLayer = SedLayer10;
       Num_SVLayers = 10;
       FirstOrgTxTyp = OrgTox1;   LastOrgTxTyp = OrgTox20;
       FirstToxTyp = OrgTox1;     LastToxTyp = OrgTox20;

Type
  SV_ID        = Packed Record
                   Nstate : AllVariables;
                   Svtype : T_SVType;
                   Layer  : T_SVLayer;
                 End; {Record}
  PSV_ID       = ^SV_ID;


  POldGraphSetupRecord = ^TOldGraphSetuprecord;
  TOldGraphSetupRecord = Packed Record
     Y1Items, Y2Items: Array[1..20] of Longint;
     VarShowOptions: Array[1..20] of Boolean;
     Y1AutoScale, Y2AutoScale: Boolean;
     Y1Min,Y1Max,Y2Min,Y2Max: Double;
     Use2Scales: Boolean;
     XMin, XMax: Double;
   End;


  ToxicantType = FirstOrgTxTyp..LastOrgTxTyp;
  DetrDataType = (CBOD,Org_Carb,Org_Matt);
  TO2Effects   = (O2Mortality,O2Growth_Red,O2Repro_Red);

  TAddtlOutput = ( Secchi, Chla, NondissocOut, BedDepth, InflowWater, ToxLoading, TotalTox, THalfLife,
                   MultiFishConc, MultiFishTox, MultiFishPPB, TotalToxMass, DischWater, DebugPurposes,
                   BedDnsty, FracWatr, BedVlm,

                   TotTLoss, TotalTWash, TWashH2o, TWashAnim, TWashDetr, {Tox Tracking, Can be positive or negative}
                   TWashPlant, TWashSed, THydrol, TPhotol, TVolatil, TMicrobMet, TBioTrans,TNotUsed,TEmergeI,
                   TLossandMass, TBuryOOS, TTotOOSLoad, TLoadH2O, TLoadSed, TLoadDetr, TLoadBiota, TMBTest,
                   TSink,TDeltaThick, TEntrain,TTurbdiff,TMigrate,TNetLayer, TFishing,

                   DeltaBedHeight,VelocityOut,DynZMeanOut,
                   Peri_Chla, Moss_Chla, Tau, VelRiff, VelPool,
                   SegThick, TidalAmp, RetTime, BirdConc,
                     {Nutrient Tracking Variables}
                   TotNMass, NDissWater, NDetr, NAnimals, NPlants,
                   TotNLoss, TotalNWash, NWashH2o, NWashAnim, NWashDetr, NWashPlant, NEmergeI, NDenitr, NBurial,
                   NTotLoad, NLoadDissH2O, NLoadDetr, NLoadBiota, NPWMacro, NFixation, NMBTest, NExposure,
                   NLSink, NLTDiff, NLMigr, NLayerNet,

                   {Total Nitrogen and Total Phosphorus in mg/L,  BOD5}
                   TN,TP,BODOut, NH3UnIon,

                   PhytoResTime, DT50Water, DT95Water, Dt50Sed, Dt95Sed, TOrgSedPPB,

                   MinOxygen, MaxOxygen, O2Duration, MinNH3UnIon, MaxNH3UnIon,

                   PctBlGrPhyto,
                   SteinAnim,SteinPlant,SteinInvert,SteinAll, SOD_OUT, NSediment, InorgDep,

                   Peri_Biomass, Phyto_Biomass, TSP_Diag, No3_Diag, NH3_Diag, POP_Dep, POC_Dep, PON_Dep, CaCO3p, NSorbCaCO3,
                   SaltInflow, FreshInflow, EstEntr, EstUpperOut,
                   InorgSed, TSS60Day, PctEmbedded, MeanVol, BenthicChla, FracLitOut, O2FluxOut, PctEPT, PctChiro,
                   GPP_Out,CommResp_Out,PtoR_Out,BtoP_Out, NFishing, // 2-10-2009
                   PctAmphipods, PctGastropods, PctBivalves, PctBlGrPeri, PctDiatomsPeri, PctGreensPeri, PctOligochaete,   // 10/6/2009
                   PFluxDiagenesis, {KG since simulation start}      // 3-16-2010   {ORD #142}
                   PctDiatomsPhyto, PctGreensPhyto, PctOtherPhyto,   // 9-30-2010
                   BoundaryCond,    {kg/timestep}                    // 2-14-2011
                   PctEphemeroptera, PctTrichoptera,PctPlecoptera, PctEunotia,   // 4-27-2012
                   BInvt_Biomass, PlnkInvt_Biomass, Fish_Biomass, NPP_Out, NekInvt_Biomass,    // 1-21-2013
                   Oyster_Biomass,
                   Extinct_out, Extinct_Peri, InorgExt, OrgExt, PhytoExt );  // 11/22/2013;

   UptakeCalcMethodType = (Default_Meth,CalcBCF,CalcK1,CalcK2);


Const  MAX_NUMBER_SEGMENTS = 500; {Keep Track of Segment IDs in Linked Mode}
Const  C1=37./378;C3=250./621;C4=125./594;C6=512./1771;  {Integration Constants}

Type  TListBoxIDs = Array[0..Max_Number_Segments] of String[4];
      PListBoxIDs = ^TListBoxIDs;

Type
 {Previous Vsn's Choosable Animals in Toxicity Screen:  necessary for reading old files}
  OldAnimals = (Trout, Bluegill, Bass, Catfish, Minnow, Daphnia,
                Chironomid, Stonefly, Ostracod, Amphipod, Other);
  OldAlgTox  = (Green,Diatom,BlueGr,Macro);
  TMacroType = (Benthic,Rootedfloat,Freefloat);

  Fish = Trout..Minnow;
  Zoo  = Daphnia..Amphipod;
  Alg = (Phyto,BlGr,Gr);
  SiteTypes = (Pond, Stream, Reservr1D, Lake, Enclosure,Estuary,TribInput, Marine);

  Wavelengths = Array[1..12] of Double;
  RefShortString   = String[45];
  NewRefShortString   = String[200];
  RefString100 = String[100];
  UnitShortString  = String[20];
  XLRefShortString = String[90];
  PRefShortString  = ^RefShortString;
  FileNShortString = String[255];
  LongRefShortString = String[60];
  NameShortString   = String[60];
  PNameShortString = ^NameShortString;
  SegIDShortString = String[4];
  PSegIDShortString = ^SegIDShortString;
  PBoolean = ^Boolean;
  PInteger = ^Integer;
  PDirShortString = ^FileNShortString;

  TMethdProc = procedure of object;
  PProgDataRec = ^ProgDataRec;
  ProgDataRec = packed record
      ErrVar, ErrRate,
      PercStepCaption,
      UncertStatLabel,
      UncertTitleLabel,
      LinkMLabel,
      ErrValue, DateStr          : AnsiString;
      UncertPanelVis, LinkMLabelVis,
      StratVis, AnoxicVis, WZVis,
      ProgCancel, StepSizeVis,
      PeriVis, SloughDia,
      SloughGr,SloughBlGr        : Boolean;
      ProgInt, Gauge2Int         : Integer;
    End;

  PChemicalRecord = ^ChemicalRecord;
  ChemicalRecord =  packed record
      ChemName             : NewRefShortString;
      CASRegNo             : String[20];
      MolWt                : Double;
      Solubility           : Double;
      XSolubility          : NewRefShortString;
      Henry                : Double;
      XHenry               : NewRefShortString;
      pka                  : Double;
      Xpka                 : NewRefShortString;
      VPress               : Double;
      XVPress              : NewRefShortString;
      LogKow               : Double; {Log KOW, log octanol water part. coeff.}
      XLogKow              : NewRefShortString;
      En                   : Double; {Activation Energy for Temperature}
      XEn                  : NewRefShortString;
      KMDegrdn             : Double;
      XKMDegrdn            : NewRefShortString;
      KMDegrAnaerobic      : Double;
      XKMDegrAnaerobic     : NewRefShortString;
      KUnCat               : Double;
      XKUncat              : NewRefShortString;
      KAcid                : Double;
      XKAcid               : NewRefShortString;
      KBase                : Double;
      XKBase               : NewRefShortString;
      PhotolysisRate       : Double;
      XPhotoLysisRate      : NewRefShortString;
      OxRateConst          : Double;
      XOxRateConst         : NewRefShortString;

      KPSed                : Double;
      XKPSed               : NewRefShortString;
      Weibull_Shape        : Double;
      XWeibull_Shape       : NewRefShortString;
      ChemIsBase           : Boolean;
      CalcKPSed            : Boolean;

      CohesivesK1          : Double;
      CohesivesK2          : Double;
      CohesivesKp          : Double;
      CohesivesRef         : NewRefShortString;
      NonCohK1             : Double;
      NonCohK2             : Double;
      NonCohKp             : Double;
      NonCohRef            : NewRefShortString;
      NonCoh2K1            : Double;
      NonCoh2K2            : Double;
      NonCoh2Kp            : Double;
      NonCoh2Ref           : NewRefShortString;

            {PFA Parameters}
      IsPFA                : Boolean;
      PFAType              : String[12];
      PFAChainLength       : Double;
      XPFAChainLength      : NewRefShortString;
      PFASedKom            : Double;
      XPFASedKom           : NewRefShortString;
      PFAAlgBCF            : Double;
      XPFAAlgBCF           : NewRefShortString;
      PFAMacroBCF          : Double;
      XPFAMacroBCF         : NewRefShortString;

      WeibullSlopeFactor   : Double;
      XWeibullSlopeFactor  : NewRefShortString;

      CalcKOMRefrDOM       : Boolean;
      KOMRefrDOM           : Double;
      XKOMRefrDOM          : NewRefShortString;

      K1Detritus           : Double;         // new to 3.77
      XK1Detritus          : NewRefShortString;

      BCFUptake            : Boolean;  // New to 3.87

      PlaceholderD1        : Double;  {place holders so additional parameters do not require storload mods}
      PlaceholderD2        : Double;
      PlaceholderR1        : NewRefShortString;
      PlaceholderR2        : NewRefShortString;
    end;

  MBTrackArray = Array[0..6] of Double;

  MBLossRecord =  {Record tracks MB loss for a particular state var. for a particular segment}
    Record
      TotalNLoss   : MBTrackArray;
      TotalWashout : MBTrackArray;
      WashoutH2O   : MBTrackArray;
      WashoutAnim  : MBTrackArray;
      WashoutDetr  : MBTrackArray;
      WashoutPlant : MBTrackArray;
      EmergeIns    : MBTrackArray;
      Denitrify    : MBTrackArray;
      Burial       : MBTrackArray;
      CaCO3Sorb    : MBTrackArray;
      FishingLoss  : MBTrackArray;
      BoundLoss    : MBTrackArray;   // Loss out of the model domain for this segment  2-14-2011  {PER TIME STEP}
    End;

  MBLoadRecord = {Record tracks MB loading for a particular state var. for a particular segment}
    Record
      LoadH2O   : MBTrackArray;
      LoadDetr   : MBTrackArray;
      LoadBiota   : MBTrackArray;
      LoadPWMacro : MBTrackArray;
      LoadFixation : MBTrackArray;
      TotOOSLoad  : MBTrackArray;  // redefined to mean "out of segment" load for linked-mode MB tracking refinement 3/20/2014
      Exposure  : MBTrackArray;
      BoundLoad    : MBTrackArray;   // gain intothe model domain for this segment  2-14-2011  {PER TIME STEP}
    End;

  MBLayerRecord = {Record tracks inter layer interactions for a particular state var. for a particular segment}
    Record
      NSink      : MBTrackArray;
      NTurbDiff  : MBTrackArray;
      NMigrate   : MBTrackArray;
      NNetLayer  : MBTrackArray;
      PFluxD     : MBTrackArray;
    End;

  EstSaltLoadingRec =
    Packed Record
      AmmoniaLoad: Double; {mg/L}
      XAmmoniaLoad: XLRefShortString;
      NitrateLoad: Double; {mg/L}
      XNitrateLoad: XLRefShortString;
      PhosphateLoad: Double; {mg/L}
      XPhosphateLoad: XLRefShortString;
      O2Load: Double; {mg/L}
      XO2Load: XLRefShortString;
      CO2Load: Double; {mg/L}
      XCO2Load: XLRefShortString;
    End;

  ToxTrackArray = Array[0..6] of Double;

  ToxLossRecord =  {Record tracks tox loss for a particular toxicant for a particular segment}
    Packed Record
      TotalToxLoss : ToxTrackArray;
      TotalWashout : ToxTrackArray;
      WashoutH2O   : ToxTrackArray;
      WashoutAnim  : ToxTrackArray;
      WashoutDetr  : ToxTrackArray;
      WashoutPlant : ToxTrackArray;
      WashoutSedm  : ToxTrackArray;
      Hydrolys     : ToxTrackArray;
      Photolys     : ToxTrackArray;
      Volatiliz    : ToxTrackArray;
      MicrobMet    : ToxTrackArray;
      BioTransf    : ToxTrackArray;
      EmergeIns    : ToxTrackArray;
      OOSBury      : ToxTrackArray;
      FishingLoss  : ToxTrackArray;

      DissHydr  : ToxTrackArray;
      DissPhot  : ToxTrackArray;
      DissMicrob: ToxTrackArray;
      DissWash  : ToxTrackArray;
      DissVolat : ToxTrackArray;
      DissSorp  : ToxTrackArray;
      SedMicrob : ToxTrackArray;
      SedHydr   : ToxTrackArray;
      SedDeSorp : ToxTrackArray;
      SedScour  : ToxTrackArray;
    End;

   ToxLayerRecord = {Record tracks inter layer interactions for a particular toxicant for a particular segment}
    Packed Record
      ToxSink      : ToxTrackArray;
      ToxDeltaThick: ToxTrackArray;
      ToxTurbDiff  : ToxTrackArray;
      ToxEntrain   : ToxTrackArray;
      ToxMigrate   : ToxTrackArray;
      ToxNetLayer  : ToxTrackArray;
    End;

  ToxLoadRecord = {Record tracks tox loading for a particular toxicant for a particular segment}
    Packed Record
      ToxLoadH2O  : ToxTrackArray;
      ToxLoadSed  : ToxTrackArray;
      ToxLoadDetr : ToxTrackArray;
      ToxLoadBiota: ToxTrackArray;
      TotOOSLoad  : ToxTrackArray;    // redefined to mean "out of segment" load for linked-mode MB tracking refinement 3/20/2014
    End;

  SiteRecord =
    packed record
      SiteName             : NewRefShortString;
      ECoeffWater          : Double;
      SiteLength           : Double;   {units are KM}
      XLength              : NewRefShortString;
      StaticVolume         : Double;
      XVolume              : NewRefShortString;
      SurfArea             : Double;
      XSurfArea            : NewRefShortString;
      ICZMean              : Double;
      XZMean               : NewRefShortString;
      ZMax                 : Double;
      XZMax                : NewRefShortString;
      TempMean             : Array[VerticalSegments] of Double;
      XTempMean            : Array[VerticalSegments] of NewRefShortString;
      TempRange            : Array[VerticalSegments] of Double;
      XTempRange           : Array[VerticalSegments] of NewRefShortString;
      Latitude             : Double;
      XLatitude            : NewRefShortString;
      LightMean            : Double;
      XLightMean           : NewRefShortString;
      LightRange           : Double;
      XLightRange          : NewRefShortString;
      AlkCaCO3             : Double;
      XAlkCaCO3            : NewRefShortString;
      HardCaCO3            : Double;
      XHardCaCO3           : NewRefShortString;
      SiteComment          : String[255];
      SO4ConC              : Double;
      XSO4Conc             : NewRefShortString;
      TotalDissSolids      : Double;
      XTotalDissSolids     : NewRefShortString;
      StreamType           : String[20];
      Channel_Slope        : Double;
      XChannel_Slope       : NewRefShortString;
      Max_Chan_Depth       : Double;
      XMax_Chan_Depth      : NewRefShortString;
      SedDepth             : Double;
      XSedDepth            : NewRefShortString;
      EnclWallArea         : Double;
      XEnclWallArea        : NewRefShortString;
      MeanEvap             : Double;       {inches / year}
      XMeanEvap            : NewRefShortString;
      UseEnteredManning    : Boolean;
      EnteredManning       : Double;
      XECoeffWater         : NewRefShortString;

      PctRiffle            : Double;
      XPctRiffle           : NewRefShortString;
      PctPool              : Double;
      XPctPool             : NewRefShortString;

      UseBathymetry        : Boolean;

      ts_clay              : Double;  { clay critical shear stress for scour [kg/m2] }
      Xts_clay             : NewRefShortString;
      ts_silt              : Double;  { silt critical shear stress for scour [kg/m2] }
      Xts_silt             : NewRefShortString;
      tdep_clay            : Double;   { clay critical shear stress for deposition [kg/m2] }
      Xtdep_clay           : NewRefShortString;
      tdep_silt            : Double;   { silt critical shear stress for deposition [kg/m2] }
      Xtdep_silt           : NewRefShortString;
      FallVel_clay         : Double;  { clay fall velocity, m/s}
      XFallVel_clay        : NewRefShortString;
      FallVel_silt         : Double;  { silt fall velocity, m/s}
      XFallVel_silt        : NewRefShortString;

     {ESTUARY ADDITIONS BELOW}

      SiteWidth            : Double;
      XSiteWidth           : NewRefShortString;

  {m2} amplitude1 : Double; k1: Double; ConstRef1: NewRefShortString;
  {s2} amplitude2 : Double; k2: Double; ConstRef2: NewRefShortString;
  {n2} amplitude3 : Double; k3: Double; ConstRef3: NewRefShortString;
  {k1} amplitude4 : Double; k4: Double; ConstRef4: NewRefShortString;
  {o1} amplitude5 : Double; k5: Double; ConstRef5: NewRefShortString;
 {SSA} amplitude6 : Double; k6: Double; ConstRef6: NewRefShortString;
  {SA} amplitude7 : Double; k7: Double; ConstRef7: NewRefShortString;
  {P1} amplitude8 : Double; k8: Double; ConstRef8: NewRefShortString;

      Min_Vol_Frac         : Double;
      XMin_Vol_Frac        : NewRefShortString;

      WaterShedArea        : Double;
      XWaterShedArea       : NewRefShortString;
      EnterTotalLength     : Boolean;
      TotalLength          : Double;
      XTotalLength         : NewRefShortString; {3.43}

      ECoeffSED            : Double;
      XECoeffSED           : NewRefShortString;
      ECoeffDOM            : Double;
      XECoeffDOM           : NewRefShortString;
      ECoeffPOM            : Double;
      XECoeffPOM           : NewRefShortString;  {3.44}

      UseCovar             : Boolean;
      EnteredKReaer        : Double;
      XEnteredKReaer       : NewRefShortString;
      UsePhytoRetention    : Boolean;

      BasePercentEmbed     : Double;     {3-6-2008}
      XBasePercentEmbed    : NewRefShortString;

      Altitude             : Double;     {12/27/2008}  {3.60}
      XAltitude            : NewRefShortString;         // size 10796 as of version 3.87

      FractalD             : Double;
      XFractalD            : RefString100;
      FD_Refuge_Coeff      : Double;
      XFD_Refuge_Coeff     : RefString100;
      HalfSatOysterRefuge  : Double;
      XHalfSatOysterRefuge : RefString100;
      NotUsedReefHeight    : Double;
      XNotUsedReefHeight   : RefString100;

      PlaceholderN1        : Double;
      PlaceholderR1        : RefString100;
      PlaceholderN2        : Double;
      PlaceholderR2        : RefString100;
      PlaceholderN3        : Double;
      PlaceholderR3        : RefString100;
      PlaceholderN4        : Double;
      PlaceholderR4        : RefString100;
      PlaceholderB1        : Boolean;
    end;

  MorphRecord =   {Hold Results of Variable Morphometry}
  Packed Record
      SegVolum         : Array[VerticalSegments] of Double;   {segment volume last good solution step}
      InflowH2O        : Array[VerticalSegments] of Double;
      XSecArea         : Double;
      OOSDischFrac     : Double; {frac of total discharge that moving out of the system (linked mode)}
      OOSInflowFrac    : Double; {Frac of total inflow that is coming from out of the sys (linked mode)}
  end;

  ReminRecord =
    packed record
      RemRecName    : NewRefShortString;
      DecayMax_Lab  : Double;
      XDecayMax_Lab : NewRefShortString;
      Q10_NotUsed   : Double;
      XQ10          : NewRefShortString;
      TOpt          : Double;
      XTOpt         : NewRefShortString;
      TMax          : Double;
      XTMax         : NewRefShortString;
      TRef_NotUsed  : Double;
      XTRef         : NewRefShortString;
      pHMin         : Double;
      XpHMin        : NewRefShortString;
      pHMax         : Double;
      XpHMax        : NewRefShortString;
      P2OrgLab      : Double;
      N2OrgLab      : Double;
      PlaceHolder   : Double; {Was Org2 Nitrate}
      XP2OrgLab     : NewRefShortString;
      XN2OrgLab     : NewRefShortString;
      O2Biomass     : Double;
      XO2Biomass    : NewRefShortString;
      O2N           : Double;
      XO2N          : NewRefShortString;
      KSed          : Double;
      XKsed         : NewRefShortString;
      PSedRelease_NotUsed   : Double;
      XPSedrelease  : NewRefShortString;
      NSedRelease_NotUsed   : Double;
      XNSedRelease  : NewRefShortString;
      DecayMax_Refr : Double;    {g/g d}
      XDecayMax_Refr: NewRefShortString;

      {ESTUARY ADDITIONS BELOW}
      KSedTemp            : Double;
      XKSedTemp           : NewRefShortString;
      KSedSalinity        : Double;
      XKSedSalinity       : NewRefShortString;
      {ESTUARY ADDITIONS Above}

      P2Org_Refr     : Double;
      XP2Org_Refr    : NewRefShortString;
      N2Org_Refr     : Double;
      XN2Org_Refr    : NewRefShortString;
      Wet2DryPRefr   : Double;
      XWet2DryPRefr  : NewRefShortString;
      Wet2DryPLab    : Double;
      Xet2DryPLab    : NewRefShortString;
      Wet2DrySRefr   : Double;
      XWet2DrySRefr  : NewRefShortString;
      Wet2DrySLab    : Double;
      XWet2DrySLab   : NewRefShortString; {1216}
      N2OrgDissLab   : Double;
      XN2OrgDissLab  : NewRefShortString;
      P2OrgDissLab   : Double;
      XP2OrgDissLab  : NewRefShortString;
      N2OrgDissRefr  : Double;
      XN2OrgDissRefr : NewRefShortString;
      P2OrgDissRefr  : Double;
      XP2OrgDissRefr : NewRefShortString;

      KD_P_Calcite   : Double;     {Sorption of P to CaCO3, L/Kg}
      XKD_P_Calcite  : NewRefShortString;

      NotUsed        : Double;  // Was BOD5_CBODu
      XNotUsed       : NewRefShortString; // XBOD5_CBODu

      KNitri         : Double;
      XKNitri        : NewRefShortString;
      KDenitri_Bot   : Double;
      XKDenitri_Bot  : NewRefShortString;
      KDenitri_Wat   : Double;
      XKDenitri_Wat  : NewRefShortString;

      PlaceholderB1  : Boolean;
      PlaceholderB2  : Boolean;
    end;

  InteractionFields =
    Packed record
      Pref : Double;
      ECoeff: Double;
      XInteraction: LongRefShortString;
          f1,f2,f3: Byte; {d4-5}
    end;

  PZooRecord = ^ZooRecord;
  ZooRecord =
    packed record {d4-5}
      AnimalName          : NewRefShortString;
      ToxicityRecord      : String[15];
      FHalfSat            : Double;
      XFHalfSat           : NewRefShortString;
      CMax                : Double;      {max consumption}
      XCMax               : NewRefShortString;
      BMin                : Double;
      XBMin               : NewRefShortString;
      Q10                 : Double;
      XQ10                : NewRefShortString;
      TOpt                : Double;
      XTOpt               : NewRefShortString;
      TMax                : Double;
      XTMax               : NewRefShortString;
      TRef                : Double;
      XTRef               : NewRefShortString;
      EndogResp           : Double;
      XEndogResp          : NewRefShortString;
      KResp               : Double;
      XKResp              : NewRefShortString;
      KExcr               : Double;
      XKExcr              : NewRefShortString;
      PctGamete           : Double;
      XPctGamete          : NewRefShortString;
      GMort               : Double;
      XGMort              : NewRefShortString;
      KMort               : Double;     {Mortality Coefficient}
      XKMort              : NewRefShortString;
      Placeholder         : Double;     { Not Used, Takes the place of EMort }
      XPlaceHolder        : NewRefShortString;
      KCap                : Double;
      XKCap               : NewRefShortString;
      MeanWeight          : Double;
      XMeanWeight         : NewRefShortString;
      FishFracLipid       : Double;
      XFishFracLipid      : NewRefShortString;
      LifeSpan            : Double;      { Mean Lifespan in days }
      XLifeSpan           : NewRefShortString;
      Animal_Type         : String[15];
      AveDrift            : Double;
      XAveDrift           : NewRefShortString;   {Background Drift}
      {V185 Additions Below}
      AutoSpawn           : Boolean;     {Calc Spawn Automatically based on Temps?}

      SpawnDate1          : TDateTime;
      SpawnDate2          : TDateTime;
      SpawnDate3          : TDateTime;
      XSpawnDate          : NewRefShortString;
      UnlimitedSpawning   : Boolean;
      SpawnLimit          : Integer;

      UseAllom_C          : Boolean;     {use allometric equations to calculate consumption}

      CA                  : Double;      {intercept for weight dependence}
      CB                  : Double;      {slope for weight dependence}
      UseAllom_R          : Boolean;     {use allometric equations to calculate respiration}

      RA                  : Double;      {intercept for spec. standard metabolism}
      RB                  : Double;      {weight dependence coeff.}
      UseSet1             : Boolean;     {Use "set 1" of resp. eqns.}

      RQ, RTO, RTM, RTL,
      RK1, RK4, ACT, BACT : Double;      {allometric respiration parameters} {size 1328}
      FracInWaterCol      : Double;
      XFracInWaterCol     : NewRefShortString;
      Guild_Taxa          : String[15];

      PrefRiffle          : Double;
      XPrefRiffle         : NewRefShortString;
      PrefPool            : Double;
      XPrefPool           : NewRefShortString;
      VelMax              : Double;
      XVelMax             : NewRefShortString;
      XAllomConsumpt      : NewRefShortString;
      XAllomResp          : NewRefShortString;

            {ESTUARY ADDITIONS BELOW}
      {Salinity & Ingestion}
      Salmin_Ing,         {minimum salinity tolerance 0/00}
      SalMax_Ing,         {max salinity tolerance 0/00}
      Salcoeff1_Ing,
      Salcoeff2_Ing       : Double; {unitless}
      XSalinity_Ing       : NewRefShortString;
      {Salinity & Gameteloss}
      Salmin_Gam,         {minimum salinity tolerance 0/00}
      SalMax_Gam,         {max salinity tolerance 0/00}
      Salcoeff1_Gam,
      Salcoeff2_Gam       : Double; {unitless}
      XSalinity_Gam       : NewRefShortString;
      {Salinity & Respiration}
      Salmin_Rsp,         {minimum salinity tolerance 0/00}
      SalMax_Rsp,         {max salinity tolerance 0/00}
      Salcoeff1_Rsp,
      Salcoeff2_Rsp       : Double; {unitless}
      XSalinity_Rsp       : NewRefShortString;
      {Salinity & Mortility}
      Salmin_Mort,         {minimum salinity tolerance 0/00}
      SalMax_Mort,         {max salinity tolerance 0/00}
      Salcoeff1_Mort,
      Salcoeff2_Mort       : Double; {unitless}
      XSalinity_Mort       : NewRefShortString;

      Fishing_Frac         : Double;    {fraction / day}
      XFishing_Frac        : NewRefShortString;

      P2Org                : Double;
      XP2Org               : NewRefShortString;
      N2Org                : Double;
      XN2Org               : NewRefShortString;

      Wet2Dry              : Double;
      XWet2Dry             : NewRefShortString;

      O2_LethalConc        : Double;
      O2_LethalPct         : Double;
      O2_LCRef             : NewRefShortString;

      O2_EC50growth        : Double;
      XO2_EC50growth       : NewRefShortString;
      O2_EC50repro         : Double;
      XO2_EC50repro        : NewRefShortString;

      Ammonia_LC50         : Double;
      XAmmonia_LC50        : NewRefShortString;

      Sorting              : Double;    {3.46, SABS}
      XSorting             : NewRefShortString;
      SuspSedFeeding       : Boolean;
      XSuspSedFeeding      : NewRefShortString;
      SlopeSSFeed          : Double;
      XSlopeSSFeed         : NewRefShortString;
      InterceptSSFeed      : Double;
      XInterceptSSFeed     : NewRefShortString;

      SenstoSediment       : NewRefShortString;
      XSensToSediment      : NewRefShortString;
      Trigger              : Double;
      XTrigger             : NewRefShortString;

      SenstoPctEmbed       : Boolean;   {3-6-2008}
      PctEmbedThreshold    : Double;
      XPctEmbedThreshold   : NewRefShortString;

      BenthicDesignation   : NewRefShortString; {10/24/08 Benthic Metric Designation}

      CanSeekRefuge        : Boolean;
      Visual_Feeder        : Boolean;

     {--------------------------------------------------------------------------------}
      PlaceholderB1        : Boolean;   // placeholders here due to misplacement of scientific name
      PlaceholderB2        : Boolean;
      PlaceholderS1        : Single;
      PlaceHolderD1        : Double;
     {--------------------------------------------------------------------------------}

      Burrow_Index         : Double;
      ScientificName       : NewRefShortString;
      XBurrow_Index        : NewRefShortString;  // 3.92

     {--------------------------------------------------------------------------------}
      PlaceholderB3        : Boolean;
      PlaceholderR1        : NewRefShortString;
      PlaceholderR2        : NewRefShortString;
    end;

  PTrophIntArray = ^TrophIntArray;
  TrophIntArray = Array[Cohesives..LastBiota] of InteractionFields;
  {Four excess entries at the beginning of the record is a coding artifact related to old versions}

  PPlantRecord= ^PlantRecord;
  PlantRecord =
    packed record
      PlantName           : NewRefShortString;
      PlantType           : String[15];
      ToxicityRecord      : String[15];
      EnteredLightSat     : Double;
      XLightSat           : NewRefShortString;
      KPO4                : Double;
      XKPO4               : NewRefShortString;
      KN                  : Double;    {n half Sat}
      XKN                 : NewRefShortString;
      KCarbon             : Double;
      XKCarbon            : NewRefShortString;
      Q10                 : Double;
      XQ10                : NewRefShortString;
      TOpt                : Double;
      XTOpt               : NewRefShortString;
      TMax                : Double;
      XTMax               : NewRefShortString;
      TRef                : Double;
      XTRef               : NewRefShortString;
      PMax                : Double;
      XPMax               : NewRefShortString;
      KResp               : Double;
      XKResp              : NewRefShortString;
      KMort               : Double;
      XKMort              : NewRefShortString;
      EMort               : Double;
      XEMort              : NewRefShortString;
      KSed                : Double;
      XKSed               : NewRefShortString;
      ESed                : Double;
      XESed               : NewRefShortString;
      P2OrgInit           : Double;
      XP2Org              : NewRefShortString;
      N2OrgInit           : Double;
      XN2Org              : NewRefShortString;
      ECoeffPhyto         : Double;
      XECoeffPhyto        : NewRefShortString;
      CarryCapac          : Double;
      XCarryCapac         : NewRefShortString;
      Red_Still_Water     : Double;
      XRed_Still_Water    : NewRefShortString;
      Macrophyte_Type     : String[15];
      Macro_Drift         : Double;
      Taxonomic_Type      : String[15];
      PrefRiffle          : Double;
      XPrefRiffle         : NewRefShortString;
      PrefPool            : Double;
      XPrefPool           : NewRefShortString;
      FCrit               : Double;
      XFCrit              : NewRefShortString;
      Macro_VelMax        : Double;
      XVelMax             : NewRefShortString;
            {ESTUARY ADDITIONS BELOW}
      KSedTemp            : Double;
      XKSedTemp           : NewRefShortString;
      KSedSalinity        : Double;
      XKSedSalinity       : NewRefShortString;
      {Salinity & Photosynthesis}
      Salmin_Phot,         {minimum salinity tolerance 0/00}
      SalMax_Phot,         {max salinity tolerance 0/00}
      Salcoeff1_Phot,
      Salcoeff2_Phot        : Double; {unitless}
      XSalinity_Phot       : NewRefShortString;
      {Salinity & Mortility}
      Salmin_Mort,         {minimum salinity tolerance 0/00}
      SalMax_Mort,         {max salinity tolerance 0/00}
      Salcoeff1_Mort,
      Salcoeff2_Mort       : Double; {unitless}
      XSalinity_Mort       : NewRefShortString;

      Wet2Dry              : Double;
      XWet2Dry             : NewRefShortString;

      Resp20              : Double;
      XResp20             : NewRefShortString;

      PctSloughed          : Double;
      XPctSloughed         : NewRefShortString;

      UseAdaptiveLight     : Boolean;
      MaxLightSat          : Double;
      XMaxLightSat         : NewRefShortString;
      MinLightSat          : Double;
      XMinLightSat         : NewRefShortString;

      PlaceholderB2        : Boolean;  {Size 7011 to here 3.67}
      ScientificName       : NewRefShortString;

      PlantFracLipid       : Double;
      XPlantFracLipid      : NewRefShortString;

      SurfaceFloating      : Boolean;  {3.80}

      NHalfSatInternal     : Double;
      XNHalfSatInternal    : NewRefShortString;    {Size 7631 to here 3.82}
      PHalfSatInternal     : Double;
      XPHalfSatInternal    : NewRefShortString;
      MaxNUptake           : Double;
      XMaxNUptake          : NewRefShortString;
      MaxPUptake           : Double;
      XMaxPUptake          : NewRefShortString;
      Min_N_Ratio          : Double;
      XMin_N_Ratio         : NewRefShortString;
      Min_P_Ratio          : Double;
      XMin_P_Ratio         : NewRefShortString;

      Plant_to_Chla        : Double;         {g carbon/g chlorophyll}
      XPlant_to_Chla       : NewRefShortString;   {Size  to here 3.89}

      PlaceholderD1        : Double;
      PlaceholderR1        : NewRefShortString;
      PlaceholderD2        : Double;
      PlaceholderR2        : NewRefShortString;
      PlaceholderD3        : Double;
      PlaceholderR3        : NewRefShortString;
      PlaceholderD4        : Double;
      PlaceholderR4        : NewRefShortString;
      PlaceholderD5        : Double;
      PlaceholderR5        : NewRefShortString;
      PlaceholderB1        : Boolean;
      PlaceholderB3        : Boolean;

   end;

  PSetup_Record = ^Setup_Record;
  Setup_Record =
  Packed record
      FirstDay          : TDateTime;
      LastDay           : TDateTime;
      StoreStepSize     : Double;
      MinStepSize       : Double;
      RelativeError     : Double;
      Placeholder       : Boolean;  {equilibrium fugacity disabled}
      SaveBRates        : Boolean;
      AlwaysWriteHypo   : Boolean;
      ShowIntegration   : Boolean;
      UseComplexedInBAF : Boolean;
      DisableLipidCalc  : Boolean;
      KeepDissToxConst  : Boolean;
      AverageOutput     : Boolean;
      UseExternalConcs  : Boolean;
      NotUsedBCFUptake  : Boolean;   // Switched to chemical record 2/15/2013

      StepSizeInDays    : Boolean;
      ModelTSDays       : Boolean;

      Spinup_Mode       : Boolean;  {to v 3.56}
      NFix_UseRatio     : Boolean;  {to v 3.66}   // 3/16/2010, option to use NFix Ratio
      NtoPRatio         : Double;   {to v 3.67}   // 3/18/2010, capability to specify NFix Ratio

      Spin_Nutrients    : Boolean;  {to v 3.77}

      FixStepSize        : Double;
      UseFixStepSize     : Boolean;  {to 3.79}

      Internal_Nutrients : Boolean;  {New to 3.83 and 3.1 plus}

      T1IsAggregate      : Boolean;  {to 3.94}
      AmmoniaIsDriving   : Boolean;  {to 3.94}
      TSedDetrIsDriving  :  Boolean;  {to 3.94}

      PlaceholderD1,D2   : Double;  {place holders so additional parameters do not require storload mods}
      PlaceholderB1,B2,B3: Boolean;
end;


  PUncertainty_Setup_Record = ^Uncertainty_Setup_Record;
  Uncertainty_Setup_Record =
  packed record {d4-5}
      Run_Uncertainty     : Boolean;
      Run_Sensitivity     : Boolean;       {new to 3.20}
        f2,f3             : Byte; {d4-5}
      NumSteps            : LongInt;
      RandomSeed          : LongInt;
      UseSeed             : Boolean;
        f4,f5,f6          : Byte; {d4-5}

      NominalPercent      : Double;        {new to 3.20 below }
      TrackUncertVars     : Boolean;
      NumUncert, NumSens  : Integer;
      SensTrack, UncertTrack: Array [1..100] of LongInt;
      LinkPeriPhyto       : Boolean;
      UseCorrelations     : Boolean;

      AdvancedSens        : Boolean;  {3.62  No Interface a this time}
      StartIteration      : Integer;
      Processors2Use      : Integer;
      StartIter, EndIter  : Integer;
      AverageAll          : Boolean;
      AverageYears        : Double;   {Size 861 to here}

      SaveToCSV           : Boolean;  {3.65 addition}
      RandomSampling      : Boolean;  {3.66 addition}

      PlaceholderD1       : Double;
      PlaceholderD2       : Double;
      PlaceholderB1       : Boolean;
      PlaceholderB2       : Boolean;
  end;

(*  PreRunDataRecord =
  Packed record
      IngestRate    : Array [FirstAnimal..LastAnimal] of Double;
      GrowthRate    : Array [FirstAnimal..LastAnimal] of Double;
      AveIngestRate : Array [FirstAnimal..LastAnimal] of Double;
      AveGrowthRate : Array [FirstAnimal..LastAnimal] of Double;
  end; *)

(*PRateInfoType=^RateInfoType;
RateInfoType = Packed Record
                 Dirnm,FileNm: String[255];
                 WriteDaily      : Boolean;
                 NotUsed         : Boolean;
                 FileInit        : Array[VerticalSegments] of Boolean;
                 NotUsed2        : Boolean;      // WriteToMemory set to true permanently, 8/27/2010
               End;  *)

Sediment_Data_Rec =
Packed record  
  Width,        { channel bottom width in meters [m] }
  Slope,        { channel slope [m/m]                }
  Manning,      { Manning's n roughness coefficient  }
  yFlood,       { Maximum channel depth[m] before overflow into the floodplain}
  Clength,      { channel length [m] }
  AWidth,       { channel width [m] }
  Max_Depth,    { maximum allowable sediment depth [m] }
  BedDepth,     { depth of bed sediment }
  Bed_Porosity, { a function of porosities for each particle type }

  msilt, msand, mclay: Double;  { Sediment masses, [kg] }

{  mett, metv                                   : Viscdat; }

  { table of kinematic viscosities as a function of Temp}
  BedDepthWarning, FloodPlainWarning           : Boolean;
  { avoid repetative warnings }

  Channel_Depth : Double;  {Current channel depth in meters}
  Avg_Depth     : Double;  {Average depth of reach in meters}
  Avg_Disch     : Double;  {Current average flow discharge in [m3/s]}
  HRadius       : Double;


  Scour_Clay, Scour_Silt, Sco_Sand : Double;
  Dep_Clay, Dep_Silt, Dep_Sand  : Double;
  CBedTo   : Double;
  Vol_Silt : Double;
  Tau      : Double; {kg/m2}

end;

Control_Opt_SubRec = Packed Record
   ZeroInitCond, OmitInflow, OmitPS, OmitDP, OmitNPS, SetMult: Boolean;
   OmitTox, OmitBuried: Boolean {Relevant only to tox and Hg}
 End;

 PControl_Opt_Rec = ^Control_Opt_Rec;
 Control_Opt_Rec = Packed Record
  Tox,Nutrient,Sediment,Detritus: Control_Opt_SubRec;
 End;

 BedRecord = Packed Record
    BedDepthIC       : Double; {m}            {Input Parameter, Initial Condition}
    BedDensity       : Double; {g/m3}         {Calculated from Component Densities}
    NotUsed          : Double; {m}            {Not Used}
    UpperDispCoeff   : Pointer; {m2/d}        {Daily Input Parameter}
    NotUsed2         : Pointer;               {Not Used}
    FracWater        : Double; {fraction}     {Calculated}
    BedVolume        : Double; {m3}           {Dynamic, Calculated}
    DynBedDepth      : Double; {m3}           {Dynamic, Calculated}
    VolumeLost       : Double; {m3}           {Calc.}
    PoreSqueeze      : Double; {m3}           {Calc.}
 End;


EAquatoxError= Exception;

CONST
    SecsPerDay  : Double = 86400.0;
    M2GDay  : Double = 480; {  cc --> m2, mg --> g, hr --> day  }
    G  : Double = 9.8062; {  gravitational constant  }
    Mi2Meters : Double  = 1.609E3; {  mi --> m  }
    MPH2MSec  : Double = 0.447; {  mph --> m/sec  }

    Tiny     : Double = 5.0e-19; {mach. accuracy = 1.0e-19 }
    VSmall   : Double = 1.0e-10;
    Small    : Double = 1.0e-6;

    KAnaerobic   : Double = 0.3; { (1/d)   {decomp reduction - check Sanders, Gunnison}
    OrgToC       : Double = 0.526;  {fraction of organic carbon - based on Winberg et al. 1971}
    Minimum_Stepsize : Double =1.0e-5   {-5};

    Eutrophication  = False;

{BELOW TYPE USED FOR TIMING PROFILE ANALYSIS, JSC}

Const NumTTimes = 100;
Type TTiming=Class
  Times: Array[1..NumTTimes] of Double;
  TimeStarts: Array[1..NumTTimes] of Double;
  Constructor Create;
  Procedure StartTime(Index: Integer);
  Procedure StopTime(Index: Integer);
end;

{Var Timer: TTiming; }

Type {Distributions/ Uncertainty types}

Reg_Dist_Type = (SingleVarDist,AllAnimals,AllPlants,AllStateVars,AnimalTox,
                 PlantTox,AllOrgToxs,AllPhyto,AllPeriMacro,AllFish,EmptyDist);

Registered_Distribution= Packed Record {not saved}
   RDIndex   : Integer;
   RDType    : Reg_Dist_Type;
   RDName    : String[45];
  End; {record}

var
    {DIRECTORIES THAT AQUATOX USES}
    Default_Dir,
    Program_Dir,
    Output_Dir,
    Studies_Dir : AnsiString;
    HelpFilePath: String;
    HelpFileURL: String;

    SegLog: AnsiString;
    WordInitialized : Boolean = False;
    WordApp             : Variant;

    BatchIsRunning, BatchErr: Boolean;
    BatchLog: TextFile;

    BODConvertWarning: Boolean;  // avoid repetitive BOD import loading

{   testlog: textfile;
    testopened: boolean = false; }

    GenScnInstalled:  Boolean;
    GenScnPath: AnsiString;
    SWATDir: AnsiString;

    {VARIABLES USED WHEN LOADING STUDIES}
    VersionNum                 : Double;  {The current version number}
{    VolumeLoaded               : Boolean; }

    {DISPLAY VARIABLES}
    TeaseInc: Integer;         {Used for updating wait dialog}
    TeaseScreen: Boolean;      {Is wait dialog visible?}

    OpenUncFiles  : Array of AnsiString;

    WizardIsRunning: Boolean;
    EditColor      : TColor;
    WriteLoadingsToTextLog: Boolean;

Type
   TUncertDraw = Class(BaseClass)
     Value: Double;
     RandomDraw: Double;
     IntervalNum: Longint;
     Constructor Init(Val,RD:Double;Int:LongInt);
   end;


{Various Utility Functions}

  Function LegalFileName(fName:AnsiString): AnsiString;  {returns a legal file name from AnsiString (removes illegal chars.)}
  Function MessageDlg2(St: AnsiString; ATyp: TMsgDlgType; AButtons: TMsgDlgButtons; HelpCtx: Longint): Word;
  Procedure DefaultControlInfo(Var C: Control_Opt_Rec);
  Function Has_Alt_Loadings(ns: AllVariables; Typ: T_SVType; Lyr: T_SVLayer): Boolean;
  Function RoundDec(I: Integer; J: Double):Double;
  Function AbbrAnsiString(InStr: AnsiString; DelimChar: AnsiChar):AnsiString;
  Function CleanFileName(InStr: AnsiString): AnsiString;
  Function GetDataName(InStr: AnsiString):AnsiString;
  Function JulianDate(Indate: TDateTime): LongInt;
  Function GetStateFromName( Name: AnsiString; Var S: StateVariables):Boolean;
  Function StateText(S : AllVariables; T:T_SVType; L:T_SVLayer) : AnsiString;
  Function OutputText(S : AllVariables; T:T_SVType; L:T_SVLayer; ST: AnsiString; IsPPB, IsToxVar: Boolean; BAFVar: Word) : AnsiString;
  Function AssocToxSV(T:T_SVType): AllVariables;
  Function AssocToxTyp(S: AllVariables): T_SVType;
  Function PrecText(T: T_SVType): AnsiString;
  Function GetID(S : AllVariables; T:T_SVType; L:T_SVLayer): SV_ID;
  Procedure ProcessDBFName(Var N: AnsiString; P: Pointer);
  Function AQTCopyFile(Src,Dst: AnsiString): Boolean;
  Procedure CleanDashes(Var Instr:AnsiString);

Var TSText: Boolean;
    GlobalTS: TStream;
    GlobalTextF: TextFile;
    GlobalLN, GlobalIndent: Integer;

    EPert, ECont, EPSave, ECSave, EPExp, ECExp, SuppressGUI: Boolean;  // command line version parameters

Function IndentString: ANSIString;

Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: Integer); overload;
Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: Byte); overload;
Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: Double); overload;
Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: Boolean); overload;
Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: ShortString; Size: Integer); overload;
Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: TDateTime); overload;
Procedure TSReadWrite_OpenObject(Read: Boolean; nm: ANSIString);
Procedure TSReadWrite_CloseObject(Read: Boolean);

Procedure TSWriteObjectHeader(nm: ANSIString);
Procedure TSWriteCloseObject;
Procedure TSWrite(nm: ANSIString; i: byte); overload;
Procedure TSWrite(nm: ANSIString; i: Integer); overload;
Procedure TSWrite(nm: ANSIString; i: Double); overload;
Procedure TSWrite(nm: ANSIString; i: Boolean); overload;
Procedure TSWrite(nm: ANSIString; i: ShortString; Size: Integer); overload;
Procedure TSWrite(nm: ANSIString; i: TDateTime); overload;

Procedure TSReadObjectHeader(nm: ANSIString);
Procedure TSReadCloseObject;
Procedure TSRead(nm: ANSIString; var i: byte); overload;
Procedure TSRead(nm: ANSIString; var i: Integer); overload;
Procedure TSRead(nm: ANSIString; var i: Double); overload;
Procedure TSRead(nm: ANSIString; var i: Boolean); overload;
Procedure TSRead(nm: ANSIString; var i: ShortString; Size: Integer); overload;
Procedure TSRead(nm: ANSIString; var i: TDateTime); overload;


Procedure TSReadWrite_BedRecord(Read: Boolean; var Rc:BedRecord; ReadVersionNum: Double);
Procedure TSReadWrite_Setup_Record(Read: Boolean; var Rc:Setup_Record; ReadVersionNum: Double);
Procedure TSReadWrite_EstSaltLoadingRecord(Read: Boolean; var Rc:EstSaltLoadingRec; ReadVersionNum: Double);
Procedure TSReadWrite_AnimalRecord(Read: Boolean; var Rc:ZooRecord; ReadVersionNum: Double);
Procedure TSReadWrite_SiteRecord(Read: Boolean; var Rc:SiteRecord; ReadVersionNum: Double);
Procedure TSReadWrite_ReminRecord(Read: Boolean; var Rc:ReminRecord; ReadVersionNum: Double);
Procedure TSReadWrite_ChemicalRecord(Read: Boolean; var Rc:ChemicalRecord; ReadVersionNum: Double);
Procedure TSReadWrite_PlantRecord(Read: Boolean; var Rc:PlantRecord; ReadVersionNum: Double);
Procedure TSReadWrite_Uncertainty_Setup_Record(Read: Boolean;  Rc:PUncertainty_Setup_Record; ReadVersionNum: Double);
Procedure TSReadWrite_Control_Opt_Rec(Read: Boolean; var Rc:Control_Opt_Rec; ReadVersionNum: Double);
Procedure TSReadWrite_TrophInt(TIName: RefShortString; Read: Boolean; Rc:PTrophIntArray; ReadVersionNum: Double);
Procedure TSReadWrite_SV_ID(Read: Boolean; var Rc:SV_ID; ReadVersionNum: Double);


{********************************************************************}
{*}                                                                {*}
{*}                        Implementation                          {*}
{*}                                                                {*}
{********************************************************************}

//  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
//  Dialogs,Main, StdCtrls, Grids, Menus, ExtCtrls, Clipbrd, Global, SLR6;

Uses Grids, Clipbrd, System.UITypes;


Procedure CleanDashes(Var Instr:AnsiString);
Begin
   While Pos('\\',Instr)>0 do
     Delete(Instr,Pos('\\',Instr),1);
End;


Function LegalFileName(fName:AnsiString): AnsiString;  {returns a legal file name from AnsiString (removes illegal chars.)}

const badChars : tSysCharSet = [':', '\', '/', '*', '?', '<', '>', '"'];
var i, j, lth : integer;

begin
lth := Length (fName);
SetLength (Result, lth);
j := 0;
for i := 1 to lth do
    begin
    if not (fName [i] in badChars)
    then begin
        inc (j); 
        Result [j] := fName [i]; 
        end; 
    end; 
SetLength (Result, j);
end;


Function MessageDlg2(St: AnsiString; ATyp: TMsgDlgType; AButtons: TMsgDlgButtons; HelpCtx: Longint): Word;
{Message DLG which does not show in batch mode so that batch runs do not get held up}
Begin
  if SuppressGUI then exit;

  If BatchIsRunning then
    Begin
      Writeln(BatchLog,St + ' [OK]');
      BatchErr := True;
      MessageDlg2 := mrOK;
      Exit;
    End;

  MessageDlg2 := MessageDlg(St,Atyp,AButtons,HelpCtx);
End;


Function AssocToxSV(T:T_SVType): AllVariables;
Begin
  Case T of
     FirstOrgTxTyp..LastOrgTxTyp: AssocToxSV := AllVariables(Ord(T)-2);
         else Raise EAQUATOXERROR.Create('Programming error, AssocToxSV Argument Out of Range');
  end; {case}
End;

Function AssocToxTyp(S: AllVariables): T_SVType;
Begin
  Case S of
     FirstOrgTox..LastOrgTox: AssocToxTyp := T_SVTYPE(Ord(S)+2);
         else Raise EAQUATOXERROR.Create('Programming error, AssocToxTyp Argument Out of Range');

  end; {case}
End;

Function GetID(S : AllVariables; T:T_SVType; L: T_SVLayer): SV_ID;
Begin
  GetID.Nstate:=S;  GetID.SVType:=T;  GetID.Layer := L;
End;

Function Has_Alt_Loadings(ns: AllVariables; Typ:T_SVType; Lyr: T_SVLayer): Boolean;
Begin
  Has_Alt_Loadings:=
      (Lyr = WaterCol) and
      ((ns in [Volume,FirstTox..LastTox,Phosphate,Oxygen,Ammonia,Nitrate,Salinity, 
              DissRefrDetr..LastDetr,Sand..Clay,FirstAnimal..LastFish]) and (Typ=StV)) or
       (ns in [Cohesives,NonCohesives,NonCohesives2]);
End;

Function  GetStateFromName(Name: AnsiString;Var S:StateVariables):Boolean;
Var Found: Boolean;
{Function finds the STATEVARIABLES value associated with a given name.}

begin
  Found:=False;
  S:=FirstState;
  If StateText(S,StV,WaterCol)=Name then Found:=True
  else repeat
         inc(S);
         If StateText(S,StV,WaterCol)=Name then Found:=True;
       until (S=LastState) or Found;
  GetStateFromName:=Found;
end;

Function StateText(S : AllVariables; T:T_SVType; L:T_SVLayer) : AnsiString;
{Returns the text name given a State Variable ID}
{Does not display buried sediment layers}

{StateNames that are associated with organic toxicant or Hg will not be
 displayed in the list of state variables in is version,
 thus they receive the 'UNDISPLAYED' Label}
begin
  StateText:='Undisplayed';
  If L>WaterCol then exit;

  If T=StV then
  case S of
   Volume        : StateText:='Water Volume';
   Temperature   : StateText:='Temperature';
   WindLoading   : StateText:='Wind Loading';
   Light         : StateText:='Light';
   pH            : StateText:='pH';
   Phosphate     : StateText:='Phosphate as P';
   Ammonia       : StateText:='Total Ammonia as N';
   Nitrate       : StateText:='Nitrate as N';
   Salinity      : StateText:='Salinity';
   Silica        : StateText:='Silica';
   Avail_Silica  : StateText:='Biogenic_Silica';
   COD           : StateText:='COD';
   TAM           : StateText:='TAM';
   Sulfide       : StateText:='Sulfide';
   Methane       : StateText:='Methane';
   POC_G1        : StateText:='POC_G1';
   POC_G2        : StateText:='POC_G2';
   POC_G3        : StateText:='POC_G3';
   PON_G1        : StateText:='PON_G1';
   PON_G2        : StateText:='PON_G2';
   PON_G3        : StateText:='PON_G3';
   POP_G1        : StateText:='POP_G1';
   POP_G2        : StateText:='POP_G2';
   POP_G3        : StateText:='POP_G3';
   CO2           : StateText:='Carbon dioxide';
   Oxygen        : StateText:='Oxygen';
   Sand           : StateText:='Sand';
   Silt          : StateText:='Silt';
   Clay          : StateText:='Clay';
   TSS           : StateText:='Tot. Susp. Solids';
   Cohesives     : StateText:='Cohesives <63';
   NonCohesives  : StateText:='Non-Cohesives 63-250';
   NonCohesives2 : StateText:='Non-Cohesives2 >250';
   SedmRefrDetr  : StateText:='Refrac. sed. detritus';
   SedmLabDetr   : StateText:='Labile sed. detritus';
   DissRefrDetr  : StateText:='Susp. and dissolved detritus';
   BuriedRefrDetr  : StateText:='BuriedRefrDetr';
   BuriedLabileDetr : StateText:='BuriedLabileDetr';

   Diatoms1      : StateText:='Diatoms1';
   Diatoms2      : StateText:='Diatoms2';
   Diatoms3      : StateText:='Diatoms3';
   Diatoms4      : StateText:='Diatoms4';
   Diatoms5      : StateText:='Diatoms5';
   Diatoms6      : StateText:='Diatoms6';
   Greens1       : StateText:='Greens1';
   Greens2       : StateText:='Greens2';
   Greens3       : StateText:='Greens3';
   Greens4       : StateText:='Greens4';
   Greens5       : StateText:='Greens5';
   Greens6       : StateText:='Greens6';
   BlGreens1     : StateText:='Cyanobacteria1';
   BlGreens2     : StateText:='Cyanobacteria2';
   BlGreens3     : StateText:='Cyanobacteria3';
   BlGreens4     : StateText:='Cyanobacteria4';
   BlGreens5     : StateText:='Cyanobacteria5';
   BlGreens6     : StateText:='Cyanobacteria6';
   OtherAlg1     : StateText:='OtherAlg1';
   OtherAlg2     : StateText:='OtherAlg2';
   Macrophytes1  : StateText:='Macrophyte1';
   Macrophytes2  : StateText:='Macrophyte2';
   Macrophytes3  : StateText:='Macrophyte3';
   Macrophytes4  : StateText:='Macrophyte4';
   Macrophytes5  : StateText:='Macrophyte5';
   Macrophytes6  : StateText:='Macrophyte6';

   DepFeeder1    : StateText:='DepFeeder1';
   DepFeeder2    : StateText:='DepFeeder2';
   DepFeeder3    : StateText:='DepFeeder3';

   SuspFeeder1   : StateText:='SuspFeeder1';
   SuspFeeder2   : StateText:='SuspFeeder2';
   SuspFeeder3   : StateText:='SuspFeeder3';
   SuspFeeder4   : StateText:='SuspFeeder4';
   SuspFeeder5   : StateText:='SuspFeeder5';
   SuspFeeder6   : StateText:='SuspFeeder6';
   SuspFeeder7   : StateText:='SuspFeeder7';
   SuspFeeder8   : StateText:='SuspFeeder8';
   SuspFeeder9   : StateText:='SuspFeeder9';

   SmallPI1     : StateText:='SmallPI1';
   SmallPI2     : StateText:='SmallPI2';

   PredInvt1     : StateText:='PredInvt1';
   PredInvt2     : StateText:='PredInvt2';
   PredInvt3     : StateText:='PredInvt3';
   PredInvt4     : StateText:='PredInvt4';

   Snail1        : StateText:='Snail1';
   Snail2        : StateText:='Snail2';

   Veliger1      : StateText:='Veliger1';
   Veliger2      : StateText:='Veliger2';
   Spat1         : StateText:='Spat1';
   Spat2         : StateText:='Spat2';
   Clams1        : StateText:='Clam1';
   Clams2        : StateText:='Clam2';
   Clams3        : StateText:='Clam3';
   Clams4        : StateText:='Clam4';

   SmForageFish1 : StateText:='SmForageFish1';
   LgForageFish1 : StateText:='LgForageFish1';
   SmForageFish2 : StateText:='SmForageFish2';
   LgForageFish2 : StateText:='LgForageFish2';
   SmBottomFish1 : StateText:='SmBottomFish1';
   LgBottomFish1 : StateText:='LgBottomFish1';
   SmBottomFish2 : StateText:='SmBottomFish2';
   LgBottomFish2 : StateText:='LgBottomFish2';
   SmGameFish1   : StateText:='SmGameFish1';
   SmGameFish2   : StateText:='SmGameFish2';
   SmGameFish3   : StateText:='SmGameFish3';
   SmGameFish4   : StateText:='SmGameFish4';
   LgGameFish1   : StateText:='LgGameFish1';
   LgGameFish2   : StateText:='LgGameFish2';
   LgGameFish3   : StateText:='LgGameFish3';
   LgGameFish4   : StateText:='LgGameFish4';
   Fish1         : StateText:='Multi.Age-Class Fish';
   FirstOrgTox..LastOrgTox: StateText:='Dissolved org. tox '+IntToStr(Ord(S)+1);
  end; {case statement}
end;  {Function STATETEXT}


Function PrecText(T: T_SVType): AnsiString;
Begin
  PrecText :='T'+IntToStr(Ord(T)-1);
End;


Function OutputText(S : AllVariables; T:T_SVType; L:T_SVLayer; ST:AnsiString; ISPPB,IsToxVar:Boolean; BAFVar: Word) : AnsiString;
{For output purposes, Returns the text name given an enumerated ALLVARIABLE value}
Var PreText,StateText : AnsiString;
    AO      : TAddtlOutput;

Begin
 OutputText:='Undisplayed';

 StateText:=ST;

 If StateText='' then
  case S of
   Volume        : StateText:='Water Vol';
   Temperature   : StateText:='Temp';
   WindLoading   : StateText:='Wind';
   Light         : StateText:='Light';
   pH            : StateText:='pH';
   Phosphate     : If L> WaterCol then StateText:='PO4'
                                  else StateText:='Tot. Sol. P';
   Ammonia       : If L> WaterCol then StateText:='Ammonia'
                                  else StateText:='NH3 & NH4+';
   Nitrate       : StateText:='NO3';
   CO2           : StateText:='CO2';
   Oxygen        : StateText:='Oxygen';
   Sand          : StateText:='Susp sand';
   Silt          : StateText:='Susp silt';
   Clay          : StateText:='Susp clay';
   TSS           : StateText:='TSS';
   SedmRefrDetr  : StateText:='R detr sed';
   SedmLabDetr   : StateText:='L detr sed';
   DissRefrDetr  : StateText:='R detr diss';
   DissLabDetr   : StateText:='L detr diss';
   SuspRefrDetr  : StateText:='R detr part';
   SuspLabDetr   : StateText:='L detr part';
   BuriedRefrDetr  : StateText:='BuryRDetr';
   BuriedLabileDetr: StateText:='BuryLDetr';
   Diatoms1      : StateText:='Diatoms1';
   Diatoms2      : StateText:='Diatoms2';
   Greens1       : StateText:='Greens1';
   Greens2       : StateText:='Greens2';
   BlGreens1     : StateText:='Cyanobacteria1';
   BlGreens2     : StateText:='Cyanobacteria2';
   OtherAlg1     : StateText:='OtherAlg1';
   OtherAlg2     : StateText:='OtherAlg2';
   Macrophytes1  : StateText:='Macrophyte1';
   Macrophytes2  : StateText:='Macrophyte2';

   DepFeeder1    : StateText:='DepositFeeder1';
   DepFeeder2    : StateText:='DepositFeeder2';
   DepFeeder3    : StateText:='DepositFeeder3';

   SuspFeeder1   : StateText:='SuspFeeder1';
   SuspFeeder2   : StateText:='SuspFeeder2';
   SuspFeeder3   : StateText:='SuspFeeder3';
   SuspFeeder4   : StateText:='SuspFeeder4';
   SuspFeeder5   : StateText:='SuspFeeder5';
   SuspFeeder6   : StateText:='SuspFeeder6';
   SuspFeeder7   : StateText:='SuspFeeder7';
   SuspFeeder8   : StateText:='SuspFeeder8';
   SuspFeeder9   : StateText:='SuspFeeder9';

   SmallPI1     : StateText:='SmallPI1';
   SmallPI2     : StateText:='SmallPI2';

   PredInvt1     : StateText:='PredInvt1';
   PredInvt2     : StateText:='PredInvt2';
   PredInvt3     : StateText:='PredInvt3';
   PredInvt4     : StateText:='PredInvt4';
   Snail1        : StateText:='Snail1';
   Snail2        : StateText:='Snail2';
   Veliger1      : StateText:='Veliger1';
   Veliger2      : StateText:='Veliger2';
   Spat1         : StateText:='Spat1';
   Spat2         : StateText:='Spat2';
   Clams1        : StateText:='Clam1';
   Clams2        : StateText:='Clam2';
   Clams3        : StateText:='Clam3';
   Clams4        : StateText:='Clam4';

   SmForageFish1 : StateText:='SmForageFish1';
   LgForageFish1 : StateText:='LgForageFish1';
   SmForageFish2 : StateText:='SmForageFish2';
   LgForageFish2 : StateText:='LgForageFish2';
   SmBottomFish1 : StateText:='SmBottomFish1';
   LgBottomFish1 : StateText:='LgBottomFish1';
   SmBottomFish2 : StateText:='SmBottomFish2';
   LgBottomFish2 : StateText:='LgBottomFish2';
   SmGameFish1   : StateText:='SmGameFish1';
   SmGameFish2   : StateText:='SmGameFish2';
   SmGameFish3   : StateText:='SmGameFish3';
   SmGameFish4   : StateText:='SmGameFish4';
   LgGameFish1   : StateText:='LgGameFish1';
   LgGameFish2   : StateText:='LgGameFish2';
   LgGameFish3   : StateText:='LgGameFish3';
   LgGameFish4   : StateText:='LgGameFish4';
   Fish1         : StateText:='Fish 0';
   Fish2         : StateText:='Fish I';
   Fish3         : StateText:='Fish II';
   Fish4         : StateText:='Fish III';
   Fish5         : StateText:='Fish IV';
   Fish6         : StateText:='Fish V';
   Fish7         : StateText:='Fish VI';
   Fish8         : StateText:='Fish VII';
   Fish9         : StateText:='Fish VIII';
   Fish10        : StateText:='Fish IX';
   Fish11        : StateText:='Fish X';
   Fish12        : StateText:='Fish XI';
   Fish13        : StateText:='Fish XII';
   Fish14        : StateText:='Fish XIII';
   Fish15        : StateText:='Fish XIV';
   Salinity      : StateText:='Salinity';
   Diatoms3      : StateText:='Diatoms3';
   Diatoms4      : StateText:='Diatoms4';
   Diatoms5      : StateText:='Diatoms5';
   Diatoms6      : StateText:='Diatoms6';
   Greens3       : StateText:='Greens3';
   Greens4       : StateText:='Greens4';
   Greens5       : StateText:='Greens5';
   Greens6       : StateText:='Greens6';
   BlGreens3     : StateText:='Cyanobacteria3';
   BlGreens4     : StateText:='Cyanobacteria4';
   BlGreens5     : StateText:='Cyanobacteria5';
   BlGreens6     : StateText:='Cyanobacteria6';
   Macrophytes3  : StateText:='Macrophyte3';
   Macrophytes4  : StateText:='Macrophyte4';
   Macrophytes5  : StateText:='Macrophyte5';
   Macrophytes6  : StateText:='Macrophyte6';
   FirstOrgTox..LastOrgTox
                 : StateText:='T'+IntToStr(Ord(S)+1)+' H2O';
   PoreWater     : StateText :='Pore Water';
   ReDOMPore     : StateText :='R DOM PoreW';
   LaDOMPore     : StateText :='L DOM PoreW';
   Cohesives     : StateText :='Cohesives <63';
   NonCohesives  : StateText :='Non-Cohesives 63-250';
   NonCohesives2 : StateText :='Non-Cohesives >250';
   Silica        : StateText:='Silica';
   Avail_Silica  : StateText:='Biogenic_Silica';
   COD           : StateText:='COD';
   TAM           : StateText:='TAM';
   Sulfide       : StateText:='Sulfide';
   Methane       : StateText:='Methane';
   POC_G1        : StateText:='POC_G1';
   POC_G2        : StateText:='POC_G2';
   POC_G3        : StateText:='POC_G3';
   PON_G1        : StateText:='PON_G1';
   PON_G2        : StateText:='PON_G2';
   PON_G3        : StateText:='PON_G3';
   POP_G1        : StateText:='POP_G1';
   POP_G2        : StateText:='POP_G2';
   POP_G3        : StateText:='POP_G3';
 end; {case}

 If L>WaterCol then
   Begin
     If T=StV then StateText :=  'L' + IntToStr(ORD(L)) +' '+ StateText
              else StateText :=  'L' + IntToStr(ORD(L)) +' '+ PrecText(T) +  StateText;

   End;

 If StateText<>'' then OutputText:=StateText;

 If T in [FirstToxTyp..LastToxTyp]  then
   Begin
     PreText := PrecText(T);

     If Not IsToxVar then
       Begin
         If (L=WaterCol) then OutputText:=PreText+StateText;
       End; {Not ToxVar}
   End; {IF TOX}

   If IsPPB then
      if L>WaterCol then OutputText:='ppb'+Result
                    else OutputText:=Result+'(ppb)';

   If T=OtherOutput then
     Begin
       AO := TAddtlOutput(S);
       PreText := '';
       if L>WaterCol then PreText := 'L' + IntToStr(ORD(L));
       Case AO of
         InflowWater      : OutputText:='InflowH2O';
         DischWater       : OutputText:='DischH2O';
         Secchi           : OutputText:='Secchi d';
         Chla             : OutputText:='Phyto. Chlorophyll';
         Peri_Chla        : OutputText:='Peri. Chlorophyll';
         Peri_Biomass     : OutputText:='Peri. Biomass';
         Phyto_Biomass    : OutputText:='Phyto. Biomass';
         Moss_Chla        : OutputText:='Moss Chla';
         MultiFishConc    : OutputText:='Mult-Fish Biomass';
{        H2OTox1Disch     : OutputText:='Tox1 Casc. Inflow'; }
         BedDepth         : OutputText:=PreText+'Bed Depth';
         BedDnsty         : OutputText:=PreText+'Density';
         FracWatr         : OutputText:=PreText+'Poros';
         BedVlm           : OutputText:=PreText+'Volume';
         DeltaBedHeight   : OutputText:='Chg. Bed Height';
         SegThick         : OutputText:='Thickness';
         TidalAmp         : OutputText:='Tidal Height';
         RetTime          : OutputText:='Retention Time';
         VelocityOut      : OutputText:='Run Velocity';
         DynZMeanOut      : OutputText:='ZMean (Dynamic)';
         VelRiff          : OutputText:='Riffle Velocity';
         VelPool          : OutputText:='Pool Velocity';
         Tau              : OutputText:='Tau: Bed Shear';
         TN               : OutputText:='TN';
         TP               : OutputText:='TP';
         BODOut           : OutputText:='CBOD5';
         NH3UnIon         : OutputText:='Un-ionized NH3';
         PhytoResTime     : OutputText:='Phyto. Res. Time';
         MinNH3UnIon      : OutputText:='Min. Un-ionized NH3';
         MaxNH3UnIon      : OutputText:='Max. Un-ionized NH3';
         MinOxygen        : OutputText:='Min. Oxygen';
         MaxOxygen        : OutputText:='Max. Oxygen';
         O2Duration       : OutputText:='Oxygen Sub Thresh.';
         SteinAnim        : OutputText:='Steinhaus Animal';
         SteinPlant       : OutputText:='Steinhaus Plant';
         SteinInvert      : OutputText:='Steinhaus Invert';
         SteinAll         : OutputText:='Steinhaus All Org.';
         SOD_OUT          : OutputText:='SOD';
         InorgDep         : OutputText:='Inorg. Deposition';
         TSP_Diag         : OutputText:='P Diag. Flux';
         NO3_Diag         : OutputText:='Nitrate Diag. Flux';
         NH3_Diag         : OutputText:='Ammonia Diag. Flux';
         POP_Dep          : OutputText:='POP Deposition';
         PON_Dep          : OutputText:='PON Deposition';
         POC_Dep          : OutputText:='POC Deposition';
         CaCO3p           : OutputText:='CaCO3 Precip.';
         SaltInflow       : OutputText:='Est.Salt Inflow';
         FreshInflow      : OutputText:='Est.Fresh Inflow';
         EstEntr          : OutputText:='Est.Entrainment';
         EstUpperOut      : OutputText:='Est.Upper Outflow';
         InorgSed         : OutputText:='Inorg. Sed.';
         TSS60Day         : OutputText:='60-day avg. Inorg. Sed.';
         PctEmbedded      : OutputText:='Pct. Embeddedness';
         MeanVol          : OutputText:='Mean Volume (annual)';
         BenthicChla      : OutputText:='Benthic Chlorophyll';
         FracLitOut       : OutputText:='Frac. Littoral';
         O2FluxOut        : OutputText:='Oxygen Range';
         PctEPT           : OutputText:='Pct EPT';
         PctEphemeroptera : OutputText:='Pct Ephemeropt.';
         PctTrichoptera   : OutputText:='Pct Trichoptera';
         PctPlecoptera    : OutputText:='Pct Plecoptera';
         PctEunotia       : OutputText:='Pct Eunotia';
         PctChiro         : OutputText:='Pct Chironomid';
         GPP_Out          : OutputText:='GPP';
		     NPP_Out          : OutputText:='NPP';
         CommResp_Out     : OutputText:='Community Resp.';
         PtoR_Out         : OutputText:='P/R';
         BtoP_Out         : OutputText:='Turnover (B/P)';
         PctAmphipods     : OutputText:='Pct Amphipods';
         PFluxDiagenesis  : OutputText:='P Diag. Flux (cum.)';
         PctGastropods    : OutputText:='Pct Gastropods';
         PctBivalves      : OutputText:='Pct Bivalves';
         PctOligochaete   : OutputText:='Pct Oligochaete';
         PctDiatomsPeri   : OutputText:='Pct Diatoms Peri.';
         PctBlGrPeri      : OutputText:='Pct Cyanobacteria Peri.';
         PctGreensPeri    : OutputText:='Pct Greens  Peri.';
         PctBlGrPhyto     : OutputText:='Pct Cyanobacteria Phyto.';
         PctDiatomsPhyto  : OutputText:='Pct Diatoms Phyto.';
         PctGreensPhyto   : OutputText:='Pct Greens Phyto.';
         PctOtherPhyto    : OutputText:='Pct Other Phyto.';
         BInvt_Biomass    : OutputText:='Benthic Invt Biomass';
         PlnkInvt_Biomass  : OutputText:='Plankton Invt Biomass';
         NekInvt_Biomass  : OutputText:='Nekton Invt Biomass';
         Fish_Biomass     : OutputText:='Fish Biomass';
         Oyster_Biomass   : OutputText:='Oyster Biomass';
         Extinct_out      : OutputText:='Light Extinct';
         Extinct_Peri     : OutputText:='Light Extinct Peri';
         InorgExt         : OutputText:='Extinct Inorganics';
         OrgExt           : OutputText:='Extinct Organics';
         PhytoExt         : OutputText:='Extinct Phyto.';


       End; {Case}
     End; {If OtherOutput}

   If T=Ntrack then PreText := 'N';
   If T=Ptrack then PreText := 'P';

   If T=NIntrnl then OutputText:=ST + ' N Internal';
   If T=PIntrnl then OutputText:=ST + ' P Internal';

   If IsToxVar then
       Begin
         AO := TAddtlOutput(S);
         Case AO of
           NonDissocOut : OutputText:=PreText+' Nondissoc.';
           THalfLife    : OutputText:=PreText+' 1/2-life';
           DT50Water    : OutputText:=PreText+' DT50 Water';
           DT95Water    : OutputText:=PreText+' DT95 Water';
           Dt50Sed      : OutputText:=PreText+' DT50 Sediment';
           Dt95Sed      : OutputText:=PreText+' DT95 Sediment';
           TOrgSedPPB   : OutputText:=PreText+' Sed. OM';
           ToxLoading   : OutputText:=PreText+' Loading';
           TotalTox     : OutputText:=PreText+' Total tox';
           TotalToxMass : OutputText:=PreText+' Mass';
           TotTLoss     : OutputText:=PreText+' Tot Loss';
           TotalTWash   : OutputText:=PreText+' Tot Wash';
           TWashH2o     : OutputText:=PreText+' WashH2O';
           TWashAnim    : OutputText:=PreText+' WashAnim';
           TWashDetr    : OutputText:=PreText+' WashDetr';
           TWashPlant   : OutputText:=PreText+' WashPlnt';
           TWashSed     : OutputText:=PreText+' WashSedm';
           THydrol      : OutputText:=PreText+' Hydrol';
           TPhotol      : OutputText:=PreText+' Photol';
           TVolatil     : OutputText:=PreText+' Volatil';
           TMicrobMet   : OutputText:=PreText+' MicrobMet';
           TBioTrans    : OutputText:=PreText+' BioTrans';
           TEmergeI     : OutputText:=PreText+' EmergeI';
           TLossandMass : OutputText:=PreText+' Loss+Mass';
           TBuryOOS     : OutputText:=PreText+' DeepBurial';
           TTotOOSLoad  : OutputText:=PreText+' Tot Load';
           TLoadH2O     : OutputText:=PreText+' H2O Load';
           TLoadSed     : OutputText:=PreText+' Sed Load';
           TLoadDetr    : OutputText:=PreText+' Detr Load';
           TLoadBiota   : OutputText:=PreText+' Biota Load';
           TMBTest      : OutputText:=PreText+' MBTest';
           TSink        : OutputText:=PreText+' Net Sink';
           TEntrain     : OutputText:=PreText+' Net Entrain';
           TTurbdiff    : OutputText:=PreText+' Net TurbDiff';
           TMigrate     : OutputText:=PreText+' Net Migrate';
           TNetLayer    : OutputText:=PreText+' Net LayerExch';
           TFishing     : OutputText:=PreText+' Fishing Loss';
           TDeltaThick  : OutputText:=PreText+' Delta Thick';
           BirdConc     : OutputText:=PreText+' Birds etc.';
           MultiFishPPB     : OutputText:=PreText+' Mult-Fish';
           TotNMass         : OutputText:=PreText+' Tot. Mass';
           BoundaryCond : OutputText:=PreText+' Boundary Cond.';   {PER TIME STEP}
           TotNLoss: OutputText:=PreText+' Tot. Loss';
           TotalNWash: OutputText:=PreText+' Tot. Washout';
           NWashH2o: OutputText:=PreText+' Wash. Dissolved';
           NWashAnim: OutputText:=PreText+' Wash. Animals';
           NWashDetr: OutputText:=PreText+' Wash. Detritus';
           NWashPlant: OutputText:=PreText+' Wash. Plants';
           NEmergeI: OutputText:=PreText+' Loss EmergeI';
           NDenitr: OutputText:=PreText+' Loss Denitrif.';
           NBurial: OutputText:=PreText+' Burial';
           NFishing: OutputText:=PreText+' Loss Fishing';
           NTotLoad: OutputText:=PreText+' Tot. Load';
           NLoadDissH2O: OutputText:=PreText+' Load, Dissolved';
           NLoadDetr: OutputText:=PreText+' Load as Detritus';
           NLoadBiota: OutputText:=PreText+' Load as Biota';
           NPWMacro: OutputText:=PreText+' Root Uptake';
           NFixation: OutputText:=PreText+' Fixation';
           NMBTest: OutputText:=PreText+' MB Test';
           NExposure: OutputText:=PreText+' Exposure';
           NLSink: OutputText:=PreText+' Net Layer Sink';
           NLTDiff: OutputText:=PreText+' Net TurbDiff';
           NLMigr: OutputText:=PreText+' Net Layer Migr.';
           NLayerNet: OutputText:=PreText+' Total Net Layer';
           NDissWater: OutputText:=PreText+' Mass Dissolved';
           NDetr: OutputText:=PreText+' Mass Susp. Detritus';
           NAnimals: OutputText:=PreText+' Mass Animals';
           NPlants: OutputText:=PreText+' Mass Plants';
           NSediment: OutputText:=PreText+' Mass Bottom Sed.';
           NSorbCaCO3: OutputText:=PreText+' Sorb CaCO3';
         End; {Case}
       End; {Else}

   Case BAFVar of
     1 : OutputText := 'BAF Lipid '+Result;
     2 : OutputText := 'BAF wet '+Result;
     3 : OutputText := 'K1 '+Result;
     4 : OutputText := 'K2 '+Result;
     5 : OutputText := 'BCF '+Result;
     6 : OutputText := 'Troph Lvl '+Result;
     7 : OutputText := 'N to Org '+Result;
     8 : OutputText := 'P to Org '+Result;
   End; {Case}
End;  {Function OutputText}


Procedure DefaultControlInfo(Var C: Control_Opt_Rec);
{*************************************}
{ Reset the Control Setup Record that }
{ Is Passed to this procedure to its  }
{ default status.                     }
{ coded by JSC                        }
{*************************************}

  Procedure DefaultSubControlInfo(Var S: Control_Opt_SubRec; Res:Boolean);
  Begin
   S.OmitInflow:=Res; S.OmitPS:=Res;     S.OmitDP:=Res;
   S.OmitNPS:=Res;    S.SetMult:=Res;    S.ZeroInitCond:=Res;
   S.OmitTox:=Res;    S.OmitBuried:=Res;
  End;

Begin
  DefaultSubControlInfo(C.Tox,True);
  DefaultSubControlInfo(C.Nutrient,False);
  DefaultSubControlInfo(C.Sediment,False);
  DefaultSubControlInfo(C.Detritus,False);
End;



{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
{                                                                         }
{      NUMERICAL AND AnsiString MANIPULATION UTILITIES FROM HERE DOWN         }
{                                                                         }
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}



Function RoundDec(I: Integer; J: double):double;
{Rounds a Function to I decimals}

Var Mult: Longint;
    Loop: Integer;
Begin
    Mult:=1;
    if I>0 then For Loop:=1 to I do Mult:=Mult*10;
    If J*Mult < 1E9
       then RoundDec:=Round(J*Mult)/Mult
       Else RoundDec:=Int(J);
End;

Function JulianDate(Indate: TDateTime): LongInt;
{Given a delphi TDATETIME, Returns the Julian Date (# of days passed in the year)}

var inday,inmonth,inyear: Word;
    first_day_of_year: TDateTime;

Begin
   DecodeDate(Indate,inyear,inmonth,inday);
   First_day_of_year:=EncodeDate(Inyear,1,1);
   JulianDate:=Trunc(InDate - First_day_of_year)+1;
End;


Function GetDataName(InStr: AnsiString):AnsiString;
{Abridges a AnsiString to what appears inside the []}
Var
  indx,startindx: integer;
  Finished: Boolean;
  started: Boolean;
  OutStr: String[255];

begin
  Finished:=false;
  started:=false;
  indx:=0;
  startindx:=1;
  Repeat      {Add Chars Between Brackets to Outstr one Chr at a time.}
     inc(indx);
     If started then OutStr[startindx]:=InStr[indx];
     if started then inc(startindx);
     If Instr[indx]='[' then started:=true;
     if indx=Length(InStr) then Finished:=true
                        else if InStr[indx+1]=']' then Finished:=true;
  until Finished;

  OutStr[0]:=Ansichar(chr(startindx-1));
  GetDataName:=OutStr;
End; {GetDataName}


Function CleanFileName(InStr: AnsiString): AnsiString;  {Remove double slashes from file names}
Var i: Integer;
    wasslash: Boolean;
Begin
  Result := '';
  WasSlash := False;
  For i := 1 to Length(Instr) do
    Begin
      If (InStr[i] = '\') and WasSlash then Continue;
      Result := Result + InStr[i];
      WasSlash := (InStr[i] = '\');
    End;
End;


    Function AbbrAnsiString(InStr: AnsiString; DelimChar: AnsiChar):AnsiString; // J.Guzman, modified by JSC
    {Abridges a ANSIString to what appears before the DELIMCHAR }
    Var jj : integer;

    Begin
      jj := Pos(DelimChar,InStr);
      if jj = 0 then AbbrANSIString := InStr
                else AbbrANSIString := Copy(InStr,1,jj-1);
    End; {AbbrANSIString}



Procedure ProcessDBFName(Var N: AnsiString; P: Pointer);
{ This procedure takes a DBF name and makes it legal.
  Illegal characters are killed, the name is limited to 10 characters, the name
  is checked against P, a pointer to a TStringList with other names.  It is
  modified if it already exists within the list }
Var Loop, Instances: Integer;
    Duplicates: Boolean;
    TS         : TStrings;
Begin
  For Loop:=1 to Length(N) do
    If N[Loop] in [' ','/','(',')','\','-','&',',',':','.']
      Then N[Loop] := '_';

  N := Uppercase(N);
  If Length(N)>10 then SetLength(N,10);

  Instances := 0;
  Repeat
    Duplicates := False;

    TS := TStrings(P^);

    For Loop:=1 to TS.Count-1 do
      If Pos('"'+N+'"',TS.Strings[Loop])>0
        Then Begin
               Duplicates := True;
               Inc(Instances);
               N[Length(N)]:=Ansichar(Chr((Instances Mod 10) + 48));
               If (Instances>9) then N[Length(N)-1] := Ansichar(Chr((Instances Div 10) + 48));
             End;
  Until Not Duplicates
End;


{BELOW CODE USED FOR TIMING PROFILE ANALYSIS, JSC}

Constructor TTiming.Create;
Var Loop: Integer;
Begin
  For Loop:=1 to 10 do
    begin
       Times[Loop]:=0;
       TimeStarts[Loop]:=0;
    end;
end;

Procedure TTiming.StartTime(Index: Integer);
Begin
     TimeStarts[Index]:=GetTickCount;
End;

Procedure TTiming.StopTime(Index: Integer);
Begin
     Times[Index]:=Times[Index]+GetTickCount-TimeStarts[Index];
End;

Function AQTCopyFile(Src,Dst: AnsiString): Boolean;
{Copy a file from the source to the destination paths indicated,
 Copied out of Delphi Help under BlockRead}

Var Source,Dest: File;
    NumRead,NumWritten: Integer;
    Buf: array[1..2048] of Char;

Begin
  AQTCopyFile:=True;
     Try
         AssignFile(Source,Src);
         AssignFile(Dest,Dst);
         Reset(Source,1);
         Rewrite(Dest,1);
         Repeat
           Blockread(Source,Buf,Sizeof(Buf),NumRead);
           Blockwrite(Dest,Buf,NumRead,NumWritten);
         Until (NumRead=0) or (NumWritten<>NumRead);
         System.CloseFile(Source);
         System.CloseFile(Dest);
      Except
         MessageDlg('File Copy Error:  '+src+'  to  '+dst,mterror,[mbOK],0);
         AQTCopyFile:=False;
      end; {try}
End;

Constructor TUncertDraw.Init(Val,RD:Double;Int:LongInt);
Begin
  Value:=Val;
  IntervalNum:=Int;
  RandomDraw:=Rd;
End;

   Function IndentString: ANSIString;
   Var i: Integer;
   Begin
     Result := '';
     for i:= 0 to GlobalIndent-1 do
       Result := Result + ' ';
   End;

   Function CheckName(Nm: ANSIString):ANSIString;
   Var NameStr, InStr: ANSIString;
       NSLen: Integer;

   Begin
     Inc(GlobalLN);
     Readln(GlobalTextF,InStr);
     NameStr := AbbrANSIString(InStr,':');
     NSLen := Length(NameStr);
     NameStr := Trim(NameStr);
     If NameStr <> '"'+Nm+'"' then Raise EAQUATOXError.Create('Text Read Name Mismatch, Line '+IntToStr(GlobalLN)+
         ' Expecting Variable "'+Nm+'"; read variable '+NameStr);

     If NSLen >= Length(InStr)
       then Raise EAQUATOXError.Create('No ":" or blank after ":", Reading Variable "'+Nm+'"  Line '+IntToStr(GlobalLN));

     Delete(InStr,1,NSLen+2);
     Result := InStr;
   End;

   Procedure TSWrite(nm: ANSIString; i: byte); overload;
   Begin
     If TSText
       then Writeln(GlobalTextF,IndentString+'"'+nm+'": ',i)
       else GlobalTS.Write(i,Sizeof(i));
   End;

   Procedure TSWrite(nm: ANSIString;i: Integer); overload;
   Begin
     If TSText
       then Writeln(GlobalTextF,IndentString+'"'+nm+'": ',i)
       else GlobalTS.Write(i,Sizeof(i));

   End;

   Procedure TSWrite(nm: ANSIString;i: Double); overload;
   Begin
     If TSText
       then Writeln(GlobalTextF,IndentString+'"'+nm+'": ',i)
       else GlobalTS.Write(i,Sizeof(i));
   End;

   Procedure TSWrite(nm: ANSIString;i: TDateTime); overload;
   Begin
     If TSText
       then Writeln(GlobalTextF,IndentString+'"'+nm+'": ',Double(i))
       else GlobalTS.Write(i,Sizeof(i));
   End;


   Procedure TSWrite(nm: ANSIString;i: Boolean); overload;
   Begin
     If TSText
       then Writeln(GlobalTextF,IndentString+'"'+nm+'": ',i)
       else GlobalTS.Write(i,Sizeof(i));
   End;

   Procedure TSWrite(nm: ANSIString;i: ShortString; Size: Integer); overload;

    function CleanAnsi(s:shortstring):Ansistring;
    var i,j:Integer;
    begin
       SetLength(result,Length(s));
       j:=0;
       for i:=1 to Length(s) do
         if (s[i] >=#32) and (S[i] <= #127) then
          begin
           inc(j);
           result[j]:=s[i];
          end;
       SetLength(result,j);
    end;


   Begin
     If TSText
       then Begin
              Writeln(GlobalTextF,IndentString+'"'+nm+'": "',CleanAnsi(i),'"')
            End
       else
         Begin
            If Size>0 then
              GlobalTS.Write(i,Size);
         End;
   End;

   Procedure TSRead(nm: ANSIString;Var i: byte); overload;
   Begin
     If TSText
       then Try
              i := StrToInt(CheckName(nm));
            Except
              MessageDlg(Exception(ExceptObject).Message,mterror,[mbOK],0);
              Raise EAQUATOXError.Create('Byte Conversion Error, Line '+IntToStr(GlobalLN));
            End
       else GlobalTS.Read(i,Sizeof(i));
   End;


   Procedure TSRead(nm: ANSIString;Var i: Integer); overload;
   Begin
     If TSText
       then Try
              i := StrToInt(CheckName(nm));
            Except
              MessageDlg(Exception(ExceptObject).Message,mterror,[mbOK],0);
              Raise EAQUATOXError.Create('Integer Conversion Error, Line '+IntToStr(GlobalLN));
            End
       else GlobalTS.Read(i,Sizeof(i));
   End;

   Procedure TSRead(nm: ANSIString;Var i: Double); overload;
   Begin
     If TSText
       then Try
              i := StrToFloat(CheckName(nm));
            Except
              MessageDlg(Exception(ExceptObject).Message,mterror,[mbOK],0);
              Raise EAQUATOXError.Create('Double Conversion Error, Line '+IntToStr(GlobalLN));
            End
       else GlobalTS.Read(i,Sizeof(i));
   End;

   Procedure TSRead(nm: ANSIString;Var i: TDateTime); overload;
   Begin
     If TSText
       then Try
              i := StrToFloat(CheckName(nm));
            Except
              MessageDlg(Exception(ExceptObject).Message,mterror,[mbOK],0);
              Raise EAQUATOXError.Create('TDateTime Conversion Error, Line '+IntToStr(GlobalLN));
            End
       else GlobalTS.Read(i,Sizeof(i));
   End;


   Procedure TSRead(nm: ANSIString;Var i: Boolean); overload;
   Begin
     If TSText
       then Try
              i := Pos('TRUE',Uppercase(CheckName(nm)))>0;
            Except
              MessageDlg(Exception(ExceptObject).Message,mterror,[mbOK],0);
              Raise EAQUATOXError.Create('Boolean Conversion Error, Line '+IntToStr(GlobalLN));
            End
       else GlobalTS.Read(i,Sizeof(i));
   End;


   Procedure TSRead(nm: ANSIString; var i: ShortString; Size: Integer); overload;
   Var ASt: ANSIString;
   Begin
     If TSText
       then Begin
              ast := CheckName(nm);
              Delete(ast,1,1);           // trim " characters
              Delete(ast,Length(ast),1);
              i := Ast;
            End
       else Begin
              GlobalTS.Read(i,Size);
            End;
   End;


Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: Byte);
Begin
  if Read then TSRead(Nm,i)
          else TSWrite(NM,i);
End;

   Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: Integer);
Begin
  if Read then TSRead(Nm,i)
          else TSWrite(NM,i);
End;
Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: Double);
Begin
  if Read then TSRead(Nm,i)
          else TSWrite(NM,i);
End;
Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: Boolean);
Begin
  if Read then TSRead(Nm,i)
          else TSWrite(NM,i);
End;

Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: ShortString; Size: Integer);
Begin
  if Read then TSRead(Nm,i,Size)
          else TSWrite(NM,i,Size);
End;

Procedure TSReadWrite(Read: Boolean; nm: ANSIString; var i: TDateTime);
Begin
  if Read then TSRead(Nm,i)
          else TSWrite(NM,i);
End;

Procedure TSWriteObjectHeader(nm: ANSIString);
Begin
  if Not TSText then Exit;
  Writeln(GlobalTextF,IndentString+'"'+nm+'": {');
  Inc(GlobalIndent);
End;

Procedure TSWriteCloseObject;
Begin
  if Not TSText then Exit;
  Writeln(GlobalTextF,IndentString+'}');
  Dec(GlobalIndent);
End;

Procedure TSReadObjectHeader(nm: ANSIString);
Begin
  if Not TSText then Exit;
  CheckName(Nm);
End;

Procedure TSReadCloseObject;
Var Nm: ANSIString;
Begin
  if Not TSText then Exit;
  Inc(GlobalLN);
  Readln(GlobalTextF,Nm);
  Nm := Trim(Nm);
  if Nm[1]<>'}' then Raise EAQUATOXError.Create('Expecting "}" to Close Object on Line '+IntToStr(GlobalLN));

End;

Procedure TSReadWrite_OpenObject(Read: Boolean; nm: ANSIString);
Begin
  if not TSText then exit;
  if Read then TSReadObjectHeader(nm)
          else TSWriteObjectHeader(nm);

End;

Procedure TSReadWrite_CloseObject(Read: Boolean);
Begin
  if not TSText then exit;
  if Read then TSReadCloseObject
          else TSWriteCloseObject;
End;


{------------------------------------------------------------------------------}

Procedure TSReadWrite_Setup_Record(Read: Boolean; var Rc:Setup_Record; ReadVersionNum: Double);
Begin
  TSReadWrite_OpenObject(Read,'SetupRecord');

  TSReadWrite(Read,'FirstDay',Rc.FirstDay);
  TSReadWrite(Read,'FirstDay',RC.FirstDay);
  TSReadWrite(Read,'LastDay',RC.LastDay);
  TSReadWrite(Read,'StoreStepSize',RC.StoreStepSize);
  TSReadWrite(Read,'MinStepSize',RC.MinStepSize);
  TSReadWrite(Read,'RelativeError',RC.RelativeError);
  TSReadWrite(Read,'SaveBRates',RC.SaveBRates);
  TSReadWrite(Read,'AlwaysWriteHypo',RC.AlwaysWriteHypo);
  TSReadWrite(Read,'ShowIntegration',RC.ShowIntegration);
  TSReadWrite(Read,'UseComplexedInBAF',RC.UseComplexedInBAF);
  TSReadWrite(Read,'DisableLipidCalc',RC.DisableLipidCalc);
  TSReadWrite(Read,'KeepDissToxConst',RC.KeepDissToxConst);
  TSReadWrite(Read,'AverageOutput',RC.AverageOutput);
  TSReadWrite(Read,'UseExternalConcs',RC.UseExternalConcs);
  TSReadWrite(Read,'StepSizeInDays',RC.StepSizeInDays);
  TSReadWrite(Read,'ModelTSDays',RC.ModelTSDays);
  TSReadWrite(Read,'Spinup_Mode',RC.Spinup_Mode);
  TSReadWrite(Read,'NFix_UseRatio',RC.NFix_UseRatio);
  TSReadWrite(Read,'NtoPRatio',RC.NtoPRatio);
  TSReadWrite(Read,'Spin_Nutrients',RC.Spin_Nutrients);
  TSReadWrite(Read,'FixStepSize',RC.FixStepSize);
  TSReadWrite(Read,'UseFixStepSize',RC.UseFixStepSize);
  TSReadWrite(Read,'Internal_Nutrients',RC.Internal_Nutrients);
  TSReadWrite(Read,'T1IsAggregate',RC.T1IsAggregate);
  TSReadWrite(Read,'AmmoniaIsDriving',RC.AmmoniaIsDriving);
  TSReadWrite(Read,'TSedDetrIsDriving',RC.TSedDetrIsDriving);

  TSReadWrite_CloseObject(Read);
end;


Procedure TSReadWrite_ReminRecord(Read: Boolean; var Rc:ReminRecord; ReadVersionNum: Double);
Begin
  if not TSText then
    Begin
      If Read then GlobalTS.Read(RC,Sizeof(RC))
              else GlobalTS.Write(RC,Sizeof(RC));
      Exit;
    End;

  TSReadWrite_OpenObject(Read,'ReminRecord');

  TSReadWrite(Read,'RemRecName',RC.RemRecName,Sizeof(RC.RemRecName));
  TSReadWrite(Read,'DecayMax_Lab',RC.DecayMax_Lab);
  TSReadWrite(Read,'XDecayMax_Lab',RC.XDecayMax_Lab,Sizeof(RC.XDecayMax_Lab));
  TSReadWrite(Read,'Q10_NotUsed',RC.Q10_NotUsed);
  TSReadWrite(Read,'XQ10',RC.XQ10,Sizeof(RC.XQ10));
  TSReadWrite(Read,'TOpt',RC.TOpt);
  TSReadWrite(Read,'XTOpt',RC.XTOpt,Sizeof(RC.XTOpt));
  TSReadWrite(Read,'TMax',RC.TMax);
  TSReadWrite(Read,'XTMax',RC.XTMax,Sizeof(RC.XTMax));
  TSReadWrite(Read,'TRef_NotUsed',RC.TRef_NotUsed);
  TSReadWrite(Read,'XTRef',RC.XTRef,Sizeof(RC.XTRef));
  TSReadWrite(Read,'pHMin',RC.pHMin);
  TSReadWrite(Read,'XpHMin',RC.XpHMin,Sizeof(RC.XpHMin));
  TSReadWrite(Read,'pHMax',RC.pHMax);
  TSReadWrite(Read,'XpHMax',RC.XpHMax,Sizeof(RC.XpHMax));
  TSReadWrite(Read,'P2OrgLab',RC.P2OrgLab);
  TSReadWrite(Read,'N2OrgLab',RC.N2OrgLab);
  TSReadWrite(Read,'XP2OrgLab',RC.XP2OrgLab,Sizeof(RC.XP2OrgLab));
  TSReadWrite(Read,'XN2OrgLab',RC.XN2OrgLab,Sizeof(RC.XN2OrgLab));
  TSReadWrite(Read,'O2Biomass',RC.O2Biomass);
  TSReadWrite(Read,'XO2Biomass',RC.XO2Biomass,Sizeof(RC.XO2Biomass));
  TSReadWrite(Read,'O2N',RC.O2N);
  TSReadWrite(Read,'XO2N',RC.XO2N,Sizeof(RC.XO2N));
  TSReadWrite(Read,'KSed',RC.KSed);
  TSReadWrite(Read,'XKsed',RC.XKsed,Sizeof(RC.XKsed));
  TSReadWrite(Read,'PSedRelease_NotUsed',RC.PSedRelease_NotUsed);
  TSReadWrite(Read,'XPSedrelease',RC.XPSedrelease,Sizeof(RC.XPSedrelease));
  TSReadWrite(Read,'NSedRelease_NotUsed',RC.NSedRelease_NotUsed);
  TSReadWrite(Read,'XNSedRelease',RC.XNSedRelease,Sizeof(RC.XNSedRelease));
  TSReadWrite(Read,'DecayMax_Refr',RC.DecayMax_Refr);
  TSReadWrite(Read,'XDecayMax_Refr',RC.XDecayMax_Refr,Sizeof(RC.XDecayMax_Refr));
  TSReadWrite(Read,'KSedTemp',RC.KSedTemp);
  TSReadWrite(Read,'XKSedTemp',RC.XKSedTemp,Sizeof(RC.XKSedTemp));
  TSReadWrite(Read,'KSedSalinity',RC.KSedSalinity);
  TSReadWrite(Read,'XKSedSalinity',RC.XKSedSalinity,Sizeof(RC.XKSedSalinity));
  TSReadWrite(Read,'P2Org_Refr',RC.P2Org_Refr);
  TSReadWrite(Read,'XP2Org_Refr',RC.XP2Org_Refr,Sizeof(RC.XP2Org_Refr));
  TSReadWrite(Read,'N2Org_Refr',RC.N2Org_Refr);
  TSReadWrite(Read,'XN2Org_Refr',RC.XN2Org_Refr,Sizeof(RC.XN2Org_Refr));
  TSReadWrite(Read,'Wet2DryPRefr',RC.Wet2DryPRefr);
  TSReadWrite(Read,'XWet2DryPRefr',RC.XWet2DryPRefr,Sizeof(RC.XWet2DryPRefr));
  TSReadWrite(Read,'Wet2DryPLab',RC.Wet2DryPLab);
  TSReadWrite(Read,'Xet2DryPLab',RC.Xet2DryPLab,Sizeof(RC.Xet2DryPLab));
  TSReadWrite(Read,'Wet2DrySRefr',RC.Wet2DrySRefr);
  TSReadWrite(Read,'XWet2DrySRefr',RC.XWet2DrySRefr,Sizeof(RC.XWet2DrySRefr));
  TSReadWrite(Read,'Wet2DrySLab',RC.Wet2DrySLab);
  TSReadWrite(Read,'XWet2DrySLab',RC.XWet2DrySLab,Sizeof(RC.XWet2DrySLab));
  TSReadWrite(Read,'N2OrgDissLab',RC.N2OrgDissLab);
  TSReadWrite(Read,'XN2OrgDissLab',RC.XN2OrgDissLab,Sizeof(RC.XN2OrgDissLab));
  TSReadWrite(Read,'P2OrgDissLab',RC.P2OrgDissLab);
  TSReadWrite(Read,'XP2OrgDissLab',RC.XP2OrgDissLab,Sizeof(RC.XP2OrgDissLab));
  TSReadWrite(Read,'N2OrgDissRefr',RC.N2OrgDissRefr);
  TSReadWrite(Read,'XN2OrgDissRefr',RC.XN2OrgDissRefr,Sizeof(RC.XN2OrgDissRefr));
  TSReadWrite(Read,'P2OrgDissRefr',RC.P2OrgDissRefr);
  TSReadWrite(Read,'XP2OrgDissRefr',RC.XP2OrgDissRefr,Sizeof(RC.XP2OrgDissRefr));
  TSReadWrite(Read,'KD_P_Calcite',RC.KD_P_Calcite);
  TSReadWrite(Read,'XKD_P_Calcite',RC.XKD_P_Calcite,Sizeof(RC.XKD_P_Calcite));
  TSReadWrite(Read,'KNitri',RC.KNitri);
  TSReadWrite(Read,'XKNitri',RC.XKNitri,Sizeof(RC.XKNitri));
  TSReadWrite(Read,'KDenitri_Bot',RC.KDenitri_Bot);
  TSReadWrite(Read,'XKDenitri_Bot',RC.XKDenitri_Bot,Sizeof(RC.XKDenitri_Bot));
  TSReadWrite(Read,'KDenitri_Wat',RC.KDenitri_Wat);
  TSReadWrite(Read,'XKDenitri_Wat',RC.XKDenitri_Wat,Sizeof(RC.XKDenitri_Wat));

  TSReadWrite_CloseObject(Read);

end;


Procedure TSReadWrite_ChemicalRecord(Read: Boolean; var Rc:ChemicalRecord; ReadVersionNum: Double);
Var St: ANSIString;
Begin
  if not TSText then
    Begin
      If Read then GlobalTS.Read(RC,Sizeof(RC))
              else GlobalTS.Write(RC,Sizeof(RC));
      Exit;
    End;

  TSReadWrite_OpenObject(Read,'ChemicalRecord');

  TSReadWrite(Read,'ChemName',RC.ChemName,Sizeof(RC.ChemName));
  TSReadWrite(Read,'CASRegNo',RC.CASRegNo,Sizeof(RC.CASRegNo));
  TSReadWrite(Read,'MolWt',RC.MolWt);
  TSReadWrite(Read,'Solubility',RC.Solubility);
  TSReadWrite(Read,'XSolubility',RC.XSolubility,Sizeof(RC.XSolubility));
  TSReadWrite(Read,'Henry',RC.Henry);
  TSReadWrite(Read,'XHenry',RC.XHenry,Sizeof(RC.XHenry));
  TSReadWrite(Read,'pka',RC.pka);
  TSReadWrite(Read,'Xpka',RC.Xpka,Sizeof(RC.Xpka));
  TSReadWrite(Read,'VPress',RC.VPress);
  TSReadWrite(Read,'XVPress',RC.XVPress,Sizeof(RC.XVPress));
  TSReadWrite(Read,'LogKow',RC.LogKow);
  TSReadWrite(Read,'XLogKow',RC.XLogKow,Sizeof(RC.XLogKow));
  TSReadWrite(Read,'En',RC.En);
  TSReadWrite(Read,'XEn',RC.XEn,Sizeof(RC.XEn));
  TSReadWrite(Read,'KMDegrdn',RC.KMDegrdn);
  TSReadWrite(Read,'XKMDegrdn',RC.XKMDegrdn,Sizeof(RC.XKMDegrdn));
  TSReadWrite(Read,'KMDegrAnaerobic',RC.KMDegrAnaerobic);
  TSReadWrite(Read,'XKMDegrAnaerobic',RC.XKMDegrAnaerobic,Sizeof(RC.XKMDegrAnaerobic));
  TSReadWrite(Read,'KUnCat',RC.KUnCat);
  TSReadWrite(Read,'XKUncat',RC.XKUncat,Sizeof(RC.XKUncat));
  TSReadWrite(Read,'KAcid',RC.KAcid);
  TSReadWrite(Read,'XKAcid',RC.XKAcid,Sizeof(RC.XKAcid));
  TSReadWrite(Read,'KBase',RC.KBase);
  TSReadWrite(Read,'XKBase',RC.XKBase,Sizeof(RC.XKBase));
  TSReadWrite(Read,'PhotolysisRate',RC.PhotolysisRate);
  TSReadWrite(Read,'XPhotoLysisRate',RC.XPhotoLysisRate,Sizeof(RC.XPhotoLysisRate));
  TSReadWrite(Read,'OxRateConst',RC.OxRateConst);
  TSReadWrite(Read,'XOxRateConst',RC.XOxRateConst,Sizeof(RC.XOxRateConst));

  TSReadWrite(Read,'KPSed',RC.KPSed);
  TSReadWrite(Read,'XKPSed',RC.XKPSed,Sizeof(RC.XKPSed));
  TSReadWrite(Read,'Weibull_Shape',RC.Weibull_Shape);
  TSReadWrite(Read,'XWeibull_Shape',RC.XWeibull_Shape,Sizeof(RC.XWeibull_Shape));
  TSReadWrite(Read,'ChemIsBase',RC.ChemIsBase);
  TSReadWrite(Read,'CalcKPSed',RC.CalcKPSed);

  TSReadWrite(Read,'CohesivesK1',RC.CohesivesK1);
  TSReadWrite(Read,'CohesivesK2',RC.CohesivesK2);
  TSReadWrite(Read,'CohesivesKp',RC.CohesivesKp);
  TSReadWrite(Read,'CohesivesRef',RC.CohesivesRef,Sizeof(RC.CohesivesRef));
  TSReadWrite(Read,'NonCohK1',RC.NonCohK1);
  TSReadWrite(Read,'NonCohK2',RC.NonCohK2);
  TSReadWrite(Read,'NonCohKp',RC.NonCohKp);
  TSReadWrite(Read,'NonCohRef',RC.NonCohRef,Sizeof(RC.NonCohRef));
  TSReadWrite(Read,'NonCoh2K1',RC.NonCoh2K1);
  TSReadWrite(Read,'NonCoh2K2',RC.NonCoh2K2);
  TSReadWrite(Read,'NonCoh2Kp',RC.NonCoh2Kp);
  TSReadWrite(Read,'NonCoh2Ref',RC.NonCoh2Ref,Sizeof(RC.NonCoh2Ref));

  TSReadWrite(Read,'IsPFA',RC.IsPFA);
  TSReadWrite(Read,'PFAType',RC.PFAType,Sizeof(RC.PFAType));
  TSReadWrite(Read,'PFAChainLength',RC.PFAChainLength);
  TSReadWrite(Read,'XPFAChainLength',RC.XPFAChainLength,Sizeof(RC.XPFAChainLength));
  TSReadWrite(Read,'PFASedKom',RC.PFASedKom);
  TSReadWrite(Read,'XPFASedKom',RC.XPFASedKom,Sizeof(RC.XPFASedKom));
  TSReadWrite(Read,'PFAAlgBCF',RC.PFAAlgBCF);
  TSReadWrite(Read,'XPFAAlgBCF',RC.XPFAAlgBCF,Sizeof(RC.XPFAAlgBCF));
  TSReadWrite(Read,'PFAMacroBCF',RC.PFAMacroBCF);
  TSReadWrite(Read,'XPFAMacroBCF',RC.XPFAMacroBCF,Sizeof(RC.XPFAMacroBCF));

  TSReadWrite(Read,'WeibullSlopeFactor',RC.WeibullSlopeFactor);
  TSReadWrite(Read,'XWeibullSlopeFactor',RC.XWeibullSlopeFactor,Sizeof(RC.XWeibullSlopeFactor));

  TSReadWrite(Read,'CalcKOMRefrDOM',RC.CalcKOMRefrDOM);
  TSReadWrite(Read,'KOMRefrDOM',RC.KOMRefrDOM);
  TSReadWrite(Read,'XKOMRefrDOM',RC.XKOMRefrDOM,Sizeof(RC.XKOMRefrDOM));

  TSReadWrite(Read,'K1Detritus',RC.K1Detritus);
  TSReadWrite(Read,'XK1Detritus',RC.XK1Detritus,Sizeof(RC.XK1Detritus));

  TSReadWrite(Read,'BCFUptake',RC.BCFUptake);

  TSReadWrite_CloseObject(Read);
 end;


Procedure TSReadWrite_EstSaltLoadingRecord(Read: Boolean; var Rc:EstSaltLoadingRec; ReadVersionNum: Double);
Begin
  TSReadWrite_OpenObject(Read,'EstSaltLoading_Record');

  TSReadWrite(Read,'AmmoniaLoad',RC.AmmoniaLoad);
  TSReadWrite(Read,'XAmmoniaLoad',RC.XAmmoniaLoad,Sizeof(RC.XAmmoniaLoad));
  TSReadWrite(Read,'NitrateLoad',RC.NitrateLoad);
  TSReadWrite(Read,'XNitrateLoad',RC.XNitrateLoad,Sizeof(RC.XNitrateLoad));
  TSReadWrite(Read,'PhosphateLoad',RC.PhosphateLoad);
  TSReadWrite(Read,'XPhosphateLoad',RC.XPhosphateLoad,Sizeof(RC.XPhosphateLoad));
  TSReadWrite(Read,'O2Load',RC.O2Load);
  TSReadWrite(Read,'XO2Load',RC.XO2Load,Sizeof(RC.XO2Load));
  TSReadWrite(Read,'CO2Load',RC.CO2Load);
  TSReadWrite(Read,'XCO2Load',RC.XCO2Load,Sizeof(RC.XCO2Load));

  TSReadWrite_CloseObject(Read);
End;


Procedure TSReadWrite_SiteRecord(Read: Boolean; var Rc:SiteRecord; ReadVersionNum: Double);
Var St: ANSIString;
Begin
  if not TSText then
    Begin
      If Read then GlobalTS.Read(RC,Sizeof(RC))
              else GlobalTS.Write(RC,Sizeof(RC));
      Exit;
    End;

  TSReadWrite_OpenObject(Read,'SiteRecord');

  TSReadWrite(Read,'SiteName',RC.SiteName,Sizeof(RC.SiteName));
  TSReadWrite(Read,'ECoeffWater',RC.ECoeffWater);
  TSReadWrite(Read,'SiteLength',RC.SiteLength);
  TSReadWrite(Read,'XLength',RC.XLength,Sizeof(RC.XLength));
  TSReadWrite(Read,'StaticVolume',RC.StaticVolume);
  TSReadWrite(Read,'XVolume',RC.XVolume,Sizeof(RC.XVolume));
  TSReadWrite(Read,'SurfArea',RC.SurfArea);
  TSReadWrite(Read,'XSurfArea',RC.XSurfArea,Sizeof(RC.XSurfArea));
  TSReadWrite(Read,'ICZMean',RC.ICZMean);
  TSReadWrite(Read,'XZMean',RC.XZMean,Sizeof(RC.XZMean));
  TSReadWrite(Read,'ZMax',RC.ZMax);
  TSReadWrite(Read,'XZMax',RC.XZMax,Sizeof(RC.XZMax));

  TSReadWrite(Read,'TempMean[epilimnion]',RC.TempMean[epilimnion]);
  TSReadWrite(Read,'XTempMean[epilimnion]',RC.XTempMean[epilimnion],Sizeof(RC.XTempMean[epilimnion]));
  TSReadWrite(Read,'TempRange[epilimnion]',RC.TempRange[epilimnion]);
  TSReadWrite(Read,'XTempRange[epilimnion]',RC.XTempRange[epilimnion],Sizeof(RC.XTempRange[epilimnion]));

  TSReadWrite(Read,'TempMean[Hypolimnion]',RC.TempMean[Hypolimnion]);
  TSReadWrite(Read,'XTempMean[Hypolimnion]',RC.XTempMean[Hypolimnion],Sizeof(RC.XTempMean[Hypolimnion]));
  TSReadWrite(Read,'TempRange[Hypolimnion]',RC.TempRange[Hypolimnion]);
  TSReadWrite(Read,'XTempRange[Hypolimnion]',RC.XTempRange[Hypolimnion],Sizeof(RC.XTempRange[Hypolimnion]));

  TSReadWrite(Read,'Latitude',RC.Latitude);
  TSReadWrite(Read,'XLatitude',RC.XLatitude,Sizeof(RC.XLatitude));
  TSReadWrite(Read,'LightMean',RC.LightMean);
  TSReadWrite(Read,'XLightMean',RC.XLightMean,Sizeof(RC.XLightMean));
  TSReadWrite(Read,'LightRange',RC.LightRange);
  TSReadWrite(Read,'XLightRange',RC.XLightRange,Sizeof(RC.XLightRange));
  TSReadWrite(Read,'AlkCaCO3',RC.AlkCaCO3);
  TSReadWrite(Read,'XAlkCaCO3',RC.XAlkCaCO3,Sizeof(RC.XAlkCaCO3));
  TSReadWrite(Read,'HardCaCO3',RC.HardCaCO3);
  TSReadWrite(Read,'XHardCaCO3',RC.XHardCaCO3,Sizeof(RC.XHardCaCO3));
  TSReadWrite(Read,'SiteComment',RC.SiteComment,Sizeof(RC.SiteComment));
  TSReadWrite(Read,'SO4ConC',RC.SO4ConC);
  TSReadWrite(Read,'XSO4Conc',RC.XSO4Conc,Sizeof(RC.XSO4Conc));
  TSReadWrite(Read,'TotalDissSolids',RC.TotalDissSolids);
  TSReadWrite(Read,'XTotalDissSolids',RC.XTotalDissSolids,Sizeof(RC.XTotalDissSolids));
  TSReadWrite(Read,'StreamType',RC.StreamType,Sizeof(RC.StreamType));
  TSReadWrite(Read,'Channel_Slope',RC.Channel_Slope);
  TSReadWrite(Read,'XChannel_Slope',RC.XChannel_Slope,Sizeof(RC.XChannel_Slope));
  TSReadWrite(Read,'Max_Chan_Depth',RC.Max_Chan_Depth);
  TSReadWrite(Read,'XMax_Chan_Depth',RC.XMax_Chan_Depth,Sizeof(RC.XMax_Chan_Depth));
  TSReadWrite(Read,'SedDepth',RC.SedDepth);
  TSReadWrite(Read,'XSedDepth',RC.XSedDepth,Sizeof(RC.XSedDepth));
  TSReadWrite(Read,'EnclWallArea',RC.EnclWallArea);
  TSReadWrite(Read,'XEnclWallArea',RC.XEnclWallArea,Sizeof(RC.XEnclWallArea));
  TSReadWrite(Read,'MeanEvap',RC.MeanEvap);
  TSReadWrite(Read,'XMeanEvap',RC.XMeanEvap,Sizeof(RC.XMeanEvap));
  TSReadWrite(Read,'UseEnteredManning',RC.UseEnteredManning);
  TSReadWrite(Read,'EnteredManning',RC.EnteredManning);
  TSReadWrite(Read,'XECoeffWater',RC.XECoeffWater,Sizeof(RC.XECoeffWater));

  TSReadWrite(Read,'PctRiffle',RC.PctRiffle);
  TSReadWrite(Read,'XPctRiffle',RC.XPctRiffle,Sizeof(RC.XPctRiffle));
  TSReadWrite(Read,'PctPool',RC.PctPool);
  TSReadWrite(Read,'XPctPool',RC.XPctPool,Sizeof(RC.XPctPool));

  TSReadWrite(Read,'UseBathymetry',RC.UseBathymetry);

  TSReadWrite(Read,'ts_clay',RC.ts_clay);
  TSReadWrite(Read,'Xts_clay',RC.Xts_clay,Sizeof(RC.Xts_clay));
  TSReadWrite(Read,'ts_silt',RC.ts_silt);
  TSReadWrite(Read,'Xts_silt',RC.Xts_silt,Sizeof(RC.Xts_silt));
  TSReadWrite(Read,'tdep_clay',RC.tdep_clay);
  TSReadWrite(Read,'Xtdep_clay',RC.Xtdep_clay,Sizeof(RC.Xtdep_clay));
  TSReadWrite(Read,'tdep_silt',RC.tdep_silt);
  TSReadWrite(Read,'Xtdep_silt',RC.Xtdep_silt,Sizeof(RC.Xtdep_silt));
  TSReadWrite(Read,'FallVel_clay',RC.FallVel_clay);
  TSReadWrite(Read,'XFallVel_clay',RC.XFallVel_clay,Sizeof(RC.XFallVel_clay));
  TSReadWrite(Read,'FallVel_silt',RC.FallVel_silt);
  TSReadWrite(Read,'XFallVel_silt',RC.XFallVel_silt,Sizeof(RC.XFallVel_silt));

  TSReadWrite(Read,'SiteWidth',RC.SiteWidth);
  TSReadWrite(Read,'XSiteWidth',RC.XSiteWidth,Sizeof(RC.XSiteWidth));

  TSReadWrite(Read,'amplitude1',RC.amplitude1);
  TSReadWrite(Read,'k1',RC.k1);
  TSReadWrite(Read,'ConstRef1',RC.ConstRef1,Sizeof(RC.ConstRef1));
  TSReadWrite(Read,'amplitude2',RC.amplitude2);
  TSReadWrite(Read,'k2',RC.k2);
  TSReadWrite(Read,'ConstRef2',RC.ConstRef2,Sizeof(RC.ConstRef2));
  TSReadWrite(Read,'amplitude3',RC.amplitude3);
  TSReadWrite(Read,'k3',RC.k3);
  TSReadWrite(Read,'ConstRef3',RC.ConstRef3,Sizeof(RC.ConstRef3));
  TSReadWrite(Read,'amplitude4',RC.amplitude4);
  TSReadWrite(Read,'k4',RC.k4);
  TSReadWrite(Read,'ConstRef4',RC.ConstRef4,Sizeof(RC.ConstRef4));
  TSReadWrite(Read,'amplitude5',RC.amplitude5);
  TSReadWrite(Read,'k5',RC.k5);
  TSReadWrite(Read,'ConstRef5',RC.ConstRef5,Sizeof(RC.ConstRef5));
  TSReadWrite(Read,'amplitude6',RC.amplitude6);
  TSReadWrite(Read,'k6',RC.k6);
  TSReadWrite(Read,'ConstRef6',RC.ConstRef6,Sizeof(RC.ConstRef6));
  TSReadWrite(Read,'amplitude7',RC.amplitude7);
  TSReadWrite(Read,'k7',RC.k7);
  TSReadWrite(Read,'ConstRef7',RC.ConstRef7,Sizeof(RC.ConstRef7));
  TSReadWrite(Read,'amplitude8',RC.amplitude8);
  TSReadWrite(Read,'k8',RC.k8);
  TSReadWrite(Read,'ConstRef8',RC.ConstRef8,Sizeof(RC.ConstRef8));

  TSReadWrite(Read,'Min_Vol_Frac',RC.Min_Vol_Frac);
  TSReadWrite(Read,'XMin_Vol_Frac',RC.XMin_Vol_Frac,Sizeof(RC.XMin_Vol_Frac));

  TSReadWrite(Read,'WaterShedArea',RC.WaterShedArea);
  TSReadWrite(Read,'XWaterShedArea',RC.XWaterShedArea,Sizeof(RC.XWaterShedArea));
  TSReadWrite(Read,'EnterTotalLength',RC.EnterTotalLength);
  TSReadWrite(Read,'TotalLength',RC.TotalLength);
  TSReadWrite(Read,'XTotalLength',RC.XTotalLength,Sizeof(RC.XTotalLength));

  TSReadWrite(Read,'ECoeffSED',RC.ECoeffSED);
  TSReadWrite(Read,'XECoeffSED',RC.XECoeffSED,Sizeof(RC.XECoeffSED));
  TSReadWrite(Read,'ECoeffDOM',RC.ECoeffDOM);
  TSReadWrite(Read,'XECoeffDOM',RC.XECoeffDOM,Sizeof(RC.XECoeffDOM));
  TSReadWrite(Read,'ECoeffPOM',RC.ECoeffPOM);
  TSReadWrite(Read,'XECoeffPOM',RC.XECoeffPOM,Sizeof(RC.XECoeffPOM));

  TSReadWrite(Read,'UseCovar',RC.UseCovar);
  TSReadWrite(Read,'EnteredKReaer',RC.EnteredKReaer);
  TSReadWrite(Read,'XEnteredKReaer',RC.XEnteredKReaer,Sizeof(RC.XEnteredKReaer));
  TSReadWrite(Read,'UsePhytoRetention',RC.UsePhytoRetention);

  TSReadWrite(Read,'BasePercentEmbed',RC.BasePercentEmbed);
  TSReadWrite(Read,'XBasePercentEmbed',RC.XBasePercentEmbed,Sizeof(RC.XBasePercentEmbed));

  TSReadWrite(Read,'Altitude',RC.Altitude);
  TSReadWrite(Read,'XAltitude',RC.XAltitude,Sizeof(RC.XAltitude));

  TSReadWrite(Read,'FractalD',RC.FractalD);
  TSReadWrite(Read,'XFractalD',RC.XFractalD,Sizeof(RC.XFractalD));
  TSReadWrite(Read,'FD_Refuge_Coeff',RC.FD_Refuge_Coeff);
  TSReadWrite(Read,'XFD_Refuge_Coeff',RC.XFD_Refuge_Coeff,Sizeof(RC.XFD_Refuge_Coeff));
  TSReadWrite(Read,'HalfSatOysterRefuge',RC.HalfSatOysterRefuge);
  TSReadWrite(Read,'XHalfSatOysterRefuge',RC.XHalfSatOysterRefuge,Sizeof(RC.XHalfSatOysterRefuge));

  TSReadWrite_CloseObject(Read);

end;

(*
  InteractionFields =
    Packed record
      Pref : Double;
      ECoeff: Double;
      XInteraction: LongRefShortString;
          f1,f2,f3: Byte; {d4-5}
    end;
*)

Procedure TSReadWrite_AnimalRecord(Read: Boolean; var Rc:ZooRecord; ReadVersionNum: Double);
Var St: ANSIString;
Begin
  if not TSText then
    Begin
      If Read then GlobalTS.Read(RC,Sizeof(RC))
              else GlobalTS.Write(RC,Sizeof(RC));
      Exit;
    End;

  TSReadWrite_OpenObject(Read,'AnimalRecord');

  TSReadWrite(Read,'AnimalName',RC.AnimalName,Sizeof(RC.AnimalName));
  TSReadWrite(Read,'ToxicityRecord',RC.ToxicityRecord,Sizeof(RC.ToxicityRecord));
  TSReadWrite(Read,'FHalfSat',RC.FHalfSat);
  TSReadWrite(Read,'XFHalfSat',RC.XFHalfSat,Sizeof(RC.XFHalfSat));
  TSReadWrite(Read,'CMax',RC.CMax);
  TSReadWrite(Read,'XCMax',RC.XCMax,Sizeof(RC.XCMax));
  TSReadWrite(Read,'BMin',RC.BMin);
  TSReadWrite(Read,'XBMin',RC.XBMin,Sizeof(RC.XBMin));
  TSReadWrite(Read,'Q10',RC.Q10);
  TSReadWrite(Read,'XQ10',RC.XQ10,Sizeof(RC.XQ10));
  TSReadWrite(Read,'TOpt',RC.TOpt);
  TSReadWrite(Read,'XTOpt',RC.XTOpt,Sizeof(RC.XTOpt));
  TSReadWrite(Read,'TMax',RC.TMax);
  TSReadWrite(Read,'XTMax',RC.XTMax,Sizeof(RC.XTMax));
  TSReadWrite(Read,'TRef',RC.TRef);
  TSReadWrite(Read,'XTRef',RC.XTRef,Sizeof(RC.XTRef));
  TSReadWrite(Read,'EndogResp',RC.EndogResp);
  TSReadWrite(Read,'XEndogResp',RC.XEndogResp,Sizeof(RC.XEndogResp));
  TSReadWrite(Read,'KResp',RC.KResp);
  TSReadWrite(Read,'XKResp',RC.XKResp,Sizeof(RC.XKResp));
  TSReadWrite(Read,'KExcr',RC.KExcr);
  TSReadWrite(Read,'XKExcr',RC.XKExcr,Sizeof(RC.XKExcr));
  TSReadWrite(Read,'PctGamete',RC.PctGamete);
  TSReadWrite(Read,'XPctGamete',RC.XPctGamete,Sizeof(RC.XPctGamete));
  TSReadWrite(Read,'GMort',RC.GMort);
  TSReadWrite(Read,'XGMort',RC.XGMort,Sizeof(RC.XGMort));
  TSReadWrite(Read,'KMort',RC.KMort);
  TSReadWrite(Read,'XKMort',RC.XKMort,Sizeof(RC.XKMort));
  TSReadWrite(Read,'Placeholder',RC.Placeholder);
  TSReadWrite(Read,'XPlaceHolder',RC.XPlaceHolder,Sizeof(RC.XPlaceHolder));
  TSReadWrite(Read,'KCap',RC.KCap);
  TSReadWrite(Read,'XKCap',RC.XKCap,Sizeof(RC.XKCap));
  TSReadWrite(Read,'MeanWeight',RC.MeanWeight);
  TSReadWrite(Read,'XMeanWeight',RC.XMeanWeight,Sizeof(RC.XMeanWeight));
  TSReadWrite(Read,'FishFracLipid',RC.FishFracLipid);
  TSReadWrite(Read,'XFishFracLipid',RC.XFishFracLipid,Sizeof(RC.XFishFracLipid));
  TSReadWrite(Read,'LifeSpan',RC.LifeSpan);
  TSReadWrite(Read,'XLifeSpan',RC.XLifeSpan,Sizeof(RC.XLifeSpan));
  TSReadWrite(Read,'Animal_Type',RC.Animal_Type,Sizeof(RC.Animal_Type));
  TSReadWrite(Read,'AveDrift',RC.AveDrift);
  TSReadWrite(Read,'XAveDrift',RC.XAveDrift,Sizeof(RC.XAveDrift));
  TSReadWrite(Read,'AutoSpawn',RC.AutoSpawn);
  TSReadWrite(Read,'SpawnDate1',RC.SpawnDate1);
  TSReadWrite(Read,'SpawnDate2',RC.SpawnDate2);
  TSReadWrite(Read,'SpawnDate3',RC.SpawnDate3);
  TSReadWrite(Read,'XSpawnDate',RC.XSpawnDate,Sizeof(RC.XSpawnDate));
  TSReadWrite(Read,'UnlimitedSpawning',RC.UnlimitedSpawning);
  TSReadWrite(Read,'SpawnLimit',RC.SpawnLimit);
  TSReadWrite(Read,'UseAllom_C',RC.UseAllom_C);
  TSReadWrite(Read,'CA',RC.CA);
  TSReadWrite(Read,'CB',RC.CB);
  TSReadWrite(Read,'UseAllom_R',RC.UseAllom_R);
  TSReadWrite(Read,'RA',RC.RA);
  TSReadWrite(Read,'RB',RC.RB);
  TSReadWrite(Read,'UseSet1',RC.UseSet1);
  TSReadWrite(Read,'RQ',RC.RQ);
  TSReadWrite(Read,'RTO',RC.RTO);
  TSReadWrite(Read,'RTM',RC.RTM);
  TSReadWrite(Read,'RTL',RC.RTL);
  TSReadWrite(Read,'RK1',RC.RK1);
  TSReadWrite(Read,'RK4',RC.RK4);
  TSReadWrite(Read,'ACT',RC.ACT);
  TSReadWrite(Read,'BACT',RC.BACT);
  TSReadWrite(Read,'FracInWaterCol',RC.FracInWaterCol);
  TSReadWrite(Read,'XFracInWaterCol',RC.XFracInWaterCol,Sizeof(RC.XFracInWaterCol));
  TSReadWrite(Read,'Guild_Taxa',RC.Guild_Taxa,Sizeof(RC.Guild_Taxa));

  TSReadWrite(Read,'PrefRiffle',RC.PrefRiffle);
  TSReadWrite(Read,'XPrefRiffle',RC.XPrefRiffle,Sizeof(RC.XPrefRiffle));
  TSReadWrite(Read,'PrefPool',RC.PrefPool);
  TSReadWrite(Read,'XPrefPool',RC.XPrefPool,Sizeof(RC.XPrefPool));
  TSReadWrite(Read,'VelMax',RC.VelMax);
  TSReadWrite(Read,'XVelMax',RC.XVelMax,Sizeof(RC.XVelMax));
  TSReadWrite(Read,'XAllomConsumpt',RC.XAllomConsumpt,Sizeof(RC.XAllomConsumpt));
  TSReadWrite(Read,'XAllomResp',RC.XAllomResp,Sizeof(RC.XAllomResp));

  TSReadWrite(Read,'Salmin_Ing',RC.Salmin_Ing);
  TSReadWrite(Read,'SalMax_Ing',RC.SalMax_Ing);
  TSReadWrite(Read,'Salcoeff1_Ing',RC.Salcoeff1_Ing);
  TSReadWrite(Read,'Salcoeff2_Ing',RC.Salcoeff2_Ing);
  TSReadWrite(Read,'XSalinity_Ing',RC.XSalinity_Ing,Sizeof(RC.XSalinity_Ing));

  TSReadWrite(Read,'Salmin_Gam',RC.Salmin_Gam);
  TSReadWrite(Read,'SalMax_Gam',RC.SalMax_Gam);
  TSReadWrite(Read,'Salcoeff1_Gam',RC.Salcoeff1_Gam);
  TSReadWrite(Read,'Salcoeff2_Gam',RC.Salcoeff2_Gam);
  TSReadWrite(Read,'XSalinity_Gam',RC.XSalinity_Gam,Sizeof(RC.XSalinity_Gam));
  TSReadWrite(Read,'Salmin_Rsp',RC.Salmin_Rsp);
  TSReadWrite(Read,'SalMax_Rsp',RC.SalMax_Rsp);
  TSReadWrite(Read,'Salcoeff1_Rsp',RC.Salcoeff1_Rsp);
  TSReadWrite(Read,'Salcoeff2_Rsp',RC.Salcoeff2_Rsp);
  TSReadWrite(Read,'XSalinity_Rsp',RC.XSalinity_Rsp,Sizeof(RC.XSalinity_Rsp));
  TSReadWrite(Read,'Salmin_Mort',RC.Salmin_Mort);
  TSReadWrite(Read,'SalMax_Mort',RC.SalMax_Mort);
  TSReadWrite(Read,'Salcoeff1_Mort',RC.Salcoeff1_Mort);
  TSReadWrite(Read,'Salcoeff2_Mort',RC.Salcoeff2_Mort);
  TSReadWrite(Read,'XSalinity_Mort',RC.XSalinity_Mort,Sizeof(RC.XSalinity_Mort));

  TSReadWrite(Read,'Fishing_Frac',RC.Fishing_Frac);
  TSReadWrite(Read,'XFishing_Frac',RC.XFishing_Frac,Sizeof(RC.XFishing_Frac));

  TSReadWrite(Read,'P2Org',RC.P2Org);
  TSReadWrite(Read,'XP2Org',RC.XP2Org,Sizeof(RC.XP2Org));
  TSReadWrite(Read,'N2Org',RC.N2Org);
  TSReadWrite(Read,'XN2Org',RC.XN2Org,Sizeof(RC.XN2Org));

  TSReadWrite(Read,'Wet2Dry',RC.Wet2Dry);
  TSReadWrite(Read,'XWet2Dry',RC.XWet2Dry,Sizeof(RC.XWet2Dry));

  TSReadWrite(Read,'O2_LethalConc',RC.O2_LethalConc);
  TSReadWrite(Read,'O2_LethalPct',RC.O2_LethalPct);
  TSReadWrite(Read,'O2_LCRef',RC.O2_LCRef,Sizeof(RC.O2_LCRef));

  TSReadWrite(Read,'O2_EC50growth',RC.O2_EC50growth);
  TSReadWrite(Read,'XO2_EC50growth',RC.XO2_EC50growth,Sizeof(RC.XO2_EC50growth));
  TSReadWrite(Read,'O2_EC50repro',RC.O2_EC50repro);
  TSReadWrite(Read,'XO2_EC50repro',RC.XO2_EC50repro,Sizeof(RC.XO2_EC50repro));

  TSReadWrite(Read,'Ammonia_LC50',RC.Ammonia_LC50);
  TSReadWrite(Read,'XAmmonia_LC50',RC.XAmmonia_LC50,Sizeof(RC.XAmmonia_LC50));

  TSReadWrite(Read,'Sorting',RC.Sorting);
  TSReadWrite(Read,'XSorting',RC.XSorting,Sizeof(RC.XSorting));
  TSReadWrite(Read,'SuspSedFeeding',RC.SuspSedFeeding);
  TSReadWrite(Read,'XSuspSedFeeding',RC.XSuspSedFeeding,Sizeof(RC.XSuspSedFeeding));
  TSReadWrite(Read,'SlopeSSFeed',RC.SlopeSSFeed);
  TSReadWrite(Read,'XSlopeSSFeed',RC.XSlopeSSFeed,Sizeof(RC.XSlopeSSFeed));
  TSReadWrite(Read,'InterceptSSFeed',RC.InterceptSSFeed);
  TSReadWrite(Read,'XInterceptSSFeed',RC.XInterceptSSFeed,Sizeof(RC.XInterceptSSFeed));

  TSReadWrite(Read,'SenstoSediment',RC.SenstoSediment,Sizeof(RC.SenstoSediment));
  TSReadWrite(Read,'XSensToSediment',RC.XSensToSediment,Sizeof(RC.XSensToSediment));
  TSReadWrite(Read,'Trigger',RC.Trigger);
  TSReadWrite(Read,'XTrigger',RC.XTrigger,Sizeof(RC.XTrigger));

  TSReadWrite(Read,'SenstoPctEmbed',RC.SenstoPctEmbed);
  TSReadWrite(Read,'PctEmbedThreshold',RC.PctEmbedThreshold);
  TSReadWrite(Read,'XPctEmbedThreshold',RC.XPctEmbedThreshold,Sizeof(RC.XPctEmbedThreshold));

  TSReadWrite(Read,'BenthicDesignation',RC.BenthicDesignation,Sizeof(RC.BenthicDesignation));

  TSReadWrite(Read,'CanSeekRefuge',RC.CanSeekRefuge);
  TSReadWrite(Read,'Visual_Feeder',RC.Visual_Feeder);

  TSReadWrite(Read,'Burrow_Index',RC.Burrow_Index);
  TSReadWrite(Read,'ScientificName',RC.ScientificName,Sizeof(RC.ScientificName));
  TSReadWrite(Read,'XBurrow_Index',RC.XBurrow_Index,Sizeof(RC.XBurrow_Index));

  TSReadWrite_CloseObject(Read);
end;


Procedure TSReadWrite_PlantRecord(Read: Boolean; var Rc:PlantRecord; ReadVersionNum: Double);
Var St: ANSIString;
Begin
  if not TSText then
    Begin
      If Read then GlobalTS.Read(RC,Sizeof(RC))
              else GlobalTS.Write(RC,Sizeof(RC));
      Exit;
    End;

  TSReadWrite_OpenObject(Read,'PlantRecord');

  TSReadWrite(Read,'PlantName',RC.PlantName,Sizeof(RC.PlantName));
  TSReadWrite(Read,'PlantType',RC.PlantType,Sizeof(RC.PlantType));
  TSReadWrite(Read,'ToxicityRecord',RC.ToxicityRecord,Sizeof(RC.ToxicityRecord));
  TSReadWrite(Read,'EnteredLightSat',RC.EnteredLightSat);
  TSReadWrite(Read,'XLightSat',RC.XLightSat,Sizeof(RC.XLightSat));
  TSReadWrite(Read,'KPO4',RC.KPO4);
  TSReadWrite(Read,'XKPO4',RC.XKPO4,Sizeof(RC.XKPO4));
  TSReadWrite(Read,'KN',RC.KN);
  TSReadWrite(Read,'XKN',RC.XKN,Sizeof(RC.XKN));
  TSReadWrite(Read,'KCarbon',RC.KCarbon);
  TSReadWrite(Read,'XKCarbon',RC.XKCarbon,Sizeof(RC.XKCarbon));
  TSReadWrite(Read,'Q10',RC.Q10);
  TSReadWrite(Read,'XQ10',RC.XQ10,Sizeof(RC.XQ10));
  TSReadWrite(Read,'TOpt',RC.TOpt);
  TSReadWrite(Read,'XTOpt',RC.XTOpt,Sizeof(RC.XTOpt));
  TSReadWrite(Read,'TMax',RC.TMax);
  TSReadWrite(Read,'XTMax',RC.XTMax,Sizeof(RC.XTMax));
  TSReadWrite(Read,'TRef',RC.TRef);
  TSReadWrite(Read,'XTRef',RC.XTRef,Sizeof(RC.XTRef));
  TSReadWrite(Read,'PMax',RC.PMax);
  TSReadWrite(Read,'XPMax',RC.XPMax,Sizeof(RC.XPMax));
  TSReadWrite(Read,'KResp',RC.KResp);
  TSReadWrite(Read,'XKResp',RC.XKResp,Sizeof(RC.XKResp));
  TSReadWrite(Read,'KMort',RC.KMort);
  TSReadWrite(Read,'XKMort',RC.XKMort,Sizeof(RC.XKMort));
  TSReadWrite(Read,'EMort',RC.EMort);
  TSReadWrite(Read,'XEMort',RC.XEMort,Sizeof(RC.XEMort));
  TSReadWrite(Read,'KSed',RC.KSed);
  TSReadWrite(Read,'XKSed',RC.XKSed,Sizeof(RC.XKSed));
  TSReadWrite(Read,'ESed',RC.ESed);
  TSReadWrite(Read,'XESed',RC.XESed,Sizeof(RC.XESed));
  TSReadWrite(Read,'P2OrgInit',RC.P2OrgInit);
  TSReadWrite(Read,'XP2Org',RC.XP2Org,Sizeof(RC.XP2Org));
  TSReadWrite(Read,'N2OrgInit',RC.N2OrgInit);
  TSReadWrite(Read,'XN2Org',RC.XN2Org,Sizeof(RC.XN2Org));
  TSReadWrite(Read,'ECoeffPhyto',RC.ECoeffPhyto);
  TSReadWrite(Read,'XECoeffPhyto',RC.XECoeffPhyto,Sizeof(RC.XECoeffPhyto));
  TSReadWrite(Read,'CarryCapac',RC.CarryCapac);
  TSReadWrite(Read,'XCarryCapac',RC.XCarryCapac,Sizeof(RC.XCarryCapac));
  TSReadWrite(Read,'Red_Still_Water',RC.Red_Still_Water);
  TSReadWrite(Read,'XRed_Still_Water',RC.XRed_Still_Water,Sizeof(RC.XRed_Still_Water));
  TSReadWrite(Read,'Macrophyte_Type',RC.Macrophyte_Type,Sizeof(RC.Macrophyte_Type));
  TSReadWrite(Read,'Macro_Drift',RC.Macro_Drift);
  TSReadWrite(Read,'Taxonomic_Type',RC.Taxonomic_Type,Sizeof(RC.Taxonomic_Type));
  TSReadWrite(Read,'PrefRiffle',RC.PrefRiffle);
  TSReadWrite(Read,'XPrefRiffle',RC.XPrefRiffle,Sizeof(RC.XPrefRiffle));
  TSReadWrite(Read,'PrefPool',RC.PrefPool);
  TSReadWrite(Read,'XPrefPool',RC.XPrefPool,Sizeof(RC.XPrefPool));
  TSReadWrite(Read,'FCrit',RC.FCrit);
  TSReadWrite(Read,'XFCrit',RC.XFCrit,Sizeof(RC.XFCrit));
  TSReadWrite(Read,'Macro_VelMax',RC.Macro_VelMax);
  TSReadWrite(Read,'XVelMax',RC.XVelMax,Sizeof(RC.XVelMax));
  TSReadWrite(Read,'KSedTemp',RC.KSedTemp);
  TSReadWrite(Read,'XKSedTemp',RC.XKSedTemp,Sizeof(RC.XKSedTemp));
  TSReadWrite(Read,'KSedSalinity',RC.KSedSalinity);
  TSReadWrite(Read,'XKSedSalinity',RC.XKSedSalinity,Sizeof(RC.XKSedSalinity));
  TSReadWrite(Read,'Salmin_Phot',RC.Salmin_Phot);
  TSReadWrite(Read,'SalMax_Phot',RC.SalMax_Phot);
  TSReadWrite(Read,'Salcoeff1_Phot',RC.Salcoeff1_Phot);
  TSReadWrite(Read,'Salcoeff2_Phot',RC.Salcoeff2_Phot);
  TSReadWrite(Read,'XSalinity_Phot',RC.XSalinity_Phot,Sizeof(RC.XSalinity_Phot));
  TSReadWrite(Read,'Salmin_Mort',RC.Salmin_Mort);
  TSReadWrite(Read,'SalMax_Mort',RC.SalMax_Mort);
  TSReadWrite(Read,'Salcoeff1_Mort',RC.Salcoeff1_Mort);
  TSReadWrite(Read,'Salcoeff2_Mort',RC.Salcoeff2_Mort);
  TSReadWrite(Read,'XSalinity_Mort',RC.XSalinity_Mort,Sizeof(RC.XSalinity_Mort));
  TSReadWrite(Read,'Wet2Dry',RC.Wet2Dry);
  TSReadWrite(Read,'XWet2Dry',RC.XWet2Dry,Sizeof(RC.XWet2Dry));
  TSReadWrite(Read,'Resp20',RC.Resp20);
  TSReadWrite(Read,'XResp20',RC.XResp20,Sizeof(RC.XResp20));
  TSReadWrite(Read,'PctSloughed',RC.PctSloughed);
  TSReadWrite(Read,'XPctSloughed',RC.XPctSloughed,Sizeof(RC.XPctSloughed));
  TSReadWrite(Read,'UseAdaptiveLight',RC.UseAdaptiveLight);
  TSReadWrite(Read,'MaxLightSat',RC.MaxLightSat);
  TSReadWrite(Read,'XMaxLightSat',RC.XMaxLightSat,Sizeof(RC.XMaxLightSat));
  TSReadWrite(Read,'MinLightSat',RC.MinLightSat);
  TSReadWrite(Read,'XMinLightSat',RC.XMinLightSat,Sizeof(RC.XMinLightSat));

  TSReadWrite(Read,'ScientificName',RC.ScientificName,Sizeof(RC.ScientificName));

  TSReadWrite(Read,'PlantFracLipid',RC.PlantFracLipid);
  TSReadWrite(Read,'XPlantFracLipid',RC.XPlantFracLipid,Sizeof(RC.XPlantFracLipid));

  TSReadWrite(Read,'SurfaceFloating',RC.SurfaceFloating);

  TSReadWrite(Read,'NHalfSatInternal',RC.NHalfSatInternal);
  TSReadWrite(Read,'XNHalfSatInternal',RC.XNHalfSatInternal,Sizeof(RC.XNHalfSatInternal));
  TSReadWrite(Read,'PHalfSatInternal',RC.PHalfSatInternal);
  TSReadWrite(Read,'XPHalfSatInternal',RC.XPHalfSatInternal,Sizeof(RC.XPHalfSatInternal));
  TSReadWrite(Read,'MaxNUptake',RC.MaxNUptake);
  TSReadWrite(Read,'XMaxNUptake',RC.XMaxNUptake,Sizeof(RC.XMaxNUptake));
  TSReadWrite(Read,'MaxPUptake',RC.MaxPUptake);
  TSReadWrite(Read,'XMaxPUptake',RC.XMaxPUptake,Sizeof(RC.XMaxPUptake));
  TSReadWrite(Read,'Min_N_Ratio',RC.Min_N_Ratio);
  TSReadWrite(Read,'XMin_N_Ratio',RC.XMin_N_Ratio,Sizeof(RC.XMin_N_Ratio));
  TSReadWrite(Read,'Min_P_Ratio',RC.Min_P_Ratio);
  TSReadWrite(Read,'XMin_P_Ratio',RC.XMin_P_Ratio,Sizeof(RC.XMin_P_Ratio));

  TSReadWrite(Read,'Plant_to_Chla',RC.Plant_to_Chla);
  TSReadWrite(Read,'XPlant_to_Chla',RC.XPlant_to_Chla,Sizeof(RC.XPlant_to_Chla));

  TSReadWrite_CloseObject(Read);
end;




Procedure TSReadWrite_Control_Opt_Rec(Read: Boolean; var Rc:Control_Opt_Rec; ReadVersionNum: Double);
Begin
  TSReadWrite_OpenObject(Read,'Control_Opt_Rec');

  TSReadWrite(Read,'Tox.ZeroInitCond',Rc.Tox.ZeroInitCond);
  TSReadWrite(Read,'Tox.OmitInflow',Rc.Tox.OmitInflow);
  TSReadWrite(Read,'Tox.OmitPS',Rc.Tox.OmitPS);
  TSReadWrite(Read,'Tox.OmitDP',Rc.Tox.OmitDP);
  TSReadWrite(Read,'Tox.OmitNPS',Rc.Tox.OmitNPS);
  TSReadWrite(Read,'Tox.SetMult',Rc.Tox.SetMult);

  TSReadWrite(Read,'Nutrient.ZeroInitCond',Rc.Nutrient.ZeroInitCond);
  TSReadWrite(Read,'Nutrient.OmitInflow',Rc.Nutrient.OmitInflow);
  TSReadWrite(Read,'Nutrient.OmitPS',Rc.Nutrient.OmitPS);
  TSReadWrite(Read,'Nutrient.OmitDP',Rc.Nutrient.OmitDP);
  TSReadWrite(Read,'Nutrient.OmitNPS',Rc.Nutrient.OmitNPS);
  TSReadWrite(Read,'Nutrient.SetMult',Rc.Nutrient.SetMult);

  TSReadWrite(Read,'Sediment.ZeroInitCond',Rc.Sediment.ZeroInitCond);
  TSReadWrite(Read,'Sediment.OmitInflow',Rc.Sediment.OmitInflow);
  TSReadWrite(Read,'Sediment.OmitPS',Rc.Sediment.OmitPS);
  TSReadWrite(Read,'Sediment.OmitDP',Rc.Sediment.OmitDP);
  TSReadWrite(Read,'Sediment.OmitNPS',Rc.Sediment.OmitNPS);
  TSReadWrite(Read,'Sediment.SetMult',Rc.Sediment.SetMult);

  TSReadWrite(Read,'Detritus.ZeroInitCond',Rc.Detritus.ZeroInitCond);
  TSReadWrite(Read,'Detritus.OmitInflow',Rc.Detritus.OmitInflow);
  TSReadWrite(Read,'Detritus.OmitPS',Rc.Detritus.OmitPS);
  TSReadWrite(Read,'Detritus.OmitDP',Rc.Detritus.OmitDP);
  TSReadWrite(Read,'Detritus.OmitNPS',Rc.Detritus.OmitNPS);
  TSReadWrite(Read,'Detritus.SetMult',Rc.Detritus.SetMult);

  TSReadWrite_CloseObject(Read);
end;


Procedure TSReadWrite_BedRecord(Read: Boolean; var Rc:BedRecord; ReadVersionNum: Double);
Begin
  TSReadWrite_OpenObject(Read,'BedRecord');

  TSReadWrite(Read,'BedDepthIC',Rc.BedDepthIC);
  TSReadWrite(Read,'BedDensity',Rc.BedDensity);
  TSReadWrite(Read,'NotUsed',Rc.NotUsed);
  TSReadWrite(Read,'FracWater',Rc.FracWater);
  TSReadWrite(Read,'BedVolume',Rc.BedVolume);
  TSReadWrite(Read,'DynBedDepth',Rc.DynBedDepth);
  TSReadWrite(Read,'VolumeLost',Rc.VolumeLost);
  TSReadWrite(Read,'PoreSqueeze',Rc.PoreSqueeze);

  TSReadWrite_CloseObject(Read);
end;


Procedure TSReadWrite_Uncertainty_Setup_Record(Read: Boolean; Rc:PUncertainty_Setup_Record; ReadVersionNum: Double);
Var i: Integer;
Begin
  if not TSText then
    Begin
      If Read then GlobalTS.Read(RC^,Sizeof(RC^))
              else GlobalTS.Write(RC^,Sizeof(RC^));
      Exit;
    End;

  TSReadWrite_OpenObject(Read,'Uncertainty_Setup_Record');

  TSReadWrite(Read,'Run_Uncertainty',RC.Run_Uncertainty);
  TSReadWrite(Read,'Run_Sensitivity',RC.Run_Sensitivity);
  TSReadWrite(Read,'NumSteps',RC.NumSteps);
  TSReadWrite(Read,'RandomSeed',RC.RandomSeed);
  TSReadWrite(Read,'UseSeed',RC.UseSeed);

  TSReadWrite(Read,'NominalPercent',RC.NominalPercent);
  TSReadWrite(Read,'TrackUncertVars',RC.TrackUncertVars);
  TSReadWrite(Read,'NumUncert',RC.NumUncert);
  TSReadWrite(Read,'NumSens',RC.NumSens);

  for i := 1 to 100 do
    TSReadWrite(Read,'SensTrack'+IntToStr(i),RC.SensTrack[i]);
  for i := 1 to 100 do
    TSReadWrite(Read,'UncertTrack'+IntToStr(i),RC.UncertTrack[i]);

  TSReadWrite(Read,'LinkPeriPhyto',RC.LinkPeriPhyto);
  TSReadWrite(Read,'UseCorrelations',RC.UseCorrelations);

  TSReadWrite(Read,'AdvancedSens',RC.AdvancedSens);
  TSReadWrite(Read,'StartIteration',RC.StartIteration);
  TSReadWrite(Read,'Processors2Use',RC.Processors2Use);
  TSReadWrite(Read,'StartIter',RC.StartIter);
  TSReadWrite(Read,'AverageAll',RC.AverageAll);
  TSReadWrite(Read,'AverageYears',RC.AverageYears);

  TSReadWrite(Read,'SaveToCSV',RC.SaveToCSV);
  TSReadWrite(Read,'RandomSampling',RC.RandomSampling);

  TSReadWrite_CloseObject(Read);
end;



Procedure TSReadWrite_TrophInt(TIName: RefShortString; Read: Boolean; Rc:PTrophIntArray; ReadVersionNum: Double);
Var ns: AllVariables;
Begin
  if not TSText then
    Begin
      If Read then GlobalTS.Read(RC^,Sizeof(RC^))
              else GlobalTS.Write(RC^,Sizeof(RC^));
      Exit;
    End;

  TSReadWrite_OpenObject(Read,'TrophInt');
  TSReadWrite(Read,TIName,TIName,Sizeof(TIName));

  for ns := Cohesives to LastBiota do
    Begin
      TSReadWrite(Read,'Pref'+IntToStr(ORD(NS)),RC^[ns].Pref);
      TSReadWrite(Read,'ECoeff'+IntToStr(ORD(NS)),Rc^[ns].ECoeff);
      TSReadWrite(Read,'XInteraction'+IntToStr(ORD(NS)),Rc^[ns].XInteraction,Sizeof(Rc^[ns].XInteraction));
    End;

  TSReadWrite_CloseObject(Read);
End;



Procedure TSReadWrite_SV_ID(Read: Boolean; var Rc:SV_ID; ReadVersionNum: Double);
Var Ordinl: Byte;
Begin
    TSReadWrite_OpenObject(Read,'SV_ID');
    Ordinl := Byte(RC.NState); TSReadWrite(Read,'NState',Ordinl); RC.NState := AllVariables(Ordinl);
    Ordinl := Byte(RC.SVType); TSReadWrite(Read,'SVType',Ordinl); RC.SVType := T_SVType(Ordinl);
    Ordinl := Byte(RC.Layer); TSReadWrite(Read,'Layer',Ordinl); RC.Layer := T_SVLayer(Ordinl);
    TSReadWrite_CloseObject(Read);
end;


Begin
{  Timer:=TTiming.Create; }
End.




