//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
//

// Interface to web help

unit hh;

interface

uses
  Windows,   //This line will not compile under Delphi 1 -- D1 is not supported
  SysUtils,
    dialogs,
    global,
  Registry;


Procedure HTMLHelpContext(Bkmark: String);



implementation

uses ShellAPI, forms, wininet;

Function CheckUrl(url:string):boolean;
var hSession, hfile, hRequest: hInternet;
    dwindex,dwcodelen :dword;
    dwcode:array[1..20] of char;
    res : pchar;
begin
  if pos('http://',lowercase(url))=0 then url := 'http://'+url;
  Result := false;
  hSession := InternetOpen('InetURL:/1.0',
  INTERNET_OPEN_TYPE_PRECONFIG,nil, nil, 0);
  if assigned(hsession) then
  begin
    hfile := InternetOpenUrl(hsession,pchar(url), nil, 0, INTERNET_FLAG_RELOAD, 0);
    dwIndex := 0;
    dwCodeLen := 10;
    HttpQueryInfo(hfile, HTTP_QUERY_STATUS_CODE, @dwcode, dwcodeLen, dwIndex);
    res := pchar(@dwcode);
    result:= (res ='200') or (res ='302');
    if assigned(hfile) then InternetCloseHandle(hfile);
    InternetCloseHandle(hsession);
  end;

end;



function OpenHTMLFileAtAnchor(fname, Anchor: string): boolean;
var
  tmp, Executable: pchar;
  x: integer;
begin
  Executable := StrAlloc(MAX_PATH);
  Tmp := StrAlloc(MAX_PATH);
  GetTempPath(255,tmp);
  FileCreate(tmp+'htmpl.htm');
  x := FindExecutable('htmpl.htm', tmp, Executable);
  Result := x > 32;
  if Result then begin
    fname := (fname + '#' + Anchor);
    Result := ShellExecute(0, 'open', Executable, PChar(fname), nil, SW_SHOWNORMAL) > 32;
  end;
  StrDispose(Executable);
  StrDispose(Tmp);
end;



Procedure HTMLHelpContext(Bkmark: String);
Var BName, PC: PWideChar;
    HFP: String;
    OpenedHelp: Boolean;
Begin
  If CheckURL(HelpFileURL) then OpenedHelp := OpenHTMLFileAtAnchor(HelpFileURL,BkMark)
                           else OpenedHelp := OpenHTMLFileAtAnchor(HelpFilePath,BkMark);
  if Not OpenedHelp then showmessage('Unable to open help file.');

End;


end.






