//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
//
Unit imp_load;

Interface

Uses
  Windows, Messages, System.SysUtils, Classes, Graphics, Controls, Forms, Dialogs, hh,
  DB,  FileCtrl, StdCtrls, ExtCtrls, Buttons, Grids, DBGrids, Global,
  FireDAC.Comp.Client,   AQBaseForm, ComCtrls, Tabnotbk, ExcelFuncs, Comobj, ActiveX, Variants, Convert,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.UI.Intf,
  FireDAC.Stan.Def, FireDAC.Stan.Pool, FireDAC.Phys, FireDAC.VCLUI.Wait;

Type
  TImportForm = class(TAQBase)
    Label5: TLabel;
    ImpTable: TFDTable;
    Label6: TLabel;
    LoadName: TLabel;
    DataSource1: TDataSource;
    IncomingTable: TFDTable;
    TabbedNotebook1: TPageControl;
    Panel2: TPanel;
    Label7: TLabel;
    Panel4: TPanel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    FileEdit2: TEdit;
    FileListBox2: TFileListBox;
    DirectoryListBox2: TDirectoryListBox;
    FCB2: TFilterComboBox;
    DriveComboBox2: TDriveComboBox;
    BitBtn1: TBitBtn;
    ExportButt: TBitBtn;
    Button1: TButton;
    ListBox1: TListBox;
    DataSource2: TDataSource;
    Label13: TLabel;
    Button2: TButton;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    Label14: TLabel;
    Label15: TLabel;
    FDConnection1: TFDConnection;
    FDConnection2: TFDConnection;
    TSImport: TTabSheet;
    TSExport: TTabSheet;
    TSClear: TTabSheet;
    DBGrid2: TDBGrid;
    Panel5: TPanel;
    ConvertToLabel: TLabel;
    ConvertLabel: TLabel;
    Label20: TLabel;
    DBGrid1: TDBGrid;
    Panel3: TPanel;
    DefaultLabel: TLabel;
    Panel1: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    PathLabel: TLabel;
    Label1: TLabel;
    Label4: TLabel;
    FileEdit: TEdit;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    FCB1: TFilterComboBox;
    DriveComboBox1: TDriveComboBox;
    CancelBtn: TBitBtn;
    OKBtn: TBitBtn;
    HelpButton: TButton;
    ErrPanel: TPanel;
    ErrLabel: TLabel;
    NoteBox: TListBox;
    ExcelOptPanel: TPanel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    SheetEdit: TEdit;
    RowEdit: TEdit;
    DCEdit: TEdit;
    VCEdit: TEdit;
    Button3: TButton;
    ConvertBox: TCheckBox;
    UnitsBox: TComboBox;
    procedure FileEditChange(Sender: TObject);
    procedure FCB1Change(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
    procedure FCB2Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FileEdit2Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ConvertBoxClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure TabbedNotebook1Change(Sender: TObject);
  private
    Function ImportData (FullFileN: AnsiString; Demo: Boolean; Var Table: TFDTable): Boolean;
    Function ExportData(FullFileN: AnsiString): Boolean;
  public
    Hourlymode: Boolean;
    CType: ConvertType;
    Function GetFullName: AnsiString;
    Function ChangeLoading(LoadNm: AnsiString; Var Table: TFDTable; WaterData, Hourly: Boolean; CT: ConvertType): Boolean;

  end;

Var
  ImportForm: TImportForm;

Implementation

uses SV_IO, Wait, Excel2000, System.UITypes;

{$R *.DFM}


{---------------------------------------------------------------------}

Function TImportForm.ExportData(FullFileN: AnsiString): Boolean;
{If demo, it only gets the first 6 fields}

Var Outfile : TextFile;
    Loop, RecNum: Integer;
    DelimChar: AnsiChar;
    Msk: AnsiString;
    TEx: TExcelOutput;

Begin

  ExportData := True;

  Msk := ExtractFileExt(FCB2.Mask);
  If LowerCase(ExtractFileExt(FullFileN)) <> Msk then FullFileN := FullFileN + Msk;

  {Check if file exists and ask user if overwriting is desired}
  If FileExists(FullFileN)  then
     If (MessageDlg('Overwrite Existing File?',mtConfirmation,[mbyes,mbno],0)= mrno)
        then Begin ExportData := False; Exit; End;

  If FileExists(FullFileN) then If Not DeleteFile(FullFileN)
    then Begin
           MessageDlg('Cannot gain exclusive access to the file to overwrite it.',mtError,[mbOK],0);
           ExportData := False; Exit;
         End;

  TRY

  WaitDlg.Setup('Please Wait One Moment, Exporting Data');

  Case FCB2.ItemIndex of
    2,1: Begin  {CSV or Tab delim Export}
          Try
             ASSIGNFILE(Outfile,FullFileN);
             Rewrite(Outfile);
          Except
             WaitDlg.Hide;
             Raise EAQUATOXError.Create('Invalid Filename');
          End;

          Try
            With IncomingTable do
              begin
                First;
                Connection.FetchOptions.RecordCountMode := cmTotal;
                Refresh;
                RecNum:=RecordCount;
                For loop:=1 to RecNum do
                  begin
                     If FCB2.ItemIndex=1 then DelimChar := ','
                                         else DelimChar := Chr(9);
                     If hourlymode
                       then Writeln(OutFile,DateTimeToStr(Fields[0].AsDateTime),DelimChar,FloatToStr(Fields[1].AsFloat))
                       else Writeln(OutFile,DateToStr(Fields[0].AsDateTime),DelimChar,FloatToStr(Fields[1].AsFloat));
                     Next;
                  end; {for do}

              end; {with}

          Except
            CloseFile(Outfile);
            WaitDlg.Hide;
            Raise EAQUATOXError.create(Exception(ExceptObject).Message);
          End;

          CloseFile(Outfile);
       End; {CSV Input or Tab Delim}
    0: Begin  {Excel Export}
         TEx := nil;
         Try
            TEx := TExcelOutput.Create(False);
            If Not TEx.OpenFiles
              then TEx := nil
              else
                Begin
                  TEx.WS.Cells.Item[1,1].Value := 'Date:';
                  TEx.WS.Cells.Item[1,2].Value := LoadName.Caption;

                  With IncomingTable do
                    begin
                      Connection.FetchOptions.RecordCountMode := cmTotal;
                      First;
                      Refresh;
                      RecNum:=RecordCount;
                      For loop:=1 to RecNum do
                        begin
                           TEx.WS.Cells.Item[Loop+1,1].Value := Fields[0].AsDateTime;
                           TEx.WS.Cells.Item[Loop+1,2].Value := Fields[1].AsFloat;
                           Next;
                           If ((Loop mod 20) = 0) then WaitDlg.Tease;
                        end; {for do}
                    end; {with}

                  TEx.WS.Range['A1', 'A1'].EntireColumn.AutoFit;
                  If HourlyMode then TEx.WS.Range['A1', 'A1'].EntireColumn.Cells.NumberFormat := 'm/d/yyyy h:mm AM/PM';

                  TEx.FileN := FullFileN;
                  Tex.SaveandClose;
                End;

         Except
            WaitDlg.Hide;
            TRY
             If TEx<>nil then TEx.CloseFiles;
            Except
            END;
            Raise;
         End;
       End; 
   End; {Case}

  FINALLY

  WaitDlg.Hide;
  IncomingTable.Active:=False;

  END;

End;

{---------------------------------------------------------------------}

Function TImportForm.ImportData (FullFileN: AnsiString; Demo: Boolean;
                                 Var Table: TFDTable): Boolean;
{If demo, it only gets the first 10 fields}

Var Infile : TextFile;
    FileDone,FileError,SkipLine,GoodData: Boolean;
    InStr,DateStr,LoadStr,YearStr,MoStr,DayStr : AnsiString;
    i,DelimIndex,Loop, TopLoop,HeaderIndex  : Integer;
    Conv: Double; SheetI, RowI, ColI1, ColI2, Reslt: Integer;
    LoadDate  : TDateTime;
    Intercept, LoadVal   : Double;
    lcid: integer;
    WBk: _WorkBook;
    WS: _Worksheet;
    Excel: _Application;

     Function ConvExcelRow(St: AnsiString): Integer;
     Var Num1,Num2: Integer;
     Begin
       Result := -1;
       If Length(St) = 0 then exit;
       If (St[1] < 'A') or (St[1]>'Z') then exit;
       Num1 := ORD(ST[1])-ORD('A') + 1;
       If Length(St)=1 then begin Result := Num1; exit; end;
       If (St[2] < 'A') or (St[2]>'Z') then exit;
       Num2 := ORD(ST[2])-ORD('A') + 1;
       Result := (Num1*26)+Num2;
       If Result > 255 then Result := -1;
     End;

     Procedure AddEntry(Date:TDateTime; Load: Double);
     Begin
       Try
        With Table do
           Begin
             Append;
             Fields[0].AsDateTime:= Date;
             Fields[1].AsFloat:=Load;
             Post;
             If (Load>1000) or (Load <0.0001) then
                   Begin
                     TFloatField(Fields[1]).DisplayFormat:='0.0000e-00';
                     TFloatField(Fields[1]).DisplayWidth := 10;
                   End;
           End;
       Except
         Table.Delete;
         Raise;
        { Raise EAQUATOXError.Create('There must be no repeated dates in your import data set');}
       End;
     End;

Begin
  If Not Demo then WaitDlg.Setup('Please Wait One Moment, Importing Data');
  If CType = CTTemp then Intercept := -32
                    else Intercept := 0;

  LoadDate:=1; LoadVal:=1;
  FileError:=False;
  GoodData := False;
  Table.Active       := False;
  EmptyTable(Table);

  Table.Active       := True;
  TFloatField(Table.Fields[1]).DisplayFormat:='###0.####';

  Case FCB1.ItemIndex of
    2,1: Begin  {CSV or Tab delim Input}
          Try
           ASSIGNFILE(Infile,FullFileN);
           Reset(Infile);
           i:=0;

           While not EOF(Infile) and not ((i>10) and (demo)) do
             Begin
               Readln(Infile,InStr);

               SkipLine:=False;
               If FCB1.ItemIndex=2 then DelimIndex := Pos(',',Instr)
                                   else DelimIndex := Pos(Chr(9),Instr);
               If (DelimIndex<=1) or (Pos('/',Instr)=0) then SkipLine:=True;

               If Not SkipLine then
                 Begin
                  Try
                   DateStr := Trim(Copy(InStr,1,DelimIndex-1));
                   LoadStr := Trim(Copy(InStr,DelimIndex+1,Length(InStr)-DelimIndex));
                   If FCB1.ItemIndex=2 then DelimIndex := Pos(',',LoadStr)
                                       else DelimIndex := Pos(Chr(9),LoadStr);
                   if DelimIndex>1 then LoadStr := Trim(Copy(LoadStr,1,DelimIndex-1));  //12/2/2016 trim extra columns if present

                   If hourlymode then LoadDate := StrToDatetime(DateStr)
                                 else LoadDate := StrToDate(DateStr);
                   LoadVal  := StrToFloat(LoadStr);
                   If (not demo) and ConvertBox.Checked then LoadVal := (LoadVal+Intercept) * Conversions[CType,UnitsBox.ItemIndex+1];
                   Except
                     SkipLine:=True;
                     If i>0 then Raise EAQUATOXError.create(Exception(ExceptObject).Message);
                   End; {try}
                 End; {if not}

               If Not SkipLine then
                 Begin
                   AddEntry(LoadDate,LoadVal);
                   GoodData:=True;
                   Inc(i);
                   If (Not Demo) and ((i mod 20) = 1) then WaitDlg.Tease;
                 End;
             End;

          If Not GoodData then
            Begin
              If Demo then ErrLabel.Caption := 'No Valid Data could be Found'
                      else Raise EAQUATOXError.create('No Valid Data could be Found');
              FileError:=True;
            End;

          Except
            FileError:=True;
            CloseFile(Infile);
            If Demo then ErrLabel.Caption := Exception(ExceptObject).Message
                    else Raise EAQUATOXError.create(Exception(ExceptObject).Message);
          End;

          CloseFile(Infile);
       End; {CSV Input or Tab Delim}
    0: Begin  {Excel Input}
           If Demo then WaitDlg.Setup('Gathering Sample Data');
           FileDone := False;

           Val(Trim(SheetEdit.Text),Conv,Reslt);
           If Reslt<>0 then Begin
                               SheetI := 1; SheetEdit.Text := '1';
                            End
                        else SheetI:=Trunc(Abs(Conv));

           Val(Trim(RowEdit.Text),Conv,Reslt);
           If Reslt<>0 then Begin
                               RowI := 1; RowEdit.Text := '1';
                            End
                        else RowI:=Trunc(Abs(Conv));

           Val(Trim(DCEdit.Text),Conv,Reslt);
           If Reslt<>0 then Begin
                               ColI1 := ConvExcelRow(Trim(DCEdit.Text));
                               If ColI1<0 then
                                 Begin
                                   ColI1 := 1; DCEdit.Text := 'A';
                                 End;
                            End
                        else ColI1:=Trunc(Abs(Conv));

           Val(Trim(VCEdit.Text),Conv,Reslt);
           If Reslt<>0 then Begin
                               ColI2 := ConvExcelRow(Trim(VCEdit.Text));
                               If ColI2<0 then
                                 Begin
                                   ColI2 := 1; VCEdit.Text := 'B';
                                 End;
                            End
                        else ColI2:=Trunc(Abs(Conv));

           TRY

           lcid := LOCALE_USER_DEFAULT;
           Excel := CoExcelApplication.Create;
           Excel.Visible[lcid] := False;

           WBk := Excel.Workbooks.Open(FullFileN, EmptyParam, EmptyParam, EmptyParam,
                                       EmptyParam, EmptyParam, EmptyParam, EmptyParam, EmptyParam,
                                       EmptyParam, EmptyParam, EmptyParam,  EmptyParam,  LCID);
           WS := WBk.Worksheets.Item[SheetI] as _Worksheet;
           WS.Activate(LCID);

           i:=0;
           loop:=RowI-1; {0}


            While not FileDone and not ((i>10) and (demo)) do
             Begin

               If Not FileDone then
                 Begin
                   Try
                     SkipLine := False;
                     LoadStr  := WS.Cells.Item[loop+1,ColI1].value2;
                     LoadDate := StrToFloat(LoadStr);
                     LoadVal  := StrToFloat(WS.Cells.Item[loop+1,ColI2].value2);
                     If (not demo) and ConvertBox.Checked
                         then LoadVal := (LoadVal+Intercept) * Conversions[CType,UnitsBox.ItemIndex+1];
                   Except
                     If loop>0 then FileDone := True;
                     Inc(Loop);
                     SkipLine := True;
                   End;

                   If Not SkipLine then
                     Begin
                       AddEntry(LoadDate,LoadVal);
                       i:=i+1;
                       GoodData := True;
                       loop := loop+1;
                       If (Not Demo) and ((i mod 20) = 1) then WaitDlg.Tease;
                     End;
                 End;
             End;

          If Not GoodData then
            Begin
              If Demo then ErrLabel.Caption := 'No Valid Data could be Found'
                      else Raise EAQUATOXError.create('No Valid Data could be Found');
              FileError:=True;
            End;

            Wbk.Close(False,EmptyParam,EmptyParam,LCID);


           FINALLY
             WaitDlg.Hide;
             Excel.Quit
           END;
       End; {0}

    3: Begin  {USGS Input}
        Try
         ASSIGNFILE(Infile,FullFileN);
         Reset(Infile);
         i:=0;
         HeaderIndex:= 0;

         While not EOF(Infile) and not ((i>4) and (demo)) do
           Begin
             Readln(Infile,InStr);

             SkipLine:=False;
             If Length(Instr)=0 then Skipline := True;
             If Not SkipLine then if InStr[1]='#' then SkipLine := True;
             If Not SkipLine then Inc(HeaderIndex);
             If HeaderIndex<3 then SkipLine := True;

             DelimIndex:=0;
             If Not SkipLine then
               Begin  {find second tab delimiter}
                 Loop := 0;
                 Repeat
                   Inc(Loop);
                   If Instr[Loop]=CHR(9) then Inc(DelimIndex)
                 Until (Loop=Length(InStr)) or (DelimIndex=2);

                 If Loop=Length(InStr) then SkipLine   := True
                                       else DelimIndex := Loop;
               End;

             If Not SkipLine then
               Begin
                Try
                 YearStr := Trim(Copy(InStr,DelimIndex+1,4));
                 MoStr   := Trim(Copy(InStr,DelimIndex+6,2));
                 DayStr  := Trim(Copy(InStr,DelimIndex+9,2));
                 LoadStr := '';
                 Loop := DelimIndex+12;
                   While (InStr[Loop] <> CHR(9)) and (Loop<=Length(InStr)) do
                     Begin
                       LoadStr := LoadStr + InStr[Loop];
                       Inc(Loop);
                     End;
                 LoadDate := EncodeDate(StrToInt(YearStr),StrToInt(MoStr),StrToInt(DayStr));;
                 LoadVal  := StrToFloat(LoadStr) * SecsPerDay * 0.028317 ;
                                {f3 / s}            {s / d}     {m3/f3}
                 Except
                   SkipLine:=True;
                 End; {try}
               End; {if not}

             If Not SkipLine then
               Begin
                 AddEntry(LoadDate,LoadVal);
                 GoodData:=True;
                 Inc(i);
                 If (Not Demo) and ((i mod 20) = 1) then WaitDlg.Tease;
               End;
           End;

          If Not GoodData then
            Begin
              If Demo then ErrLabel.Caption := 'No Valid Data could be Found'
                      else Raise EAQUATOXError.create('No Valid Data could be Found');
              FileError:=True;
            End;

          Except
            CloseFile(Infile);
            FileError:=True;
            WaitDlg.Hide;
            If Demo then ErrLabel.Caption := Exception(ExceptObject).Message
                    else Raise EAQUATOXError.create(Exception(ExceptObject).Message);
          End;

        CloseFile(Infile);
       End;
   End; {Case}

  WaitDlg.Hide;
  IncomingTable.Active:=False;
  Table.Active := Not FileError;
  ImportData   := Not FileError;
End;


procedure TImportForm.OKBtnClick(Sender: TObject);
begin

end;


{---------------------------------------------------------------------}

procedure TImportForm.Button3Click(Sender: TObject);
begin
  FileEditChange(nil);
end;

Function TImportForm.ChangeLoading(LoadNm: AnsiString; Var Table: TFDTable; WaterData, Hourly: Boolean; CT: ConvertType): Boolean;

Procedure ImpLoad;
Var CanExit:Boolean;
    i: Integer;
Begin
  CType := CT;

  ConvertBox.Visible := (CType <> CTNone);
  UnitsBox.Visible := (CType <> CTNone);
  ConvertToLabel.Visible := (CType <> CTNone);
  ConvertLabel.Visible := False;
  ConvertBox.Checked := False;

  If CType <> CTNone then
    Begin
      UnitsBox.Items.Clear;
      For i := 1 to MaxConversions do
        Begin
          If ConvertFrom[CType,i] <> '' then
            UnitsBox.Items.Add(ConvertFrom[CType,i]);
        End;
      UnitsBox.ItemIndex := 0;
      ConvertToLabel.Caption := 'to '+ConvertTo[CType];
      Unitsbox.Enabled := False;
    End;

  HourlyMode := Hourly;
  If Hourly then ImpTable.TableName := 'LoadHourI';
  OKBtn.Enabled := False;

  IncomingTable.TableName := Table.TableName;

  With FCB1 do
    If WaterData then Filter := 'Excel (*.xls*)|*.xls*|Tab Delimited Text (*.txt)|*.txt|Comma Delim. Text (*.csv)|*.csv|USGS Flow Data (*.*)|*.*'
                 else Filter := 'Excel (*.xls*)|*.xls*|Tab Delimited Text (*.txt)|*.txt|Comma Delim. Text (*.csv)|*.csv';

  ChangeLoading := False;
  LoadName.Caption:=LoadNm;

  Repeat
    CanExit := True;
    If ShowModal = MrOK then
    Case TabbedNotebook1.ActivePageIndex of
     0:  Begin
            ChangeLoading := True;
            If not ImportData(GetFullName,False,Table)
               then Raise EAquatoxError.Create('Import Error');
         End;
     1:  Begin
            If not ExportData(GetFullName)
               then CanExit := False;
         End;
     2:  Begin
           IncomingTable.Active := False;
           EmptyTable(IncomingTable);
         End;
    End; {Case}
  Until CanExit;        
End;

Begin
  Application.CreateForm(TImportForm, ImportForm);
  ImportForm.FDConnection1.Params.DriverID:='SQLite';
  ImportForm.FDConnection1.Params.Database:=Program_Dir + 'ProgramDBs.sdb';

  ImportForm.FDConnection2.Params.DriverID:='SQLite';
  ImportForm.FDConnection2.Params.Database:=Program_Dir + 'ProgramDBs.sdb';

  Self := importForm;
  ImpLoad;
  ImportForm.Free;

End;


procedure TImportForm.ConvertBoxClick(Sender: TObject);
Var Intercept: Double;
begin
  If CType = CTTemp then Intercept := -32
                    else Intercept := 0;

  UnitsBox.Enabled := ConvertBox.Checked;
  Convertlabel.Visible := ConvertBox.Checked;
  If ConvertLabel.Visible then
     ConvertLabel.Caption := '(1 '+ UnitsBox.Text + ' = ' +
         FloatToStrf((1+Intercept) * Conversions[CType,UnitsBox.ItemIndex+1],ffgeneral,9,4) +
         ' '+ConvertTo[CType] +')' ;

end;



{---------------------------------------------------------------------}

Procedure TImportForm.FileEditChange(Sender: TObject);
Var FullName              : AnsiString;
    FileIsThere           : Boolean;
    LoadError             : Boolean;
Begin
  OKBtn.Enabled:=False;

  FullName := GetFullName;

  {Check and see if file exists}
  FileIsThere:=FileExists(FullName);
  If FileIsThere then FileIsThere := Pos('*',FullName)=0;
  If FileIsThere then FileIsThere := Pos('?',FullName)=0;

  If Not FileIsThere then Begin
                            ErrPanel.Visible:=True;
                            ErrLabel.Caption:='No File Has Been Selected';
                            Exit;
                          End;

  LoadError := not ImportData(FullName,True,ImpTable);

  If LoadError then
    Begin
      ErrLabel.Caption := 'Error Reading File';
      ErrPanel.Visible := True;
      OKBtn.Enabled := False;
    End
  else
    Begin
     OKBtn.Enabled:=True;
     ErrPanel.Visible:=False;
    End;

End;

{---------------------------------------------------------------------}
procedure TImportForm.FileEdit2Change(Sender: TObject);
Var FileName: AnsiString;

begin
  FileName := GetFullName;
  ExportButt.Enabled:=True;

  {Check and see if file exists}
  If TRIM(FileEdit2.Text) = '' then ExportButt.Enabled := False;
  If Pos('*',FileName)>0 then ExportButt.Enabled := False;
  If Pos('?',FileName)>0 then ExportButt.Enabled := False;
end;
{---------------------------------------------------------------------}


Procedure TImportForm.FCB1Change(Sender: TObject);
Var datestr: AnsiString;
    datetimeformat: AnsiString;
Begin
  ConvertBox.Visible := (CType <> CTNone) and (FCB1.ItemIndex<>3);
  UnitsBox.Visible := (CType <> CTNone) and (FCB1.ItemIndex<>3);
  ConvertToLabel.Visible := (CType <> CTNone) and (FCB1.ItemIndex<>3);
  ConvertLabel.Visible := (CType <> CTNone) and (FCB1.ItemIndex<>3) and (ConvertBox.Checked);

  If hourlymode then datestr := 'date and time'
                else datestr := 'date';
  With FormatSettings do
  If hourlymode then datetimeformat := FormatSettings.ShortDateFormat+' '+shorttimeformat
                else datetimeformat := FormatSettings.ShortDateFormat;

  NoteBox.Items.Clear;
  ExcelOptPanel.Visible := (FCB1.ItemIndex = 0);

  Case FCB1.ItemIndex of
    0: Begin
         NoteBox.Items.Add('');
         NoteBox.Items.Add('    Excel Data');
         NoteBox.Items.Add('');
         NoteBox.Items.Add('    Column A of the first sheet in ');
         NoteBox.Items.Add('    the workbook should hold the');
         NoteBox.Items.Add('    '+datestr+'.  Column B should');
         NoteBox.Items.Add('    hold data to be imported.  (Or, ');
         NoteBox.Items.Add('    specify row, col, sheet below)');
       End;
    1: Begin
         NoteBox.Items.Add('');
         NoteBox.Items.Add('    Tab Delimited Text');
         NoteBox.Items.Add('');
         NoteBox.Items.Add('    Each line of the text file must');
         NoteBox.Items.Add('    have a unique '+datestr+' entry');
         NoteBox.Items.Add('    in the form '+datetimeformat);
         NoteBox.Items.Add('    followed by a tab character,');
         NoteBox.Items.Add('    then a loading entry in the');
         NoteBox.Items.Add('    appropriate units.');
       End;
    2: Begin
         NoteBox.Items.Add('');
         NoteBox.Items.Add('    Comma Delimited Text');
         NoteBox.Items.Add('');
         NoteBox.Items.Add('    Each line of the text file must');
         NoteBox.Items.Add('    have a unique '+datestr+' entry');
         NoteBox.Items.Add('    in the form '+datetimeformat);
         NoteBox.Items.Add('    followed by a comma character,');
         NoteBox.Items.Add('    then a loading entry in the');
         NoteBox.Items.Add('    appropriate units.');
       End;
    3: Begin
         NoteBox.Items.Add('');
         NoteBox.Items.Add('   USGS Flow Data');
         NoteBox.Items.Add('');
         NoteBox.Items.Add('   Save USGS Daily Streamflow');
         NoteBox.Items.Add('   data (http://water.usgs.gov/)');
         NoteBox.Items.Add('   as a tab separated file ');
         NoteBox.Items.Add('   with date format YYYY-MM-DD. ');
         NoteBox.Items.Add('   Data will be converted from ');
         NoteBox.Items.Add('   cu.ft./sec to cu.m/day');
       End;
  End;
End;

procedure TImportForm.HelpButtonClick(Sender: TObject);
begin
  HTMLHelpContext('Import_and_Export_Loadings');
end;

procedure TImportForm.FCB2Change(Sender: TObject);
Var datestr: AnsiString;
    datetimeformat: AnsiString;
Begin
  If hourlymode then datestr := 'date and time'
                else datestr := 'date';
  With FormatSettings do
  If hourlymode then datetimeformat := FormatSettings.ShortDateFormat+' '+shorttimeformat
                else datetimeformat := FormatSettings.ShortDateFormat;

  ListBox1.Items.Clear;

  Case FCB2.ItemIndex of
    1: Begin
         ListBox1.Items.Add('');
         ListBox1.Items.Add('    Comma Delimited Text');
         ListBox1.Items.Add('');
         ListBox1.Items.Add('    Each line of the text file will');
         ListBox1.Items.Add('    have a unique date entry in the');
         ListBox1.Items.Add('    form '+datetimeformat);
         ListBox1.Items.Add('    followed by a comma, then');
         ListBox1.Items.Add('    a loading entry for that '+datestr);
       End;
    2: Begin
         ListBox1.Items.Add('');
         ListBox1.Items.Add('    Tab Delimited Text');
         ListBox1.Items.Add('');
         ListBox1.Items.Add('    Each line of the text file will');
         ListBox1.Items.Add('    have a unique date entry in the');
         ListBox1.Items.Add('    form '+datetimeformat);
         ListBox1.Items.Add('    followed by a tab character, then');
         ListBox1.Items.Add('    a loading entry for that '+datestr);
       End;
    0: Begin
         ListBox1.Items.Add('');
         ListBox1.Items.Add('    Excel Data');
         ListBox1.Items.Add('');
         ListBox1.Items.Add('    Column A of the first sheet in ');
         ListBox1.Items.Add('    the workbook will hold the');
         ListBox1.Items.Add('    '+datestr+'.  Column B will');
         ListBox1.Items.Add('    hold the exported data. ');
       End;
  End;

End;


procedure TImportForm.FormShow(Sender: TObject);
begin
  FCB1change(nil);
  FCB2Change(nil);
  FileEdit2Change(nil);
end;

function TImportForm.GetFullName: AnsiString;
Var Dir,FileName: AnsiString;
begin
  Case TabbedNotebook1.ActivePageIndex of
    0: Begin
        FileName:=FileEdit.Text;
        Dir:=DirectoryListBox1.Directory;
       End;
    1: Begin
        FileName:=FileEdit2.Text;
        Dir:=DirectoryListBox2.Directory;
       End;
  End;

  If Pos(':',FileName)>0 then Result := FileName
                         else Result := Dir+'\'+FileName;  // 12/2/2016 allow specification of full name in box, bypassing directory selection
  While Pos('\\',Result)>0 do
     Delete(Result,Pos('\\',Result),1);
end;

procedure TImportForm.TabbedNotebook1Change(Sender: TObject);
begin
  If TabbedNotebook1.ActivePageIndex>0 then
                    Begin
                     DBGrid2.Visible := True;
                     IncomingTable.Active := True;
                     TFloatField(IncomingTable.Fields[1]).DisplayFormat:='###0.####';
                     TFloatField(IncomingTable.Fields[1]).DisplayWidth := 14;
                    End
              else Begin
                     DBGrid2.Visible := False;
                     IncomingTable.Active := False;
                   End;

end;



End.
