//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
//
unit Initcond;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Global, Aquaobj, StdCtrls, AQSTUDY, AQBaseForm,
  FireDAC.Comp.Client,   Grids, DBGrids, DB,  ExtCtrls, Buttons, AQSite,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.UI.Intf,
  FireDAC.Stan.Def, FireDAC.Stan.Pool, FireDAC.Phys, FireDAC.Phys.SQLite,
  FireDAC.Phys.SQLiteDef, FireDAC.Stan.ExprFuncs, FireDAC.VCLUI.Wait;

type
  TInitCondForm = class(TAQBase)
    DataSource1: TDataSource;

    Table1: TFDTable;
    Panel1: TPanel;
    Label3: TLabel;
    OKBtn: TBitBtn;
    DbGrid1: TDBGRID;
    HelpButton: TButton;
    PlantExportButt: TButton;
    FDConnection1: TFDConnection;
    procedure Table1BeforeInsert(DataSet: TDataset);
    procedure HelpButtonClick(Sender: TObject);
    procedure PlantExportButtClick(Sender: TObject);
  private
    Insertable: Boolean;
    { Private declarations }
  public
    FileN: AnsiString;
    Procedure Show_Init_Conds(SV: TStates; FileName: AnsiString);
  end;

var
  InitCondForm: TInitCondForm;

implementation

Uses Grid2Excel, hh;

procedure TInitCondForm.PlantExportButtClick(Sender: TObject);
begin
  DBGrid2Excel(TDBGrid(DBGrid1), FileN +  '_Init_Conds.xls',True)
end;

Procedure TInitCondForm.Show_Init_Conds(SV: TStates; FileName: AnsiString);

Var SVLoop, TestVar: AllVariables;
    TypLoop: T_SVType;
    PreText: AnsiString;
    SVptr  : TStateVariable;
    i, FieldIndex: Integer;


          Procedure AddtoDB(p: TStateVariable);
          {Add one state variable to the database of Init Conds}
          Begin
           With Table1 do
           Begin
             If P.SVType= StV then
               Begin
                 Append;
                 Fields[0].AsAnsiString :=OutputText(P.nstate,P.SVType,P.layer,SV.UniqueName(P.NState),False,False,0);
               End;

             Inc(FieldIndex);
             Fields[FieldIndex].AsFloat  :=p.InitialCond;
             If (p.InitialCond < 0.0001) and (P.InitialCond > tiny) then TFloatField(Table1.Fields[1]).DisplayFormat:='0.0000e-00';
             Inc(FieldIndex);
             Fields[FieldIndex].AsAnsiString :=P.StateUnit;
           End; {with}
          End;


Begin
 FileN := FileName;
 Insertable:=True;
 With InitCondForm.Table1 do
  begin
     Active:=False;
     FDConnection1.Params.DriverID:='SQLite';
     FDConnection1.Params.Database:=Program_Dir + 'ProgramDBs.sdb';

     TableName:='InitCond';
     FieldDefs.Clear;
     IndexDefs.Clear;
     FieldDefs.Add('State Variable Name',ftString,28,False);
     FieldDefs.Add('Init. Cond.',ftFloat,0,False);
     FieldDefs.Add('Units',ftString,12,False);

     For TypLoop := FirstToxTyp to LastToxTyp do
       Begin
         Case TypLoop of
           FirstOrgTxTyp..LastOrgTxTyp: PreText :='Tox'+ IntToStr(Ord(TypLoop));
         end; {case}

         TestVar := AssocToxSV(TypLoop);

         SVPtr:=SV.GetStatePointer(TestVar,StV,WaterCol);
         If SVPtr <> nil then
           Begin
             FieldDefs.Add(PreText+' I. C.',ftFloat,0,False);
             FieldDefs.Add(PreText+' Units',ftString,12,False);
           End;
       End; {TypLoop}

     CreateTable;
     Active:=True;

    TFloatField(Table1.Fields[1]).DisplayFormat:='###0.####';
    For SVloop:= FirstState to LastState do
     Begin
      FieldIndex := 0;
       For TypLoop := StV to LastOrgTxTyp do
        Begin
          SVPtr := SV.GetStatePointer(SVLoop,TypLoop,WaterCol);
          If not (SVPtr = nil) then AddtoDB(SVPtr);
        End;
     End;

    For i := 0 to FieldCount - 1 do
      If i mod 2 = 0 then
        Fields[i].ReadOnly:=True;

    First;

  End; {with initcondtable}

  Insertable:=False;

  InitCondForm.WindowState:=WSMaximized;
  If InitCondForm.ShowModal = MrCancel then exit;


end;


{$R *.DFM}


procedure TInitCondForm.Table1BeforeInsert(DataSet: TDataset);
begin
   If not Insertable then Raise EAquatoxError.Create('No Insertions or Deletions may be made.');
end;

procedure TInitCondForm.HelpButtonClick(Sender: TObject);
begin
  HTMLHelpContext('InitialConds');
end;

end.

