//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
// 
unit Librarys;

interface

uses
  Global,SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl, Finddlg,  DB,  SV_IO, AQBaseform,FireDAC.Comp.Client,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.UI.Intf,
  FireDAC.Stan.Def, FireDAC.Stan.Pool, FireDAC.Phys, FireDAC.VCLUI.Wait;

type
  TLibrary_File = class(TAQBase)
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    OK_Button: TButton;
    Cancel_Button: TButton;
    SaveTable: TFDTable;
    FileEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    EntryList: TListBox;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    FDConnection1: TFDConnection;
    procedure OK_ButtonClick(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure Cancel_ButtonClick(Sender: TObject);
    procedure FileEditChange(Sender: TObject);
    procedure OKDisable(Sender: TObject);
    procedure FileListBox1DblClick(Sender: TObject);
    procedure EntryListClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    DefaultTName, TableN,FileN: AnsiString;
    Procedure UpdateTableList;
    Function Transfer_TempFile(NFile: AnsiString;TOTEMP:Boolean):Boolean;
    Function SaveToLibrary(TableN2: AnsiString; Var InTable: TFDTable; Var ReturnFileN: AnsiString; Indx: Integer):Boolean;
  end;

var
  Library_File: TLibrary_File;

implementation

uses System.UITypes;

Function TLibrary_File.Transfer_TempFile(NFile: AnsiString; ToTemp:Boolean):Boolean;
{This Procedure transfers the selected Database to a Temporary File, so
Changes can be accepted or rejected..  If TOTEMP is true, the transfer
is to the temporary file, if TOTEMP is false, the transfer is back to
the original database}

Var SourceN,DestinationN: AnsiString;
    Copy_OK: Boolean;

Begin
  IF TOTEMP THEN  BEGIN  SourceN  := NFile;
                         DestinationN:=Program_Dir+'tempedit';
                         Copy_OK:=AQTCopyFile(SourceN,DestinationN+'.db');
                         If not Copy_OK then
                            MessageDlg('Unable to create temporary database file',mterror,[mbOK],0)
                   END
            ELSE   BEGIN DestinationN:=NFile;
                         SourceN:=Program_Dir+'tempedit';
                         Copy_OK:=AQTCopyFile(SourceN+'.db',DestinationN);
                         If not Copy_OK then
                            MessageDlg('Unable to update Library Database, Your Changes are in TEMPFILE.DB.',mterror,
                                              [mbOK],0)
                   END;

   Transfer_TempFile:=Copy_OK;

end;

procedure TLibrary_File.UpdateTableList;
begin
   FileN := FileEdit.Text;
   if Not FileExists(FileN) then
     Begin
       EntryList.Items.Clear;
       OK_Button.Enabled := False;
       Exit;
     End;

   OK_Button.Enabled := True;

   FDConnection1.Params.DriverID:='SQLite';
   FDConnection1.Params.Database:=FileEdit.Text;
   FDConnection1.GetTableNames('', '', '', EntryList.Items);
   FDConnection1.Connected := False;
  {}
end;

{Transfer_TempFile}


{$R *.DFM}


Function TLibrary_File.SaveToLibrary(TableN2: AnsiString; Var InTable: TFDTable;Var ReturnFileN: AnsiString; Indx: Integer):Boolean;

Var SmallFilter: AnsiString;
    FileisThere, Success: Boolean;
    ShortFileN,
    InDbName: AnsiString;
    KeyStr, KeyStr2: AnsiString;
    ChemRecHolder: ChemicalRecord;
    AnimRecHolder: ZooRecord;
    PlantRecHolder: PlantRecord;
    ReminRecHolder: ReminRecord;
    SiteRecHolder:  SiteRecord;
    i: Integer;

Begin
  SaveToLibrary:=False;
  Application.CreateForm(TLibrary_File, Library_File);

  KeyStr := InTable.Fields[0].AsAnsiString;

  FileN := Default_Dir + 'AQUATOX.SDB';
  TableN := '';
  FDConnection1.Params.DriverID:='SQLite';
  FDConnection1.Params.Database:='ProgramDBs.sdb';
  FileEdit.Text := FileN;

  Caption:=DefaultTName+' Library:';
  RadioButton1.Caption:='Default Table: '+DefaultTName;
  RadioButton1.Checked:=True;

  ShowModal;
  If FileN='Default' then FileN:=Default_Dir+'AQUATOX.sdb';
  If FileN='Cancel' then Exit;

  {Check and see if file exists}
  FileIsThere:=FileExists(FileN);
  If Not FileIsThere then Begin
                            MessageDlg('Database File Not Found: '+FileN,MtError,[mbOK],0);
                            Exit;
                          End;

  FDConnection1.Params.DriverID:='SQLite';
  FDConnection1.Params.Database:=FileN;

  if (TableN <> '') then TableN2 := TableN;

  With SaveTable do
    Begin
      TableName    := TableN2;
      Active       := True;
    End;

  KeyStr := InTable.Fields[0].AsAnsiString;
  If Indx > 0 then KeyStr2 := '' else KeyStr2 := KeyStr;

  If (SaveTable.FindKey([KeyStr]))
    then Begin
           If MessageDlg('The entry "'+KeyStr+'" already exists in that Database.  Overwrite?',MtConfirmation,[mbYes,mbNo],0) = mrno
              then
                Begin
                  MessageDlg('No data have been written to the Library.  Change the name of your entry and save again if you wish.',MtInformation,[mbOK],0);
                  SaveTable.Active:=False;
                  Exit;
                End
              else SaveTable.Delete;
         End
    else
         Begin
           SaveTable.Insert;
           SaveTable.Fields[0].AsAnsiString := KeyStr;
           SaveTable.Post;
         End;

  SaveTable.Active:=False;
  SaveTable.Connection.Connected := False;

  If InTable.State in [dsedit,dsinsert] then InTable.Post;
  InTable.Active:=False;
  InDBName := InTable.Connection.Params.Database;

  Success := True;
  Case TableN2[1] of
   'C': Begin   {Chemical}
         Success := Dbase_to_ChemRecord2(InDBName,InTable.TableName,KeyStr2,Indx,ChemRecHolder);
         Success := ChemRecord_to_DBase2(FileN,SaveTable.TableName,KeyStr,ChemRecHolder,False);
         {Toxicity data is copied in CHEM.PAS}
        End;
   'A': Begin  {Animal}
         Success := Dbase_to_AnimalRecord2(InDBName,InTable.TableName,KeyStr2,Indx,AnimRecHolder);
         Success := AnimalRecord_to_DBase2(FileN,SaveTable.TableName,KeyStr,AnimRecHolder,False);
        End;
   'P': Begin  {Plant}
         Success := Dbase_to_PlantRecord2(InDBName,InTable.TableName,KeyStr2,Indx,PlantRecHolder);
         Success := PlantRecord_to_DBase2(FileN,SaveTable.TableName,KeyStr,PlantRecHolder,False);
        End;
   'S': Begin  {Site}
         Success := Dbase_to_SiteRecord2(InDBName,InTable.TableName,KeyStr,SiteRecHolder);
         Success := SiteRecord_to_DBase2(FileN,SaveTable.TableName,KeyStr,SiteRecHolder,False);
        End;
   'R': Begin  {Remineralization}
         Success := Dbase_to_ReminRecord2(InDBName,InTable.TableName,KeyStr,ReminRecHolder);
         Success := ReminRecord_to_DBase2(FileN,SaveTable.TableName,KeyStr,ReminRecHolder,False);
        End;
  End; {Case}


  InTable.Active:=True;

  If Indx>0 then
    Begin
      InTable.First;
      For i := 2 to Indx do
        InTable.Next;
    End;


  If Success then MessageDlg('Data successfully written to the Library.',MtInformation,[mbOK],0)
             else MessageDlg('File write error writing to '+SaveTable.TableName,MtError,[mbOK],0);

  ReturnFileN := FileN;
  SaveToLibrary := Success;
End;

{************************************************************************}
{****** THE REST OF THE PROCEDURES ARE SCREEN BUTTON-CLICK METHODS ******}
{************************************************************************}

procedure TLibrary_File.OK_ButtonClick(Sender: TObject);
begin
  If RadioButton1.Checked then FileN:='Default'
                          else FileN:=FileEdit.Text;

end;

procedure TLibrary_File.RadioButton2Click(Sender: TObject);
begin
   Height:=392;
   OK_BUTTON.Enabled:=FileExists(fileedit.text);
   if OK_Button.Enabled then UpdateTableList;

   {Enable OK button only if file exists}
end;

procedure TLibrary_File.RadioButton1Click(Sender: TObject);
begin
   Height:=100;
   Update;
   OK_Button.Enabled:=True;

   FileN := Default_Dir + 'AQUATOX.SDB';
   TableN := DefaultTName;

end;

procedure TLibrary_File.Button1Click(Sender: TObject);
begin
  OpenDialog1.InitialDir := Default_Dir;
  OpenDialog1.Title := 'Select the SQLite File to read from';
  OpenDialog1.Filter := 'SQLite files (*.sdb)|*.SDB|All files (*.*)|*.*';
  If not OpenDialog1.Execute then Exit;
  FileEdit.Text := OpenDialog1.FileName;
  UpdateTableList;
end;

procedure TLibrary_File.Cancel_ButtonClick(Sender: TObject);
begin
     FileN:='Cancel';
end;

procedure TLibrary_File.EntryListClick(Sender: TObject);
begin
  If EntryList.ItemIndex >= 0 then TableN := EntryList.items[EntryList.itemindex]
end;

procedure TLibrary_File.FileEditChange(Sender: TObject);
begin
  UpdateTableList;
end;

procedure TLibrary_File.OKDisable(Sender: TObject);
begin
     OK_BUTTON.Enabled:=False;
end;

procedure TLibrary_File.FileListBox1DblClick(Sender: TObject);
{Accept double click on file name if appropriate}
begin
    if OK_Button.Enabled then begin
                                FileN:=FileEdit.Text;
                                ModalResult:=MROK;
                              end;
end;

end.
