//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
//
unit Librarys2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Chem,
  Site,Plant,Animal,Remin, StdCtrls, FileCtrl, Global, DB, AQBaseform,
   librarys, FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client,
  FireDAC.UI.Intf, FireDAC.Stan.Def, FireDAC.Stan.Pool, FireDAC.Phys,
  FireDAC.VCLUI.Wait;

type
  TLibrary_File1 = class(TLibrary_File)
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure OK_ButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
     DBFileN: AnsiString;
     Procedure EditLibrary(DefaultTName: AnsiString);
     Function ReturnDBName(DefaultTName:AnsiString; Var DBNm,TableNm: AnsiString): Boolean;
    { Public declarations }
  end;

var
  Library_File1: TLibrary_File1;


implementation

uses EstKPSed, ChemTox, ec50lc50, regress, StreamFrm, PFAK2s, System.UITypes;



procedure TLibrary_File1.RadioButton1Click(Sender: TObject);
begin
   FileN := Default_Dir + 'AQUATOX.SDB';
   Library_File1.Height:=100;

end;

procedure TLibrary_File1.RadioButton2Click(Sender: TObject);
begin
   Library_File1.Height:=392;
   inherited;
end;

Function TLibrary_File1.ReturnDBName(DefaultTName:AnsiString; Var DBNm,TableNm: AnsiString): Boolean;
Var  smallfilter: AnsiString;
Begin
    FileN := Default_Dir + 'AQUATOX.SDB';
    FDConnection1.Params.DriverID:='SQLite';
    FDConnection1.Params.Database:='ProgramDBs.sdb';
    FileEdit.Text := FileN;

    {ENABLE DIALOG BOX TO FIND LOCATION OF LIBRARY FILE}
     Caption:=DefaultTName+' Library:';
     RadioButton1.Caption:='Default Table: '+DefaultTName;
     RadioButton1.Checked:=True;
     ShowModal;
     Hide;

    ReturnDBName := False;
    if FileN='Cancel' then exit;

    ReturnDBName := True;
    DBNm := FileN;
    if TableN <> '' then TableNm := TableN;
    If FileN='Default' then begin  DBNm:=Default_Dir + 'AQUATOX.SDB';
                                   TableNm:=DefaultTName;
                            end;
End;


Procedure TLibrary_File1.EditLibrary(DefaultTName: AnsiString);
{This code provides the interface between the main program and the edit
library fields by asking the user to select the appropriate database and
calling the right form to modify that database}

Var modalresult: integer;

Begin
    FileEdit.Text := FileN;

    modalresult:=mrcancel;

    {ENABLE DIALOG BOX TO FIND LOCATION OF LIBRARY FILE}
    FileN := Default_Dir + 'AQUATOX.SDB';
    FDConnection1.Params.DriverID:='SQLite';
    FDConnection1.Params.Database:=FileN;
    FileEdit.Text := FileN;

    Caption:=DefaultTName+' Library:';
    RadioButton1.Caption:='Default: '+DefaultTName;
    RadioButton1.Checked:=True;
    TableN := '';
    ShowModal;
    Hide;

    if FileN='Cancel' then exit;
    If FileN='Default' then begin  TableN := DefaultTName;
                                   FileN  := Default_Dir+'AQUATOX.SDB';
                            end;
    if TableN = '' then TableN := DefaultTName;


    If not Library_File.Transfer_TempFile(FileN,True) then exit;
            {Transfer, if not successful, exit}

    Try
    Case DefaultTName[1] of
         'C': Begin   {Chemical}
                Application.CreateForm(TEdit_Chemical, Edit_Chemical);
                Application.CreateForm(TKPSedConfirm, KPSedConfirm);
                Application.CreateForm(TPFAK2Form, PFAK2Form);
                Application.CreateForm(TChemToxForm, ChemToxForm);
                Application.CreateForm(TEC50LC50Dialog, EC50LC50Dialog);
                Application.CreateForm(TRegrDialog, RegrDialog);
                Edit_Chemical.PLipidModified := Nil;
                Edit_Chemical.Table1.Active:=False;
                Edit_Chemical.Table1.TableName:=TableN;
                Edit_Chemical.Table1.UpdateOptions.UpdateTableName:=TableN;
                Edit_Chemical.FDConnection1.Params.Database:=Program_Dir+'tempedit.db';
                Edit_Chemical.Table1.Active:=True;
                Edit_Chemical.LibraryMode := True;
                ModalResult:=Edit_Chemical.ShowModal;
                Edit_Chemical.Hide;
                Edit_Chemical.Free;
                KPSedConfirm.Free;
                PFAK2Form.Free;
                ChemToxForm.Free;
                EC50LC50Dialog.Free;
                RegrDialog.Free;
              End;
         'A': Begin  {Animal}
                Application.CreateForm(TEdit_Animal, Edit_Animal);
                Edit_Animal.Table2.Active:=False;
                Edit_Animal.Table2.TableName:=TableN;
                Edit_Animal.Table2.UpdateOptions.UpdateTableName:=TableN;
                Edit_Animal.FDConnection1.Params.Database:=Program_Dir+'tempedit.db';
                Edit_Animal.Table2.Active:=True;
                Edit_Animal.OrigDBDir := ExtractFileDir(FileN);
                Edit_Animal.MultiFish := False;
                Edit_Animal.YOYFish := False;
                Edit_Animal.LibraryMode := True;
                Edit_Animal.EditAllLinks.Visible := False;
                ModalResult:=Edit_Animal.ShowModal;
                Edit_Animal.Hide;
                Edit_Animal.Free;
              End;
         'P': Begin  {Plant}
                Application.CreateForm(TEdit_Plant, Edit_Plant);
                edit_plant.PlantTable.Active:=False;
                edit_plant.PlantTable.TableName:=TableN;
                edit_plant.PlantTable.UpdateOptions.UpdateTableName:=TableN;
                edit_plant.FDConnection1.Params.Database:=Program_Dir+'tempedit.db';
                edit_plant.PlantTable.Active:=True;
                Edit_plant.LibraryMode := True;
                Edit_plant.EditAllLinks.Visible := False;
                ModalResult:=edit_plant.ShowModal;
                Edit_Plant.Hide;
                edit_plant.Free;
              End;
          'S': Begin    {Site}
                Application.CreateForm(TEdit_site, Edit_site);
                Application.CreateForm(TStreamform, Streamform);
                edit_site.Table2.Active:=False;
                edit_site.Table2.TableName:=TableN;
                edit_site.Table2.UpdateOptions.UpdateTableName:=TableN;
                edit_site.FDConnection1.Params.Database:=Program_Dir+'tempedit.db';
                edit_site.Table2.Active:=True;
                edit_site.Libmode := True;
                ModalResult:=edit_site.ShowModal;
                Edit_site.Hide;
                edit_site.Free;
                StreamForm.Free;
              End;
           'R': Begin    {Remineralization}
                Application.CreateForm(TRemineralization, Remineralization);
                Remineralization.Table1.Active:=False;
                Remineralization.Table1.TableName:=TableN;
                Remineralization.Table1.UpdateOptions.UpdateTableName:=TableN;
                Remineralization.FDConnection1.Params.Database:=Program_Dir+'tempedit.db';
                Remineralization.Table1.Active:=True;
                ModalResult:=Remineralization.ShowModal;
                Remineralization.Hide;
                Remineralization.Free;
              End;
    End; {Case}

    Except
        on E : Exception do
          Begin
           MessageDlg('You must open an AQUATOX table of the correct type. (One that includes all relevant fields).',mterror,[mbOK],0);
           ShowMessage('Error detail : '+E.Message);
          End;
    end;  {try Except}

 If ModalResult=MROK then Library_File.Transfer_TempFile(FileN,False);

End;



procedure TLibrary_File1.OK_ButtonClick(Sender: TObject);
begin
  inherited;
end;

{$R *.DFM}

end.
