//AQUATOX SOURCE CODE Copyright (c) 2005-2017 Eco Modeling and Warren Pinnacle Consulting, Inc.
//Code Use and Redistribution is Subject to Licensing, SEE AQUATOX_License.txt
// 
unit Wiz_DBEntry;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Db,  Global, notused, aqbaseform, FireDAC.Comp.Client,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.UI.Intf,
  FireDAC.Stan.Def, FireDAC.Stan.Pool, FireDAC.Phys, FireDAC.Phys.SQLite,
  FireDAC.Phys.SQLiteDef, FireDAC.Stan.ExprFuncs, FireDAC.VCLUI.Wait;

type
  TWiz_GetEntry = class(TAQBase)
    EntryList: TListBox;
    Header: TLabel;
    Table1: TFDTable;
    OKBtn: TButton;
    Bevel1: TBevel;
    FDConnection1: TFDConnection;
    procedure HelpBtnClick(Sender: TObject);
    procedure EntryListClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations } 
  public
    Entry: AnsiString;
    Function GetEntry(FC: Word): Boolean;
    Procedure UpdateScreen;
    { Public declarations }
  end;

Var
  FishClass: Word;
 {FishClass=0: forage, FC=1: bottom, FC=2: game, FC=3: all}

  Wiz_GetEntry: TWiz_GetEntry;

implementation

{$R *.DFM}

Procedure TWiz_GetEntry.UpdateScreen;
Var RecNum, Loop: Integer;
    Holder: AnsiString;
    IncludeFish: Boolean;
Begin
   EntryList.Items.Clear;
   FDConnection1.Params.Database := Default_Dir+'AQUATOX.sdb';
   Table1.TableName:='Animal';

  Try
     Table1.Active:=True;
     With Table1 do begin
        Connection.FetchOptions.RecordCountMode := cmTotal;
        Refresh;
        First;
        RecNum:=RecordCount;
        If RecNum>0 then
           For loop:=1 to RecNum do
               begin
                 Holder:=Fields[0].AsAnsiString;
                 Case FishClass of
                   0: {forage} IncludeFish := (FieldByName('GuildTaxa').AsAnsiString = 'Forage Fish');
                   1: {bottom} IncludeFish := (FieldByName('GuildTaxa').AsAnsiString = 'Bottom Fish');
                   2: {game  } IncludeFish := (FieldByName('GuildTaxa').AsAnsiString = 'Game Fish');
                   else {all } IncludeFish := (Pos('Fish',FieldByName('GuildTaxa').AsAnsiString)>0);
                 End; {Case}
                 If IncludeFish then EntryList.Items.Add(Holder);
                 Next;
               end; {for do loop}
        EntryList.Update;
     end; {with}
  Except
  End;
  Table1.Active:=False;

End;

Function TWiz_GetEntry.GetEntry(FC: Word): Boolean;
 {FC=0: forage, FC=1: bottom, FC=2: game, FC=3: all}

Begin
   FishClass := FC;
   OKBtn.Enabled := False;
   EntryList.ItemIndex := -1;
   GetEntry:=False;
   UpdateScreen;
   If Showmodal = Mrok then GetEntry:=True;
End;


procedure TWiz_GetEntry.HelpBtnClick(Sender: TObject);
begin
  Application.HelpContext(HelpContext);
end;

procedure TWiz_GetEntry.EntryListClick(Sender: TObject);
begin
   If (EntryList.ItemIndex=-1)
     then OKBtn.Enabled:=False
     else OkBtn.Enabled:=EntryList.Items.Strings[EntryList.ItemIndex]<>'';
end;

procedure TWiz_GetEntry.OKBtnClick(Sender: TObject);
begin
  Entry:=EntryList.Items.Strings[EntryList.ItemIndex];
end;

end.

