function [battery] = battery_pack_NMC_58kWh()

% Based on https://doi.org/10.1016/j.etran.2022.100167
% Quantifying the state of the art of electric powertrains in battery electric vehicles:
% Range, efficiency, and lifetime from component to system level of the Volkswagen ID.3

battery = class_REVS_battery;

battery.cell.chemistry             = enum_battery_type.NiMH;
battery.cell.capacity_nominal_Ah   = 78;

battery.num_parallel_cells              = 2;
battery.num_series_cells                = 12*9;
battery.use_average_open_circuit_Volts  = true;

battery.initial_soc_norm   = 0.87;
%% Charge and discharge limits are based on cells tuned for Model 3
battery.cell.powerlimit_discharge_map_W.axis_1.signal = 'temp_degC';
battery.cell.powerlimit_discharge_map_W.axis_1.breakpoints = [-30 -20 -10 0 10 20 30 40];
battery.cell.powerlimit_discharge_map_W.axis_2.signal = 'soc_norm';
battery.cell.powerlimit_discharge_map_W.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
battery.cell.powerlimit_discharge_map_W.table  = [67 79 85 93 110 118 131 135 136 140;
                                                           118 132 145 190 224 264 300 332 348 363;
                                                           187 223 308 391 486 536 573 573 580.5 588;
                                                           308 386 445 534 587 608 630 648 658 671;
                                                           643 681 690 696 702 718 732 738.5 745 745;
                                                           730.81 774 782.5 791 803 812 820 832 833.5 835;
                                                           770.47 816 821 826 835 841 847 858 860 860;
                                                           789 836 841 846 851 855 866 877 880 880];
                                                       
battery.cell.powerlimit_charge_map_W.axis_1.signal = 'temp_degC';
battery.cell.powerlimit_charge_map_W.axis_1.breakpoints = [-30 -20 -10 0 10 20 30 40];
battery.cell.powerlimit_charge_map_W.axis_2.signal = 'soc_norm';
battery.cell.powerlimit_charge_map_W.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
battery.cell.powerlimit_charge_map_W.table     = [15 15 15 15 15 15 0 0 0 0;
                                                           37 37 37 37 37 37 37 37 37 37;
                                                           190 183 180.5 179.25 178 175 172 164 157 157;
                                                           439 404 387 370 368 367 366 343 334 321;
                                                           729 689 668 634 633 632 559 466 372 372;
                                                           1051 1044 990 978 972 966 931 838 745 698;
                                                           1117 1117 1117 1117 1117 1024 931 838 745 698;
                                                           1117 1117 1117 1117 1117 1024 931 838 745 698];
%%
battery.cell.open_circuit_voltage_map_discharge_V.axis_1.signal = 'temp_degC';
battery.cell.open_circuit_voltage_map_discharge_V.axis_1.breakpoints = [0 20 40];
battery.cell.open_circuit_voltage_map_discharge_V.axis_2.signal = 'soc_norm';
battery.cell.open_circuit_voltage_map_discharge_V.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
battery.cell.open_circuit_voltage_map_discharge_V.table =      [3.4041 3.4897 3.5696 3.5967 3.6435 3.7204 3.8316 3.9446 4.0528 4.1703
                                                                3.4041 3.4897 3.5696 3.5967 3.6435 3.7204 3.8316 3.9446 4.0528 4.1703
                                                                3.4041 3.4897 3.5696 3.5967 3.6435 3.7204 3.8316 3.9446 4.0528 4.1703];
                                                                         

battery.cell.open_circuit_voltage_map_charge_V.axis_1.signal = 'temp_degC';
battery.cell.open_circuit_voltage_map_charge_V.axis_1.breakpoints = [0 20 40];
battery.cell.open_circuit_voltage_map_charge_V.axis_2.signal = 'soc_norm';
battery.cell.open_circuit_voltage_map_charge_V.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
battery.cell.open_circuit_voltage_map_charge_V.table =        [3.4399 3.5513 3.6115 3.6493 3.6907 3.7811 3.8806 3.9879 4.0928 4.1923
                                                                3.4399 3.5513 3.6115 3.6493 3.6907 3.7811 3.8806 3.9879 4.0928 4.1923
                                                                3.4399 3.5513 3.6115 3.6493 3.6907 3.7811 3.8806 3.9879 4.0928 4.1923];

%%

battery.cell.resistance_map_discharge_Ohms.axis_1.signal = 'temp_degC';
battery.cell.resistance_map_discharge_Ohms.axis_1.breakpoints = [0 20 40];
battery.cell.resistance_map_discharge_Ohms.axis_2.signal = 'soc_norm';
battery.cell.resistance_map_discharge_Ohms.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
battery.cell.resistance_map_discharge_Ohms.table      = 1e-3.*[3.3582 3.3582    3.1521    3.0998    3.1091    3.2094    3.0851    3.0672    3.0613   3.0613 ;
                                                               1.9974 1.9974    1.8558    1.8465    1.8571    1.9406    1.8799    1.8572    1.8670   1.8670 ;
                                                               1.5759 1.5759    1.4962    1.4792    1.5061    1.6074    1.5304    1.5309    1.5413   1.5413];

battery.cell.resistance_map_charge_Ohms.axis_1.signal = 'temp_degC';
battery.cell.resistance_map_charge_Ohms.axis_1.breakpoints = [0 20 40];
battery.cell.resistance_map_charge_Ohms.axis_2.signal = 'soc_norm';
battery.cell.resistance_map_charge_Ohms.axis_2.breakpoints = [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1];
battery.cell.resistance_map_charge_Ohms.table      = 1e-3.*[3.3582 3.3582    3.1521    3.0998    3.1091    3.2094    3.0851    3.0672    3.0613   3.0613 ;
                                                            1.9974 1.9974    1.8558    1.8465    1.8571    1.9406    1.8799    1.8572    1.8670   1.8670 ;
                                                            1.5759 1.5759    1.4962    1.4792    1.5061    1.6074    1.5304    1.5309    1.5413   1.5413];

%% UC Davis first order battery model

battery.use_second_order_model                         = false;
battery.use_first_order_model                          = false;

% First ans Second order cell parameters are just place holders to avoid numerical errors in the
% simulink, and are neglected if the first and second order are set to
% false
battery.cell.transient_R_discharge_short_term_Ohms.axis_1.signal            = 'soc_norm';
battery.cell.transient_R_discharge_short_term_Ohms.axis_1.breakpoints       = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_R_discharge_short_term_Ohms.table                    = [0.00315 0.0023 0.00229 0.00228 0.00228];

battery.cell.transient_R_charge_short_term_Ohms.axis_1.signal               = 'soc_norm';
battery.cell.transient_R_charge_short_term_Ohms.axis_1.breakpoints          = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_R_charge_short_term_Ohms.table                       = [0.00315 0.0023 0.00229 0.00228 0.00228];

battery.cell.transient_R_discharge_long_term_Ohms.axis_1.signal             = 'soc_norm';
battery.cell.transient_R_discharge_long_term_Ohms.axis_1.breakpoints        = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_R_discharge_long_term_Ohms.table                     = [0.00031 0.0003 0.0003 0.0003 0.0003];

battery.cell.transient_R_charge_long_term_Ohms.axis_1.signal                = 'soc_norm';
battery.cell.transient_R_charge_long_term_Ohms.axis_1.breakpoints           = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_R_charge_long_term_Ohms.table                        = [0.00031 0.0003 0.0003 0.0003 0.0003];


%%
battery.cell.transient_C_discharge_short_term_Farads.axis_1.signal      = 'soc_norm';
battery.cell.transient_C_discharge_short_term_Farads.axis_1.breakpoints = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_C_discharge_short_term_Farads.table              = [3333.33333333333 4478.26086956522 4454.14847161572 4429.82456140351 4385.9649122807];

battery.cell.transient_C_charge_short_term_Farads.axis_1.signal        = 'soc_norm';
battery.cell.transient_C_charge_short_term_Farads.axis_1.breakpoints   = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_C_charge_short_term_Farads.table                = [3333.33333333333 4478.26086956522 4454.14847161572 4429.82456140351 4385.9649122807];

battery.cell.transient_C_discharge_long_term_Farads.axis_1.signal      = 'soc_norm';
battery.cell.transient_C_discharge_long_term_Farads.axis_1.breakpoints = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_C_discharge_long_term_Farads.table              = [162903.225806452 184333.333333333 184000 183666.666666667 183333.333333333];

battery.cell.transient_C_charge_long_term_Farads.axis_1.signal         = 'soc_norm';
battery.cell.transient_C_charge_long_term_Farads.axis_1.breakpoints    = [0.1 0.3 0.5 0.7 0.9];
battery.cell.transient_C_charge_long_term_Farads.table                 = [162903.225806452 184333.333333333 184000 183666.666666667 183333.333333333];

battery.charge_efficiency_map_norm.axis_1.signal                       = 'soc_norm';
battery.charge_efficiency_map_norm.axis_1.breakpoints                  = [0 0.8 0.85 0.9 1];
battery.charge_efficiency_map_norm.table                               = [0.99 0.99 0.99 0.98 0.97];  % Sandia Lab, J.W. Stevens & G.P. Corey


%%
battery.cell.temperature_power_derate_index_temp_degC  = [-30 -20 -10 0 10 20 30 40 50 55];
battery.cell.temperature_power_discharge_derate_norm   = [0.1139 0.3454 0.5528 0.7314 0.8763 0.9828 1.046 1.0611 1.0233 0.1139];
battery.cell.temperature_power_charge_derate_norm      = [0.027 0.09675 0.1665 0.4031 0.6776 0.9351 1.1206 1.179 1.0554 0.027];

battery.discharge_derate_soc_norm  = [0.18 0.21];
battery.charge_derate_soc_norm     = [0.97 1];
battery.thermal.initial_temp_degC  = 22.25;

battery.thermal.pack_mass_kg                           = 0.5 * battery.num_cells;
battery.thermal.specific_heat_capacity_JpkgK           = 660;          % NREL A.A. Pesaran & M. Keyser thermal characteristics of selected EV & HEV batteries
battery.thermal.heat_transfer_coefficient_Wpm2K        = 10.5 * 0.3;   % Base * hrate_cal
battery.thermal.pack_heat_transfer_area_m2             = 8.698186 * battery.num_cells;

end